/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.actions.resource;

import com.eviware.soapui.config.RestParametersConfig;
import com.eviware.soapui.impl.rest.RestMethod;
import com.eviware.soapui.impl.rest.RestRequest;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.actions.support.NewRestResourceActionBase;
import com.eviware.soapui.impl.rest.panels.resource.RestParamsTableModel;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.rest.support.XmlBeansRestParamsTestPropertyHolder;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewRestMethodAction
extends AbstractSoapUIAction<RestResource> {
    public static final String SOAPUI_ACTION_ID = "NewRestMethodAction";
    public static final MessageSupport messages = MessageSupport.getMessages(NewRestMethodAction.class);
    private XFormDialog dialog;
    private XmlBeansRestParamsTestPropertyHolder params;
    private NewRestResourceActionBase.InternalRestParamsTable paramsTable;

    public NewRestMethodAction() {
        super(messages.get("title"), messages.get("description"));
    }

    @Override
    public void perform(RestResource resource, Object param) {
        if (this.dialog == null) {
            this.dialog = ADialogBuilder.buildDialog(Form.class);
            this.dialog.setBooleanValue(Form.CREATEREQUEST, true);
        }
        this.dialog.setValue(Form.RESOURCENAME, "Method " + (resource.getRestMethodCount() + 1));
        this.params = param instanceof XmlBeansRestParamsTestPropertyHolder ? (XmlBeansRestParamsTestPropertyHolder)param : new XmlBeansRestParamsTestPropertyHolder(null, RestParametersConfig.Factory.newInstance());
        this.paramsTable = new MethodInternalRestParamsTable(this.params, NewRestResourceActionBase.ParamLocation.METHOD){

            public int getColumnCount() {
                return this.getColumnCount() - 1;
            }
        };
        this.dialog.getFormField(Form.PARAMSTABLE).setProperty("component", this.paramsTable);
        if (this.dialog.show()) {
            RestMethod method = resource.addNewMethod(this.dialog.getValue(Form.RESOURCENAME));
            method.setMethod(RestRequestInterface.RequestMethod.valueOf(this.dialog.getValue(Form.METHOD)));
            this.paramsTable.extractParams(method.getParams(), NewRestResourceActionBase.ParamLocation.METHOD);
            UISupport.select(method);
            if (this.dialog.getBooleanValue(Form.CREATEREQUEST)) {
                this.createRequest(method);
            }
        }
    }

    protected void createRequest(RestMethod method) {
        RestRequest request = method.addNewRequest("Request " + (method.getRequestCount() + 1));
        UISupport.showDesktopPanel(request);
    }

    @AForm(name="Form.Title", description="Form.Description", helpUrl="http://www.soapui.org/userguide/rest/index.html", icon="/applications-system.png")
    public static interface Form {
        @AField(description="Form.ResourceName.Description", type=AField.AFieldType.STRING)
        public static final String RESOURCENAME = messages.get("Form.ResourceName.Label");
        @AField(description="Form.Method.Description", type=AField.AFieldType.ENUMERATION, values={"GET", "POST", "PUT", "DELETE", "HEAD"})
        public static final String METHOD = messages.get("Form.Method.Label");
        @AField(description="Form.ParamsTable.Description", type=AField.AFieldType.COMPONENT)
        public static final String PARAMSTABLE = messages.get("Form.ParamsTable.Label");
        @AField(description="Form.CreateRequest.Description", type=AField.AFieldType.BOOLEAN)
        public static final String CREATEREQUEST = messages.get("Form.CreateRequest.Label");
    }

    private class MethodInternalRestParamsTable
    extends NewRestResourceActionBase.InternalRestParamsTable {
        public MethodInternalRestParamsTable(RestParamsPropertyHolder params, NewRestResourceActionBase.ParamLocation defaultLocation) {
            super(params, defaultLocation);
        }

        protected RestParamsTableModel createTableModel(RestParamsPropertyHolder params) {
            return new NewRestResourceActionBase.InternalRestParamsTable.InternalRestParamsTableModel(params){

                public int getColumnCount() {
                    return super.getColumnCount() - 1;
                }
            };
        }
    }
}

