/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.SoapuiWorkspaceDocumentConfig;
import com.eviware.soapui.config.WorkspaceProjectConfig;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.project.ProjectFactoryRegistry;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.AbstractModelItem;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.model.workspace.WorkspaceListener;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveDialog;
import com.eviware.soapui.support.types.StringToStringMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceImpl
extends AbstractModelItem
implements Workspace {
    private static final Logger log = Logger.getLogger(WorkspaceImpl.class);
    public static final MessageSupport messages = MessageSupport.getMessages(WorkspaceImpl.class);
    private List<Project> projectList = new ArrayList<Project>();
    private SoapuiWorkspaceDocumentConfig workspaceConfig;
    private String path = null;
    private Set<WorkspaceListener> listeners = new HashSet<WorkspaceListener>();
    private ImageIcon workspaceIcon;
    private XmlBeansSettingsImpl settings;
    private StringToStringMap projectOptions;
    private ResolveDialog resolver;

    public WorkspaceImpl(String path, StringToStringMap projectOptions) throws XmlException, IOException {
        this.projectOptions = projectOptions == null ? new StringToStringMap() : projectOptions;
        File file = new File(path);
        this.path = file.getAbsolutePath();
        this.loadWorkspace(file);
        this.workspaceIcon = UISupport.createImageIcon("/workspace.gif");
        for (WorkspaceListener listener : SoapUI.getListenerRegistry().getListeners(WorkspaceListener.class)) {
            this.addWorkspaceListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchWorkspace(File file) throws SoapUIException {
        if (file.exists()) {
            try {
                SoapuiWorkspaceDocumentConfig.Factory.parse((File)file);
            }
            catch (Exception e) {
                throw new SoapUIException(messages.get("FailedToLoadWorkspaceException") + e.toString());
            }
        }
        this.fireWorkspaceSwitching();
        while (this.projectList.size() > 0) {
            Object var4_5;
            Project project = this.projectList.remove(0);
            try {
                this.fireProjectRemoved(project);
                var4_5 = null;
                project.release();
            }
            catch (Throwable throwable) {
                var4_5 = null;
                project.release();
                throw throwable;
            }
        }
        try {
            String oldName = this.getName();
            this.loadWorkspace(file);
            this.path = file.getAbsolutePath();
            for (Project project : this.projectList) {
                this.fireProjectAdded(project);
            }
            this.notifyPropertyChanged(ModelItem.NAME_PROPERTY, oldName, this.getName());
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        this.fireWorkspaceSwitched();
    }

    public void loadWorkspace(File file) throws XmlException, IOException {
        if (file.exists()) {
            log.info((Object)messages.get("FailedToLoadWorkspaceFrom", file.getAbsolutePath()));
            this.workspaceConfig = SoapuiWorkspaceDocumentConfig.Factory.parse((File)file);
            if (this.workspaceConfig.getSoapuiWorkspace().getSettings() == null) {
                this.workspaceConfig.getSoapuiWorkspace().addNewSettings();
            }
            this.setPath(file.getAbsolutePath());
            this.settings = new XmlBeansSettingsImpl(this, SoapUI.getSettings(), this.workspaceConfig.getSoapuiWorkspace().getSettings());
            boolean closeOnStartup = this.getSettings().getBoolean(UISettings.CLOSE_PROJECTS);
            List projects = this.workspaceConfig.getSoapuiWorkspace().getProjectList();
            for (int i = 0; i < projects.size(); ++i) {
                WorkspaceProjectConfig wsc = (WorkspaceProjectConfig)projects.get(i);
                String str = PathUtils.denormalizePath(wsc.getStringValue());
                str = PathUtils.adjustRelativePath(str, this.getProjectRoot(), this);
                try {
                    WsdlProject project = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(str, this, false, !closeOnStartup && wsc.getStatus() != WorkspaceProjectConfig.Status.CLOSED && wsc.getType() != WorkspaceProjectConfig.Type.REMOTE, wsc.getName(), null);
                    this.projectList.add(project);
                    continue;
                }
                catch (Exception e) {
                    UISupport.showErrorMessage(messages.get("FailedToLoadProjectInWorkspace", str) + e.getMessage());
                    SoapUI.logError(e);
                }
            }
        } else {
            this.workspaceConfig = SoapuiWorkspaceDocumentConfig.Factory.newInstance();
            this.workspaceConfig.addNewSoapuiWorkspace().setName(messages.get("DefaultWorkspaceName"));
            this.workspaceConfig.getSoapuiWorkspace().addNewSettings();
            this.settings = new XmlBeansSettingsImpl(this, SoapUI.getSettings(), this.workspaceConfig.getSoapuiWorkspace().getSettings());
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Map<String, Project> getProjects() {
        HashMap<String, Project> result = new HashMap<String, Project>();
        for (Project project : this.projectList) {
            result.put(project.getName(), project);
        }
        return result;
    }

    public void setName(String name) {
        String oldName = this.getName();
        this.workspaceConfig.getSoapuiWorkspace().setName(name);
        this.notifyPropertyChanged(ModelItem.NAME_PROPERTY, oldName, name);
    }

    public void setDescription(String description) {
        String oldDescription = this.getDescription();
        this.workspaceConfig.getSoapuiWorkspace().setDescription(description);
        this.notifyPropertyChanged(ModelItem.DESCRIPTION_PROPERTY, oldDescription, description);
    }

    @Override
    public String getName() {
        return this.workspaceConfig.getSoapuiWorkspace().isSetName() ? this.workspaceConfig.getSoapuiWorkspace().getName() : messages.get("DefaultWorkspaceName");
    }

    @Override
    public Project getProjectAt(int index) {
        return this.projectList.get(index);
    }

    @Override
    public Project getProjectByName(String projectName) {
        for (Project project : this.projectList) {
            if (!project.getName().equals(projectName)) continue;
            return project;
        }
        return null;
    }

    @Override
    public int getProjectCount() {
        return this.projectList.size();
    }

    @Override
    public void onClose() {
        this.save(!this.getSettings().getBoolean(UISettings.AUTO_SAVE_PROJECTS_ON_EXIT));
    }

    @Override
    public void save(boolean workspaceOnly) {
        this.save(workspaceOnly, false);
    }

    public void save(boolean workspaceOnly, boolean skipProjectsWithRunningTests) {
        try {
            if (this.path == null) {
                File file = UISupport.getFileDialogs().saveAs(this, messages.get("SaveWorkspace.Title"), ".xml", "XML Files (*.xml)", null);
                if (file == null) {
                    return;
                }
                this.path = file.getAbsolutePath();
            }
            ArrayList<WorkspaceProjectConfig> projects = new ArrayList<WorkspaceProjectConfig>();
            for (int c = 0; c < this.getProjectCount(); ++c) {
                String path;
                WsdlProject project = (WsdlProject)this.getProjectAt(c);
                if (!workspaceOnly) {
                    if (skipProjectsWithRunningTests && SoapUI.getTestMonitor().hasRunningTests(project)) {
                        log.warn((Object)messages.get("ProjectHasRunningTests.Warning", project.getName()));
                    } else {
                        path = project.getPath();
                        if (!StringUtils.hasContent(path)) {
                            if (UISupport.confirm(messages.get("ProjectHasNotBeenSaved.Label", project.getName()), messages.get("ProjectHasNotBeenSaved.Title"))) {
                                project.save();
                            }
                        } else {
                            project.save();
                        }
                    }
                }
                if ((path = project.getPath()) == null) continue;
                path = PathUtils.createRelativePath(path, this.getProjectRoot(), this);
                WorkspaceProjectConfig wpc = WorkspaceProjectConfig.Factory.newInstance();
                wpc.setStringValue(PathUtils.normalizePath(path));
                if (project.isRemote()) {
                    wpc.setType(WorkspaceProjectConfig.Type.REMOTE);
                }
                if (!project.isOpen()) {
                    if (project.getEncrypted() == 0) {
                        wpc.setStatus(WorkspaceProjectConfig.Status.CLOSED);
                    } else {
                        wpc.setStatus(WorkspaceProjectConfig.Status.CLOSED_AND_ENCRYPTED);
                    }
                }
                wpc.setName(project.getName());
                projects.add(wpc);
            }
            this.workspaceConfig.getSoapuiWorkspace().setProjectArray(projects.toArray(new WorkspaceProjectConfig[projects.size()]));
            this.workspaceConfig.getSoapuiWorkspace().setSoapuiVersion("3.5.1");
            File workspaceFile = new File(this.path);
            this.workspaceConfig.save(workspaceFile, new XmlOptions().setSavePrettyPrint());
            log.info((Object)messages.get("SavedWorkspace.Info", workspaceFile.getAbsolutePath()));
        }
        catch (IOException e) {
            log.error((Object)(messages.get("FailedToSaveWorkspace.Error") + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void addWorkspaceListener(WorkspaceListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeWorkspaceListener(WorkspaceListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Project importProject(String fileName) throws SoapUIException {
        File projectFile = new File(fileName);
        WsdlProject project = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(projectFile.getAbsolutePath(), this);
        this.projectList.add(project);
        this.fireProjectAdded(project);
        this.resolveProject(project);
        this.save(true);
        return project;
    }

    public void resolveProject(WsdlProject project) {
        if (this.resolver == null) {
            this.resolver = new ResolveDialog("Resolve Project", "Resolve imported project", null);
            this.resolver.setShowOkMessage(false);
        }
        this.resolver.resolve(project);
    }

    public WsdlProject createProject(String name) throws SoapUIException {
        File projectFile = new File(this.createProjectFileName(name));
        File file = UISupport.getFileDialogs().saveAs(this, messages.get("CreateProject.Title"), ".xml", "XML Files (*.xml)", projectFile);
        if (file == null) {
            return null;
        }
        return this.createProject(name, file);
    }

    @Override
    public WsdlProject createProject(String name, File file) throws SoapUIException {
        File projectFile = file;
        block2: while (projectFile != null && projectFile.exists()) {
            Boolean result = Boolean.FALSE;
            while (!result.booleanValue()) {
                result = UISupport.confirmOrCancel(messages.get("OverwriteProject.Label"), messages.get("OverwriteProject.Title"));
                if (result == null) {
                    return null;
                }
                if (result.booleanValue()) {
                    projectFile.delete();
                    continue;
                }
                projectFile = UISupport.getFileDialogs().saveAs(this, messages.get("CreateProject.Title"), ".xml", "XML Files (*.xml)", projectFile);
                if (projectFile != null) continue block2;
                return null;
            }
        }
        WsdlProject project = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(null, this);
        project.setName(name);
        this.projectList.add(project);
        this.fireProjectAdded(project);
        try {
            if (projectFile != null) {
                project.saveAs(projectFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            log.error((Object)(messages.get("FailedToSaveProject.Error") + e.getMessage()), (Throwable)e);
        }
        return project;
    }

    private void fireProjectAdded(Project project) {
        for (WorkspaceListener listener : this.listeners) {
            listener.projectAdded(project);
        }
    }

    private void fireWorkspaceSwitching() {
        for (WorkspaceListener listener : this.listeners) {
            listener.workspaceSwitching(this);
        }
    }

    private void fireWorkspaceSwitched() {
        for (WorkspaceListener listener : this.listeners) {
            listener.workspaceSwitched(this);
        }
    }

    private String createProjectFileName(String name) {
        return name + "-soapui-project.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProject(Project project) {
        int ix = this.projectList.indexOf(project);
        if (ix == -1) {
            throw new RuntimeException("Project [" + project.getName() + "] not available in workspace for removal");
        }
        this.projectList.remove(ix);
        try {
            this.fireProjectRemoved(project);
            Object var4_3 = null;
            project.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            project.release();
            throw throwable;
        }
    }

    public Project reloadProject(Project project) throws SoapUIException {
        int ix = this.projectList.indexOf(project);
        if (ix == -1) {
            throw new RuntimeException("Project [" + project.getName() + "] not available in workspace for reload");
        }
        this.projectList.remove(ix);
        this.fireProjectRemoved(project);
        String tempName = project.getName();
        project.release();
        project = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(project.getPath(), this, false, true, tempName, null);
        this.projectList.add(ix, project);
        this.fireProjectAdded(project);
        return project;
    }

    private void fireProjectRemoved(Project project) {
        WorkspaceListener[] listenerArray = this.listeners.toArray(new WorkspaceListener[this.listeners.size()]);
        for (int c = 0; c < listenerArray.length; ++c) {
            listenerArray[c].projectRemoved(project);
        }
    }

    @Override
    public ImageIcon getIcon() {
        return this.workspaceIcon;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public int getIndexOfProject(Project project) {
        return this.projectList.indexOf(project);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public String getProjectRoot() {
        return this.workspaceConfig.getSoapuiWorkspace().getProjectRoot();
    }

    public void setProjectRoot(String workspaceRoot) {
        this.workspaceConfig.getSoapuiWorkspace().setProjectRoot(workspaceRoot);
    }

    public void release() {
        this.settings.release();
        for (Project project : this.projectList) {
            project.release();
        }
    }

    public List<? extends Project> getProjectList() {
        return this.projectList;
    }

    @Override
    public String getDescription() {
        return this.workspaceConfig.getSoapuiWorkspace().getDescription();
    }

    public WsdlProject importRemoteProject(String url) throws SoapUIException {
        WsdlProject project = (WsdlProject)ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(url, this, false);
        this.projectList.add(project);
        this.fireProjectAdded(project);
        this.resolveProject(project);
        this.save(true);
        return project;
    }

    public void closeProject(Project project) {
        int oldProjectEncrypt = ((WsdlProject)project).getEncrypted();
        int ix = this.projectList.indexOf(project);
        if (ix == -1) {
            throw new RuntimeException("Project [" + project.getName() + "] not available in workspace for close");
        }
        this.projectList.remove(ix);
        this.fireProjectRemoved(project);
        String name = project.getName();
        project.release();
        try {
            project = ProjectFactoryRegistry.getProjectFactory("wsdl").createNew(project.getPath(), this, false, false, name, null);
            ((WsdlProject)project).setEncrypted(oldProjectEncrypt);
            this.projectList.add(ix, project);
            this.fireProjectAdded(project);
        }
        catch (Exception e) {
            UISupport.showErrorMessage(messages.get("FailedToCloseProject.Error", name) + e.getMessage());
            SoapUI.logError(e);
        }
    }

    public List<Project> getOpenProjectList() {
        ArrayList<Project> availableProjects = new ArrayList<Project>();
        for (Project project : this.projectList) {
            if (!project.isOpen()) continue;
            availableProjects.add(project);
        }
        return availableProjects;
    }

    @Override
    public Project openProject(Project project) throws SoapUIException {
        return this.reloadProject(project);
    }

    @Override
    public String getId() {
        return String.valueOf(this.hashCode());
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return this.getProjectList();
    }

    @Override
    public ModelItem getParent() {
        return null;
    }

    @Override
    public void inspectProjects() {
        for (int cnt = 0; cnt < this.projectList.size(); ++cnt) {
            Project project = this.projectList.get(cnt);
            if (!project.isOpen()) continue;
            project.inspect();
        }
    }

    public String getProjectPassword(String name) {
        return (String)this.projectOptions.get(name);
    }

    public void clearProjectPassword(String name) {
        this.projectOptions.remove(name);
    }
}

