/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.model.workspace.WorkspaceListener;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.SoapUIActionMapping;
import com.eviware.soapui.support.action.support.DefaultActionMapping;
import com.eviware.soapui.support.action.swing.SwingActionDelegate;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.ui.desktop.DesktopListener;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import java.awt.event.ActionEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class RecentItemsListener
implements WorkspaceListener,
DesktopListener {
    private static final String RECENT_WORKSPACES_SETTING = "RecentWorkspaces";
    private static final String RECENT_PROJECTS_SETTING = "RecentProjects";
    private JMenu recentProjectsMenu;
    private JMenu recentWorkspacesMenu;
    private JMenu recentEditorsMenu;
    private boolean switchingWorkspace;

    public RecentItemsListener(JMenu recentWorkspacesMenu2, JMenu recentProjectsMenu2, JMenu recentEditorsMenu2) {
        this.recentWorkspacesMenu = recentWorkspacesMenu2;
        this.recentProjectsMenu = recentProjectsMenu2;
        this.recentEditorsMenu = recentEditorsMenu2;
        this.recentEditorsMenu.add("- empty -").setEnabled(false);
        this.recentEditorsMenu.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                for (int c = 0; c < RecentItemsListener.this.recentEditorsMenu.getItemCount(); ++c) {
                    ShowEditorAction action = (ShowEditorAction)RecentItemsListener.this.recentEditorsMenu.getItem(c).getAction();
                    if (action == null) continue;
                    if (action.isReleased()) {
                        RecentItemsListener.this.recentEditorsMenu.remove(c);
                        --c;
                        continue;
                    }
                    try {
                        action.update();
                        continue;
                    }
                    catch (Throwable e1) {
                        RecentItemsListener.this.recentEditorsMenu.remove(c);
                        --c;
                    }
                }
                if (RecentItemsListener.this.recentEditorsMenu.getItemCount() == 0) {
                    RecentItemsListener.this.recentEditorsMenu.add("- empty -").setEnabled(false);
                }
            }
        });
        this.updateRecentWorkspacesMenu();
        this.updateRecentProjectsMenu();
    }

    private void updateRecentWorkspacesMenu() {
        String recent = SoapUI.getSettings().getString(RECENT_WORKSPACES_SETTING, null);
        StringToStringMap history = recent == null ? new StringToStringMap() : StringToStringMap.fromXml(recent);
        this.recentWorkspacesMenu.removeAll();
        if (history.size() > 0) {
            for (String filePath : history.keySet()) {
                DefaultActionMapping mapping = new DefaultActionMapping("SwitchWorkspaceAction", null, null, false, filePath);
                String wsName = (String)history.get(filePath);
                if (SoapUI.getWorkspace().getPath().equals(filePath)) continue;
                mapping.setName(wsName);
                mapping.setDescription("Switches to the [" + wsName + "] workspace");
                SwingActionDelegate<Workspace> delegate = new SwingActionDelegate<Workspace>(mapping, SoapUI.getWorkspace());
                this.recentWorkspacesMenu.add(new JMenuItem(delegate));
            }
        } else {
            this.recentWorkspacesMenu.add("- empty -").setEnabled(false);
        }
    }

    private void updateRecentProjectsMenu() {
        StringToStringMap history;
        this.recentProjectsMenu.removeAll();
        String recent = SoapUI.getSettings().getString(RECENT_PROJECTS_SETTING, null);
        StringToStringMap stringToStringMap = history = recent == null ? new StringToStringMap() : StringToStringMap.fromXml(recent);
        if (history.size() > 0) {
            for (String filePath : history.keySet()) {
                DefaultActionMapping mapping = new DefaultActionMapping("ImportWsdlProjectAction", null, null, false, filePath);
                String wsName = (String)history.get(filePath);
                mapping.setName(wsName);
                mapping.setDescription("Switches to the [" + wsName + "] project");
                SwingActionDelegate<Workspace> delegate = new SwingActionDelegate<Workspace>(mapping, SoapUI.getWorkspace());
                this.recentProjectsMenu.add(new JMenuItem(delegate));
            }
        } else {
            this.recentProjectsMenu.add("- empty -").setEnabled(false);
        }
    }

    public void projectAdded(Project project) {
        if (this.switchingWorkspace) {
            return;
        }
        String filePath = ((WsdlProject)project).getPath();
        if (filePath == null) {
            return;
        }
        String recent = SoapUI.getSettings().getString(RECENT_PROJECTS_SETTING, null);
        if (recent != null) {
            StringToStringMap history = StringToStringMap.fromXml(recent);
            history.remove(filePath);
            SoapUI.getSettings().setString(RECENT_PROJECTS_SETTING, history.toXml());
        }
        for (int c = 0; c < this.recentProjectsMenu.getItemCount(); ++c) {
            SoapUIActionMapping mapping;
            SwingActionDelegate action = (SwingActionDelegate)this.recentProjectsMenu.getItem(c).getAction();
            if (action == null || !filePath.equals((mapping = action.getMapping()).getParam())) continue;
            this.recentProjectsMenu.remove(c);
            break;
        }
        if (this.recentProjectsMenu.getItemCount() == 0) {
            this.recentProjectsMenu.add("- empty -").setEnabled(false);
        }
    }

    public void projectChanged(Project project) {
    }

    public void projectRemoved(Project project) {
        if (this.switchingWorkspace) {
            return;
        }
        String filePath = ((WsdlProject)project).getPath();
        String recent = SoapUI.getSettings().getString(RECENT_PROJECTS_SETTING, null);
        StringToStringMap history = recent == null ? new StringToStringMap() : StringToStringMap.fromXml(recent);
        history.put(filePath, project.getName());
        SoapUI.getSettings().setString(RECENT_PROJECTS_SETTING, history.toXml());
        DefaultActionMapping mapping = new DefaultActionMapping("ImportWsdlProjectAction", null, null, false, filePath);
        mapping.setName(project.getName());
        mapping.setDescription("Switches to the [" + project.getName() + "] project");
        SwingActionDelegate<Workspace> delegate = new SwingActionDelegate<Workspace>(mapping, SoapUI.getWorkspace());
        this.recentProjectsMenu.add(new JMenuItem(delegate));
        SwingActionDelegate action = (SwingActionDelegate)this.recentProjectsMenu.getItem(0).getAction();
        if (action == null) {
            this.recentProjectsMenu.remove(0);
        }
        this.removeProjectEditors(project);
    }

    private void removeProjectEditors(Project project) {
        for (int c = 0; c < this.recentEditorsMenu.getItemCount(); ++c) {
            ShowEditorAction action = (ShowEditorAction)this.recentEditorsMenu.getItem(c).getAction();
            if (action == null) continue;
            if (action.isReleased()) {
                this.recentEditorsMenu.remove(c);
                --c;
                continue;
            }
            try {
                action.update();
                if (!this.dependsOnProject(action.getModelItem(), project)) continue;
                this.recentEditorsMenu.remove(c);
                --c;
                continue;
            }
            catch (Throwable e1) {
                this.recentEditorsMenu.remove(c);
                --c;
            }
        }
    }

    private boolean dependsOnProject(ModelItem modelItem, Project project) {
        if (modelItem instanceof Interface) {
            return ((Interface)modelItem).getProject() == project;
        }
        if (modelItem instanceof Operation) {
            return ((Operation)modelItem).getInterface().getProject() == project;
        }
        if (modelItem instanceof Request) {
            return ((Request)modelItem).getOperation().getInterface().getProject() == project;
        }
        if (modelItem instanceof TestSuite) {
            return ((TestSuite)modelItem).getProject() == project;
        }
        if (modelItem instanceof TestCase) {
            return ((TestCase)modelItem).getTestSuite().getProject() == project;
        }
        if (modelItem instanceof TestStep) {
            return ((TestStep)modelItem).getTestCase().getTestSuite().getProject() == project;
        }
        if (modelItem instanceof LoadTest) {
            return ((LoadTest)modelItem).getTestCase().getTestSuite().getProject() == project;
        }
        if (modelItem instanceof MockService) {
            return ((MockService)modelItem).getProject() == project;
        }
        if (modelItem instanceof MockOperation) {
            return ((MockOperation)modelItem).getMockService().getProject() == project;
        }
        if (modelItem instanceof MockResponse) {
            return ((MockResponse)modelItem).getMockOperation().getMockService().getProject() == project;
        }
        return false;
    }

    public void workspaceSwitched(Workspace workspace) {
        this.switchingWorkspace = false;
        String filePath = workspace.getPath();
        String recent = SoapUI.getSettings().getString(RECENT_WORKSPACES_SETTING, null);
        if (recent != null) {
            StringToStringMap history = StringToStringMap.fromXml(recent);
            history.remove(filePath);
            SoapUI.getSettings().setString(RECENT_WORKSPACES_SETTING, history.toXml());
        }
        for (int c = 0; c < this.recentWorkspacesMenu.getItemCount(); ++c) {
            SoapUIActionMapping mapping;
            SwingActionDelegate action = (SwingActionDelegate)this.recentWorkspacesMenu.getItem(c).getAction();
            if (action == null || !filePath.equals((mapping = action.getMapping()).getParam())) continue;
            this.recentWorkspacesMenu.remove(c);
            break;
        }
        if (this.recentWorkspacesMenu.getItemCount() == 0) {
            this.recentWorkspacesMenu.add("- empty -").setEnabled(false);
        }
    }

    public void workspaceSwitching(Workspace workspace) {
        this.switchingWorkspace = true;
        this.recentEditorsMenu.removeAll();
        if (this.recentEditorsMenu.getItemCount() == 0) {
            this.recentEditorsMenu.add("- empty -").setEnabled(false);
        }
        String filePath = workspace.getPath();
        DefaultActionMapping mapping = new DefaultActionMapping("SwitchWorkspaceAction", null, null, false, filePath);
        mapping.setName(workspace.getName());
        mapping.setDescription("Switches to the [" + workspace.getName() + "] workspace");
        SwingActionDelegate<Workspace> delegate = new SwingActionDelegate<Workspace>(mapping, SoapUI.getWorkspace());
        this.recentWorkspacesMenu.add(new JMenuItem(delegate));
        String recent = SoapUI.getSettings().getString(RECENT_WORKSPACES_SETTING, null);
        StringToStringMap history = recent == null ? new StringToStringMap() : StringToStringMap.fromXml(recent);
        history.put(filePath, workspace.getName());
        SoapUI.getSettings().setString(RECENT_WORKSPACES_SETTING, history.toXml());
        SwingActionDelegate action = (SwingActionDelegate)this.recentWorkspacesMenu.getItem(0).getAction();
        if (action == null) {
            this.recentWorkspacesMenu.remove(0);
        }
        this.recentEditorsMenu.removeAll();
    }

    public void desktopPanelClosed(DesktopPanel desktopPanel) {
        ModelItem modelItem = desktopPanel.getModelItem();
        if (modelItem == null) {
            return;
        }
        this.recentEditorsMenu.add(new JMenuItem(new ShowEditorAction(modelItem)));
        ShowEditorAction action = (ShowEditorAction)this.recentEditorsMenu.getItem(0).getAction();
        if (action == null) {
            this.recentEditorsMenu.remove(0);
        }
    }

    public void desktopPanelCreated(DesktopPanel desktopPanel) {
        for (int c = 0; c < this.recentEditorsMenu.getItemCount(); ++c) {
            ShowEditorAction action = (ShowEditorAction)this.recentEditorsMenu.getItem(c).getAction();
            if (action == null) continue;
            if (action.isReleased()) {
                this.recentEditorsMenu.remove(c);
                --c;
                continue;
            }
            if (!action.getModelItem().equals(desktopPanel.getModelItem())) continue;
            this.recentEditorsMenu.remove(c);
            break;
        }
        if (this.recentEditorsMenu.getItemCount() == 0) {
            this.recentEditorsMenu.add("- empty -").setEnabled(false);
        }
    }

    public void desktopPanelSelected(DesktopPanel desktopPanel) {
    }

    private static class ShowEditorAction
    extends AbstractAction {
        private Reference<ModelItem> ref;

        public ShowEditorAction(ModelItem modelItem) {
            super(modelItem.getName());
            this.putValue("ShortDescription", "Reopen editor for [" + modelItem.getName() + "]");
            this.ref = new WeakReference<ModelItem>(modelItem);
        }

        public ModelItem getModelItem() {
            return this.ref.get();
        }

        public void update() {
            ModelItem modelItem = this.ref.get();
            if (modelItem == null) {
                return;
            }
            this.putValue("Name", modelItem.getName());
            this.putValue("ShortDescription", "Reopen editor for [" + modelItem.getName() + "]");
        }

        public boolean isReleased() {
            return this.ref.get() == null;
        }

        public void actionPerformed(ActionEvent e) {
            ModelItem modelItem = this.ref.get();
            if (modelItem != null) {
                UISupport.showDesktopPanel(modelItem);
            } else {
                UISupport.showErrorMessage("Item [" + this.getValue("Name") + "] is no longer available");
            }
        }
    }
}

