/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import org.sleuthkit.datamodel.IngestModuleInfo;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.TskCoreException;

public final class IngestJobInfo {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.sleuthkit.datamodel.Bundle");
    private final long ingestJobId;
    private final long objectId;
    private final String hostName;
    private final Date startDateTime;
    private Date endDateTime = new Date(0L);
    private final String settingsDir;
    private final List<IngestModuleInfo> ingestModuleInfo;
    private final SleuthkitCase skCase;
    private IngestJobStatusType status;

    IngestJobInfo(long ingestJobId, long objectId, String hostName, Date startDateTime, String settingsDir, List<IngestModuleInfo> ingestModuleInfo, SleuthkitCase skCase) {
        this.ingestJobId = ingestJobId;
        this.objectId = objectId;
        this.hostName = hostName;
        this.startDateTime = startDateTime;
        this.settingsDir = settingsDir;
        this.skCase = skCase;
        this.ingestModuleInfo = ingestModuleInfo;
        this.status = IngestJobStatusType.STARTED;
    }

    IngestJobInfo(long ingestJobId, long dataSourceId, String hostName, Date startDateTime, Date endDateTime, IngestJobStatusType status, String settingsDir, List<IngestModuleInfo> ingestModuleInfo, SleuthkitCase skCase) {
        this.ingestJobId = ingestJobId;
        this.objectId = dataSourceId;
        this.hostName = hostName;
        this.startDateTime = startDateTime;
        this.endDateTime = endDateTime;
        this.settingsDir = settingsDir;
        this.skCase = skCase;
        this.ingestModuleInfo = ingestModuleInfo;
        this.status = status;
    }

    public Date getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(Date endDateTime) throws TskCoreException {
        Date oldDate = this.endDateTime;
        this.endDateTime = endDateTime;
        try {
            this.skCase.setIngestJobEndDateTime(this.getIngestJobId(), endDateTime.getTime());
        }
        catch (TskCoreException ex) {
            this.endDateTime = oldDate;
            throw ex;
        }
    }

    public void setIngestJobStatus(IngestJobStatusType status) throws TskCoreException {
        IngestJobStatusType oldStatus = this.getStatus();
        this.status = status;
        try {
            this.skCase.setIngestJobStatus(this.getIngestJobId(), status);
        }
        catch (TskCoreException ex) {
            this.status = oldStatus;
            throw ex;
        }
    }

    public long getIngestJobId() {
        return this.ingestJobId;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Date getStartDateTime() {
        return this.startDateTime;
    }

    public String getSettingsDir() {
        return this.settingsDir;
    }

    public List<IngestModuleInfo> getIngestModuleInfo() {
        return this.ingestModuleInfo;
    }

    public IngestJobStatusType getStatus() {
        return this.status;
    }

    static /* synthetic */ ResourceBundle access$000() {
        return bundle;
    }

    public static enum IngestJobStatusType {
        STARTED(IngestJobInfo.access$000().getString("IngestJobInfo.IngestJobStatusType.Started.displayName")),
        CANCELLED(IngestJobInfo.access$000().getString("IngestJobInfo.IngestJobStatusType.Cancelled.displayName")),
        COMPLETED(IngestJobInfo.access$000().getString("IngestJobInfo.IngestJobStatusType.Completed.displayName"));

        private String displayName;

        private IngestJobStatusType(String displayName) {
            this.displayName = displayName;
        }

        public static IngestJobStatusType fromID(int typeId) {
            for (IngestJobStatusType statusType : IngestJobStatusType.values()) {
                if (statusType.ordinal() != typeId) continue;
                return statusType;
            }
            return null;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

