/*
 * Decompiled with CFR 0.152.
 */
package org.sleuthkit.datamodel;

import java.util.List;
import org.sleuthkit.datamodel.AbstractContent;
import org.sleuthkit.datamodel.Content;
import org.sleuthkit.datamodel.ContentVisitor;
import org.sleuthkit.datamodel.Directory;
import org.sleuthkit.datamodel.Image;
import org.sleuthkit.datamodel.SleuthkitCase;
import org.sleuthkit.datamodel.SleuthkitItemVisitor;
import org.sleuthkit.datamodel.SleuthkitJNI;
import org.sleuthkit.datamodel.TskCoreException;
import org.sleuthkit.datamodel.TskData;

public class FileSystem
extends AbstractContent {
    private long imgOffset;
    private long blockSize;
    private long blockCount;
    private long rootInum;
    private long firstInum;
    private long lastInum;
    private TskData.TSK_FS_TYPE_ENUM fsType;
    private Content parent;
    private volatile long filesystemHandle = 0L;

    protected FileSystem(SleuthkitCase db, long obj_id, String name, long img_offset, TskData.TSK_FS_TYPE_ENUM fs_type, long block_size, long block_count, long root_inum, long first_inum, long last_inum) {
        super(db, obj_id, name);
        this.imgOffset = img_offset;
        this.fsType = fs_type;
        this.blockSize = block_size;
        this.blockCount = block_count;
        this.rootInum = root_inum;
        this.firstInum = first_inum;
        this.lastInum = last_inum;
    }

    @Override
    public void close() {
    }

    @Override
    public int read(byte[] buf, long offset, long len) throws TskCoreException {
        return SleuthkitJNI.readFs(this.getFileSystemHandle(), buf, offset, len);
    }

    @Override
    public long getSize() {
        return this.blockSize * this.blockCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getFileSystemHandle() throws TskCoreException {
        if (this.filesystemHandle == 0L) {
            FileSystem fileSystem = this;
            synchronized (fileSystem) {
                if (this.filesystemHandle == 0L) {
                    Content dataSource = this.getDataSource();
                    if (dataSource != null && dataSource instanceof Image) {
                        Image image = (Image)dataSource;
                        this.filesystemHandle = SleuthkitJNI.openFs(image.getImageHandle(), this.imgOffset, this.getSleuthkitCase());
                    } else {
                        throw new TskCoreException("Data Source of File System is not an image");
                    }
                }
            }
        }
        return this.filesystemHandle;
    }

    public Directory getRootDirectory() throws TskCoreException {
        List<Content> children = this.getChildren();
        if (children.size() != 1) {
            throw new TskCoreException("FileSystem must have only one child.");
        }
        if (!(children.get(0) instanceof Directory)) {
            throw new TskCoreException("Child of FileSystem must be a Directory.");
        }
        return (Directory)children.get(0);
    }

    public long getImageOffset() {
        return this.imgOffset;
    }

    public TskData.TSK_FS_TYPE_ENUM getFsType() {
        return this.fsType;
    }

    public long getBlock_size() {
        return this.blockSize;
    }

    public long getBlock_count() {
        return this.blockCount;
    }

    public long getRoot_inum() {
        return this.rootInum;
    }

    public long getFirst_inum() {
        return this.firstInum;
    }

    public long getLastInum() {
        return this.lastInum;
    }

    public void finalize() throws Throwable {
        try {
            if (this.filesystemHandle != 0L) {
                this.filesystemHandle = 0L;
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public <T> T accept(SleuthkitItemVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public <T> T accept(ContentVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public String toString(boolean preserveState) {
        return super.toString(preserveState) + "FileSystem [\t blockCount " + this.blockCount + "\tblockSize " + this.blockSize + "\tfirstInum " + this.firstInum + "\tfsType " + (Object)((Object)this.fsType) + "\timgOffset " + this.imgOffset + "\tlastInum " + this.lastInum + "\trootInum " + this.rootInum + "\t]";
    }
}

