# -*- coding: utf-8 -*-
"""
vulnerability_data_reader
"""

from redteamcore import ResourceWithCache

class VulnerabilitySource(ResourceWithCache):
    """
    Args:
        name (str): Human readable notation naming this reader.
        location (str): Either a file path or URL to a file.
        tlsverify (bool): Whether or not to verify the SSL connection.
        cache (bool): Whether or not to cache the file.
        cache_path (str): The path at which to cache the file.
    """
    API_SOURCE = 0

    def __init__(self, name, location, source_type, tlsverify=True, cache_location=None):
        super(VulnerabilitySource, self).__init__(location,
                                                  cache_location=cache_location,
                                                  tlsverify=tlsverify)
        self.name = name
        self.source_type = source_type

    def cves(self):
        return []

    def get_type(self):
        if self.source_type == VulnerabilitySource.API_SOURCE:
            return 'security api'
        return 'unknown type'


    def __str__(self):
        string = [self.name]
        string.append(self.get_type())
        string.append(self.location)
        string.append(str(len(self.cves())))
        return ','.join(string)
