from lem.vulnerability import SecurityApiSource

class VulnerabilityManager(object):
    def __init__(self):
        self.readers = dict()
        self.data = dict()
        self.cves = dict()

    def add_api_source(self, name, location, tlsverify=True, cache_path=None):
        self.readers[name] = SecurityApiSource(name,
                                               location,
                                               tlsverify,
                                               cache_path)

    def delete_reader(self, name):
        if name in self.readers.keys():
            self.readers.pop(name)

    def read_data(self, refresh=False):
        if refresh:
            self.data = dict()
            refresh = True
        if not self.data:
            for name, reader in self.readers.iteritems():
                if name not in "modified":
                    self.data[name] = reader.read()

        return self.data, refresh

    def refresh_data(self, delete_cache=False):
        for _, reader in self.readers.iteritems():
            if delete_cache:
                reader.update()
        self.read_data(refresh=True)

    def list_cves(self, refresh=False):
        if refresh:
            self.cves = dict()
            refresh = True
        if not self.cves:
            for _, reader in self.readers.iteritems():
                self.cves.update(reader.cves())
        return self.cves, refresh

    def delete_cache(self, reader_names):
        reader_names = reader_names or []
        if reader_names:
            for reader_name in reader_names:
                self.readers[reader_name].delete_cache()
        else:
            for _, reader in self.readers.iteritems():
                reader.delete_cache()

    def __str__(self):
        string = ['name,type,location,number of CVE\'s']
        for _, reader in self.readers.iteritems():
            string.append(str(reader))
        return '\n'.join(string)
