/*
 * Decompiled with CFR 0.152.
 */
package net.cqure;

import java.util.Vector;
import net.cqure.IAddressPool;
import net.cqure.MSSQLOptions;
import net.cqure.MSSQLProbe;
import net.cqure.SimpleLogger;

public class ThreadManager {
    private int m_nMaxThreads = -1;
    private Vector<MSSQLProbe> m_oPool = new Vector();
    private Vector<MSSQLProbe> m_oReschedPool = new Vector();
    private boolean _break = false;

    public ThreadManager(int nMaxThreads) {
        this.m_nMaxThreads = nMaxThreads;
    }

    public void setBreak(boolean b) {
        this._break = b;
    }

    public boolean isBreak() {
        return this._break;
    }

    private void processPool() {
        int i = 0;
        while (i < this.m_oPool.size()) {
            MSSQLProbe probe = this.m_oPool.get(i);
            if (!probe.isAlive()) {
                if (probe.getError() != 0) {
                    this.m_oReschedPool.add(new MSSQLProbe(probe.getTarget(), probe.getSource()));
                }
                this.m_oPool.remove(i);
            }
            ++i;
        }
    }

    public void increaseTimeout(int nInc) {
        int n = Integer.parseInt((String)MSSQLOptions.getInstance().get("timeout"));
        MSSQLOptions.getInstance().put("timeout", String.valueOf(n += nInc));
    }

    public void waitForMaxRunningThreads() {
        while (this.m_oPool.size() > this.m_nMaxThreads) {
            this.processPool();
        }
    }

    public void startScan() throws InterruptedException {
        String strTarget;
        IAddressPool addressPool = (IAddressPool)MSSQLOptions.getInstance().get("targets");
        MSSQLProbe oProbe = null;
        String strSource = (String)MSSQLOptions.getInstance().get("source");
        while ((strTarget = addressPool.getNextAddress()) != null && !this._break) {
            if (!this.m_oReschedPool.isEmpty()) {
                this.increaseTimeout(10);
                oProbe = this.m_oReschedPool.get(0);
                this.m_oReschedPool.remove(0);
                SimpleLogger.getInstance().logDebug("Rescheduling " + oProbe.getTarget() + " probe ...");
                SimpleLogger.getInstance().logDebug("Increasing timeout ...");
                this.m_oPool.add(oProbe);
                oProbe.start();
            }
            this.waitForMaxRunningThreads();
            oProbe = new MSSQLProbe(strTarget, strSource);
            this.m_oPool.add(oProbe);
            oProbe.start();
        }
    }

    public void waitForRunningThreads() throws InterruptedException {
        while (this.m_oPool.size() > 0) {
            this.processPool();
            Thread.sleep(1000L);
        }
    }
}

