/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.value;

import java.util.ArrayList;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibFileRef;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.value.ValueReference;

public class ObjectIdentifierValue
extends MibValue {
    private MibFileRef fileRef = null;
    private MibValue parent;
    private ArrayList<ObjectIdentifierValue> children = new ArrayList();
    private String name;
    private int value;
    private MibValueSymbol symbol = null;
    private String cachedNumericValue = null;

    public ObjectIdentifierValue(String name, int value) {
        super("OBJECT IDENTIFIER");
        this.parent = null;
        this.name = name;
        this.value = value;
    }

    public ObjectIdentifierValue(MibFileRef fileRef, ObjectIdentifierValue parent, String name, int value) throws MibException {
        super("OBJECT IDENTIFIER");
        this.parent = parent;
        this.name = name;
        this.value = value;
        if (parent.getChildByValue(value) != null) {
            throw new MibException(fileRef, "cannot add duplicate OID children with value " + value);
        }
        parent.addChild(null, fileRef, this);
    }

    public ObjectIdentifierValue(MibFileRef fileRef, ValueReference parent, String name, int value) {
        super("OBJECT IDENTIFIER");
        this.fileRef = fileRef;
        this.parent = parent;
        this.name = name;
        this.value = value;
    }

    @Override
    public MibValue initialize(MibLoaderLog log, MibType type) throws MibException {
        ValueReference ref = null;
        if (this.parent == null) {
            return this;
        }
        if (this.parent instanceof ValueReference) {
            ref = (ValueReference)this.parent;
        }
        this.parent = this.parent.initialize(log, type);
        if (ref != null) {
            if (this.parent instanceof ObjectIdentifierValue) {
                ObjectIdentifierValue oid = (ObjectIdentifierValue)this.parent;
                oid.addChild(log, this.fileRef, this);
            } else {
                throw new MibException(ref.getFileRef(), "referenced value is not an object identifier");
            }
        }
        this.fileRef = null;
        this.cachedNumericValue = null;
        if (this.parent instanceof ObjectIdentifierValue) {
            return ((ObjectIdentifierValue)this.parent).getChildByValue(this.value);
        }
        return this;
    }

    @Override
    public MibValue createReference() {
        return this;
    }

    @Override
    protected void clear() {
        if (this.children != null) {
            Mib mib = this.getMib();
            for (ObjectIdentifierValue child : new ArrayList<ObjectIdentifierValue>(this.children)) {
                if (mib != null && mib != child.getMib()) continue;
                child.clear();
            }
        }
        if (this.getChildCount() <= 0) {
            if (this.parent != null) {
                this.getParent().children.remove(this);
                this.parent = null;
            }
            this.children = new ArrayList();
        }
        this.symbol = null;
        super.clear();
    }

    @Override
    public int compareTo(Object obj) {
        if (obj instanceof ObjectIdentifierValue) {
            return this.compareToOid((ObjectIdentifierValue)obj);
        }
        return this.toString().compareTo(obj.toString());
    }

    private int compareToOid(ObjectIdentifierValue oid) {
        int[] one = this.getParentValues();
        int[] two = oid.getParentValues();
        for (int i = 0; i < one.length; ++i) {
            if (i >= two.length) {
                return 1;
            }
            if (one[i] == two[i]) continue;
            return one[i] - two[i];
        }
        return one.length == two.length ? 0 : -1;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public ObjectIdentifierValue getParent() {
        if (this.parent instanceof ObjectIdentifierValue) {
            return (ObjectIdentifierValue)this.parent;
        }
        return null;
    }

    public int[] getParentValues() {
        return this.getParentValuesInternal(1);
    }

    private int[] getParentValuesInternal(int length) {
        int[] res = this.parent instanceof ObjectIdentifierValue ? ((ObjectIdentifierValue)this.parent).getParentValuesInternal(length + 1) : new int[length];
        res[res.length - length] = this.value;
        return res;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public MibValueSymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(MibValueSymbol symbol) {
        if (this.name == null) {
            this.name = symbol.getName();
        }
        this.symbol = symbol;
    }

    public Mib getMib() {
        return this.symbol == null ? null : this.symbol.getMib();
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public ObjectIdentifierValue getChild(int index) {
        return this.children.get(index);
    }

    public ObjectIdentifierValue getChildByName(String name) {
        for (ObjectIdentifierValue child : this.children) {
            if (!name.equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    public ObjectIdentifierValue getChildByValue(int value) {
        if (value > 0 && value <= this.children.size()) {
            ObjectIdentifierValue child = this.children.get(value - 1);
            if (child.value == value) {
                return child;
            }
        }
        int low = 0;
        int high = this.children.size();
        int pos = (low + high) / 2;
        while (low < high) {
            ObjectIdentifierValue child = this.children.get(pos);
            if (child.value == value) {
                return child;
            }
            if (child.value < value) {
                low = pos + 1;
            } else {
                high = pos;
            }
            pos = (low + high) / 2;
        }
        return null;
    }

    public ObjectIdentifierValue[] getAllChildren() {
        ObjectIdentifierValue[] values = new ObjectIdentifierValue[this.children.size()];
        this.children.toArray(values);
        return values;
    }

    public ObjectIdentifierValue find(String oid) {
        if (oid.startsWith(".")) {
            oid = oid.substring(1);
        }
        if (oid.length() > 0 && this.toString().startsWith(oid)) {
            return this.findAncestor(oid);
        }
        if (oid.startsWith(this.toString())) {
            return this.findDescendant(oid);
        }
        return null;
    }

    public ObjectIdentifierValue findAncestor(String oid) {
        ObjectIdentifierValue ancestor;
        if (oid.startsWith(".")) {
            oid = oid.substring(1);
        }
        for (ancestor = this; ancestor != null && !ancestor.toString().equals(oid); ancestor = ancestor.getParent()) {
        }
        return ancestor;
    }

    public ObjectIdentifierValue findDescendant(String oid) {
        int value;
        ObjectIdentifierValue child;
        if (oid.startsWith(".")) {
            oid = oid.substring(1);
        }
        if (!oid.startsWith(this.toString())) {
            return null;
        }
        if ((oid = oid.substring(this.toString().length())).startsWith(".")) {
            oid = oid.substring(1);
        }
        ObjectIdentifierValue parent = this;
        for (child = this; child != null && oid.length() > 0; child = child.getChildByValue(value)) {
            value = -1;
            try {
                int pos = oid.indexOf(46);
                if (pos > 0) {
                    value = Integer.parseInt(oid.substring(0, pos));
                    oid = oid.substring(pos + 1);
                } else {
                    value = Integer.parseInt(oid);
                    oid = "";
                }
            }
            catch (NumberFormatException ignore) {
                oid = "";
            }
            parent = child;
        }
        return child == null ? parent : child;
    }

    private ObjectIdentifierValue addChild(MibLoaderLog log, MibFileRef fileRef, ObjectIdentifierValue child) throws MibException {
        int i;
        for (i = this.children.size(); i > 0; --i) {
            ObjectIdentifierValue value = this.children.get(i - 1);
            if (value.getValue() == child.getValue()) {
                value = value.merge(log, fileRef, child);
                this.children.set(i - 1, value);
                return value;
            }
            if (value.getValue() < child.getValue()) break;
        }
        this.children.add(i, child);
        return child;
    }

    private void addChildren(MibLoaderLog log, MibFileRef fileRef, ObjectIdentifierValue parent) throws MibException {
        if (this.name == null) {
            this.name = parent.name;
        } else if (parent.name != null && !parent.name.equals(this.name)) {
            String msg = "OID component '" + parent.name + "' was previously " + "defined as '" + this.name + "'";
            if (log == null) {
                throw new MibException(fileRef, msg);
            }
            log.addWarning(fileRef, msg);
        }
        if (parent.symbol != null) {
            throw new MibException(fileRef, "INTERNAL ERROR: OID merge with symbol reference already set");
        }
        for (ObjectIdentifierValue child : parent.children) {
            child.parent = this;
            this.addChild(log, fileRef, child);
        }
        parent.children = new ArrayList();
    }

    private ObjectIdentifierValue merge(MibLoaderLog log, MibFileRef fileRef, ObjectIdentifierValue value) throws MibException {
        if (this.symbol != null || value.symbol == null && this.children.size() > 0) {
            this.addChildren(log, fileRef, value);
            return this;
        }
        value.addChildren(log, fileRef, this);
        return value;
    }

    @Override
    public Object toObject() {
        return this.toString();
    }

    public String toString() {
        if (this.cachedNumericValue == null) {
            StringBuilder buffer = new StringBuilder();
            if (this.parent != null) {
                buffer.append(this.parent.toString());
                buffer.append(".");
            }
            buffer.append(this.value);
            this.cachedNumericValue = buffer.toString();
        }
        return this.cachedNumericValue;
    }

    public String toDetailString() {
        StringBuilder buffer = new StringBuilder();
        if (this.parent instanceof ObjectIdentifierValue) {
            buffer.append(((ObjectIdentifierValue)this.parent).toDetailString());
            buffer.append(".");
        }
        if (this.name == null) {
            buffer.append(this.value);
        } else {
            buffer.append(this.name);
            buffer.append("(");
            buffer.append(this.value);
            buffer.append(")");
        }
        return buffer.toString();
    }

    public String toAsn1String() {
        StringBuilder buffer = new StringBuilder();
        if (this.parent instanceof ObjectIdentifierValue) {
            ObjectIdentifierValue ref = (ObjectIdentifierValue)this.parent;
            if (ref.getSymbol() == null) {
                buffer.append(ref.toAsn1String());
            } else {
                buffer.append(ref.getSymbol().getName());
            }
            buffer.append(" ");
        }
        if (this.name == null || this.getSymbol() != null) {
            buffer.append(this.value);
        } else {
            buffer.append(this.name);
            buffer.append("(");
            buffer.append(this.value);
            buffer.append(")");
        }
        return buffer.toString();
    }
}

