/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.snmp;

import java.util.ArrayList;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpModule;
import net.percederberg.mibble.snmp.SnmpStatus;
import net.percederberg.mibble.snmp.SnmpType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class SnmpModuleCompliance
extends SnmpType {
    private SnmpStatus status;
    private String reference;
    private ArrayList<SnmpModule> modules;

    public SnmpModuleCompliance(SnmpStatus status, String description, String reference, ArrayList<SnmpModule> modules) {
        super("MODULE-COMPLIANCE", description);
        this.status = status;
        this.reference = reference;
        this.modules = modules;
    }

    @Override
    public MibType initialize(MibSymbol symbol, MibLoaderLog log) throws MibException {
        if (!(symbol instanceof MibValueSymbol)) {
            throw new MibException(symbol.getFileRef(), "only values can have the " + this.getName() + " type");
        }
        for (SnmpModule module : this.modules) {
            module.initialize(log);
        }
        return this;
    }

    @Override
    public boolean isCompatible(MibValue value) {
        return value instanceof ObjectIdentifierValue;
    }

    public SnmpStatus getStatus() {
        return this.status;
    }

    public String getReference() {
        return this.reference;
    }

    public ArrayList<SnmpModule> getModules() {
        return this.modules;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.toString());
        buffer.append(" (");
        buffer.append("\n  Status: ");
        buffer.append(this.status);
        buffer.append("\n  Description: ");
        buffer.append(this.getDescription("               "));
        if (this.reference != null) {
            buffer.append("\n  Reference: ");
            buffer.append(this.reference);
        }
        for (SnmpModule module : this.modules) {
            buffer.append("\n  Module: ");
            buffer.append(module);
        }
        buffer.append("\n)");
        return buffer.toString();
    }
}

