/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble.browser;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.browser.MibTreeNode;
import net.percederberg.mibble.snmp.SnmpTrapType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class MibTree
extends JTree {
    private HashMap<MibSymbol, MibTreeNode> nodes = new HashMap();

    public MibTree() {
        super(new MibTreeNode("MIB Tree Root", null));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setToolTipText("");
        this.getSelectionModel().setSelectionMode(1);
    }

    public MibTreeNode getRootNode() {
        return (MibTreeNode)this.getModel().getRoot();
    }

    public MibTreeNode getTreeNode(MibSymbol symbol) {
        return this.nodes.get(symbol);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this.getRowForLocation(e.getX(), e.getY()) == -1) {
            return null;
        }
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        MibTreeNode node = (MibTreeNode)path.getLastPathComponent();
        return node.getToolTipText();
    }

    public void addTreeNodes(Mib mib) {
        MibTreeNode mibNode = new MibTreeNode(mib.getName(), mib);
        MibTreeNode valuesNode = new MibTreeNode("VALUES", mib);
        MibTreeNode trapsNode = new MibTreeNode("TRAPS", mib);
        MibTreeNode typesNode = new MibTreeNode("TYPES", mib);
        for (MibSymbol symbol : mib.getAllSymbols()) {
            if (symbol instanceof MibValueSymbol) {
                MibValueSymbol value = (MibValueSymbol)symbol;
                this.addTreeNodes(valuesNode, symbol.getMib(), value.getOid());
                if (!(value.getType() instanceof SnmpTrapType)) continue;
                MibTreeNode node = new MibTreeNode(symbol.getName(), symbol);
                trapsNode.add(node);
                this.nodes.put(symbol, node);
                continue;
            }
            if (!(symbol instanceof MibTypeSymbol)) continue;
            MibTreeNode node = new MibTreeNode(symbol.getName(), symbol);
            typesNode.add(node);
            this.nodes.put(symbol, node);
        }
        if (trapsNode.getChildCount() == 0 && typesNode.getChildCount() == 0) {
            while (valuesNode.getChildCount() > 0) {
                mibNode.add((MibTreeNode)valuesNode.getFirstChild());
            }
        } else {
            if (valuesNode.getChildCount() > 0) {
                mibNode.add(valuesNode);
            }
            if (trapsNode.getChildCount() > 0) {
                mibNode.add(trapsNode);
            }
            if (typesNode.getChildCount() >= 0) {
                mibNode.add(typesNode);
            }
        }
        this.getRootNode().add(mibNode);
    }

    private MibTreeNode addTreeNodes(MibTreeNode tree, Mib mib, ObjectIdentifierValue oid) {
        if (oid == null) {
            return null;
        }
        if (this.nodes.containsKey(oid)) {
            return this.nodes.get(oid);
        }
        if (this.nodes.containsKey(oid.getSymbol())) {
            return this.nodes.get(oid.getSymbol());
        }
        ObjectIdentifierValue parent = oid.getParent();
        if (MibTree.hasMib(mib, parent)) {
            tree = this.addTreeNodes(tree, mib, parent);
        }
        String name = oid.getName() + " (" + oid.getValue() + ")";
        MibValueSymbol sym = oid.getSymbol();
        MibTreeNode node = new MibTreeNode(name, sym != null ? sym : oid);
        tree.add(node);
        if (sym != null) {
            this.nodes.put(sym, node);
        }
        return node;
    }

    public void removeAllTreeNodes() {
        this.nodes.clear();
        this.getRootNode().removeAllChildren();
    }

    public void removeTreeNodes(Mib mib) {
        MibTreeNode mibNode = this.getRootNode().findChildByValue(mib);
        if (mibNode != null) {
            mibNode.removeFromParent();
        }
        ArrayList<MibSymbol> symbols = new ArrayList<MibSymbol>();
        for (MibSymbol symbol : this.nodes.keySet()) {
            if (!mib.equals(symbol.getMib())) continue;
            symbols.add(symbol);
        }
        this.nodes.keySet().removeAll(symbols);
    }

    private static boolean hasMib(Mib mib, ObjectIdentifierValue oid) {
        Mib oidMib;
        Mib mib2 = oidMib = oid != null ? oid.getMib() : null;
        if (oidMib != null) {
            return mib == oidMib;
        }
        return oid != null && MibTree.hasMib(mib, oid.getParent());
    }
}

