/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.percederberg.mibble.Mib;
import net.percederberg.mibble.MibImport;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibType;
import net.percederberg.mibble.MibTypeSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpAgentCapabilities;
import net.percederberg.mibble.snmp.SnmpCompliance;
import net.percederberg.mibble.snmp.SnmpIndex;
import net.percederberg.mibble.snmp.SnmpModule;
import net.percederberg.mibble.snmp.SnmpModuleCompliance;
import net.percederberg.mibble.snmp.SnmpModuleIdentity;
import net.percederberg.mibble.snmp.SnmpModuleSupport;
import net.percederberg.mibble.snmp.SnmpNotificationGroup;
import net.percederberg.mibble.snmp.SnmpNotificationType;
import net.percederberg.mibble.snmp.SnmpObjectGroup;
import net.percederberg.mibble.snmp.SnmpObjectIdentity;
import net.percederberg.mibble.snmp.SnmpObjectType;
import net.percederberg.mibble.snmp.SnmpRevision;
import net.percederberg.mibble.snmp.SnmpTextualConvention;
import net.percederberg.mibble.snmp.SnmpTrapType;
import net.percederberg.mibble.snmp.SnmpVariation;
import net.percederberg.mibble.type.BitSetType;
import net.percederberg.mibble.type.Constraint;
import net.percederberg.mibble.type.ElementType;
import net.percederberg.mibble.type.IntegerType;
import net.percederberg.mibble.type.SequenceOfType;
import net.percederberg.mibble.type.SequenceType;
import net.percederberg.mibble.type.StringType;
import net.percederberg.mibble.value.BitSetValue;
import net.percederberg.mibble.value.ObjectIdentifierValue;
import net.percederberg.mibble.value.StringValue;

public class MibWriter {
    private PrintWriter os;
    private int margin;

    public MibWriter(OutputStream os) {
        this(new OutputStreamWriter(os));
    }

    public MibWriter(Writer os) {
        this(os, 0);
    }

    public MibWriter(Writer os, int margin) {
        this.os = os instanceof PrintWriter ? (PrintWriter)os : new PrintWriter(os);
        this.margin = margin;
    }

    public void close() {
        this.os.close();
    }

    public void print(Mib mib) {
        Iterator<Object> iter;
        this.printComment(mib.getHeaderComment(), "", true);
        if (mib.getHeaderComment() != null) {
            this.os.println();
        }
        this.os.print(mib.getName());
        this.os.println(" DEFINITIONS ::= BEGIN");
        this.os.println();
        List<MibImport> imps = mib.getAllImports();
        if (imps.size() > 0) {
            this.os.println("IMPORTS");
            iter = imps.iterator();
            while (iter.hasNext()) {
                this.printImport((MibImport)iter.next());
                if (!iter.hasNext()) continue;
                this.os.println();
            }
            this.os.println(";");
            this.os.println();
        }
        iter = mib.getAllSymbols().iterator();
        while (iter.hasNext()) {
            this.printSymbol((MibSymbol)iter.next(), mib.getSmiVersion());
        }
        this.os.println("END");
        this.printComment(mib.getFooterComment(), "", true);
        this.os.flush();
    }

    private void printComment(String comment, String indent, boolean header) {
        if (comment != null) {
            if (header) {
                this.printIndent(indent + "-- ", comment);
                this.os.println();
            } else if (comment.indexOf("\n") >= 0) {
                int pos = comment.indexOf("\n");
                this.os.print(" -- ");
                this.os.print(comment.substring(0, pos));
                this.os.println();
                this.printIndent(indent + " -- ", comment.substring(pos + 1));
            } else {
                this.os.print(" -- ");
                this.os.print(comment);
            }
        }
    }

    private void printImport(MibImport imp) {
        Iterator<String> iter = imp.getAllSymbolNames().iterator();
        while (iter.hasNext()) {
            String str = iter.next().toString();
            int pos = 0;
            if (pos <= 0) {
                pos = str.length();
                this.os.print("    ");
            } else {
                pos = str.length();
                this.os.println(",");
                this.os.print("    ");
            }
            this.os.print(str);
        }
        this.os.println();
        this.os.print("        FROM ");
        this.os.print(imp.getName());
    }

    private void printSymbol(MibSymbol sym, int smiVersion) {
        this.printComment(sym.getComment(), "", true);
        if (sym instanceof MibTypeSymbol) {
            this.os.print(sym.getName());
            this.os.print(" ::= ");
            this.printType(((MibTypeSymbol)sym).getType(), "", smiVersion);
        } else if (sym instanceof MibValueSymbol) {
            this.os.print(sym.getName());
            this.os.print(" ");
            this.printType(((MibValueSymbol)sym).getType(), "", smiVersion);
            this.os.println();
            this.os.print("    ::= ");
            this.printValue(((MibValueSymbol)sym).getValue());
        } else {
            this.os.print("-- ");
            this.os.print(sym.getName());
            this.os.print(" MACRO ... not printed");
        }
        this.os.println();
        this.os.println();
    }

    private void printType(MibType type, String indent, int smiVersion) {
        if (type.getReferenceSymbol() != null) {
            this.os.print(type.getReferenceSymbol().getName());
            MibType refType = type.getReferenceSymbol().getType();
            Constraint refCons = this.getConstraint(refType);
            Constraint typeCons = this.getConstraint(type);
            if (typeCons != null && typeCons != refCons) {
                this.printConstraint(type, indent);
            }
        } else if (type instanceof SequenceType) {
            SequenceType seqType = (SequenceType)type;
            this.os.println("SEQUENCE {");
            this.printTypeElements(seqType.getAllElements(), indent + "    ", smiVersion);
            this.os.println();
            this.os.print(indent);
            this.os.print("}");
        } else if (type instanceof SequenceOfType) {
            SequenceOfType seqOfType = (SequenceOfType)type;
            this.os.print("SEQUENCE ");
            if (seqOfType.getConstraint() != null) {
                this.os.print("(");
                this.os.print(seqOfType.getConstraint());
                this.os.print(") ");
            }
            this.os.print("OF ");
            this.printType(seqOfType.getElementType(), indent, smiVersion);
        } else if (type instanceof IntegerType) {
            this.os.print("INTEGER");
            this.printConstraint(type, indent);
        } else if (type instanceof BitSetType) {
            this.os.print("BITS");
            this.printConstraint(type, indent);
        } else if (type instanceof StringType) {
            this.os.print("OCTET STRING");
            this.printConstraint(type, indent);
        } else if (type.isPrimitive()) {
            this.os.print(type.getName());
        } else if (type instanceof SnmpModuleIdentity) {
            this.printType((SnmpModuleIdentity)type, indent);
        } else if (type instanceof SnmpObjectIdentity) {
            this.printType((SnmpObjectIdentity)type, indent);
        } else if (type instanceof SnmpObjectType) {
            this.printType((SnmpObjectType)type, indent, smiVersion);
        } else if (type instanceof SnmpNotificationType) {
            this.printType((SnmpNotificationType)type, indent);
        } else if (type instanceof SnmpTrapType) {
            this.printType((SnmpTrapType)type, indent);
        } else if (type instanceof SnmpTextualConvention) {
            this.printType((SnmpTextualConvention)type, indent, smiVersion);
        } else if (type instanceof SnmpObjectGroup) {
            this.printType((SnmpObjectGroup)type, indent);
        } else if (type instanceof SnmpNotificationGroup) {
            this.printType((SnmpNotificationGroup)type, indent);
        } else if (type instanceof SnmpModuleCompliance) {
            this.printType((SnmpModuleCompliance)type, indent, smiVersion);
        } else if (type instanceof SnmpAgentCapabilities) {
            this.printType((SnmpAgentCapabilities)type, indent, smiVersion);
        } else {
            this.os.print("-- ERROR: type definition unknown");
        }
        this.printComment(type.getComment(), indent, false);
    }

    private void printType(SnmpModuleIdentity type, String indent) {
        this.os.println("MODULE-IDENTITY");
        this.os.print("    LAST-UPDATED    ");
        this.os.println(this.getQuote(type.getLastUpdated()));
        this.os.print("    ORGANIZATION    ");
        this.os.println(this.getQuote(type.getOrganization()));
        this.os.println("    CONTACT-INFO");
        this.printIndent("            ", this.getQuote(type.getContactInfo()));
        this.os.println();
        this.printDescription(type.getDescription());
        ArrayList<SnmpRevision> list = type.getRevisions();
        for (SnmpRevision rev : list) {
            this.os.println();
            if (rev.getComment() != null) {
                this.os.println();
                this.printComment(rev.getComment(), "    ", true);
            }
            this.os.print("    REVISION        ");
            this.printValue(rev.getValue());
            this.os.println();
            this.os.println("    DESCRIPTION");
            this.printIndent("            ", this.getQuote(rev.getDescription()));
        }
    }

    private void printType(SnmpObjectIdentity type, String indent) {
        this.os.println("OBJECT-IDENTITY");
        this.os.print("    STATUS          ");
        this.os.println(type.getStatus());
        this.printDescription(type.getDescription());
        if (type.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(type.getReference()));
        }
    }

    private void printType(SnmpObjectType type, String indent, int smiVersion) {
        this.os.println("OBJECT-TYPE");
        this.os.print("    SYNTAX          ");
        this.printType(type.getSyntax(), "                    ", smiVersion);
        this.os.println();
        if (type.getUnits() != null) {
            this.os.print("    UNITS           ");
            this.os.print(this.getQuote(type.getUnits()));
            this.os.println();
        }
        if (smiVersion == 1) {
            this.os.print("    ACCESS          ");
        } else {
            this.os.print("    MAX-ACCESS      ");
        }
        this.os.println(type.getAccess());
        this.os.print("    STATUS          ");
        this.os.print(type.getStatus());
        if (type.getDescription() != null) {
            this.os.println();
            this.printDescription(type.getDescription());
        }
        if (type.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(type.getReference()));
        }
        if (type.getIndex() != null && type.getIndex().size() > 0) {
            this.os.println();
            this.os.print("    INDEX           ");
            this.printReferenceList(type.getIndex(), "                    ");
        }
        if (type.getAugments() != null) {
            this.os.println();
            this.os.print("    AUGMENTS        ");
            this.printReference(type.getAugments());
        }
        if (type.getDefaultValue() != null) {
            this.os.println();
            this.os.print("    DEFVAL          ");
            this.printReference(type.getDefaultValue(), this.getSymbols(type.getSyntax()));
        }
    }

    private void printType(SnmpNotificationType type, String indent) {
        this.os.println("NOTIFICATION-TYPE");
        if (type.getObjects().size() > 0) {
            this.os.print("    OBJECTS         ");
            this.printReferenceList(type.getObjects(), "                    ");
            this.os.println();
        }
        this.os.print("    STATUS          ");
        this.os.println(type.getStatus());
        this.printDescription(type.getDescription());
        if (type.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(type.getReference()));
        }
    }

    private void printType(SnmpTrapType type, String indent) {
        this.os.println("TRAP-TYPE");
        this.os.print("    ENTERPRISE      ");
        this.printReferenceEntry(type.getEnterprise());
        if (type.getVariables().size() > 0) {
            this.os.println();
            this.os.print("    VARIABLES       ");
            this.printReferenceList(type.getVariables(), "                    ");
        }
        if (type.getDescription() != null) {
            this.os.println();
            this.printDescription(type.getDescription());
        }
        if (type.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(type.getReference()));
        }
    }

    private void printType(SnmpTextualConvention type, String indent, int smiVersion) {
        this.os.println("TEXTUAL-CONVENTION");
        if (type.getDisplayHint() != null) {
            this.os.print("    DISPLAY-HINT    ");
            this.os.print(this.getQuote(type.getDisplayHint()));
            this.os.println();
        }
        this.os.print("    STATUS          ");
        this.os.println(type.getStatus());
        this.printDescription(type.getDescription());
        if (type.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(type.getReference()));
        }
        this.os.println();
        this.os.print("    SYNTAX          ");
        this.printType(type.getSyntax(), "                    ", smiVersion);
    }

    private void printType(SnmpObjectGroup type, String indent) {
        this.os.println("OBJECT-GROUP");
        this.os.print("    OBJECTS         ");
        this.printReferenceList(type.getObjects(), "                    ");
        this.os.println();
        this.os.print("    STATUS          ");
        this.os.println(type.getStatus());
        this.printDescription(type.getDescription());
        if (type.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(type.getReference()));
        }
    }

    private void printType(SnmpNotificationGroup type, String indent) {
        this.os.println("NOTIFICATION-GROUP");
        this.os.print("    NOTIFICATIONS   ");
        this.printReferenceList(type.getNotifications(), "                    ");
        this.os.println();
        this.os.print("    STATUS          ");
        this.os.println(type.getStatus());
        this.printDescription(type.getDescription());
        if (type.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(type.getReference()));
        }
    }

    private void printType(SnmpModuleCompliance type, String indent, int smiVersion) {
        this.os.println("MODULE-COMPLIANCE");
        this.os.print("    STATUS          ");
        this.os.println(type.getStatus());
        this.printDescription(type.getDescription());
        if (type.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(type.getReference()));
        }
        for (SnmpModule module : type.getModules()) {
            this.os.println();
            this.printComment(module.getComment(), "    ", true);
            this.os.print("    MODULE          ");
            if (module.getModule() == null) {
                this.os.print("-- this module");
            } else {
                this.os.print(module.getModule());
            }
            if (module.getGroups().size() > 0) {
                this.os.println();
                this.os.print("    MANDATORY-GROUPS ");
                this.printReferenceList(module.getGroups(), "                    ");
            }
            for (SnmpCompliance comp : module.getCompliances()) {
                this.os.println();
                this.os.println();
                this.printModuleCompliance(comp, smiVersion);
            }
        }
    }

    private void printType(SnmpAgentCapabilities type, String indent, int smiVersion) {
        this.os.println("AGENT-CAPABILITIES");
        this.os.print("    PRODUCT-RELEASE ");
        this.os.println(this.getQuote(type.getProductRelease()));
        this.os.print("    STATUS          ");
        this.os.println(type.getStatus());
        this.printDescription(type.getDescription());
        if (type.getReference() != null) {
            this.os.println();
            this.os.print("    REFERENCE       ");
            this.os.print(this.getQuote(type.getReference()));
        }
        for (SnmpModuleSupport module : type.getModules()) {
            this.os.println();
            this.os.print("    SUPPORTS        ");
            this.os.println(module.getModule());
            this.os.print("    INCLUDES        ");
            this.printReferenceList(module.getGroups(), "                    ");
            for (SnmpVariation var : module.getVariations()) {
                this.os.println();
                this.os.println();
                this.printVariation(var, smiVersion);
            }
        }
    }

    private void printModuleCompliance(SnmpCompliance comp, int smiVersion) {
        this.printComment(comp.getComment(), "    ", true);
        if (comp.isGroup()) {
            this.os.print("    GROUP           ");
            this.printReferenceEntry(comp.getValue());
            this.os.println();
        } else {
            this.os.print("    OBJECT          ");
            this.printReferenceEntry(comp.getValue());
            this.os.println();
            if (comp.getSyntax() != null) {
                this.os.print("    SYNTAX          ");
                this.printType(comp.getSyntax(), "                    ", smiVersion);
                this.os.println();
            }
            if (comp.getWriteSyntax() != null) {
                this.os.print("    WRITE-SYNTAX    ");
                this.printType(comp.getWriteSyntax(), "                    ", smiVersion);
                this.os.println();
            }
            if (comp.getAccess() != null) {
                this.os.print("    MIN-ACCESS      ");
                this.os.println(comp.getAccess());
            }
        }
        this.printDescription(comp.getDescription());
    }

    private void printVariation(SnmpVariation var, int smiVersion) {
        this.os.print("    VARIATION       ");
        this.printReferenceEntry(var.getValue());
        this.os.println();
        if (var.getSyntax() != null) {
            this.os.print("    SYNTAX          ");
            this.printType(var.getSyntax(), "                    ", smiVersion);
            this.os.println();
        }
        if (var.getWriteSyntax() != null) {
            this.os.print("    WRITE-SYNTAX    ");
            this.printType(var.getWriteSyntax(), "                    ", smiVersion);
            this.os.println();
        }
        if (var.getAccess() != null) {
            this.os.print("    ACCESS          ");
            this.os.println(var.getAccess());
        }
        if (var.getRequiredCells().size() > 0) {
            this.os.print("    CREATION-REQUIRES ");
            this.printReferenceList(var.getRequiredCells(), "                     ");
            this.os.println();
        }
        if (var.getDefaultValue() != null) {
            this.os.print("    DEFVAL          ");
            this.printReference(var.getDefaultValue(), this.getSymbols(var.getBaseSymbol()));
            this.os.println();
        }
        this.printDescription(var.getDescription());
    }

    private void printDescription(String descr) {
        if (descr.length() < 50 && descr.indexOf("\n") < 0) {
            this.os.print("    DESCRIPTION     ");
            this.os.print(this.getQuote(descr));
        } else {
            this.os.println("    DESCRIPTION");
            this.printIndent("            ", this.getQuote(descr));
        }
    }

    private void printTypeElements(ElementType[] elems, String indent, int smiVersion) {
        int i;
        int column = 20;
        for (ElementType elem : elems) {
            if (elem.getName().length() + 2 <= column) continue;
            column = elem.getName().length() + 2;
        }
        String typeIndent = indent;
        for (i = 0; i < column; ++i) {
            typeIndent = typeIndent + " ";
        }
        for (i = 0; i < elems.length; ++i) {
            if (i > 0) {
                this.os.println(",");
            }
            this.printComment(elems[i].getComment(), indent, true);
            this.os.print(indent);
            this.os.print(elems[i].getName());
            for (int j = elems[i].getName().length(); j < column; ++j) {
                this.os.print(" ");
            }
            this.printType(elems[i].getType(), typeIndent, smiVersion);
        }
    }

    private void printConstraint(MibType type, String indent) {
        StringType strType;
        if (type instanceof IntegerType) {
            IntegerType intType = (IntegerType)type;
            if (intType.hasSymbols()) {
                this.os.println(" {");
                this.printEnumeration(intType.getAllSymbols(), indent + "    ");
                this.os.println();
                this.os.print(indent);
                this.os.print("}");
            } else if (intType.hasConstraint()) {
                this.os.print(" (");
                this.os.print(intType.getConstraint());
                this.os.print(")");
            }
        } else if (type instanceof BitSetType) {
            BitSetType bitType = (BitSetType)type;
            if (bitType.hasSymbols()) {
                this.os.println(" {");
                this.printEnumeration(bitType.getAllSymbols(), indent + "    ");
                this.os.println();
                this.os.print(indent);
                this.os.print("}");
            } else if (bitType.hasConstraint()) {
                this.os.print(" (");
                this.os.print(bitType.getConstraint());
                this.os.print(")");
            }
        } else if (type instanceof StringType && (strType = (StringType)type).hasConstraint()) {
            this.os.print(" (");
            this.os.print(strType.getConstraint());
            this.os.print(")");
        }
    }

    private void printEnumeration(MibValueSymbol[] symbols, String indent) {
        for (int i = 0; i < symbols.length; ++i) {
            if (i > 0) {
                this.os.println(",");
            }
            this.printComment(symbols[i].getComment(), indent, true);
            this.os.print(indent);
            this.os.print(symbols[i].getName());
            this.os.print("(");
            this.os.print(symbols[i].getValue());
            this.os.print(")");
        }
    }

    private void printValue(MibValue value) {
        if (value instanceof ObjectIdentifierValue) {
            this.os.print("{ ");
            this.os.print(((ObjectIdentifierValue)value).toAsn1String());
            this.os.print(" }");
        } else if (value instanceof StringValue) {
            this.os.print(this.getQuote(value.toString()));
        } else {
            this.os.print(value.toString());
        }
    }

    private void printReference(Object obj) {
        this.os.print("{ ");
        this.printReferenceEntry(obj);
        this.os.print(" }");
    }

    private void printReference(Object obj, MibValueSymbol[] values) {
        if (obj instanceof BitSetValue) {
            obj = ((BitSetValue)obj).toAsn1String(values);
        } else if (values != null) {
            for (MibValueSymbol val : values) {
                if (!val.getValue().equals(obj)) continue;
                this.printReference(val.getName());
                return;
            }
        }
        this.printReference(obj);
    }

    private void printReferenceList(ArrayList<?> list, String indent) {
        if (list.size() == 1) {
            this.printReference(list.get(0));
        } else {
            this.os.print("{");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    this.os.print(",");
                }
                this.os.println();
                this.os.print(indent);
                this.os.print("    ");
                this.printReferenceEntry(list.get(i));
            }
            this.os.println();
            this.os.print(indent);
            this.os.print("}");
        }
    }

    private void printReferenceEntry(Object obj) {
        if (obj instanceof SnmpIndex) {
            if (((SnmpIndex)obj).isImplied()) {
                this.os.print("IMPLIED ");
            }
            this.printReferenceEntry(((SnmpIndex)obj).getTypeOrValue());
        } else if (obj instanceof ObjectIdentifierValue) {
            ObjectIdentifierValue oid = (ObjectIdentifierValue)obj;
            if (oid.getSymbol() != null) {
                this.os.print(oid.getSymbol().getName());
            } else {
                this.os.print(oid.toAsn1String());
            }
        } else if (obj instanceof StringValue) {
            this.os.print(this.getQuote(obj.toString()));
        } else {
            this.os.print(obj.toString());
        }
    }

    private void printIndent(String indent, String str) {
        if (this.margin > 0) {
            str = this.reflow(str, this.margin - indent.length());
        }
        int pos = -1;
        while (str != null && (pos = str.indexOf(10)) >= 0) {
            if (pos == 0) {
                this.os.println();
            } else {
                this.os.print(indent);
                this.os.println(str.substring(0, pos));
            }
            str = str.substring(pos + 1);
        }
        if (str != null && str.length() > 0) {
            this.os.print(indent);
            this.os.print(str);
        }
    }

    private String reflow(String str, int maxLen) {
        StringBuilder src = new StringBuilder(str);
        StringBuilder res = new StringBuilder();
        while (src.length() > 0) {
            int pos = src.indexOf("\n");
            boolean fillNext = false;
            if (fillNext && pos > 0) {
                fillNext = false;
                src.setCharAt(pos, ' ');
                pos = src.indexOf("\n");
            }
            if (pos == 0) {
                fillNext = false;
                res.append("\n");
            } else {
                int temp;
                if (pos < 0) {
                    pos = src.length();
                }
                while (pos > maxLen && (temp = src.lastIndexOf(" ", pos - 1)) >= 0) {
                    pos = temp;
                    fillNext = true;
                }
                res.append(src.substring(0, pos));
                res.append("\n");
            }
            if (pos + 1 >= src.length()) {
                src.setLength(0);
                continue;
            }
            src.delete(0, pos + 1);
        }
        return res.toString();
    }

    private Constraint getConstraint(MibType type) {
        if (type instanceof IntegerType) {
            return ((IntegerType)type).getConstraint();
        }
        if (type instanceof BitSetType) {
            return ((BitSetType)type).getConstraint();
        }
        if (type instanceof StringType) {
            return ((StringType)type).getConstraint();
        }
        if (type instanceof SnmpTextualConvention) {
            return this.getConstraint(((SnmpTextualConvention)type).getSyntax());
        }
        return null;
    }

    private MibValueSymbol[] getSymbols(Object obj) {
        if (obj instanceof IntegerType) {
            return ((IntegerType)obj).getAllSymbols();
        }
        if (obj instanceof BitSetType) {
            return ((BitSetType)obj).getAllSymbols();
        }
        if (obj instanceof SnmpTextualConvention) {
            return this.getSymbols(((SnmpTextualConvention)obj).getSyntax());
        }
        if (obj instanceof SnmpObjectType) {
            return this.getSymbols(((SnmpObjectType)obj).getSyntax());
        }
        if (obj instanceof MibValueSymbol) {
            return this.getSymbols(((MibValueSymbol)obj).getType());
        }
        return null;
    }

    private String getQuote(String str) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('\"');
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\"') {
                buffer.append("\"\"");
                continue;
            }
            buffer.append(str.charAt(i));
        }
        buffer.append('\"');
        return buffer.toString();
    }
}

