/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.percederberg.mibble.MibContext;
import net.percederberg.mibble.MibException;
import net.percederberg.mibble.MibFileRef;
import net.percederberg.mibble.MibImport;
import net.percederberg.mibble.MibLoader;
import net.percederberg.mibble.MibLoaderException;
import net.percederberg.mibble.MibLoaderLog;
import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValue;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.value.NumberValue;
import net.percederberg.mibble.value.ObjectIdentifierValue;

public class Mib
implements MibContext {
    private MibLoader loader;
    private MibLoaderLog log;
    private MibFileRef fileRef = null;
    private boolean loaded = false;
    private String name = null;
    private int smiVersion = 1;
    private String headerComment = null;
    private String footerComment = null;
    private ArrayList<String> text = new ArrayList();
    private ArrayList<MibImport> imports = new ArrayList();
    private ArrayList<MibSymbol> symbolList = new ArrayList();
    private HashMap<String, MibSymbol> symbolNameMap = new HashMap();
    private HashMap<String, MibSymbol> symbolValueMap = new HashMap();

    Mib(MibLoader loader, MibLoaderLog log) {
        this.loader = loader;
        this.log = log;
    }

    void initialize() throws MibLoaderException {
        int errors = this.log.errorCount();
        for (MibImport imp : this.imports) {
            imp.initialize(this.log);
            if (!this.loaded) continue;
            imp.validateSmiVersion(this.log, this);
        }
        if (errors != this.log.errorCount()) {
            throw new MibLoaderException(this.log);
        }
    }

    void validate() throws MibLoaderException {
        int errors = this.log.errorCount();
        for (MibSymbol symbol : new ArrayList<MibSymbol>(this.symbolList)) {
            try {
                symbol.initialize(this.log);
            }
            catch (MibException e) {
                this.log.addError(e);
            }
            if (!(symbol instanceof MibValueSymbol)) continue;
            MibValue value = ((MibValueSymbol)symbol).getValue();
            boolean isNumber = value instanceof NumberValue;
            boolean isOID = value instanceof ObjectIdentifierValue;
            if (!isNumber && !isOID) continue;
            if (this.symbolValueMap.containsKey(value.toString())) {
                String msg = "duplicate definition of " + value.toString() + " in MIB";
                this.log.addWarning(symbol.getFileRef(), msg);
            }
            this.symbolValueMap.put(value.toString(), symbol);
        }
        if (errors != this.log.errorCount()) {
            throw new MibLoaderException(this.log);
        }
    }

    void clear() {
        this.loader = null;
        this.log = null;
        if (this.imports != null) {
            this.imports.clear();
        }
        this.imports = null;
        if (this.symbolList != null) {
            for (MibSymbol symbol : new ArrayList<MibSymbol>(this.symbolList)) {
                symbol.clear();
            }
            this.symbolList.clear();
        }
        this.symbolList = null;
        if (this.symbolNameMap != null) {
            this.symbolNameMap.clear();
        }
        this.symbolNameMap = null;
        if (this.symbolValueMap != null) {
            this.symbolValueMap.clear();
        }
        this.symbolValueMap = null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.name.equals(obj);
        }
        if (this.fileRef.file != null && obj instanceof File) {
            return this.fileRef.file.equals(obj);
        }
        if (obj instanceof Mib) {
            return obj.equals(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public File getFile() {
        return this.fileRef.getFile();
    }

    void setFileRef(MibFileRef fileRef) {
        this.fileRef = fileRef;
        if (fileRef.file == null) {
            fileRef.file = new File(this.name);
        }
    }

    public MibLoader getLoader() {
        return this.loader;
    }

    public MibLoaderLog getLog() {
        return this.log;
    }

    public int getSmiVersion() {
        return this.smiVersion;
    }

    void setSmiVersion(int version) {
        this.smiVersion = version;
    }

    public String getText() {
        StringBuilder buffer = new StringBuilder();
        for (String line : this.text) {
            buffer.append(line);
            buffer.append('\n');
        }
        return buffer.toString();
    }

    String getText(MibFileRef ref) {
        int from = ref.lineCommentStart - this.fileRef.lineCommentStart;
        int to = ref.lineEnd - this.fileRef.lineCommentStart;
        StringBuilder buffer = new StringBuilder();
        for (int i = from; i <= to; ++i) {
            buffer.append(this.text.get(i));
            buffer.append('\n');
        }
        return buffer.toString();
    }

    void setText(String text) {
        String[] lines;
        this.text.clear();
        for (String line : lines = text.split("[ \\t\\r]*\\n")) {
            this.text.add(line);
        }
    }

    public String getHeaderComment() {
        return this.headerComment;
    }

    void setHeaderComment(String comment) {
        this.headerComment = comment;
    }

    public String getFooterComment() {
        return this.footerComment;
    }

    void setFooterComment(String comment) {
        this.footerComment = comment;
    }

    public List<MibImport> getAllImports() {
        ArrayList<MibImport> res = new ArrayList<MibImport>();
        for (MibImport imp : this.imports) {
            if (!imp.hasSymbols()) continue;
            res.add(imp);
        }
        return res;
    }

    MibImport getImport(String name) {
        for (MibImport imp : this.imports) {
            if (!imp.getName().equals(name)) continue;
            return imp;
        }
        return null;
    }

    void addImport(MibImport ref) {
        this.imports.add(ref);
    }

    public Mib[] getImportingMibs() {
        ArrayList<Mib> res = new ArrayList<Mib>();
        for (Mib mib : this.loader.getAllMibs()) {
            if (mib == this || mib.getImport(this.name) == null) continue;
            res.add(mib);
        }
        return res.toArray(new Mib[res.size()]);
    }

    public List<MibSymbol> getAllSymbols() {
        return this.symbolList;
    }

    public MibSymbol getSymbol(String name) {
        return this.symbolNameMap.get(name);
    }

    public MibValueSymbol getSymbolByValue(String value) {
        if (value.startsWith(".")) {
            value = value.substring(1);
        }
        return (MibValueSymbol)this.symbolValueMap.get(value);
    }

    public MibValueSymbol getSymbolByValue(MibValue value) {
        return (MibValueSymbol)this.symbolValueMap.get(value.toString());
    }

    public MibValueSymbol getSymbolByOid(String oid) {
        if (oid.startsWith(".")) {
            oid = oid.substring(1);
        }
        int pos = 0;
        do {
            MibValueSymbol sym;
            if ((sym = this.getSymbolByValue(oid)) != null) {
                return sym;
            }
            pos = oid.lastIndexOf(".");
            if (pos <= 0) continue;
            oid = oid.substring(0, pos);
        } while (pos > 0);
        return null;
    }

    public MibValueSymbol getRootSymbol() {
        MibValueSymbol root = null;
        for (MibSymbol symbol : this.symbolList) {
            if (!(symbol instanceof MibValueSymbol)) continue;
            root = (MibValueSymbol)symbol;
            break;
        }
        MibValueSymbol parent = null;
        while (root != null && (parent = root.getParent()) != null && root.getMib().equals(parent.getMib())) {
            root = parent;
        }
        return root;
    }

    void addSymbol(MibSymbol symbol) {
        this.symbolList.add(symbol);
        this.symbolNameMap.put(symbol.getName(), symbol);
    }

    @Override
    public MibSymbol findSymbol(String name, boolean expanded) {
        return this.getSymbol(name);
    }

    public String toString() {
        return this.getName();
    }
}

