/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class FileLocation {
    protected File file;
    protected int line;
    protected int column;

    public FileLocation(File file) {
        this(file, -1, -1);
    }

    public FileLocation(File file, int line, int column) {
        this.file = file;
        this.line = line;
        this.column = column;
    }

    public File getFile() {
        return this.file;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readLine() {
        if (this.file == null) return null;
        if (this.line < 0) {
            return null;
        }
        try (BufferedReader input = new BufferedReader(new FileReader(this.file));){
            int chr;
            int count = 1;
            while (count < this.line && (chr = input.read()) >= 0) {
                if (chr != 10) continue;
                ++count;
            }
            String string = input.readLine();
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }
}

