/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import net.percederberg.grammatica.parser.LookAheadSet;
import net.percederberg.grammatica.parser.Token;

public class ProductionPatternElement {
    private boolean token;
    private int id;
    private int min;
    private int max;
    private LookAheadSet lookAhead;

    public ProductionPatternElement(boolean isToken, int id, int min, int max) {
        this.token = isToken;
        this.id = id;
        if (min < 0) {
            min = 0;
        }
        this.min = min;
        if (max <= 0) {
            max = Integer.MAX_VALUE;
        } else if (max < min) {
            max = min;
        }
        this.max = max;
        this.lookAhead = null;
    }

    public boolean isToken() {
        return this.token;
    }

    public boolean isProduction() {
        return !this.token;
    }

    public boolean isMatch(Token token) {
        return this.isToken() && token != null && token.getId() == this.id;
    }

    public int getId() {
        return this.id;
    }

    public int getMinCount() {
        return this.min;
    }

    public int getMaxCount() {
        return this.max;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProductionPatternElement) {
            ProductionPatternElement elem = (ProductionPatternElement)obj;
            return this.token == elem.token && this.id == elem.id && this.min == elem.min && this.max == elem.max;
        }
        return false;
    }

    public int hashCode() {
        return this.id * 37;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.id);
        if (this.token) {
            buffer.append("(Token)");
        } else {
            buffer.append("(Production)");
        }
        if (this.min != 1 || this.max != 1) {
            buffer.append("{");
            buffer.append(this.min);
            buffer.append(",");
            buffer.append(this.max);
            buffer.append("}");
        }
        return buffer.toString();
    }

    LookAheadSet getLookAhead() {
        return this.lookAhead;
    }

    void setLookAhead(LookAheadSet lookAhead) {
        this.lookAhead = lookAhead;
    }
}

