/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.ArrayList;
import net.percederberg.grammatica.parser.Parser;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.Tokenizer;

class LookAheadSet {
    private ArrayList elements = new ArrayList();
    private int maxLength;

    public LookAheadSet(int maxLength) {
        this.maxLength = maxLength;
    }

    public LookAheadSet(int maxLength, LookAheadSet set) {
        this(maxLength);
        this.addAll(set);
    }

    public boolean isEmpty() {
        return this.elements.size() == 0;
    }

    public int getMinLength() {
        int min = -1;
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence seq = (Sequence)this.elements.get(i);
            if (min >= 0 && seq.length() >= min) continue;
            min = seq.length();
        }
        return min < 0 ? 0 : min;
    }

    public int getMaxLength() {
        int max = 0;
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence seq = (Sequence)this.elements.get(i);
            if (seq.length() <= max) continue;
            max = seq.length();
        }
        return max;
    }

    public int[] getInitialTokens() {
        int i;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (i = 0; i < this.elements.size(); ++i) {
            Integer token = ((Sequence)this.elements.get(i)).getToken(0);
            if (token == null || list.contains(token)) continue;
            list.add(token);
        }
        int[] result = new int[list.size()];
        for (i = 0; i < list.size(); ++i) {
            result[i] = (Integer)list.get(i);
        }
        return result;
    }

    public boolean isRepetitive() {
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence seq = (Sequence)this.elements.get(i);
            if (!seq.isRepetitive()) continue;
            return true;
        }
        return false;
    }

    public boolean isNext(Parser parser) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence seq = (Sequence)this.elements.get(i);
            if (!seq.isNext(parser)) continue;
            return true;
        }
        return false;
    }

    public boolean isNext(Parser parser, int length) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence seq = (Sequence)this.elements.get(i);
            if (!seq.isNext(parser, length)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOverlap(LookAheadSet set) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!set.hasOverlap((Sequence)this.elements.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean hasOverlap(Sequence seq) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence elem = (Sequence)this.elements.get(i);
            if (!seq.startsWith(elem) && !elem.startsWith(seq)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIntersection(LookAheadSet set) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!set.contains((Sequence)this.elements.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean contains(Sequence elem) {
        return this.findSequence(elem) != null;
    }

    private Sequence findSequence(Sequence elem) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!this.elements.get(i).equals(elem)) continue;
            return (Sequence)this.elements.get(i);
        }
        return null;
    }

    private void add(Sequence seq) {
        if (seq.length() > this.maxLength) {
            seq = new Sequence(this.maxLength, seq);
        }
        if (!this.contains(seq)) {
            this.elements.add(seq);
        }
    }

    public void add(int token) {
        this.add(new Sequence(false, token));
    }

    public void addAll(LookAheadSet set) {
        for (int i = 0; i < set.elements.size(); ++i) {
            this.add((Sequence)set.elements.get(i));
        }
    }

    public void addEmpty() {
        this.add(new Sequence());
    }

    private void remove(Sequence seq) {
        this.elements.remove(seq);
    }

    public void removeAll(LookAheadSet set) {
        for (int i = 0; i < set.elements.size(); ++i) {
            this.remove((Sequence)set.elements.get(i));
        }
    }

    public LookAheadSet createNextSet(int token) {
        LookAheadSet result = new LookAheadSet(this.maxLength - 1);
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence seq = (Sequence)this.elements.get(i);
            Integer value = seq.getToken(0);
            if (value == null || value != token) continue;
            result.add(seq.subsequence(1));
        }
        return result;
    }

    public LookAheadSet createIntersection(LookAheadSet set) {
        LookAheadSet result = new LookAheadSet(this.maxLength);
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence seq1 = (Sequence)this.elements.get(i);
            Sequence seq2 = set.findSequence(seq1);
            if (seq2 != null && seq1.isRepetitive()) {
                result.add(seq2);
                continue;
            }
            if (seq2 == null) continue;
            result.add(seq1);
        }
        return result;
    }

    public LookAheadSet createCombination(LookAheadSet set) {
        LookAheadSet result = new LookAheadSet(this.maxLength);
        if (this.isEmpty()) {
            return set;
        }
        if (set.isEmpty()) {
            return this;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence first = (Sequence)this.elements.get(i);
            if (first.length() >= this.maxLength) {
                result.add(first);
                continue;
            }
            if (first.length() <= 0) {
                result.addAll(set);
                continue;
            }
            for (int j = 0; j < set.elements.size(); ++j) {
                Sequence second = (Sequence)set.elements.get(j);
                result.add(first.concat(this.maxLength, second));
            }
        }
        return result;
    }

    public LookAheadSet createOverlaps(LookAheadSet set) {
        LookAheadSet result = new LookAheadSet(this.maxLength);
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence seq = (Sequence)this.elements.get(i);
            if (!set.hasOverlap(seq)) continue;
            result.add(seq);
        }
        return result;
    }

    public LookAheadSet createFilter(LookAheadSet set) {
        LookAheadSet result = new LookAheadSet(this.maxLength);
        if (this.isEmpty() || set.isEmpty()) {
            return this;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence first = (Sequence)this.elements.get(i);
            for (int j = 0; j < set.elements.size(); ++j) {
                Sequence second = (Sequence)set.elements.get(j);
                if (!first.startsWith(second)) continue;
                result.add(first.subsequence(second.length()));
            }
        }
        return result;
    }

    public LookAheadSet createRepetitive() {
        LookAheadSet result = new LookAheadSet(this.maxLength);
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence seq = (Sequence)this.elements.get(i);
            if (seq.isRepetitive()) {
                result.add(seq);
                continue;
            }
            result.add(new Sequence(true, seq));
        }
        return result;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Tokenizer tokenizer) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        for (int i = 0; i < this.elements.size(); ++i) {
            Sequence seq = (Sequence)this.elements.get(i);
            buffer.append("\n  ");
            buffer.append(seq.toString(tokenizer));
        }
        buffer.append("\n}");
        return buffer.toString();
    }

    private class Sequence {
        private boolean repeat = false;
        private ArrayList tokens = null;

        public Sequence() {
            this.repeat = false;
            this.tokens = new ArrayList(0);
        }

        public Sequence(boolean repeat, int token) {
            this.repeat = false;
            this.tokens = new ArrayList(1);
            this.tokens.add(new Integer(token));
        }

        public Sequence(int length, Sequence seq) {
            this.repeat = seq.repeat;
            this.tokens = new ArrayList(length);
            if (seq.length() < length) {
                length = seq.length();
            }
            for (int i = 0; i < length; ++i) {
                this.tokens.add(seq.tokens.get(i));
            }
        }

        public Sequence(boolean repeat, Sequence seq) {
            this.repeat = repeat;
            this.tokens = seq.tokens;
        }

        public int length() {
            return this.tokens.size();
        }

        public Integer getToken(int pos) {
            if (pos >= 0 && pos < this.tokens.size()) {
                return (Integer)this.tokens.get(pos);
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Sequence) {
                return this.tokens.equals(((Sequence)obj).tokens);
            }
            return false;
        }

        public int hashCode() {
            return this.tokens.hashCode();
        }

        public boolean startsWith(Sequence seq) {
            if (this.length() < seq.length()) {
                return false;
            }
            for (int i = 0; i < seq.tokens.size(); ++i) {
                if (this.tokens.get(i).equals(seq.tokens.get(i))) continue;
                return false;
            }
            return true;
        }

        public boolean isRepetitive() {
            return this.repeat;
        }

        public boolean isNext(Parser parser) {
            for (int i = 0; i < this.tokens.size(); ++i) {
                Integer id = (Integer)this.tokens.get(i);
                Token token = parser.peekToken(i);
                if (token != null && token.getId() == id.intValue()) continue;
                return false;
            }
            return true;
        }

        public boolean isNext(Parser parser, int length) {
            if (length > this.tokens.size()) {
                length = this.tokens.size();
            }
            for (int i = 0; i < length; ++i) {
                Integer id = (Integer)this.tokens.get(i);
                Token token = parser.peekToken(i);
                if (token != null && token.getId() == id.intValue()) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(Tokenizer tokenizer) {
            StringBuffer buffer = new StringBuffer();
            if (tokenizer == null) {
                buffer.append(this.tokens.toString());
            } else {
                buffer.append("[");
                for (int i = 0; i < this.tokens.size(); ++i) {
                    Integer id = (Integer)this.tokens.get(i);
                    String str = tokenizer.getPatternDescription(id);
                    if (i > 0) {
                        buffer.append(" ");
                    }
                    buffer.append(str);
                }
                buffer.append("]");
            }
            if (this.repeat) {
                buffer.append(" *");
            }
            return buffer.toString();
        }

        public Sequence concat(int length, Sequence seq) {
            Sequence res = new Sequence(length, this);
            if (seq.repeat) {
                res.repeat = true;
            }
            if ((length -= this.length()) > seq.length()) {
                res.tokens.addAll(seq.tokens);
            } else {
                for (int i = 0; i < length; ++i) {
                    res.tokens.add(seq.tokens.get(i));
                }
            }
            return res;
        }

        public Sequence subsequence(int start) {
            Sequence res = new Sequence(this.length(), this);
            while (start > 0 && res.tokens.size() > 0) {
                res.tokens.remove(0);
                --start;
            }
            return res;
        }
    }
}

