/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.io.InputStream;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.AsnSequence;
import uk.co.westhawk.snmp.stack.AsnUnsInteger;
import uk.co.westhawk.snmp.stack.DecodingException;

class AsnTrapPduv1Sequence
extends AsnSequence {
    private static final String version_id = "@(#)$Id: AsnTrapPduv1Sequence.java,v 3.6 2006/01/17 17:43:54 birgit Exp $ Copyright Westhawk Ltd";

    AsnTrapPduv1Sequence(InputStream in, int len, int pos) throws IOException {
        super(in, len, pos);
    }

    String getEnterprise() throws DecodingException {
        String ent = "";
        AsnObject obj = this.getObj(0);
        if (!(obj instanceof AsnObjectId)) {
            String msg = "TrapPduv1.Enterprise should be AsnObjectId instead of " + obj.getRespTypeString();
            throw new DecodingException(msg);
        }
        AsnObjectId rid = (AsnObjectId)obj;
        ent = rid.getValue();
        return ent;
    }

    byte[] getIPAddress() throws DecodingException {
        byte[] ip = null;
        AsnObject obj = this.getObj(1);
        if (!(obj instanceof AsnOctets)) {
            String msg = "TrapPduv1.IPAddress should be of type AsnOctets instead of " + obj.getRespTypeString();
            throw new DecodingException(msg);
        }
        AsnOctets estat = (AsnOctets)obj;
        ip = estat.getBytes();
        return ip;
    }

    int getGenericTrap() throws DecodingException {
        int genTrap = -1;
        AsnObject obj = this.getObj(2);
        if (!(obj instanceof AsnInteger)) {
            String msg = "TrapPduv1.GenericTrap should be of type AsnInteger instead of " + obj.getRespTypeString();
            throw new DecodingException(msg);
        }
        AsnInteger estat = (AsnInteger)obj;
        genTrap = estat.getValue();
        return genTrap;
    }

    int getSpecificTrap() throws DecodingException {
        int specTrap = -1;
        AsnObject obj = this.getObj(3);
        if (!(obj instanceof AsnInteger)) {
            String msg = "TrapPduv1.SpecificTrap should be of type AsnInteger instead of " + obj.getRespTypeString();
            throw new DecodingException(msg);
        }
        AsnInteger estat = (AsnInteger)obj;
        specTrap = estat.getValue();
        return specTrap;
    }

    long getTimeTicks() throws DecodingException {
        long ticks = -1L;
        AsnObject obj = this.getObj(4);
        if (!(obj instanceof AsnUnsInteger)) {
            String msg = "TrapPduv1.TimeTicks should be of type AsnUnsInteger instead of " + obj.getRespTypeString();
            throw new DecodingException(msg);
        }
        AsnUnsInteger estat = (AsnUnsInteger)obj;
        ticks = estat.getValue();
        return ticks;
    }

    AsnSequence getVarBind() throws DecodingException {
        AsnSequence varb = null;
        AsnObject obj = this.getObj(5);
        if (!(obj instanceof AsnSequence)) {
            String msg = "TrapPduv1.VarBind should be of type AsnSequence instead of " + obj.getRespTypeString();
            throw new DecodingException(msg);
        }
        varb = (AsnSequence)obj;
        return varb;
    }

    AsnObject findTrapPduv1() {
        return this;
    }
}

