/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import uk.co.westhawk.snmp.beans.SNMPRunBean;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.GetNextPdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.varbind;

public class NTPrintQBean
extends SNMPRunBean
implements Observer {
    private static final String version_id = "@(#)$Id: NTPrintQBean.java,v 1.13 2006/01/25 18:08:55 birgit Exp $ Copyright Westhawk Ltd";
    public static final String svPrintQName = "1.3.6.1.4.1.77.1.2.29.1.1";
    private int svPrintQName_len;
    private GetNextPdu pdu;
    private Hashtable printHash = new Hashtable();
    private boolean isGetNextInFlight;
    private Date lastUpdateDate = null;

    public NTPrintQBean() {
        this.svPrintQName_len = svPrintQName.length();
    }

    public NTPrintQBean(String h, int p) {
        this(h, p, null);
    }

    public NTPrintQBean(String h, int p, String b) {
        this();
        this.setHost(h);
        this.setPort(p);
        this.setBindAddress(b);
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public Enumeration getIndices() {
        return this.printHash.elements();
    }

    public String getIndex(String name) {
        return (String)this.printHash.get(name);
    }

    public Enumeration getNames() {
        return this.printHash.keys();
    }

    public synchronized int getCount() {
        return this.printHash.size();
    }

    public void action() {
        if (this.isHostPortReachable()) {
            this.printHash.clear();
            this.lastUpdateDate = new Date();
            this.isGetNextInFlight = false;
            this.setRunning(true);
        }
    }

    public void run() {
        while (this.context != null && this.isRunning()) {
            if (!this.isGetNextInFlight) {
                this.isGetNextInFlight = true;
                this.pdu = new GetNextPdu(this.context);
                this.pdu.addObserver(this);
                this.pdu.addOid(svPrintQName);
                try {
                    this.pdu.send();
                }
                catch (PduException exc) {
                    System.out.println("PduException " + exc.getMessage());
                }
                catch (IOException exc) {
                    System.out.println("IOException " + exc.getMessage());
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void update(Observable obs, Object ov) {
        this.pdu = (GetNextPdu)obs;
        if (this.pdu.getErrorStatus() == 0) {
            varbind var = (varbind)ov;
            String oid = "";
            if (var != null) {
                oid = var.getOid().toString();
            }
            if (oid.startsWith(svPrintQName)) {
                String index = oid.substring(this.svPrintQName_len + 1);
                String name = ((AsnOctets)var.getValue()).getValue();
                this.printHash.put(name, index);
                this.pdu = new GetNextPdu(this.context);
                this.pdu.addObserver(this);
                this.pdu.addOid(oid);
                try {
                    this.pdu.send();
                }
                catch (PduException exc) {
                    System.out.println("PduException " + exc.getMessage());
                }
                catch (IOException exc) {
                    System.out.println("IOException " + exc.getMessage());
                }
            } else {
                this.lastUpdateDate = new Date();
                this.isGetNextInFlight = false;
                this.firePropertyChange("resourceNames", null, null);
            }
        } else {
            this.lastUpdateDate = new Date();
            this.isGetNextInFlight = false;
            this.firePropertyChange("resourceNames", null, null);
        }
    }
}

