/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.output;

import java.io.IOException;
import net.percederberg.grammatica.code.visualbasic.VisualBasicClass;
import net.percederberg.grammatica.code.visualbasic.VisualBasicComment;
import net.percederberg.grammatica.code.visualbasic.VisualBasicConstructor;
import net.percederberg.grammatica.code.visualbasic.VisualBasicFile;
import net.percederberg.grammatica.code.visualbasic.VisualBasicImports;
import net.percederberg.grammatica.code.visualbasic.VisualBasicMethod;
import net.percederberg.grammatica.code.visualbasic.VisualBasicNamespace;
import net.percederberg.grammatica.output.VisualBasicConstantsFile;
import net.percederberg.grammatica.output.VisualBasicParserGenerator;
import net.percederberg.grammatica.parser.TokenPattern;

class VisualBasicTokenizerFile {
    private static final String TYPE_COMMENT = "<remarks>A character stream tokenizer.</remarks>";
    private static final String CONSTRUCTOR_COMMENT = "<summary>Creates a new tokenizer for the specified input\nstream.</summary>\n\n<param name='input'>the input stream to read</param>\n\n<exception cref='ParserCreationException'>if the tokenizer\ncouldn't be initialized correctly</exception>";
    private static final String INIT_METHOD_COMMENT = "<summary>Initializes the tokenizer by creating all the token\npatterns.</summary>\n\n<exception cref='ParserCreationException'>if the tokenizer\ncouldn't be initialized correctly</exception>";
    private VisualBasicParserGenerator gen;
    private VisualBasicFile file;
    private VisualBasicClass cls;
    private VisualBasicMethod initMethod;

    public VisualBasicTokenizerFile(VisualBasicParserGenerator gen) {
        String name = gen.getBaseName() + "Tokenizer";
        this.gen = gen;
        this.file = new VisualBasicFile(gen.getBaseDir(), name);
        int modifiers = gen.getPublicAccess() ? 1 : 4;
        this.cls = new VisualBasicClass(modifiers, name, "Tokenizer");
        this.initMethod = new VisualBasicMethod(5, "CreatePatterns", "", "");
        this.initializeCode();
    }

    private void initializeCode() {
        this.file.addImports(new VisualBasicImports("System.IO"));
        this.file.addImports(new VisualBasicImports("PerCederberg.Grammatica.Runtime"));
        if (this.gen.getNamespace() == null) {
            this.file.addClass(this.cls);
        } else {
            VisualBasicNamespace n = new VisualBasicNamespace(this.gen.getNamespace());
            n.addClass(this.cls);
            this.file.addNamespace(n);
        }
        String str = this.file.toString() + "\n\n" + this.gen.getFileComment();
        this.file.addComment(new VisualBasicComment(1, str));
        this.cls.addComment(new VisualBasicComment(TYPE_COMMENT));
        VisualBasicConstructor constr = new VisualBasicConstructor("ByVal input As TextReader");
        this.cls.addConstructor(constr);
        constr.addComment(new VisualBasicComment(CONSTRUCTOR_COMMENT));
        constr.addCode("MyBase.New(input, " + this.getBoolean(!this.gen.getGrammar().getCaseSensitive()) + ")");
        constr.addCode("CreatePatterns()");
        this.cls.addMethod(this.initMethod);
        this.initMethod.addComment(new VisualBasicComment(INIT_METHOD_COMMENT));
        this.initMethod.addCode("Dim pattern as TokenPattern");
    }

    public void addToken(TokenPattern pattern, VisualBasicConstantsFile constants) {
        StringBuffer code = new StringBuffer();
        code.append("pattern = New TokenPattern(CInt(");
        code.append(constants.getConstant(pattern.getId()));
        code.append("), \"");
        code.append(pattern.getName());
        code.append("\", TokenPattern.PatternType.");
        switch (pattern.getType()) {
            case 1: {
                code.append("STRING");
                break;
            }
            case 2: {
                code.append("REGEXP");
            }
        }
        code.append(", ");
        String str = pattern.getPattern();
        code.append(this.gen.getCodeStyle().getStringConstant(str, '\"'));
        code.append(")\n");
        if (pattern.isError()) {
            if (pattern.getErrorMessage() == null) {
                code.append("pattern.Error = True");
            } else {
                code.append("pattern.ErrorMessage = ");
                str = pattern.getErrorMessage();
                code.append(this.gen.getCodeStyle().getStringConstant(str, '\"'));
            }
            code.append("\n");
        }
        if (pattern.isIgnore()) {
            if (pattern.getIgnoreMessage() == null) {
                code.append("pattern.Ignore = True");
            } else {
                code.append("pattern.IgnoreMessage = ");
                str = pattern.getIgnoreMessage();
                code.append(this.gen.getCodeStyle().getStringConstant(str, '\"'));
            }
            code.append("\n");
        }
        code.append("AddPattern(pattern)");
        this.initMethod.addCode("");
        this.initMethod.addCode(code.toString());
    }

    protected String getClassName() {
        return this.cls.toString();
    }

    private String getBoolean(boolean value) {
        return value ? "True" : "False";
    }

    public void writeCode() throws IOException {
        this.file.writeCode(this.gen.getCodeStyle());
    }
}

