/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code.java;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.LinkedList;
import net.percederberg.grammatica.code.CodeElement;
import net.percederberg.grammatica.code.CodeStyle;
import net.percederberg.grammatica.code.java.JavaClass;
import net.percederberg.grammatica.code.java.JavaComment;
import net.percederberg.grammatica.code.java.JavaModifier;

public class JavaConstructor
extends CodeElement {
    public static final int PUBLIC = 0;
    public static final int PROTECTED = 1;
    public static final int PACKAGE_LOCAL = 2;
    public static final int PRIVATE = 3;
    private int modifiers;
    private JavaClass cls;
    private String args;
    private LinkedList throwList;
    private LinkedList code;
    private JavaComment comment;

    public JavaConstructor() {
        this("");
    }

    public JavaConstructor(String args) {
        this(0, args);
    }

    public JavaConstructor(int modifiers, String args) {
        this.modifiers = modifiers;
        this.cls = null;
        this.args = args;
        this.throwList = new LinkedList();
        this.code = new LinkedList();
        this.comment = null;
    }

    public JavaClass getJavaClass() {
        return this.cls;
    }

    void setJavaClass(JavaClass cls) {
        this.cls = cls;
    }

    public void addThrows(String className) {
        this.throwList.add(className);
    }

    public void addCode(String codeLines) {
        int pos = codeLines.indexOf(10);
        while (pos >= 0) {
            this.code.add(codeLines.substring(0, pos));
            codeLines = codeLines.substring(pos + 1);
            pos = codeLines.indexOf(10);
        }
        this.code.add(codeLines);
    }

    public void addComment(JavaComment comment) {
        this.comment = comment;
    }

    public int category() {
        return 7;
    }

    public void print(PrintWriter out, CodeStyle style, int indent) {
        String indentStr = style.getIndent(indent);
        String codeIndentStr = style.getIndent(indent + 1);
        StringBuffer res = new StringBuffer();
        boolean brokenThrows = false;
        if (this.comment != null) {
            this.comment.print(out, style, indent);
        }
        res.append(indentStr);
        res.append(JavaModifier.createModifierDecl(this.modifiers));
        res.append(this.cls.toString());
        res.append("(");
        res.append(this.args);
        res.append(")");
        String str = this.getThrowDecl();
        if (str.length() > 0) {
            if (res.length() + str.length() < style.getMargin()) {
                res.append(" ");
            } else {
                res.append("\n");
                res.append(codeIndentStr);
                brokenThrows = true;
            }
            res.append(str);
        }
        res.append(" {\n");
        if (brokenThrows && this.code.size() > 0) {
            res.append("\n");
        }
        for (int i = 0; i < this.code.size(); ++i) {
            if (this.code.get(i).toString().length() > 0) {
                res.append(codeIndentStr);
                res.append(this.code.get(i).toString());
                res.append("\n");
                continue;
            }
            res.append("\n");
        }
        res.append(indentStr);
        res.append("}");
        out.println(res.toString());
    }

    private String getThrowDecl() {
        StringBuffer res = new StringBuffer("throws ");
        if (this.throwList.size() == 0) {
            return "";
        }
        Collections.sort(this.throwList);
        for (int i = 0; i < this.throwList.size(); ++i) {
            res.append(this.throwList.get(i).toString());
            if (i >= this.throwList.size() - 1) continue;
            res.append(", ");
        }
        return res.toString();
    }
}

