/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.code;

public class CodeStyle {
    public static final CodeStyle JAVA = new CodeStyle(70, "    ");
    public static final CodeStyle CSHARP = new CodeStyle(70, "    ");
    public static final CodeStyle VISUAL_BASIC = new CodeStyle(70, "    ");
    private int margin;
    private String indentString;

    public CodeStyle(int margin, String indent) {
        this.margin = margin;
        this.indentString = indent;
    }

    public int getMargin() {
        return this.margin;
    }

    public String getIndent(int level) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            buffer.append(this.indentString);
        }
        return buffer.toString();
    }

    public String getStringConstant(String str, char escape) {
        StringBuffer res = new StringBuffer();
        res.append('\"');
        res.append(this.addStringEscapes(str, escape));
        res.append('\"');
        return res.toString();
    }

    public String getUpperCase(String str) {
        StringBuffer res = new StringBuffer();
        char last = 'A';
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isLowerCase(last) && Character.isUpperCase(str.charAt(i))) {
                res.append("_");
            }
            if (!('A' <= (last = str.charAt(i)) && last <= 'Z' || 'a' <= last && last <= 'z' || '0' <= last && last <= '9') && last != 95) continue;
            res.append(Character.toUpperCase(last));
        }
        return res.toString();
    }

    public String getLowerCase(String str) {
        StringBuffer res = new StringBuffer();
        char last = 'A';
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isLowerCase(last) && Character.isUpperCase(str.charAt(i))) {
                res.append("_");
            }
            if (!('A' <= (last = str.charAt(i)) && last <= 'Z' || 'a' <= last && last <= 'z' || '0' <= last && last <= '9') && last != 95) continue;
            res.append(Character.toLowerCase(last));
        }
        return res.toString();
    }

    public String getMixedCase(String str, boolean initialUpper) {
        StringBuffer res = new StringBuffer();
        char last = 'A';
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isLowerCase(last) && Character.isUpperCase(str.charAt(i))) {
                initialUpper = true;
            } else if (str.charAt(i) == '_') {
                initialUpper = true;
            }
            last = str.charAt(i);
            if (!('A' <= last && last <= 'Z' || 'a' <= last && last <= 'z') && (48 > last || last > 57)) continue;
            if (initialUpper) {
                res.append(Character.toUpperCase(last));
                initialUpper = false;
                continue;
            }
            res.append(Character.toLowerCase(last));
        }
        return res.toString();
    }

    public String addStringEscapes(String str, char escape) {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\"') {
                res.append(escape);
                res.append("\"");
                continue;
            }
            if (str.charAt(i) == escape) {
                res.append(escape);
                res.append(escape);
                continue;
            }
            res.append(str.charAt(i));
        }
        return res.toString();
    }
}

