# frozen_string_literal: true

# WARNING ABOUT GENERATED CODE
#
# This file is generated. See the contributing guide for more information:
# https://github.com/aws/aws-sdk-ruby/blob/version-3/CONTRIBUTING.md
#
# WARNING ABOUT GENERATED CODE

module Aws::EC2
  module Types

    # Contains the parameters for accepting the quote.
    #
    # @note When making an API call, you may pass AcceptReservedInstancesExchangeQuoteRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         reserved_instance_ids: ["ReservationId"], # required
    #         target_configurations: [
    #           {
    #             instance_count: 1,
    #             offering_id: "ReservedInstancesOfferingId", # required
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] reserved_instance_ids
    #   The IDs of the Convertible Reserved Instances to exchange for
    #   another Convertible Reserved Instance of the same or higher value.
    #   @return [Array<String>]
    #
    # @!attribute [rw] target_configurations
    #   The configuration of the target Convertible Reserved Instance to
    #   exchange for your current Convertible Reserved Instances.
    #   @return [Array<Types::TargetConfigurationRequest>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuoteRequest AWS API Documentation
    #
    class AcceptReservedInstancesExchangeQuoteRequest < Struct.new(
      :dry_run,
      :reserved_instance_ids,
      :target_configurations)
      SENSITIVE = []
      include Aws::Structure
    end

    # The result of the exchange and whether it was `successful`.
    #
    # @!attribute [rw] exchange_id
    #   The ID of the successful exchange.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptReservedInstancesExchangeQuoteResult AWS API Documentation
    #
    class AcceptReservedInstancesExchangeQuoteResult < Struct.new(
      :exchange_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AcceptTransitGatewayMulticastDomainAssociationsRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_multicast_domain_id: "TransitGatewayMulticastDomainId",
    #         transit_gateway_attachment_id: "TransitGatewayAttachmentId",
    #         subnet_ids: ["String"],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the transit gateway attachment.
    #   @return [String]
    #
    # @!attribute [rw] subnet_ids
    #   The IDs of the subnets to associate with the transit gateway
    #   multicast domain.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociationsRequest AWS API Documentation
    #
    class AcceptTransitGatewayMulticastDomainAssociationsRequest < Struct.new(
      :transit_gateway_multicast_domain_id,
      :transit_gateway_attachment_id,
      :subnet_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] associations
    #   Describes the multicast domain associations.
    #   @return [Types::TransitGatewayMulticastDomainAssociations]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayMulticastDomainAssociationsResult AWS API Documentation
    #
    class AcceptTransitGatewayMulticastDomainAssociationsResult < Struct.new(
      :associations)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AcceptTransitGatewayPeeringAttachmentRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the transit gateway attachment.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachmentRequest AWS API Documentation
    #
    class AcceptTransitGatewayPeeringAttachmentRequest < Struct.new(
      :transit_gateway_attachment_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_peering_attachment
    #   The transit gateway peering attachment.
    #   @return [Types::TransitGatewayPeeringAttachment]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayPeeringAttachmentResult AWS API Documentation
    #
    class AcceptTransitGatewayPeeringAttachmentResult < Struct.new(
      :transit_gateway_peering_attachment)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AcceptTransitGatewayVpcAttachmentRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the attachment.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachmentRequest AWS API Documentation
    #
    class AcceptTransitGatewayVpcAttachmentRequest < Struct.new(
      :transit_gateway_attachment_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_vpc_attachment
    #   The VPC attachment.
    #   @return [Types::TransitGatewayVpcAttachment]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptTransitGatewayVpcAttachmentResult AWS API Documentation
    #
    class AcceptTransitGatewayVpcAttachmentResult < Struct.new(
      :transit_gateway_vpc_attachment)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AcceptVpcEndpointConnectionsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         service_id: "VpcEndpointServiceId", # required
    #         vpc_endpoint_ids: ["VpcEndpointId"], # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] service_id
    #   The ID of the VPC endpoint service.
    #   @return [String]
    #
    # @!attribute [rw] vpc_endpoint_ids
    #   The IDs of one or more interface VPC endpoints.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnectionsRequest AWS API Documentation
    #
    class AcceptVpcEndpointConnectionsRequest < Struct.new(
      :dry_run,
      :service_id,
      :vpc_endpoint_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] unsuccessful
    #   Information about the interface endpoints that were not accepted, if
    #   applicable.
    #   @return [Array<Types::UnsuccessfulItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcEndpointConnectionsResult AWS API Documentation
    #
    class AcceptVpcEndpointConnectionsResult < Struct.new(
      :unsuccessful)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AcceptVpcPeeringConnectionRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         vpc_peering_connection_id: "VpcPeeringConnectionId",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_peering_connection_id
    #   The ID of the VPC peering connection. You must specify this
    #   parameter in the request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnectionRequest AWS API Documentation
    #
    class AcceptVpcPeeringConnectionRequest < Struct.new(
      :dry_run,
      :vpc_peering_connection_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc_peering_connection
    #   Information about the VPC peering connection.
    #   @return [Types::VpcPeeringConnection]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AcceptVpcPeeringConnectionResult AWS API Documentation
    #
    class AcceptVpcPeeringConnectionResult < Struct.new(
      :vpc_peering_connection)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an account attribute.
    #
    # @!attribute [rw] attribute_name
    #   The name of the account attribute.
    #   @return [String]
    #
    # @!attribute [rw] attribute_values
    #   The values for the account attribute.
    #   @return [Array<Types::AccountAttributeValue>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AccountAttribute AWS API Documentation
    #
    class AccountAttribute < Struct.new(
      :attribute_name,
      :attribute_values)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a value of an account attribute.
    #
    # @!attribute [rw] attribute_value
    #   The value of the attribute.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AccountAttributeValue AWS API Documentation
    #
    class AccountAttributeValue < Struct.new(
      :attribute_value)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a running instance in a Spot Fleet.
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @!attribute [rw] instance_type
    #   The instance type.
    #   @return [String]
    #
    # @!attribute [rw] spot_instance_request_id
    #   The ID of the Spot Instance request.
    #   @return [String]
    #
    # @!attribute [rw] instance_health
    #   The health status of the instance. If the status of either the
    #   instance status check or the system status check is `impaired`, the
    #   health status of the instance is `unhealthy`. Otherwise, the health
    #   status is `healthy`.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ActiveInstance AWS API Documentation
    #
    class ActiveInstance < Struct.new(
      :instance_id,
      :instance_type,
      :spot_instance_request_id,
      :instance_health)
      SENSITIVE = []
      include Aws::Structure
    end

    # An entry for a prefix list.
    #
    # @note When making an API call, you may pass AddPrefixListEntry
    #   data as a hash:
    #
    #       {
    #         cidr: "String", # required
    #         description: "String",
    #       }
    #
    # @!attribute [rw] cidr
    #   The CIDR block.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A description for the entry.
    #
    #   Constraints: Up to 255 characters in length.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AddPrefixListEntry AWS API Documentation
    #
    class AddPrefixListEntry < Struct.new(
      :cidr,
      :description)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an Elastic IP address, or a carrier IP address.
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance that the address is associated with (if any).
    #   @return [String]
    #
    # @!attribute [rw] public_ip
    #   The Elastic IP address.
    #   @return [String]
    #
    # @!attribute [rw] allocation_id
    #   The ID representing the allocation of the address for use with
    #   EC2-VPC.
    #   @return [String]
    #
    # @!attribute [rw] association_id
    #   The ID representing the association of the address with an instance
    #   in a VPC.
    #   @return [String]
    #
    # @!attribute [rw] domain
    #   Indicates whether this Elastic IP address is for use with instances
    #   in EC2-Classic (`standard`) or instances in a VPC (`vpc`).
    #   @return [String]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @!attribute [rw] network_interface_owner_id
    #   The ID of the AWS account that owns the network interface.
    #   @return [String]
    #
    # @!attribute [rw] private_ip_address
    #   The private IP address associated with the Elastic IP address.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   Any tags assigned to the Elastic IP address.
    #   @return [Array<Types::Tag>]
    #
    # @!attribute [rw] public_ipv_4_pool
    #   The ID of an address pool.
    #   @return [String]
    #
    # @!attribute [rw] network_border_group
    #   The name of the unique set of Availability Zones, Local Zones, or
    #   Wavelength Zones from which AWS advertises IP addresses.
    #   @return [String]
    #
    # @!attribute [rw] customer_owned_ip
    #   The customer-owned IP address.
    #   @return [String]
    #
    # @!attribute [rw] customer_owned_ipv_4_pool
    #   The ID of the customer-owned address pool.
    #   @return [String]
    #
    # @!attribute [rw] carrier_ip
    #   The carrier IP address associated. This option is only available for
    #   network interfaces which reside in a subnet in a Wavelength Zone
    #   (for example an EC2 instance).
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/Address AWS API Documentation
    #
    class Address < Struct.new(
      :instance_id,
      :public_ip,
      :allocation_id,
      :association_id,
      :domain,
      :network_interface_id,
      :network_interface_owner_id,
      :private_ip_address,
      :tags,
      :public_ipv_4_pool,
      :network_border_group,
      :customer_owned_ip,
      :customer_owned_ipv_4_pool,
      :carrier_ip)
      SENSITIVE = []
      include Aws::Structure
    end

    # The attributes associated with an Elastic IP address.
    #
    # @!attribute [rw] public_ip
    #   The public IP address.
    #   @return [String]
    #
    # @!attribute [rw] allocation_id
    #   \[EC2-VPC\] The allocation ID.
    #   @return [String]
    #
    # @!attribute [rw] ptr_record
    #   The pointer (PTR) record for the IP address.
    #   @return [String]
    #
    # @!attribute [rw] ptr_record_update
    #   The updated PTR record for the IP address.
    #   @return [Types::PtrUpdateStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AddressAttribute AWS API Documentation
    #
    class AddressAttribute < Struct.new(
      :public_ip,
      :allocation_id,
      :ptr_record,
      :ptr_record_update)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AdvertiseByoipCidrRequest
    #   data as a hash:
    #
    #       {
    #         cidr: "String", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] cidr
    #   The address range, in CIDR notation. This must be the exact range
    #   that you provisioned. You can't advertise only a portion of the
    #   provisioned range.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidrRequest AWS API Documentation
    #
    class AdvertiseByoipCidrRequest < Struct.new(
      :cidr,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] byoip_cidr
    #   Information about the address range.
    #   @return [Types::ByoipCidr]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AdvertiseByoipCidrResult AWS API Documentation
    #
    class AdvertiseByoipCidrResult < Struct.new(
      :byoip_cidr)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AllocateAddressRequest
    #   data as a hash:
    #
    #       {
    #         domain: "vpc", # accepts vpc, standard
    #         address: "PublicIpAddress",
    #         public_ipv_4_pool: "Ipv4PoolEc2Id",
    #         network_border_group: "String",
    #         customer_owned_ipv_4_pool: "String",
    #         dry_run: false,
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] domain
    #   Indicates whether the Elastic IP address is for use with instances
    #   in a VPC or instances in EC2-Classic.
    #
    #   Default: If the Region supports EC2-Classic, the default is
    #   `standard`. Otherwise, the default is `vpc`.
    #   @return [String]
    #
    # @!attribute [rw] address
    #   \[EC2-VPC\] The Elastic IP address to recover or an IPv4 address
    #   from an address pool.
    #   @return [String]
    #
    # @!attribute [rw] public_ipv_4_pool
    #   The ID of an address pool that you own. Use this parameter to let
    #   Amazon EC2 select an address from the address pool. To specify a
    #   specific address from the address pool, use the `Address` parameter
    #   instead.
    #   @return [String]
    #
    # @!attribute [rw] network_border_group
    #   A unique set of Availability Zones, Local Zones, or Wavelength Zones
    #   from which AWS advertises IP addresses. Use this parameter to limit
    #   the IP address to this location. IP addresses cannot move between
    #   network border groups.
    #
    #   Use [DescribeAvailabilityZones][1] to view the network border
    #   groups.
    #
    #   <note markdown="1"> You cannot use a network border group with EC2 Classic. If you
    #   attempt this operation on EC2 classic, you will receive an
    #   `InvalidParameterCombination` error. For more information, see
    #   [Error Codes][2].
    #
    #    </note>
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAvailabilityZones.html
    #   [2]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html
    #   @return [String]
    #
    # @!attribute [rw] customer_owned_ipv_4_pool
    #   The ID of a customer-owned address pool. Use this parameter to let
    #   Amazon EC2 select an address from the address pool. Alternatively,
    #   specify a specific address from the address pool.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the Elastic IP address.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddressRequest AWS API Documentation
    #
    class AllocateAddressRequest < Struct.new(
      :domain,
      :address,
      :public_ipv_4_pool,
      :network_border_group,
      :customer_owned_ipv_4_pool,
      :dry_run,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] public_ip
    #   The Elastic IP address.
    #   @return [String]
    #
    # @!attribute [rw] allocation_id
    #   \[EC2-VPC\] The ID that AWS assigns to represent the allocation of
    #   the Elastic IP address for use with instances in a VPC.
    #   @return [String]
    #
    # @!attribute [rw] public_ipv_4_pool
    #   The ID of an address pool.
    #   @return [String]
    #
    # @!attribute [rw] network_border_group
    #   The set of Availability Zones, Local Zones, or Wavelength Zones from
    #   which AWS advertises IP addresses.
    #   @return [String]
    #
    # @!attribute [rw] domain
    #   Indicates whether the Elastic IP address is for use with instances
    #   in a VPC (`vpc`) or instances in EC2-Classic (`standard`).
    #   @return [String]
    #
    # @!attribute [rw] customer_owned_ip
    #   The customer-owned IP address.
    #   @return [String]
    #
    # @!attribute [rw] customer_owned_ipv_4_pool
    #   The ID of the customer-owned address pool.
    #   @return [String]
    #
    # @!attribute [rw] carrier_ip
    #   The carrier IP address. This option is only available for network
    #   interfaces which reside in a subnet in a Wavelength Zone (for
    #   example an EC2 instance).
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateAddressResult AWS API Documentation
    #
    class AllocateAddressResult < Struct.new(
      :public_ip,
      :allocation_id,
      :public_ipv_4_pool,
      :network_border_group,
      :domain,
      :customer_owned_ip,
      :customer_owned_ipv_4_pool,
      :carrier_ip)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AllocateHostsRequest
    #   data as a hash:
    #
    #       {
    #         auto_placement: "on", # accepts on, off
    #         availability_zone: "String", # required
    #         client_token: "String",
    #         instance_type: "String",
    #         instance_family: "String",
    #         quantity: 1, # required
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         host_recovery: "on", # accepts on, off
    #       }
    #
    # @!attribute [rw] auto_placement
    #   Indicates whether the host accepts any untargeted instance launches
    #   that match its instance type configuration, or if it only accepts
    #   Host tenancy instance launches that specify its unique host ID. For
    #   more information, see [ Understanding auto-placement and
    #   affinity][1] in the *Amazon EC2 User Guide*.
    #
    #   Default: `on`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding
    #   @return [String]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone in which to allocate the Dedicated Host.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] instance_type
    #   Specifies the instance type to be supported by the Dedicated Hosts.
    #   If you specify an instance type, the Dedicated Hosts support
    #   instances of the specified instance type only.
    #
    #   If you want the Dedicated Hosts to support multiple instance types
    #   in a specific instance family, omit this parameter and specify
    #   **InstanceFamily** instead. You cannot specify **InstanceType** and
    #   **InstanceFamily** in the same request.
    #   @return [String]
    #
    # @!attribute [rw] instance_family
    #   Specifies the instance family to be supported by the Dedicated
    #   Hosts. If you specify an instance family, the Dedicated Hosts
    #   support multiple instance types within that instance family.
    #
    #   If you want the Dedicated Hosts to support a specific instance type
    #   only, omit this parameter and specify **InstanceType** instead. You
    #   cannot specify **InstanceFamily** and **InstanceType** in the same
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] quantity
    #   The number of Dedicated Hosts to allocate to your account with these
    #   parameters.
    #   @return [Integer]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the Dedicated Host during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] host_recovery
    #   Indicates whether to enable or disable host recovery for the
    #   Dedicated Host. Host recovery is disabled by default. For more
    #   information, see [ Host recovery][1] in the *Amazon EC2 User Guide*.
    #
    #   Default: `off`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHostsRequest AWS API Documentation
    #
    class AllocateHostsRequest < Struct.new(
      :auto_placement,
      :availability_zone,
      :client_token,
      :instance_type,
      :instance_family,
      :quantity,
      :tag_specifications,
      :host_recovery)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of AllocateHosts.
    #
    # @!attribute [rw] host_ids
    #   The ID of the allocated Dedicated Host. This is used to launch an
    #   instance onto a specific host.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllocateHostsResult AWS API Documentation
    #
    class AllocateHostsResult < Struct.new(
      :host_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a principal.
    #
    # @!attribute [rw] principal_type
    #   The type of principal.
    #   @return [String]
    #
    # @!attribute [rw] principal
    #   The Amazon Resource Name (ARN) of the principal.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AllowedPrincipal AWS API Documentation
    #
    class AllowedPrincipal < Struct.new(
      :principal_type,
      :principal)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an potential intermediate component of a feasible path.
    #
    # @!attribute [rw] component_id
    #   The ID of the component.
    #   @return [String]
    #
    # @!attribute [rw] component_arn
    #   The Amazon Resource Name (ARN) of the component.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AlternatePathHint AWS API Documentation
    #
    class AlternatePathHint < Struct.new(
      :component_id,
      :component_arn)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a network access control (ACL) rule.
    #
    # @!attribute [rw] cidr
    #   The IPv4 address range, in CIDR notation.
    #   @return [String]
    #
    # @!attribute [rw] egress
    #   Indicates whether the rule is an outbound rule.
    #   @return [Boolean]
    #
    # @!attribute [rw] port_range
    #   The range of ports.
    #   @return [Types::PortRange]
    #
    # @!attribute [rw] protocol
    #   The protocol.
    #   @return [String]
    #
    # @!attribute [rw] rule_action
    #   Indicates whether to allow or deny traffic that matches the rule.
    #   @return [String]
    #
    # @!attribute [rw] rule_number
    #   The rule number.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AnalysisAclRule AWS API Documentation
    #
    class AnalysisAclRule < Struct.new(
      :cidr,
      :egress,
      :port_range,
      :protocol,
      :rule_action,
      :rule_number)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a path component.
    #
    # @!attribute [rw] id
    #   The ID of the component.
    #   @return [String]
    #
    # @!attribute [rw] arn
    #   The Amazon Resource Name (ARN) of the component.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AnalysisComponent AWS API Documentation
    #
    class AnalysisComponent < Struct.new(
      :id,
      :arn)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a load balancer listener.
    #
    # @!attribute [rw] load_balancer_port
    #   The port on which the load balancer is listening.
    #   @return [Integer]
    #
    # @!attribute [rw] instance_port
    #   \[Classic Load Balancers\] The back-end port for the listener.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AnalysisLoadBalancerListener AWS API Documentation
    #
    class AnalysisLoadBalancerListener < Struct.new(
      :load_balancer_port,
      :instance_port)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a load balancer target.
    #
    # @!attribute [rw] address
    #   The IP address.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone.
    #   @return [String]
    #
    # @!attribute [rw] instance
    #   Information about the instance.
    #   @return [Types::AnalysisComponent]
    #
    # @!attribute [rw] port
    #   The port on which the target is listening.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AnalysisLoadBalancerTarget AWS API Documentation
    #
    class AnalysisLoadBalancerTarget < Struct.new(
      :address,
      :availability_zone,
      :instance,
      :port)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a header. Reflects any changes made by a component as
    # traffic passes through. The fields of an inbound header are null
    # except for the first component of a path.
    #
    # @!attribute [rw] destination_addresses
    #   The destination addresses.
    #   @return [Array<String>]
    #
    # @!attribute [rw] destination_port_ranges
    #   The destination port ranges.
    #   @return [Array<Types::PortRange>]
    #
    # @!attribute [rw] protocol
    #   The protocol.
    #   @return [String]
    #
    # @!attribute [rw] source_addresses
    #   The source addresses.
    #   @return [Array<String>]
    #
    # @!attribute [rw] source_port_ranges
    #   The source port ranges.
    #   @return [Array<Types::PortRange>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AnalysisPacketHeader AWS API Documentation
    #
    class AnalysisPacketHeader < Struct.new(
      :destination_addresses,
      :destination_port_ranges,
      :protocol,
      :source_addresses,
      :source_port_ranges)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a route table route.
    #
    # @!attribute [rw] destination_cidr
    #   The destination IPv4 address, in CIDR notation.
    #   @return [String]
    #
    # @!attribute [rw] destination_prefix_list_id
    #   The prefix of the AWS service.
    #   @return [String]
    #
    # @!attribute [rw] egress_only_internet_gateway_id
    #   The ID of an egress-only internet gateway.
    #   @return [String]
    #
    # @!attribute [rw] gateway_id
    #   The ID of the gateway, such as an internet gateway or virtual
    #   private gateway.
    #   @return [String]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance, such as a NAT instance.
    #   @return [String]
    #
    # @!attribute [rw] nat_gateway_id
    #   The ID of a NAT gateway.
    #   @return [String]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of a network interface.
    #   @return [String]
    #
    # @!attribute [rw] origin
    #   Describes how the route was created. The following are possible
    #   values:
    #
    #   * `CreateRouteTable` - The route was automatically created when the
    #     route table was created.
    #
    #   * `CreateRoute` - The route was manually added to the route table.
    #
    #   * `EnableVgwRoutePropagation` - The route was propagated by route
    #     propagation.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_id
    #   The ID of a transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] vpc_peering_connection_id
    #   The ID of a VPC peering connection.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AnalysisRouteTableRoute AWS API Documentation
    #
    class AnalysisRouteTableRoute < Struct.new(
      :destination_cidr,
      :destination_prefix_list_id,
      :egress_only_internet_gateway_id,
      :gateway_id,
      :instance_id,
      :nat_gateway_id,
      :network_interface_id,
      :origin,
      :transit_gateway_id,
      :vpc_peering_connection_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a security group rule.
    #
    # @!attribute [rw] cidr
    #   The IPv4 address range, in CIDR notation.
    #   @return [String]
    #
    # @!attribute [rw] direction
    #   The direction. The following are possible values:
    #
    #   * egress
    #
    #   * ingress
    #   @return [String]
    #
    # @!attribute [rw] security_group_id
    #   The security group ID.
    #   @return [String]
    #
    # @!attribute [rw] port_range
    #   The port range.
    #   @return [Types::PortRange]
    #
    # @!attribute [rw] prefix_list_id
    #   The prefix list ID.
    #   @return [String]
    #
    # @!attribute [rw] protocol
    #   The protocol name.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AnalysisSecurityGroupRule AWS API Documentation
    #
    class AnalysisSecurityGroupRule < Struct.new(
      :cidr,
      :direction,
      :security_group_id,
      :port_range,
      :prefix_list_id,
      :protocol)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass ApplySecurityGroupsToClientVpnTargetNetworkRequest
    #   data as a hash:
    #
    #       {
    #         client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #         vpc_id: "VpcId", # required
    #         security_group_ids: ["SecurityGroupId"], # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC in which the associated target network is located.
    #   @return [String]
    #
    # @!attribute [rw] security_group_ids
    #   The IDs of the security groups to apply to the associated target
    #   network. Up to 5 security groups can be applied to an associated
    #   target network.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetworkRequest AWS API Documentation
    #
    class ApplySecurityGroupsToClientVpnTargetNetworkRequest < Struct.new(
      :client_vpn_endpoint_id,
      :vpc_id,
      :security_group_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] security_group_ids
    #   The IDs of the applied security groups.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ApplySecurityGroupsToClientVpnTargetNetworkResult AWS API Documentation
    #
    class ApplySecurityGroupsToClientVpnTargetNetworkResult < Struct.new(
      :security_group_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AssignIpv6AddressesRequest
    #   data as a hash:
    #
    #       {
    #         ipv_6_address_count: 1,
    #         ipv_6_addresses: ["String"],
    #         network_interface_id: "NetworkInterfaceId", # required
    #       }
    #
    # @!attribute [rw] ipv_6_address_count
    #   The number of additional IPv6 addresses to assign to the network
    #   interface. The specified number of IPv6 addresses are assigned in
    #   addition to the existing IPv6 addresses that are already assigned to
    #   the network interface. Amazon EC2 automatically selects the IPv6
    #   addresses from the subnet range. You can't use this option if
    #   specifying specific IPv6 addresses.
    #   @return [Integer]
    #
    # @!attribute [rw] ipv_6_addresses
    #   One or more specific IPv6 addresses to be assigned to the network
    #   interface. You can't use this option if you're specifying a number
    #   of IPv6 addresses.
    #   @return [Array<String>]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6AddressesRequest AWS API Documentation
    #
    class AssignIpv6AddressesRequest < Struct.new(
      :ipv_6_address_count,
      :ipv_6_addresses,
      :network_interface_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] assigned_ipv_6_addresses
    #   The new IPv6 addresses assigned to the network interface. Existing
    #   IPv6 addresses that were assigned to the network interface before
    #   the request are not included.
    #   @return [Array<String>]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignIpv6AddressesResult AWS API Documentation
    #
    class AssignIpv6AddressesResult < Struct.new(
      :assigned_ipv_6_addresses,
      :network_interface_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for AssignPrivateIpAddresses.
    #
    # @note When making an API call, you may pass AssignPrivateIpAddressesRequest
    #   data as a hash:
    #
    #       {
    #         allow_reassignment: false,
    #         network_interface_id: "NetworkInterfaceId", # required
    #         private_ip_addresses: ["String"],
    #         secondary_private_ip_address_count: 1,
    #       }
    #
    # @!attribute [rw] allow_reassignment
    #   Indicates whether to allow an IP address that is already assigned to
    #   another network interface or instance to be reassigned to the
    #   specified network interface.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @!attribute [rw] private_ip_addresses
    #   One or more IP addresses to be assigned as a secondary private IP
    #   address to the network interface. You can't specify this parameter
    #   when also specifying a number of secondary IP addresses.
    #
    #   If you don't specify an IP address, Amazon EC2 automatically
    #   selects an IP address within the subnet range.
    #   @return [Array<String>]
    #
    # @!attribute [rw] secondary_private_ip_address_count
    #   The number of secondary IP addresses to assign to the network
    #   interface. You can't specify this parameter when also specifying
    #   private IP addresses.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddressesRequest AWS API Documentation
    #
    class AssignPrivateIpAddressesRequest < Struct.new(
      :allow_reassignment,
      :network_interface_id,
      :private_ip_addresses,
      :secondary_private_ip_address_count)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @!attribute [rw] assigned_private_ip_addresses
    #   The private IP addresses assigned to the network interface.
    #   @return [Array<Types::AssignedPrivateIpAddress>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignPrivateIpAddressesResult AWS API Documentation
    #
    class AssignPrivateIpAddressesResult < Struct.new(
      :network_interface_id,
      :assigned_private_ip_addresses)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the private IP addresses assigned to a network interface.
    #
    # @!attribute [rw] private_ip_address
    #   The private IP address assigned to the network interface.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssignedPrivateIpAddress AWS API Documentation
    #
    class AssignedPrivateIpAddress < Struct.new(
      :private_ip_address)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AssociateAddressRequest
    #   data as a hash:
    #
    #       {
    #         allocation_id: "AllocationId",
    #         instance_id: "InstanceId",
    #         public_ip: "String",
    #         allow_reassociation: false,
    #         dry_run: false,
    #         network_interface_id: "NetworkInterfaceId",
    #         private_ip_address: "String",
    #       }
    #
    # @!attribute [rw] allocation_id
    #   \[EC2-VPC\] The allocation ID. This is required for EC2-VPC.
    #   @return [String]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance. The instance must have exactly one attached
    #   network interface. For EC2-VPC, you can specify either the instance
    #   ID or the network interface ID, but not both. For EC2-Classic, you
    #   must specify an instance ID and the instance must be in the running
    #   state.
    #   @return [String]
    #
    # @!attribute [rw] public_ip
    #   \[EC2-Classic\] The Elastic IP address to associate with the
    #   instance. This is required for EC2-Classic.
    #   @return [String]
    #
    # @!attribute [rw] allow_reassociation
    #   \[EC2-VPC\] For a VPC in an EC2-Classic account, specify true to
    #   allow an Elastic IP address that is already associated with an
    #   instance or network interface to be reassociated with the specified
    #   instance or network interface. Otherwise, the operation fails. In a
    #   VPC in an EC2-VPC-only account, reassociation is automatic,
    #   therefore you can specify false to ensure the operation fails if the
    #   Elastic IP address is already associated with another resource.
    #   @return [Boolean]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_interface_id
    #   \[EC2-VPC\] The ID of the network interface. If the instance has
    #   more than one network interface, you must specify a network
    #   interface ID.
    #
    #   For EC2-VPC, you can specify either the instance ID or the network
    #   interface ID, but not both.
    #   @return [String]
    #
    # @!attribute [rw] private_ip_address
    #   \[EC2-VPC\] The primary or secondary private IP address to associate
    #   with the Elastic IP address. If no private IP address is specified,
    #   the Elastic IP address is associated with the primary private IP
    #   address.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddressRequest AWS API Documentation
    #
    class AssociateAddressRequest < Struct.new(
      :allocation_id,
      :instance_id,
      :public_ip,
      :allow_reassociation,
      :dry_run,
      :network_interface_id,
      :private_ip_address)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] association_id
    #   \[EC2-VPC\] The ID that represents the association of the Elastic IP
    #   address with an instance.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateAddressResult AWS API Documentation
    #
    class AssociateAddressResult < Struct.new(
      :association_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AssociateClientVpnTargetNetworkRequest
    #   data as a hash:
    #
    #       {
    #         client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #         subnet_id: "SubnetId", # required
    #         client_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] subnet_id
    #   The ID of the subnet to associate with the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetworkRequest AWS API Documentation
    #
    class AssociateClientVpnTargetNetworkRequest < Struct.new(
      :client_vpn_endpoint_id,
      :subnet_id,
      :client_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] association_id
    #   The unique ID of the target network association.
    #   @return [String]
    #
    # @!attribute [rw] status
    #   The current state of the target network association.
    #   @return [Types::AssociationStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateClientVpnTargetNetworkResult AWS API Documentation
    #
    class AssociateClientVpnTargetNetworkResult < Struct.new(
      :association_id,
      :status)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AssociateDhcpOptionsRequest
    #   data as a hash:
    #
    #       {
    #         dhcp_options_id: "DefaultingDhcpOptionsId", # required
    #         vpc_id: "VpcId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] dhcp_options_id
    #   The ID of the DHCP options set, or `default` to associate no DHCP
    #   options with the VPC.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateDhcpOptionsRequest AWS API Documentation
    #
    class AssociateDhcpOptionsRequest < Struct.new(
      :dhcp_options_id,
      :vpc_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AssociateEnclaveCertificateIamRoleRequest
    #   data as a hash:
    #
    #       {
    #         certificate_arn: "ResourceArn",
    #         role_arn: "ResourceArn",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] certificate_arn
    #   The ARN of the ACM certificate with which to associate the IAM role.
    #   @return [String]
    #
    # @!attribute [rw] role_arn
    #   The ARN of the IAM role to associate with the ACM certificate. You
    #   can associate up to 16 IAM roles with an ACM certificate.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRoleRequest AWS API Documentation
    #
    class AssociateEnclaveCertificateIamRoleRequest < Struct.new(
      :certificate_arn,
      :role_arn,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] certificate_s3_bucket_name
    #   The name of the Amazon S3 bucket to which the certificate was
    #   uploaded.
    #   @return [String]
    #
    # @!attribute [rw] certificate_s3_object_key
    #   The Amazon S3 object key where the certificate, certificate chain,
    #   and encrypted private key bundle are stored. The object key is
    #   formatted as follows: `role_arn`/`certificate_arn`.
    #   @return [String]
    #
    # @!attribute [rw] encryption_kms_key_id
    #   The ID of the AWS KMS CMK used to encrypt the private key of the
    #   certificate.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateEnclaveCertificateIamRoleResult AWS API Documentation
    #
    class AssociateEnclaveCertificateIamRoleResult < Struct.new(
      :certificate_s3_bucket_name,
      :certificate_s3_object_key,
      :encryption_kms_key_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AssociateIamInstanceProfileRequest
    #   data as a hash:
    #
    #       {
    #         iam_instance_profile: { # required
    #           arn: "String",
    #           name: "String",
    #         },
    #         instance_id: "InstanceId", # required
    #       }
    #
    # @!attribute [rw] iam_instance_profile
    #   The IAM instance profile.
    #   @return [Types::IamInstanceProfileSpecification]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfileRequest AWS API Documentation
    #
    class AssociateIamInstanceProfileRequest < Struct.new(
      :iam_instance_profile,
      :instance_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] iam_instance_profile_association
    #   Information about the IAM instance profile association.
    #   @return [Types::IamInstanceProfileAssociation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateIamInstanceProfileResult AWS API Documentation
    #
    class AssociateIamInstanceProfileResult < Struct.new(
      :iam_instance_profile_association)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AssociateRouteTableRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         route_table_id: "RouteTableId", # required
    #         subnet_id: "SubnetId",
    #         gateway_id: "RouteGatewayId",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] route_table_id
    #   The ID of the route table.
    #   @return [String]
    #
    # @!attribute [rw] subnet_id
    #   The ID of the subnet.
    #   @return [String]
    #
    # @!attribute [rw] gateway_id
    #   The ID of the internet gateway or virtual private gateway.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTableRequest AWS API Documentation
    #
    class AssociateRouteTableRequest < Struct.new(
      :dry_run,
      :route_table_id,
      :subnet_id,
      :gateway_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] association_id
    #   The route table association ID. This ID is required for
    #   disassociating the route table.
    #   @return [String]
    #
    # @!attribute [rw] association_state
    #   The state of the association.
    #   @return [Types::RouteTableAssociationState]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateRouteTableResult AWS API Documentation
    #
    class AssociateRouteTableResult < Struct.new(
      :association_id,
      :association_state)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AssociateSubnetCidrBlockRequest
    #   data as a hash:
    #
    #       {
    #         subnet_id: "SubnetId", # required
    #         ipv_6_cidr_block: "String", # required
    #       }
    #
    # @!attribute [rw] subnet_id
    #   The ID of your subnet.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_cidr_block
    #   The IPv6 CIDR block for your subnet. The subnet must have a /64
    #   prefix length.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlockRequest AWS API Documentation
    #
    class AssociateSubnetCidrBlockRequest < Struct.new(
      :subnet_id,
      :ipv_6_cidr_block)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipv_6_cidr_block_association
    #   Information about the IPv6 CIDR block association.
    #   @return [Types::SubnetIpv6CidrBlockAssociation]
    #
    # @!attribute [rw] subnet_id
    #   The ID of the subnet.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateSubnetCidrBlockResult AWS API Documentation
    #
    class AssociateSubnetCidrBlockResult < Struct.new(
      :ipv_6_cidr_block_association,
      :subnet_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AssociateTransitGatewayMulticastDomainRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_multicast_domain_id: "TransitGatewayMulticastDomainId",
    #         transit_gateway_attachment_id: "TransitGatewayAttachmentId",
    #         subnet_ids: ["SubnetId"],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the transit gateway attachment to associate with the
    #   transit gateway multicast domain.
    #   @return [String]
    #
    # @!attribute [rw] subnet_ids
    #   The IDs of the subnets to associate with the transit gateway
    #   multicast domain.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomainRequest AWS API Documentation
    #
    class AssociateTransitGatewayMulticastDomainRequest < Struct.new(
      :transit_gateway_multicast_domain_id,
      :transit_gateway_attachment_id,
      :subnet_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] associations
    #   Information about the transit gateway multicast domain associations.
    #   @return [Types::TransitGatewayMulticastDomainAssociations]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayMulticastDomainResult AWS API Documentation
    #
    class AssociateTransitGatewayMulticastDomainResult < Struct.new(
      :associations)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AssociateTransitGatewayRouteTableRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_route_table_id: "TransitGatewayRouteTableId", # required
    #         transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the attachment.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTableRequest AWS API Documentation
    #
    class AssociateTransitGatewayRouteTableRequest < Struct.new(
      :transit_gateway_route_table_id,
      :transit_gateway_attachment_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] association
    #   The ID of the association.
    #   @return [Types::TransitGatewayAssociation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateTransitGatewayRouteTableResult AWS API Documentation
    #
    class AssociateTransitGatewayRouteTableResult < Struct.new(
      :association)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AssociateVpcCidrBlockRequest
    #   data as a hash:
    #
    #       {
    #         amazon_provided_ipv_6_cidr_block: false,
    #         cidr_block: "String",
    #         vpc_id: "VpcId", # required
    #         ipv_6_cidr_block_network_border_group: "String",
    #         ipv_6_pool: "Ipv6PoolEc2Id",
    #         ipv_6_cidr_block: "String",
    #       }
    #
    # @!attribute [rw] amazon_provided_ipv_6_cidr_block
    #   Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length
    #   for the VPC. You cannot specify the range of IPv6 addresses, or the
    #   size of the CIDR block.
    #   @return [Boolean]
    #
    # @!attribute [rw] cidr_block
    #   An IPv4 CIDR block to associate with the VPC.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_cidr_block_network_border_group
    #   The name of the location from which we advertise the IPV6 CIDR
    #   block. Use this parameter to limit the CIDR block to this location.
    #
    #   You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this
    #   parameter.
    #
    #   You can have one IPv6 CIDR block association per network border
    #   group.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_pool
    #   The ID of an IPv6 address pool from which to allocate the IPv6 CIDR
    #   block.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_cidr_block
    #   An IPv6 CIDR block from the IPv6 address pool. You must also specify
    #   `Ipv6Pool` in the request.
    #
    #   To let Amazon choose the IPv6 CIDR block for you, omit this
    #   parameter.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlockRequest AWS API Documentation
    #
    class AssociateVpcCidrBlockRequest < Struct.new(
      :amazon_provided_ipv_6_cidr_block,
      :cidr_block,
      :vpc_id,
      :ipv_6_cidr_block_network_border_group,
      :ipv_6_pool,
      :ipv_6_cidr_block)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipv_6_cidr_block_association
    #   Information about the IPv6 CIDR block association.
    #   @return [Types::VpcIpv6CidrBlockAssociation]
    #
    # @!attribute [rw] cidr_block_association
    #   Information about the IPv4 CIDR block association.
    #   @return [Types::VpcCidrBlockAssociation]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociateVpcCidrBlockResult AWS API Documentation
    #
    class AssociateVpcCidrBlockResult < Struct.new(
      :ipv_6_cidr_block_association,
      :cidr_block_association,
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about the associated IAM roles.
    #
    # @!attribute [rw] associated_role_arn
    #   The ARN of the associated IAM role.
    #   @return [String]
    #
    # @!attribute [rw] certificate_s3_bucket_name
    #   The name of the Amazon S3 bucket in which the Amazon S3 object is
    #   stored.
    #   @return [String]
    #
    # @!attribute [rw] certificate_s3_object_key
    #   The key of the Amazon S3 object ey where the certificate,
    #   certificate chain, and encrypted private key bundle is stored. The
    #   object key is formated as follows: `role_arn`/`certificate_arn`.
    #   @return [String]
    #
    # @!attribute [rw] encryption_kms_key_id
    #   The ID of the KMS customer master key (CMK) used to encrypt the
    #   private key.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociatedRole AWS API Documentation
    #
    class AssociatedRole < Struct.new(
      :associated_role_arn,
      :certificate_s3_bucket_name,
      :certificate_s3_object_key,
      :encryption_kms_key_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a target network that is associated with a Client VPN
    # endpoint. A target network is a subnet in a VPC.
    #
    # @!attribute [rw] network_id
    #   The ID of the subnet.
    #   @return [String]
    #
    # @!attribute [rw] network_type
    #   The target network type.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociatedTargetNetwork AWS API Documentation
    #
    class AssociatedTargetNetwork < Struct.new(
      :network_id,
      :network_type)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the state of a target network association.
    #
    # @!attribute [rw] code
    #   The state of the target network association.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   A message about the status of the target network association, if
    #   applicable.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AssociationStatus AWS API Documentation
    #
    class AssociationStatus < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AttachClassicLinkVpcRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         groups: ["String"], # required
    #         instance_id: "InstanceId", # required
    #         vpc_id: "VpcId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] groups
    #   The ID of one or more of the VPC's security groups. You cannot
    #   specify security groups from a different VPC.
    #   @return [Array<String>]
    #
    # @!attribute [rw] instance_id
    #   The ID of an EC2-Classic instance to link to the ClassicLink-enabled
    #   VPC.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of a ClassicLink-enabled VPC.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpcRequest AWS API Documentation
    #
    class AttachClassicLinkVpcRequest < Struct.new(
      :dry_run,
      :groups,
      :instance_id,
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachClassicLinkVpcResult AWS API Documentation
    #
    class AttachClassicLinkVpcResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AttachInternetGatewayRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         internet_gateway_id: "InternetGatewayId", # required
    #         vpc_id: "VpcId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] internet_gateway_id
    #   The ID of the internet gateway.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachInternetGatewayRequest AWS API Documentation
    #
    class AttachInternetGatewayRequest < Struct.new(
      :dry_run,
      :internet_gateway_id,
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for AttachNetworkInterface.
    #
    # @note When making an API call, you may pass AttachNetworkInterfaceRequest
    #   data as a hash:
    #
    #       {
    #         device_index: 1, # required
    #         dry_run: false,
    #         instance_id: "InstanceId", # required
    #         network_interface_id: "NetworkInterfaceId", # required
    #         network_card_index: 1,
    #       }
    #
    # @!attribute [rw] device_index
    #   The index of the device for the network interface attachment.
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @!attribute [rw] network_card_index
    #   The index of the network card. Some instance types support multiple
    #   network cards. The primary network interface must be assigned to
    #   network card index 0. The default is network card index 0.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterfaceRequest AWS API Documentation
    #
    class AttachNetworkInterfaceRequest < Struct.new(
      :device_index,
      :dry_run,
      :instance_id,
      :network_interface_id,
      :network_card_index)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of AttachNetworkInterface.
    #
    # @!attribute [rw] attachment_id
    #   The ID of the network interface attachment.
    #   @return [String]
    #
    # @!attribute [rw] network_card_index
    #   The index of the network card.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachNetworkInterfaceResult AWS API Documentation
    #
    class AttachNetworkInterfaceResult < Struct.new(
      :attachment_id,
      :network_card_index)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AttachVolumeRequest
    #   data as a hash:
    #
    #       {
    #         device: "String", # required
    #         instance_id: "InstanceId", # required
    #         volume_id: "VolumeId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] device
    #   The device name (for example, `/dev/sdh` or `xvdh`).
    #   @return [String]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @!attribute [rw] volume_id
    #   The ID of the EBS volume. The volume and instance must be within the
    #   same Availability Zone.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVolumeRequest AWS API Documentation
    #
    class AttachVolumeRequest < Struct.new(
      :device,
      :instance_id,
      :volume_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for AttachVpnGateway.
    #
    # @note When making an API call, you may pass AttachVpnGatewayRequest
    #   data as a hash:
    #
    #       {
    #         vpc_id: "VpcId", # required
    #         vpn_gateway_id: "VpnGatewayId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] vpn_gateway_id
    #   The ID of the virtual private gateway.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGatewayRequest AWS API Documentation
    #
    class AttachVpnGatewayRequest < Struct.new(
      :vpc_id,
      :vpn_gateway_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of AttachVpnGateway.
    #
    # @!attribute [rw] vpc_attachment
    #   Information about the attachment.
    #   @return [Types::VpcAttachment]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttachVpnGatewayResult AWS API Documentation
    #
    class AttachVpnGatewayResult < Struct.new(
      :vpc_attachment)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a value for a resource attribute that is a Boolean value.
    #
    # @note When making an API call, you may pass AttributeBooleanValue
    #   data as a hash:
    #
    #       {
    #         value: false,
    #       }
    #
    # @!attribute [rw] value
    #   The attribute value. The valid values are `true` or `false`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttributeBooleanValue AWS API Documentation
    #
    class AttributeBooleanValue < Struct.new(
      :value)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a value for a resource attribute that is a String.
    #
    # @note When making an API call, you may pass AttributeValue
    #   data as a hash:
    #
    #       {
    #         value: "String",
    #       }
    #
    # @!attribute [rw] value
    #   The attribute value. The value is case-sensitive.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AttributeValue AWS API Documentation
    #
    class AttributeValue < Struct.new(
      :value)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about an authorization rule.
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint with which the authorization rule
    #   is associated.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A brief description of the authorization rule.
    #   @return [String]
    #
    # @!attribute [rw] group_id
    #   The ID of the Active Directory group to which the authorization rule
    #   grants access.
    #   @return [String]
    #
    # @!attribute [rw] access_all
    #   Indicates whether the authorization rule grants access to all
    #   clients.
    #   @return [Boolean]
    #
    # @!attribute [rw] destination_cidr
    #   The IPv4 address range, in CIDR notation, of the network to which
    #   the authorization rule applies.
    #   @return [String]
    #
    # @!attribute [rw] status
    #   The current state of the authorization rule.
    #   @return [Types::ClientVpnAuthorizationRuleStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizationRule AWS API Documentation
    #
    class AuthorizationRule < Struct.new(
      :client_vpn_endpoint_id,
      :description,
      :group_id,
      :access_all,
      :destination_cidr,
      :status)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AuthorizeClientVpnIngressRequest
    #   data as a hash:
    #
    #       {
    #         client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #         target_network_cidr: "String", # required
    #         access_group_id: "String",
    #         authorize_all_groups: false,
    #         description: "String",
    #         client_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] target_network_cidr
    #   The IPv4 address range, in CIDR notation, of the network for which
    #   access is being authorized.
    #   @return [String]
    #
    # @!attribute [rw] access_group_id
    #   The ID of the group to grant access to, for example, the Active
    #   Directory group or identity provider (IdP) group. Required if
    #   `AuthorizeAllGroups` is `false` or not specified.
    #   @return [String]
    #
    # @!attribute [rw] authorize_all_groups
    #   Indicates whether to grant access to all clients. Specify `true` to
    #   grant all clients who successfully establish a VPN connection access
    #   to the network. Must be set to `true` if `AccessGroupId` is not
    #   specified.
    #   @return [Boolean]
    #
    # @!attribute [rw] description
    #   A brief description of the authorization rule.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngressRequest AWS API Documentation
    #
    class AuthorizeClientVpnIngressRequest < Struct.new(
      :client_vpn_endpoint_id,
      :target_network_cidr,
      :access_group_id,
      :authorize_all_groups,
      :description,
      :client_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] status
    #   The current state of the authorization rule.
    #   @return [Types::ClientVpnAuthorizationRuleStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeClientVpnIngressResult AWS API Documentation
    #
    class AuthorizeClientVpnIngressResult < Struct.new(
      :status)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AuthorizeSecurityGroupEgressRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         group_id: "SecurityGroupId", # required
    #         ip_permissions: [
    #           {
    #             from_port: 1,
    #             ip_protocol: "String",
    #             ip_ranges: [
    #               {
    #                 cidr_ip: "String",
    #                 description: "String",
    #               },
    #             ],
    #             ipv_6_ranges: [
    #               {
    #                 cidr_ipv_6: "String",
    #                 description: "String",
    #               },
    #             ],
    #             prefix_list_ids: [
    #               {
    #                 description: "String",
    #                 prefix_list_id: "String",
    #               },
    #             ],
    #             to_port: 1,
    #             user_id_group_pairs: [
    #               {
    #                 description: "String",
    #                 group_id: "String",
    #                 group_name: "String",
    #                 peering_status: "String",
    #                 user_id: "String",
    #                 vpc_id: "String",
    #                 vpc_peering_connection_id: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         cidr_ip: "String",
    #         from_port: 1,
    #         ip_protocol: "String",
    #         to_port: 1,
    #         source_security_group_name: "String",
    #         source_security_group_owner_id: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] group_id
    #   The ID of the security group.
    #   @return [String]
    #
    # @!attribute [rw] ip_permissions
    #   The sets of IP permissions. You can't specify a destination
    #   security group and a CIDR IP address range in the same set of
    #   permissions.
    #   @return [Array<Types::IpPermission>]
    #
    # @!attribute [rw] cidr_ip
    #   Not supported. Use a set of IP permissions to specify the CIDR.
    #   @return [String]
    #
    # @!attribute [rw] from_port
    #   Not supported. Use a set of IP permissions to specify the port.
    #   @return [Integer]
    #
    # @!attribute [rw] ip_protocol
    #   Not supported. Use a set of IP permissions to specify the protocol
    #   name or number.
    #   @return [String]
    #
    # @!attribute [rw] to_port
    #   Not supported. Use a set of IP permissions to specify the port.
    #   @return [Integer]
    #
    # @!attribute [rw] source_security_group_name
    #   Not supported. Use a set of IP permissions to specify a destination
    #   security group.
    #   @return [String]
    #
    # @!attribute [rw] source_security_group_owner_id
    #   Not supported. Use a set of IP permissions to specify a destination
    #   security group.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupEgressRequest AWS API Documentation
    #
    class AuthorizeSecurityGroupEgressRequest < Struct.new(
      :dry_run,
      :group_id,
      :ip_permissions,
      :cidr_ip,
      :from_port,
      :ip_protocol,
      :to_port,
      :source_security_group_name,
      :source_security_group_owner_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass AuthorizeSecurityGroupIngressRequest
    #   data as a hash:
    #
    #       {
    #         cidr_ip: "String",
    #         from_port: 1,
    #         group_id: "SecurityGroupId",
    #         group_name: "SecurityGroupName",
    #         ip_permissions: [
    #           {
    #             from_port: 1,
    #             ip_protocol: "String",
    #             ip_ranges: [
    #               {
    #                 cidr_ip: "String",
    #                 description: "String",
    #               },
    #             ],
    #             ipv_6_ranges: [
    #               {
    #                 cidr_ipv_6: "String",
    #                 description: "String",
    #               },
    #             ],
    #             prefix_list_ids: [
    #               {
    #                 description: "String",
    #                 prefix_list_id: "String",
    #               },
    #             ],
    #             to_port: 1,
    #             user_id_group_pairs: [
    #               {
    #                 description: "String",
    #                 group_id: "String",
    #                 group_name: "String",
    #                 peering_status: "String",
    #                 user_id: "String",
    #                 vpc_id: "String",
    #                 vpc_peering_connection_id: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         ip_protocol: "String",
    #         source_security_group_name: "String",
    #         source_security_group_owner_id: "String",
    #         to_port: 1,
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] cidr_ip
    #   The IPv4 address range, in CIDR format. You can't specify this
    #   parameter when specifying a source security group. To specify an
    #   IPv6 address range, use a set of IP permissions.
    #
    #   Alternatively, use a set of IP permissions to specify multiple rules
    #   and a description for the rule.
    #   @return [String]
    #
    # @!attribute [rw] from_port
    #   The start of port range for the TCP and UDP protocols, or an ICMP
    #   type number. For the ICMP type number, use `-1` to specify all
    #   types. If you specify all ICMP types, you must specify all codes.
    #
    #   Alternatively, use a set of IP permissions to specify multiple rules
    #   and a description for the rule.
    #   @return [Integer]
    #
    # @!attribute [rw] group_id
    #   The ID of the security group. You must specify either the security
    #   group ID or the security group name in the request. For security
    #   groups in a nondefault VPC, you must specify the security group ID.
    #   @return [String]
    #
    # @!attribute [rw] group_name
    #   \[EC2-Classic, default VPC\] The name of the security group. You
    #   must specify either the security group ID or the security group name
    #   in the request.
    #   @return [String]
    #
    # @!attribute [rw] ip_permissions
    #   The sets of IP permissions.
    #   @return [Array<Types::IpPermission>]
    #
    # @!attribute [rw] ip_protocol
    #   The IP protocol name (`tcp`, `udp`, `icmp`) or number (see [Protocol
    #   Numbers][1]). To specify `icmpv6`, use a set of IP permissions.
    #
    #   \[VPC only\] Use `-1` to specify all protocols. If you specify `-1`
    #   or a protocol other than `tcp`, `udp`, or `icmp`, traffic on all
    #   ports is allowed, regardless of any ports you specify.
    #
    #   Alternatively, use a set of IP permissions to specify multiple rules
    #   and a description for the rule.
    #
    #
    #
    #   [1]: http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml
    #   @return [String]
    #
    # @!attribute [rw] source_security_group_name
    #   \[EC2-Classic, default VPC\] The name of the source security group.
    #   You can't specify this parameter in combination with the following
    #   parameters: the CIDR IP address range, the start of the port range,
    #   the IP protocol, and the end of the port range. Creates rules that
    #   grant full ICMP, UDP, and TCP access. To create a rule with a
    #   specific IP protocol and port range, use a set of IP permissions
    #   instead. For EC2-VPC, the source security group must be in the same
    #   VPC.
    #   @return [String]
    #
    # @!attribute [rw] source_security_group_owner_id
    #   \[nondefault VPC\] The AWS account ID for the source security group,
    #   if the source security group is in a different account. You can't
    #   specify this parameter in combination with the following parameters:
    #   the CIDR IP address range, the IP protocol, the start of the port
    #   range, and the end of the port range. Creates rules that grant full
    #   ICMP, UDP, and TCP access. To create a rule with a specific IP
    #   protocol and port range, use a set of IP permissions instead.
    #   @return [String]
    #
    # @!attribute [rw] to_port
    #   The end of port range for the TCP and UDP protocols, or an ICMP code
    #   number. For the ICMP code number, use `-1` to specify all codes. If
    #   you specify all ICMP types, you must specify all codes.
    #
    #   Alternatively, use a set of IP permissions to specify multiple rules
    #   and a description for the rule.
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AuthorizeSecurityGroupIngressRequest AWS API Documentation
    #
    class AuthorizeSecurityGroupIngressRequest < Struct.new(
      :cidr_ip,
      :from_port,
      :group_id,
      :group_name,
      :ip_permissions,
      :ip_protocol,
      :source_security_group_name,
      :source_security_group_owner_id,
      :to_port,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes Availability Zones, Local Zones, and Wavelength Zones.
    #
    # @!attribute [rw] state
    #   The state of the Availability Zone, Local Zone, or Wavelength Zone.
    #   @return [String]
    #
    # @!attribute [rw] opt_in_status
    #   For Availability Zones, this parameter always has the value of
    #   `opt-in-not-required`.
    #
    #   For Local Zones and Wavelength Zones, this parameter is the opt-in
    #   status. The possible values are `opted-in`, and `not-opted-in`.
    #   @return [String]
    #
    # @!attribute [rw] messages
    #   Any messages about the Availability Zone, Local Zone, or Wavelength
    #   Zone.
    #   @return [Array<Types::AvailabilityZoneMessage>]
    #
    # @!attribute [rw] region_name
    #   The name of the Region.
    #   @return [String]
    #
    # @!attribute [rw] zone_name
    #   The name of the Availability Zone, Local Zone, or Wavelength Zone.
    #   @return [String]
    #
    # @!attribute [rw] zone_id
    #   The ID of the Availability Zone, Local Zone, or Wavelength Zone.
    #   @return [String]
    #
    # @!attribute [rw] group_name
    #   For Availability Zones, this parameter has the same value as the
    #   Region name.
    #
    #   For Local Zones, the name of the associated group, for example
    #   `us-west-2-lax-1`.
    #
    #   For Wavelength Zones, the name of the associated group, for example
    #   `us-east-1-wl1-bos-wlz-1`.
    #   @return [String]
    #
    # @!attribute [rw] network_border_group
    #   The name of the network border group.
    #   @return [String]
    #
    # @!attribute [rw] zone_type
    #   The type of zone. The valid values are `availability-zone`,
    #   `local-zone`, and `wavelength-zone`.
    #   @return [String]
    #
    # @!attribute [rw] parent_zone_name
    #   The name of the zone that handles some of the Local Zone or
    #   Wavelength Zone control plane operations, such as API calls.
    #   @return [String]
    #
    # @!attribute [rw] parent_zone_id
    #   The ID of the zone that handles some of the Local Zone or Wavelength
    #   Zone control plane operations, such as API calls.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AvailabilityZone AWS API Documentation
    #
    class AvailabilityZone < Struct.new(
      :state,
      :opt_in_status,
      :messages,
      :region_name,
      :zone_name,
      :zone_id,
      :group_name,
      :network_border_group,
      :zone_type,
      :parent_zone_name,
      :parent_zone_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a message about an Availability Zone, Local Zone, or
    # Wavelength Zone.
    #
    # @!attribute [rw] message
    #   The message about the Availability Zone, Local Zone, or Wavelength
    #   Zone.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AvailabilityZoneMessage AWS API Documentation
    #
    class AvailabilityZoneMessage < Struct.new(
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # The capacity information for instances that can be launched onto the
    # Dedicated Host.
    #
    # @!attribute [rw] available_instance_capacity
    #   The number of instances that can be launched onto the Dedicated Host
    #   depending on the host's available capacity. For Dedicated Hosts
    #   that support multiple instance types, this parameter represents the
    #   number of instances for each instance size that is supported on the
    #   host.
    #   @return [Array<Types::InstanceCapacity>]
    #
    # @!attribute [rw] available_v_cpus
    #   The number of vCPUs available for launching instances onto the
    #   Dedicated Host.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/AvailableCapacity AWS API Documentation
    #
    class AvailableCapacity < Struct.new(
      :available_instance_capacity,
      :available_v_cpus)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass BlobAttributeValue
    #   data as a hash:
    #
    #       {
    #         value: "data",
    #       }
    #
    # @!attribute [rw] value
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BlobAttributeValue AWS API Documentation
    #
    class BlobAttributeValue < Struct.new(
      :value)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a block device mapping.
    #
    # @note When making an API call, you may pass BlockDeviceMapping
    #   data as a hash:
    #
    #       {
    #         device_name: "String",
    #         virtual_name: "String",
    #         ebs: {
    #           delete_on_termination: false,
    #           iops: 1,
    #           snapshot_id: "String",
    #           volume_size: 1,
    #           volume_type: "standard", # accepts standard, io1, io2, gp2, sc1, st1, gp3
    #           kms_key_id: "String",
    #           throughput: 1,
    #           outpost_arn: "String",
    #           encrypted: false,
    #         },
    #         no_device: "String",
    #       }
    #
    # @!attribute [rw] device_name
    #   The device name (for example, `/dev/sdh` or `xvdh`).
    #   @return [String]
    #
    # @!attribute [rw] virtual_name
    #   The virtual device name (`ephemeral`N). Instance store volumes are
    #   numbered starting from 0. An instance type with 2 available instance
    #   store volumes can specify mappings for `ephemeral0` and
    #   `ephemeral1`. The number of available instance store volumes depends
    #   on the instance type. After you connect to the instance, you must
    #   mount the volume.
    #
    #   NVMe instance store volumes are automatically enumerated and
    #   assigned a device name. Including them in your block device mapping
    #   has no effect.
    #
    #   Constraints: For M3 instances, you must specify instance store
    #   volumes in the block device mapping for the instance. When you
    #   launch an M3 instance, we ignore any instance store volumes
    #   specified in the block device mapping for the AMI.
    #   @return [String]
    #
    # @!attribute [rw] ebs
    #   Parameters used to automatically set up EBS volumes when the
    #   instance is launched.
    #   @return [Types::EbsBlockDevice]
    #
    # @!attribute [rw] no_device
    #   To omit the device from the block device mapping, specify an empty
    #   string.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BlockDeviceMapping AWS API Documentation
    #
    class BlockDeviceMapping < Struct.new(
      :device_name,
      :virtual_name,
      :ebs,
      :no_device)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for BundleInstance.
    #
    # @note When making an API call, you may pass BundleInstanceRequest
    #   data as a hash:
    #
    #       {
    #         instance_id: "InstanceId", # required
    #         storage: { # required
    #           s3: {
    #             aws_access_key_id: "String",
    #             bucket: "String",
    #             prefix: "String",
    #             upload_policy: "data",
    #             upload_policy_signature: "String",
    #           },
    #         },
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance to bundle.
    #
    #   Type: String
    #
    #   Default: None
    #
    #   Required: Yes
    #   @return [String]
    #
    # @!attribute [rw] storage
    #   The bucket in which to store the AMI. You can specify a bucket that
    #   you already own or a new bucket that Amazon EC2 creates on your
    #   behalf. If you specify a bucket that belongs to someone else, Amazon
    #   EC2 returns an error.
    #   @return [Types::Storage]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstanceRequest AWS API Documentation
    #
    class BundleInstanceRequest < Struct.new(
      :instance_id,
      :storage,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of BundleInstance.
    #
    # @!attribute [rw] bundle_task
    #   Information about the bundle task.
    #   @return [Types::BundleTask]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleInstanceResult AWS API Documentation
    #
    class BundleInstanceResult < Struct.new(
      :bundle_task)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a bundle task.
    #
    # @!attribute [rw] bundle_id
    #   The ID of the bundle task.
    #   @return [String]
    #
    # @!attribute [rw] bundle_task_error
    #   If the task fails, a description of the error.
    #   @return [Types::BundleTaskError]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance associated with this bundle task.
    #   @return [String]
    #
    # @!attribute [rw] progress
    #   The level of task completion, as a percent (for example, 20%).
    #   @return [String]
    #
    # @!attribute [rw] start_time
    #   The time this task started.
    #   @return [Time]
    #
    # @!attribute [rw] state
    #   The state of the task.
    #   @return [String]
    #
    # @!attribute [rw] storage
    #   The Amazon S3 storage locations.
    #   @return [Types::Storage]
    #
    # @!attribute [rw] update_time
    #   The time of the most recent update for the task.
    #   @return [Time]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleTask AWS API Documentation
    #
    class BundleTask < Struct.new(
      :bundle_id,
      :bundle_task_error,
      :instance_id,
      :progress,
      :start_time,
      :state,
      :storage,
      :update_time)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an error for BundleInstance.
    #
    # @!attribute [rw] code
    #   The error code.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   The error message.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/BundleTaskError AWS API Documentation
    #
    class BundleTaskError < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about an address range that is provisioned for use with
    # your AWS resources through bring your own IP addresses (BYOIP).
    #
    # @!attribute [rw] cidr
    #   The address range, in CIDR notation.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   The description of the address range.
    #   @return [String]
    #
    # @!attribute [rw] status_message
    #   Upon success, contains the ID of the address pool. Otherwise,
    #   contains an error message.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The state of the address pool.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ByoipCidr AWS API Documentation
    #
    class ByoipCidr < Struct.new(
      :cidr,
      :description,
      :status_message,
      :state)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CancelBundleTask.
    #
    # @note When making an API call, you may pass CancelBundleTaskRequest
    #   data as a hash:
    #
    #       {
    #         bundle_id: "BundleId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] bundle_id
    #   The ID of the bundle task.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTaskRequest AWS API Documentation
    #
    class CancelBundleTaskRequest < Struct.new(
      :bundle_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CancelBundleTask.
    #
    # @!attribute [rw] bundle_task
    #   Information about the bundle task.
    #   @return [Types::BundleTask]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTaskResult AWS API Documentation
    #
    class CancelBundleTaskResult < Struct.new(
      :bundle_task)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CancelCapacityReservationRequest
    #   data as a hash:
    #
    #       {
    #         capacity_reservation_id: "CapacityReservationId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] capacity_reservation_id
    #   The ID of the Capacity Reservation to be cancelled.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationRequest AWS API Documentation
    #
    class CancelCapacityReservationRequest < Struct.new(
      :capacity_reservation_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelCapacityReservationResult AWS API Documentation
    #
    class CancelCapacityReservationResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CancelConversionRequest
    #   data as a hash:
    #
    #       {
    #         conversion_task_id: "ConversionTaskId", # required
    #         dry_run: false,
    #         reason_message: "String",
    #       }
    #
    # @!attribute [rw] conversion_task_id
    #   The ID of the conversion task.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] reason_message
    #   The reason for canceling the conversion task.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelConversionRequest AWS API Documentation
    #
    class CancelConversionRequest < Struct.new(
      :conversion_task_id,
      :dry_run,
      :reason_message)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CancelExportTaskRequest
    #   data as a hash:
    #
    #       {
    #         export_task_id: "ExportVmTaskId", # required
    #       }
    #
    # @!attribute [rw] export_task_id
    #   The ID of the export task. This is the ID returned by
    #   `CreateInstanceExportTask`.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelExportTaskRequest AWS API Documentation
    #
    class CancelExportTaskRequest < Struct.new(
      :export_task_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CancelImportTaskRequest
    #   data as a hash:
    #
    #       {
    #         cancel_reason: "String",
    #         dry_run: false,
    #         import_task_id: "ImportTaskId",
    #       }
    #
    # @!attribute [rw] cancel_reason
    #   The reason for canceling the task.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] import_task_id
    #   The ID of the import image or import snapshot task to be canceled.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTaskRequest AWS API Documentation
    #
    class CancelImportTaskRequest < Struct.new(
      :cancel_reason,
      :dry_run,
      :import_task_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] import_task_id
    #   The ID of the task being canceled.
    #   @return [String]
    #
    # @!attribute [rw] previous_state
    #   The current state of the task being canceled.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The current state of the task being canceled.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelImportTaskResult AWS API Documentation
    #
    class CancelImportTaskResult < Struct.new(
      :import_task_id,
      :previous_state,
      :state)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CancelReservedInstancesListing.
    #
    # @note When making an API call, you may pass CancelReservedInstancesListingRequest
    #   data as a hash:
    #
    #       {
    #         reserved_instances_listing_id: "ReservedInstancesListingId", # required
    #       }
    #
    # @!attribute [rw] reserved_instances_listing_id
    #   The ID of the Reserved Instance listing.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListingRequest AWS API Documentation
    #
    class CancelReservedInstancesListingRequest < Struct.new(
      :reserved_instances_listing_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CancelReservedInstancesListing.
    #
    # @!attribute [rw] reserved_instances_listings
    #   The Reserved Instance listing.
    #   @return [Array<Types::ReservedInstancesListing>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelReservedInstancesListingResult AWS API Documentation
    #
    class CancelReservedInstancesListingResult < Struct.new(
      :reserved_instances_listings)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a Spot Fleet error.
    #
    # @!attribute [rw] code
    #   The error code.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   The description for the error code.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsError AWS API Documentation
    #
    class CancelSpotFleetRequestsError < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a Spot Fleet request that was not successfully canceled.
    #
    # @!attribute [rw] error
    #   The error.
    #   @return [Types::CancelSpotFleetRequestsError]
    #
    # @!attribute [rw] spot_fleet_request_id
    #   The ID of the Spot Fleet request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsErrorItem AWS API Documentation
    #
    class CancelSpotFleetRequestsErrorItem < Struct.new(
      :error,
      :spot_fleet_request_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CancelSpotFleetRequests.
    #
    # @note When making an API call, you may pass CancelSpotFleetRequestsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         spot_fleet_request_ids: ["SpotFleetRequestId"], # required
    #         terminate_instances: false, # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] spot_fleet_request_ids
    #   The IDs of the Spot Fleet requests.
    #   @return [Array<String>]
    #
    # @!attribute [rw] terminate_instances
    #   Indicates whether to terminate instances for a Spot Fleet request if
    #   it is canceled successfully.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsRequest AWS API Documentation
    #
    class CancelSpotFleetRequestsRequest < Struct.new(
      :dry_run,
      :spot_fleet_request_ids,
      :terminate_instances)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CancelSpotFleetRequests.
    #
    # @!attribute [rw] successful_fleet_requests
    #   Information about the Spot Fleet requests that are successfully
    #   canceled.
    #   @return [Array<Types::CancelSpotFleetRequestsSuccessItem>]
    #
    # @!attribute [rw] unsuccessful_fleet_requests
    #   Information about the Spot Fleet requests that are not successfully
    #   canceled.
    #   @return [Array<Types::CancelSpotFleetRequestsErrorItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsResponse AWS API Documentation
    #
    class CancelSpotFleetRequestsResponse < Struct.new(
      :successful_fleet_requests,
      :unsuccessful_fleet_requests)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a Spot Fleet request that was successfully canceled.
    #
    # @!attribute [rw] current_spot_fleet_request_state
    #   The current state of the Spot Fleet request.
    #   @return [String]
    #
    # @!attribute [rw] previous_spot_fleet_request_state
    #   The previous state of the Spot Fleet request.
    #   @return [String]
    #
    # @!attribute [rw] spot_fleet_request_id
    #   The ID of the Spot Fleet request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotFleetRequestsSuccessItem AWS API Documentation
    #
    class CancelSpotFleetRequestsSuccessItem < Struct.new(
      :current_spot_fleet_request_state,
      :previous_spot_fleet_request_state,
      :spot_fleet_request_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CancelSpotInstanceRequests.
    #
    # @note When making an API call, you may pass CancelSpotInstanceRequestsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         spot_instance_request_ids: ["SpotInstanceRequestId"], # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] spot_instance_request_ids
    #   One or more Spot Instance request IDs.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequestsRequest AWS API Documentation
    #
    class CancelSpotInstanceRequestsRequest < Struct.new(
      :dry_run,
      :spot_instance_request_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CancelSpotInstanceRequests.
    #
    # @!attribute [rw] cancelled_spot_instance_requests
    #   One or more Spot Instance requests.
    #   @return [Array<Types::CancelledSpotInstanceRequest>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelSpotInstanceRequestsResult AWS API Documentation
    #
    class CancelSpotInstanceRequestsResult < Struct.new(
      :cancelled_spot_instance_requests)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a request to cancel a Spot Instance.
    #
    # @!attribute [rw] spot_instance_request_id
    #   The ID of the Spot Instance request.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The state of the Spot Instance request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelledSpotInstanceRequest AWS API Documentation
    #
    class CancelledSpotInstanceRequest < Struct.new(
      :spot_instance_request_id,
      :state)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a Capacity Reservation.
    #
    # @!attribute [rw] capacity_reservation_id
    #   The ID of the Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] owner_id
    #   The ID of the AWS account that owns the Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservation_arn
    #   The Amazon Resource Name (ARN) of the Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   The Availability Zone ID of the Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] instance_type
    #   The type of instance for which the Capacity Reservation reserves
    #   capacity.
    #   @return [String]
    #
    # @!attribute [rw] instance_platform
    #   The type of operating system for which the Capacity Reservation
    #   reserves capacity.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone in which the capacity is reserved.
    #   @return [String]
    #
    # @!attribute [rw] tenancy
    #   Indicates the tenancy of the Capacity Reservation. A Capacity
    #   Reservation can have one of the following tenancy settings:
    #
    #   * `default` - The Capacity Reservation is created on hardware that
    #     is shared with other AWS accounts.
    #
    #   * `dedicated` - The Capacity Reservation is created on single-tenant
    #     hardware that is dedicated to a single AWS account.
    #   @return [String]
    #
    # @!attribute [rw] total_instance_count
    #   The total number of instances for which the Capacity Reservation
    #   reserves capacity.
    #   @return [Integer]
    #
    # @!attribute [rw] available_instance_count
    #   The remaining capacity. Indicates the number of instances that can
    #   be launched in the Capacity Reservation.
    #   @return [Integer]
    #
    # @!attribute [rw] ebs_optimized
    #   Indicates whether the Capacity Reservation supports EBS-optimized
    #   instances. This optimization provides dedicated throughput to Amazon
    #   EBS and an optimized configuration stack to provide optimal I/O
    #   performance. This optimization isn't available with all instance
    #   types. Additional usage charges apply when using an EBS- optimized
    #   instance.
    #   @return [Boolean]
    #
    # @!attribute [rw] ephemeral_storage
    #   Indicates whether the Capacity Reservation supports instances with
    #   temporary, block-level storage.
    #   @return [Boolean]
    #
    # @!attribute [rw] state
    #   The current state of the Capacity Reservation. A Capacity
    #   Reservation can be in one of the following states:
    #
    #   * `active` - The Capacity Reservation is active and the capacity is
    #     available for your use.
    #
    #   * `expired` - The Capacity Reservation expired automatically at the
    #     date and time specified in your request. The reserved capacity is
    #     no longer available for your use.
    #
    #   * `cancelled` - The Capacity Reservation was cancelled. The reserved
    #     capacity is no longer available for your use.
    #
    #   * `pending` - The Capacity Reservation request was successful but
    #     the capacity provisioning is still pending.
    #
    #   * `failed` - The Capacity Reservation request has failed. A request
    #     might fail due to invalid request parameters, capacity
    #     constraints, or instance limit constraints. Failed requests are
    #     retained for 60 minutes.
    #   @return [String]
    #
    # @!attribute [rw] start_date
    #   The date and time at which the Capacity Reservation was started.
    #   @return [Time]
    #
    # @!attribute [rw] end_date
    #   The date and time at which the Capacity Reservation expires. When a
    #   Capacity Reservation expires, the reserved capacity is released and
    #   you can no longer launch instances into it. The Capacity
    #   Reservation's state changes to `expired` when it reaches its end
    #   date and time.
    #   @return [Time]
    #
    # @!attribute [rw] end_date_type
    #   Indicates the way in which the Capacity Reservation ends. A Capacity
    #   Reservation can have one of the following end types:
    #
    #   * `unlimited` - The Capacity Reservation remains active until you
    #     explicitly cancel it.
    #
    #   * `limited` - The Capacity Reservation expires automatically at a
    #     specified date and time.
    #   @return [String]
    #
    # @!attribute [rw] instance_match_criteria
    #   Indicates the type of instance launches that the Capacity
    #   Reservation accepts. The options include:
    #
    #   * `open` - The Capacity Reservation accepts all instances that have
    #     matching attributes (instance type, platform, and Availability
    #     Zone). Instances that have matching attributes launch into the
    #     Capacity Reservation automatically without specifying any
    #     additional parameters.
    #
    #   * `targeted` - The Capacity Reservation only accepts instances that
    #     have matching attributes (instance type, platform, and
    #     Availability Zone), and explicitly target the Capacity
    #     Reservation. This ensures that only permitted instances can use
    #     the reserved capacity.
    #   @return [String]
    #
    # @!attribute [rw] create_date
    #   The date and time at which the Capacity Reservation was created.
    #   @return [Time]
    #
    # @!attribute [rw] tags
    #   Any tags assigned to the Capacity Reservation.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservation AWS API Documentation
    #
    class CapacityReservation < Struct.new(
      :capacity_reservation_id,
      :owner_id,
      :capacity_reservation_arn,
      :availability_zone_id,
      :instance_type,
      :instance_platform,
      :availability_zone,
      :tenancy,
      :total_instance_count,
      :available_instance_count,
      :ebs_optimized,
      :ephemeral_storage,
      :state,
      :start_date,
      :end_date,
      :end_date_type,
      :instance_match_criteria,
      :create_date,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a resource group to which a Capacity Reservation has been
    # added.
    #
    # @!attribute [rw] group_arn
    #   The ARN of the resource group.
    #   @return [String]
    #
    # @!attribute [rw] owner_id
    #   The ID of the AWS account that owns the resource group.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationGroup AWS API Documentation
    #
    class CapacityReservationGroup < Struct.new(
      :group_arn,
      :owner_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the strategy for using unused Capacity Reservations for
    # fulfilling On-Demand capacity.
    #
    # <note markdown="1"> This strategy can only be used if the EC2 Fleet is of type `instant`.
    #
    #  </note>
    #
    # For more information about Capacity Reservations, see [On-Demand
    # Capacity Reservations][1] in the *Amazon EC2 User Guide*. For examples
    # of using Capacity Reservations in an EC2 Fleet, see [EC2 Fleet example
    # configurations][2] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-examples.html
    #
    # @!attribute [rw] usage_strategy
    #   Indicates whether to use unused Capacity Reservations for fulfilling
    #   On-Demand capacity.
    #
    #   If you specify `use-capacity-reservations-first`, the fleet uses
    #   unused Capacity Reservations to fulfill On-Demand capacity up to the
    #   target On-Demand capacity. If multiple instance pools have unused
    #   Capacity Reservations, the On-Demand allocation strategy
    #   (`lowest-price` or `prioritized`) is applied. If the number of
    #   unused Capacity Reservations is less than the On-Demand target
    #   capacity, the remaining On-Demand target capacity is launched
    #   according to the On-Demand allocation strategy (`lowest-price` or
    #   `prioritized`).
    #
    #   If you do not specify a value, the fleet fulfils the On-Demand
    #   capacity according to the chosen On-Demand allocation strategy.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationOptions AWS API Documentation
    #
    class CapacityReservationOptions < Struct.new(
      :usage_strategy)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the strategy for using unused Capacity Reservations for
    # fulfilling On-Demand capacity.
    #
    # <note markdown="1"> This strategy can only be used if the EC2 Fleet is of type `instant`.
    #
    #  </note>
    #
    # For more information about Capacity Reservations, see [On-Demand
    # Capacity Reservations][1] in the *Amazon EC2 User Guide*. For examples
    # of using Capacity Reservations in an EC2 Fleet, see [EC2 Fleet example
    # configurations][2] in the *Amazon EC2 User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html
    # [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-examples.html
    #
    # @note When making an API call, you may pass CapacityReservationOptionsRequest
    #   data as a hash:
    #
    #       {
    #         usage_strategy: "use-capacity-reservations-first", # accepts use-capacity-reservations-first
    #       }
    #
    # @!attribute [rw] usage_strategy
    #   Indicates whether to use unused Capacity Reservations for fulfilling
    #   On-Demand capacity.
    #
    #   If you specify `use-capacity-reservations-first`, the fleet uses
    #   unused Capacity Reservations to fulfill On-Demand capacity up to the
    #   target On-Demand capacity. If multiple instance pools have unused
    #   Capacity Reservations, the On-Demand allocation strategy
    #   (`lowest-price` or `prioritized`) is applied. If the number of
    #   unused Capacity Reservations is less than the On-Demand target
    #   capacity, the remaining On-Demand target capacity is launched
    #   according to the On-Demand allocation strategy (`lowest-price` or
    #   `prioritized`).
    #
    #   If you do not specify a value, the fleet fulfils the On-Demand
    #   capacity according to the chosen On-Demand allocation strategy.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationOptionsRequest AWS API Documentation
    #
    class CapacityReservationOptionsRequest < Struct.new(
      :usage_strategy)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an instance's Capacity Reservation targeting option. You
    # can specify only one parameter at a time. If you specify
    # `CapacityReservationPreference` and `CapacityReservationTarget`, the
    # request fails.
    #
    # Use the `CapacityReservationPreference` parameter to configure the
    # instance to run as an On-Demand Instance or to run in any `open`
    # Capacity Reservation that has matching attributes (instance type,
    # platform, Availability Zone). Use the `CapacityReservationTarget`
    # parameter to explicitly target a specific Capacity Reservation or a
    # Capacity Reservation group.
    #
    # @note When making an API call, you may pass CapacityReservationSpecification
    #   data as a hash:
    #
    #       {
    #         capacity_reservation_preference: "open", # accepts open, none
    #         capacity_reservation_target: {
    #           capacity_reservation_id: "CapacityReservationId",
    #           capacity_reservation_resource_group_arn: "String",
    #         },
    #       }
    #
    # @!attribute [rw] capacity_reservation_preference
    #   Indicates the instance's Capacity Reservation preferences. Possible
    #   preferences include:
    #
    #   * `open` - The instance can run in any `open` Capacity Reservation
    #     that has matching attributes (instance type, platform,
    #     Availability Zone).
    #
    #   * `none` - The instance avoids running in a Capacity Reservation
    #     even if one is available. The instance runs as an On-Demand
    #     Instance.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservation_target
    #   Information about the target Capacity Reservation or Capacity
    #   Reservation group.
    #   @return [Types::CapacityReservationTarget]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationSpecification AWS API Documentation
    #
    class CapacityReservationSpecification < Struct.new(
      :capacity_reservation_preference,
      :capacity_reservation_target)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the instance's Capacity Reservation targeting preferences.
    # The action returns the `capacityReservationPreference` response
    # element if the instance is configured to run in On-Demand capacity, or
    # if it is configured in run in any `open` Capacity Reservation that has
    # matching attributes (instance type, platform, Availability Zone). The
    # action returns the `capacityReservationTarget` response element if the
    # instance explicily targets a specific Capacity Reservation or Capacity
    # Reservation group.
    #
    # @!attribute [rw] capacity_reservation_preference
    #   Describes the instance's Capacity Reservation preferences. Possible
    #   preferences include:
    #
    #   * `open` - The instance can run in any `open` Capacity Reservation
    #     that has matching attributes (instance type, platform,
    #     Availability Zone).
    #
    #   * `none` - The instance avoids running in a Capacity Reservation
    #     even if one is available. The instance runs in On-Demand capacity.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservation_target
    #   Information about the targeted Capacity Reservation or Capacity
    #   Reservation group.
    #   @return [Types::CapacityReservationTargetResponse]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationSpecificationResponse AWS API Documentation
    #
    class CapacityReservationSpecificationResponse < Struct.new(
      :capacity_reservation_preference,
      :capacity_reservation_target)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a target Capacity Reservation or Capacity Reservation group.
    #
    # @note When making an API call, you may pass CapacityReservationTarget
    #   data as a hash:
    #
    #       {
    #         capacity_reservation_id: "CapacityReservationId",
    #         capacity_reservation_resource_group_arn: "String",
    #       }
    #
    # @!attribute [rw] capacity_reservation_id
    #   The ID of the Capacity Reservation in which to run the instance.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservation_resource_group_arn
    #   The ARN of the Capacity Reservation resource group in which to run
    #   the instance.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationTarget AWS API Documentation
    #
    class CapacityReservationTarget < Struct.new(
      :capacity_reservation_id,
      :capacity_reservation_resource_group_arn)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a target Capacity Reservation or Capacity Reservation group.
    #
    # @!attribute [rw] capacity_reservation_id
    #   The ID of the targeted Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservation_resource_group_arn
    #   The ARN of the targeted Capacity Reservation group.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CapacityReservationTargetResponse AWS API Documentation
    #
    class CapacityReservationTargetResponse < Struct.new(
      :capacity_reservation_id,
      :capacity_reservation_resource_group_arn)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a carrier gateway.
    #
    # @!attribute [rw] carrier_gateway_id
    #   The ID of the carrier gateway.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC associated with the carrier gateway.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The state of the carrier gateway.
    #   @return [String]
    #
    # @!attribute [rw] owner_id
    #   The AWS account ID of the owner of the carrier gateway.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   The tags assigned to the carrier gateway.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CarrierGateway AWS API Documentation
    #
    class CarrierGateway < Struct.new(
      :carrier_gateway_id,
      :vpc_id,
      :state,
      :owner_id,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about the client certificate used for authentication.
    #
    # @!attribute [rw] client_root_certificate_chain
    #   The ARN of the client certificate.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CertificateAuthentication AWS API Documentation
    #
    class CertificateAuthentication < Struct.new(
      :client_root_certificate_chain)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about the client certificate to be used for
    # authentication.
    #
    # @note When making an API call, you may pass CertificateAuthenticationRequest
    #   data as a hash:
    #
    #       {
    #         client_root_certificate_chain_arn: "String",
    #       }
    #
    # @!attribute [rw] client_root_certificate_chain_arn
    #   The ARN of the client certificate. The certificate must be signed by
    #   a certificate authority (CA) and it must be provisioned in AWS
    #   Certificate Manager (ACM).
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CertificateAuthenticationRequest AWS API Documentation
    #
    class CertificateAuthenticationRequest < Struct.new(
      :client_root_certificate_chain_arn)
      SENSITIVE = []
      include Aws::Structure
    end

    # Provides authorization for Amazon to bring a specific IP address range
    # to a specific AWS account using bring your own IP addresses (BYOIP).
    # For more information, see [Prepare to Bring Your Address Range to Your
    # AWS Account][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html#prepare-for-byoip
    #
    # @note When making an API call, you may pass CidrAuthorizationContext
    #   data as a hash:
    #
    #       {
    #         message: "String", # required
    #         signature: "String", # required
    #       }
    #
    # @!attribute [rw] message
    #   The plain-text authorization message for the prefix and account.
    #   @return [String]
    #
    # @!attribute [rw] signature
    #   The signed authorization message for the prefix and account.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CidrAuthorizationContext AWS API Documentation
    #
    class CidrAuthorizationContext < Struct.new(
      :message,
      :signature)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an IPv4 CIDR block.
    #
    # @!attribute [rw] cidr_block
    #   The IPv4 CIDR block.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CidrBlock AWS API Documentation
    #
    class CidrBlock < Struct.new(
      :cidr_block)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the ClassicLink DNS support status of a VPC.
    #
    # @!attribute [rw] classic_link_dns_supported
    #   Indicates whether ClassicLink DNS support is enabled for the VPC.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClassicLinkDnsSupport AWS API Documentation
    #
    class ClassicLinkDnsSupport < Struct.new(
      :classic_link_dns_supported,
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a linked EC2-Classic instance.
    #
    # @!attribute [rw] groups
    #   A list of security groups.
    #   @return [Array<Types::GroupIdentifier>]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   Any tags assigned to the instance.
    #   @return [Array<Types::Tag>]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClassicLinkInstance AWS API Documentation
    #
    class ClassicLinkInstance < Struct.new(
      :groups,
      :instance_id,
      :tags,
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a Classic Load Balancer.
    #
    # @note When making an API call, you may pass ClassicLoadBalancer
    #   data as a hash:
    #
    #       {
    #         name: "String",
    #       }
    #
    # @!attribute [rw] name
    #   The name of the load balancer.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClassicLoadBalancer AWS API Documentation
    #
    class ClassicLoadBalancer < Struct.new(
      :name)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the Classic Load Balancers to attach to a Spot Fleet. Spot
    # Fleet registers the running Spot Instances with these Classic Load
    # Balancers.
    #
    # @note When making an API call, you may pass ClassicLoadBalancersConfig
    #   data as a hash:
    #
    #       {
    #         classic_load_balancers: [
    #           {
    #             name: "String",
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] classic_load_balancers
    #   One or more Classic Load Balancers.
    #   @return [Array<Types::ClassicLoadBalancer>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClassicLoadBalancersConfig AWS API Documentation
    #
    class ClassicLoadBalancersConfig < Struct.new(
      :classic_load_balancers)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the state of a client certificate revocation list.
    #
    # @!attribute [rw] code
    #   The state of the client certificate revocation list.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   A message about the status of the client certificate revocation
    #   list, if applicable.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientCertificateRevocationListStatus AWS API Documentation
    #
    class ClientCertificateRevocationListStatus < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # The options for managing connection authorization for new client
    # connections.
    #
    # @note When making an API call, you may pass ClientConnectOptions
    #   data as a hash:
    #
    #       {
    #         enabled: false,
    #         lambda_function_arn: "String",
    #       }
    #
    # @!attribute [rw] enabled
    #   Indicates whether client connect options are enabled. The default is
    #   `false` (not enabled).
    #   @return [Boolean]
    #
    # @!attribute [rw] lambda_function_arn
    #   The Amazon Resource Name (ARN) of the AWS Lambda function used for
    #   connection authorization.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientConnectOptions AWS API Documentation
    #
    class ClientConnectOptions < Struct.new(
      :enabled,
      :lambda_function_arn)
      SENSITIVE = []
      include Aws::Structure
    end

    # The options for managing connection authorization for new client
    # connections.
    #
    # @!attribute [rw] enabled
    #   Indicates whether client connect options are enabled.
    #   @return [Boolean]
    #
    # @!attribute [rw] lambda_function_arn
    #   The Amazon Resource Name (ARN) of the AWS Lambda function used for
    #   connection authorization.
    #   @return [String]
    #
    # @!attribute [rw] status
    #   The status of any updates to the client connect options.
    #   @return [Types::ClientVpnEndpointAttributeStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientConnectResponseOptions AWS API Documentation
    #
    class ClientConnectResponseOptions < Struct.new(
      :enabled,
      :lambda_function_arn,
      :status)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the client-specific data.
    #
    # @note When making an API call, you may pass ClientData
    #   data as a hash:
    #
    #       {
    #         comment: "String",
    #         upload_end: Time.now,
    #         upload_size: 1.0,
    #         upload_start: Time.now,
    #       }
    #
    # @!attribute [rw] comment
    #   A user-defined comment about the disk upload.
    #   @return [String]
    #
    # @!attribute [rw] upload_end
    #   The time that the disk upload ends.
    #   @return [Time]
    #
    # @!attribute [rw] upload_size
    #   The size of the uploaded disk image, in GiB.
    #   @return [Float]
    #
    # @!attribute [rw] upload_start
    #   The time that the disk upload starts.
    #   @return [Time]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientData AWS API Documentation
    #
    class ClientData < Struct.new(
      :comment,
      :upload_end,
      :upload_size,
      :upload_start)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the authentication methods used by a Client VPN endpoint.
    # For more information, see [Authentication][1] in the *AWS Client VPN
    # Administrator Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/client-authentication.html
    #
    # @!attribute [rw] type
    #   The authentication type used.
    #   @return [String]
    #
    # @!attribute [rw] active_directory
    #   Information about the Active Directory, if applicable.
    #   @return [Types::DirectoryServiceAuthentication]
    #
    # @!attribute [rw] mutual_authentication
    #   Information about the authentication certificates, if applicable.
    #   @return [Types::CertificateAuthentication]
    #
    # @!attribute [rw] federated_authentication
    #   Information about the IAM SAML identity provider, if applicable.
    #   @return [Types::FederatedAuthentication]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnAuthentication AWS API Documentation
    #
    class ClientVpnAuthentication < Struct.new(
      :type,
      :active_directory,
      :mutual_authentication,
      :federated_authentication)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the authentication method to be used by a Client VPN
    # endpoint. For more information, see [Authentication][1] in the *AWS
    # Client VPN Administrator Guide*.
    #
    #
    #
    # [1]: https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/authentication-authrization.html#client-authentication
    #
    # @note When making an API call, you may pass ClientVpnAuthenticationRequest
    #   data as a hash:
    #
    #       {
    #         type: "certificate-authentication", # accepts certificate-authentication, directory-service-authentication, federated-authentication
    #         active_directory: {
    #           directory_id: "String",
    #         },
    #         mutual_authentication: {
    #           client_root_certificate_chain_arn: "String",
    #         },
    #         federated_authentication: {
    #           saml_provider_arn: "String",
    #           self_service_saml_provider_arn: "String",
    #         },
    #       }
    #
    # @!attribute [rw] type
    #   The type of client authentication to be used.
    #   @return [String]
    #
    # @!attribute [rw] active_directory
    #   Information about the Active Directory to be used, if applicable.
    #   You must provide this information if **Type** is
    #   `directory-service-authentication`.
    #   @return [Types::DirectoryServiceAuthenticationRequest]
    #
    # @!attribute [rw] mutual_authentication
    #   Information about the authentication certificates to be used, if
    #   applicable. You must provide this information if **Type** is
    #   `certificate-authentication`.
    #   @return [Types::CertificateAuthenticationRequest]
    #
    # @!attribute [rw] federated_authentication
    #   Information about the IAM SAML identity provider to be used, if
    #   applicable. You must provide this information if **Type** is
    #   `federated-authentication`.
    #   @return [Types::FederatedAuthenticationRequest]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnAuthenticationRequest AWS API Documentation
    #
    class ClientVpnAuthenticationRequest < Struct.new(
      :type,
      :active_directory,
      :mutual_authentication,
      :federated_authentication)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the state of an authorization rule.
    #
    # @!attribute [rw] code
    #   The state of the authorization rule.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   A message about the status of the authorization rule, if applicable.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnAuthorizationRuleStatus AWS API Documentation
    #
    class ClientVpnAuthorizationRuleStatus < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a client connection.
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint to which the client is connected.
    #   @return [String]
    #
    # @!attribute [rw] timestamp
    #   The current date and time.
    #   @return [String]
    #
    # @!attribute [rw] connection_id
    #   The ID of the client connection.
    #   @return [String]
    #
    # @!attribute [rw] username
    #   The username of the client who established the client connection.
    #   This information is only provided if Active Directory client
    #   authentication is used.
    #   @return [String]
    #
    # @!attribute [rw] connection_established_time
    #   The date and time the client connection was established.
    #   @return [String]
    #
    # @!attribute [rw] ingress_bytes
    #   The number of bytes sent by the client.
    #   @return [String]
    #
    # @!attribute [rw] egress_bytes
    #   The number of bytes received by the client.
    #   @return [String]
    #
    # @!attribute [rw] ingress_packets
    #   The number of packets sent by the client.
    #   @return [String]
    #
    # @!attribute [rw] egress_packets
    #   The number of packets received by the client.
    #   @return [String]
    #
    # @!attribute [rw] client_ip
    #   The IP address of the client.
    #   @return [String]
    #
    # @!attribute [rw] common_name
    #   The common name associated with the client. This is either the name
    #   of the client certificate, or the Active Directory user name.
    #   @return [String]
    #
    # @!attribute [rw] status
    #   The current state of the client connection.
    #   @return [Types::ClientVpnConnectionStatus]
    #
    # @!attribute [rw] connection_end_time
    #   The date and time the client connection was terminated.
    #   @return [String]
    #
    # @!attribute [rw] posture_compliance_statuses
    #   The statuses returned by the client connect handler for posture
    #   compliance, if applicable.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnConnection AWS API Documentation
    #
    class ClientVpnConnection < Struct.new(
      :client_vpn_endpoint_id,
      :timestamp,
      :connection_id,
      :username,
      :connection_established_time,
      :ingress_bytes,
      :egress_bytes,
      :ingress_packets,
      :egress_packets,
      :client_ip,
      :common_name,
      :status,
      :connection_end_time,
      :posture_compliance_statuses)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the status of a client connection.
    #
    # @!attribute [rw] code
    #   The state of the client connection.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   A message about the status of the client connection, if applicable.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnConnectionStatus AWS API Documentation
    #
    class ClientVpnConnectionStatus < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a Client VPN endpoint.
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A brief description of the endpoint.
    #   @return [String]
    #
    # @!attribute [rw] status
    #   The current state of the Client VPN endpoint.
    #   @return [Types::ClientVpnEndpointStatus]
    #
    # @!attribute [rw] creation_time
    #   The date and time the Client VPN endpoint was created.
    #   @return [String]
    #
    # @!attribute [rw] deletion_time
    #   The date and time the Client VPN endpoint was deleted, if
    #   applicable.
    #   @return [String]
    #
    # @!attribute [rw] dns_name
    #   The DNS name to be used by clients when connecting to the Client VPN
    #   endpoint.
    #   @return [String]
    #
    # @!attribute [rw] client_cidr_block
    #   The IPv4 address range, in CIDR notation, from which client IP
    #   addresses are assigned.
    #   @return [String]
    #
    # @!attribute [rw] dns_servers
    #   Information about the DNS servers to be used for DNS resolution.
    #   @return [Array<String>]
    #
    # @!attribute [rw] split_tunnel
    #   Indicates whether split-tunnel is enabled in the AWS Client VPN
    #   endpoint.
    #
    #   For information about split-tunnel VPN endpoints, see [Split-Tunnel
    #   AWS Client VPN Endpoint][1] in the *AWS Client VPN Administrator
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html
    #   @return [Boolean]
    #
    # @!attribute [rw] vpn_protocol
    #   The protocol used by the VPN session.
    #   @return [String]
    #
    # @!attribute [rw] transport_protocol
    #   The transport protocol used by the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] vpn_port
    #   The port number for the Client VPN endpoint.
    #   @return [Integer]
    #
    # @!attribute [rw] associated_target_networks
    #   Information about the associated target networks. A target network
    #   is a subnet in a VPC.
    #   @return [Array<Types::AssociatedTargetNetwork>]
    #
    # @!attribute [rw] server_certificate_arn
    #   The ARN of the server certificate.
    #   @return [String]
    #
    # @!attribute [rw] authentication_options
    #   Information about the authentication method used by the Client VPN
    #   endpoint.
    #   @return [Array<Types::ClientVpnAuthentication>]
    #
    # @!attribute [rw] connection_log_options
    #   Information about the client connection logging options for the
    #   Client VPN endpoint.
    #   @return [Types::ConnectionLogResponseOptions]
    #
    # @!attribute [rw] tags
    #   Any tags assigned to the Client VPN endpoint.
    #   @return [Array<Types::Tag>]
    #
    # @!attribute [rw] security_group_ids
    #   The IDs of the security groups for the target network.
    #   @return [Array<String>]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] self_service_portal_url
    #   The URL of the self-service portal.
    #   @return [String]
    #
    # @!attribute [rw] client_connect_options
    #   The options for managing connection authorization for new client
    #   connections.
    #   @return [Types::ClientConnectResponseOptions]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnEndpoint AWS API Documentation
    #
    class ClientVpnEndpoint < Struct.new(
      :client_vpn_endpoint_id,
      :description,
      :status,
      :creation_time,
      :deletion_time,
      :dns_name,
      :client_cidr_block,
      :dns_servers,
      :split_tunnel,
      :vpn_protocol,
      :transport_protocol,
      :vpn_port,
      :associated_target_networks,
      :server_certificate_arn,
      :authentication_options,
      :connection_log_options,
      :tags,
      :security_group_ids,
      :vpc_id,
      :self_service_portal_url,
      :client_connect_options)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the status of the Client VPN endpoint attribute.
    #
    # @!attribute [rw] code
    #   The status code.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   The status message.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnEndpointAttributeStatus AWS API Documentation
    #
    class ClientVpnEndpointAttributeStatus < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the state of a Client VPN endpoint.
    #
    # @!attribute [rw] code
    #   The state of the Client VPN endpoint. Possible states include:
    #
    #   * `pending-associate` - The Client VPN endpoint has been created but
    #     no target networks have been associated. The Client VPN endpoint
    #     cannot accept connections.
    #
    #   * `available` - The Client VPN endpoint has been created and a
    #     target network has been associated. The Client VPN endpoint can
    #     accept connections.
    #
    #   * `deleting` - The Client VPN endpoint is being deleted. The Client
    #     VPN endpoint cannot accept connections.
    #
    #   * `deleted` - The Client VPN endpoint has been deleted. The Client
    #     VPN endpoint cannot accept connections.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   A message about the status of the Client VPN endpoint.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnEndpointStatus AWS API Documentation
    #
    class ClientVpnEndpointStatus < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about a Client VPN endpoint route.
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint with which the route is
    #   associated.
    #   @return [String]
    #
    # @!attribute [rw] destination_cidr
    #   The IPv4 address range, in CIDR notation, of the route destination.
    #   @return [String]
    #
    # @!attribute [rw] target_subnet
    #   The ID of the subnet through which traffic is routed.
    #   @return [String]
    #
    # @!attribute [rw] type
    #   The route type.
    #   @return [String]
    #
    # @!attribute [rw] origin
    #   Indicates how the route was associated with the Client VPN endpoint.
    #   `associate` indicates that the route was automatically added when
    #   the target network was associated with the Client VPN endpoint.
    #   `add-route` indicates that the route was manually added using the
    #   **CreateClientVpnRoute** action.
    #   @return [String]
    #
    # @!attribute [rw] status
    #   The current state of the route.
    #   @return [Types::ClientVpnRouteStatus]
    #
    # @!attribute [rw] description
    #   A brief description of the route.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnRoute AWS API Documentation
    #
    class ClientVpnRoute < Struct.new(
      :client_vpn_endpoint_id,
      :destination_cidr,
      :target_subnet,
      :type,
      :origin,
      :status,
      :description)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the state of a Client VPN endpoint route.
    #
    # @!attribute [rw] code
    #   The state of the Client VPN endpoint route.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   A message about the status of the Client VPN endpoint route, if
    #   applicable.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ClientVpnRouteStatus AWS API Documentation
    #
    class ClientVpnRouteStatus < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes address usage for a customer-owned address pool.
    #
    # @!attribute [rw] allocation_id
    #   The allocation ID of the address.
    #   @return [String]
    #
    # @!attribute [rw] aws_account_id
    #   The AWS account ID.
    #   @return [String]
    #
    # @!attribute [rw] aws_service
    #   The AWS service.
    #   @return [String]
    #
    # @!attribute [rw] co_ip
    #   The customer-owned IP address.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CoipAddressUsage AWS API Documentation
    #
    class CoipAddressUsage < Struct.new(
      :allocation_id,
      :aws_account_id,
      :aws_service,
      :co_ip)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a customer-owned address pool.
    #
    # @!attribute [rw] pool_id
    #   The ID of the address pool.
    #   @return [String]
    #
    # @!attribute [rw] pool_cidrs
    #   The address ranges of the address pool.
    #   @return [Array<String>]
    #
    # @!attribute [rw] local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   The tags.
    #   @return [Array<Types::Tag>]
    #
    # @!attribute [rw] pool_arn
    #   The ARN of the address pool.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CoipPool AWS API Documentation
    #
    class CoipPool < Struct.new(
      :pool_id,
      :pool_cidrs,
      :local_gateway_route_table_id,
      :tags,
      :pool_arn)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass ConfirmProductInstanceRequest
    #   data as a hash:
    #
    #       {
    #         instance_id: "InstanceId", # required
    #         product_code: "String", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @!attribute [rw] product_code
    #   The product code. This must be a product code that you own.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstanceRequest AWS API Documentation
    #
    class ConfirmProductInstanceRequest < Struct.new(
      :instance_id,
      :product_code,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] owner_id
    #   The AWS account ID of the instance owner. This is only present if
    #   the product code is attached to the instance.
    #   @return [String]
    #
    # @!attribute [rw] return
    #   The return value of the request. Returns `true` if the specified
    #   product code is owned by the requester and associated with the
    #   specified instance.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConfirmProductInstanceResult AWS API Documentation
    #
    class ConfirmProductInstanceResult < Struct.new(
      :owner_id,
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the client connection logging options for the Client VPN
    # endpoint.
    #
    # @note When making an API call, you may pass ConnectionLogOptions
    #   data as a hash:
    #
    #       {
    #         enabled: false,
    #         cloudwatch_log_group: "String",
    #         cloudwatch_log_stream: "String",
    #       }
    #
    # @!attribute [rw] enabled
    #   Indicates whether connection logging is enabled.
    #   @return [Boolean]
    #
    # @!attribute [rw] cloudwatch_log_group
    #   The name of the CloudWatch Logs log group. Required if connection
    #   logging is enabled.
    #   @return [String]
    #
    # @!attribute [rw] cloudwatch_log_stream
    #   The name of the CloudWatch Logs log stream to which the connection
    #   data is published.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConnectionLogOptions AWS API Documentation
    #
    class ConnectionLogOptions < Struct.new(
      :enabled,
      :cloudwatch_log_group,
      :cloudwatch_log_stream)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about the client connection logging options for a Client
    # VPN endpoint.
    #
    # @!attribute [rw] enabled
    #   Indicates whether client connection logging is enabled for the
    #   Client VPN endpoint.
    #   @return [Boolean]
    #
    # @!attribute [rw] cloudwatch_log_group
    #   The name of the Amazon CloudWatch Logs log group to which connection
    #   logging data is published.
    #   @return [String]
    #
    # @!attribute [rw] cloudwatch_log_stream
    #   The name of the Amazon CloudWatch Logs log stream to which
    #   connection logging data is published.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConnectionLogResponseOptions AWS API Documentation
    #
    class ConnectionLogResponseOptions < Struct.new(
      :enabled,
      :cloudwatch_log_group,
      :cloudwatch_log_stream)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a connection notification for a VPC endpoint or VPC endpoint
    # service.
    #
    # @!attribute [rw] connection_notification_id
    #   The ID of the notification.
    #   @return [String]
    #
    # @!attribute [rw] service_id
    #   The ID of the endpoint service.
    #   @return [String]
    #
    # @!attribute [rw] vpc_endpoint_id
    #   The ID of the VPC endpoint.
    #   @return [String]
    #
    # @!attribute [rw] connection_notification_type
    #   The type of notification.
    #   @return [String]
    #
    # @!attribute [rw] connection_notification_arn
    #   The ARN of the SNS topic for the notification.
    #   @return [String]
    #
    # @!attribute [rw] connection_events
    #   The events for the notification. Valid values are `Accept`,
    #   `Connect`, `Delete`, and `Reject`.
    #   @return [Array<String>]
    #
    # @!attribute [rw] connection_notification_state
    #   The state of the notification.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConnectionNotification AWS API Documentation
    #
    class ConnectionNotification < Struct.new(
      :connection_notification_id,
      :service_id,
      :vpc_endpoint_id,
      :connection_notification_type,
      :connection_notification_arn,
      :connection_events,
      :connection_notification_state)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a conversion task.
    #
    # @!attribute [rw] conversion_task_id
    #   The ID of the conversion task.
    #   @return [String]
    #
    # @!attribute [rw] expiration_time
    #   The time when the task expires. If the upload isn't complete before
    #   the expiration time, we automatically cancel the task.
    #   @return [String]
    #
    # @!attribute [rw] import_instance
    #   If the task is for importing an instance, this contains information
    #   about the import instance task.
    #   @return [Types::ImportInstanceTaskDetails]
    #
    # @!attribute [rw] import_volume
    #   If the task is for importing a volume, this contains information
    #   about the import volume task.
    #   @return [Types::ImportVolumeTaskDetails]
    #
    # @!attribute [rw] state
    #   The state of the conversion task.
    #   @return [String]
    #
    # @!attribute [rw] status_message
    #   The status message related to the conversion task.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   Any tags assigned to the task.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ConversionTask AWS API Documentation
    #
    class ConversionTask < Struct.new(
      :conversion_task_id,
      :expiration_time,
      :import_instance,
      :import_volume,
      :state,
      :status_message,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CopyFpgaImageRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         source_fpga_image_id: "String", # required
    #         description: "String",
    #         name: "String",
    #         source_region: "String", # required
    #         client_token: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] source_fpga_image_id
    #   The ID of the source AFI.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   The description for the new AFI.
    #   @return [String]
    #
    # @!attribute [rw] name
    #   The name for the new AFI. The default is the name of the source AFI.
    #   @return [String]
    #
    # @!attribute [rw] source_region
    #   The Region that contains the source AFI.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImageRequest AWS API Documentation
    #
    class CopyFpgaImageRequest < Struct.new(
      :dry_run,
      :source_fpga_image_id,
      :description,
      :name,
      :source_region,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] fpga_image_id
    #   The ID of the new AFI.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyFpgaImageResult AWS API Documentation
    #
    class CopyFpgaImageResult < Struct.new(
      :fpga_image_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CopyImage.
    #
    # @note When making an API call, you may pass CopyImageRequest
    #   data as a hash:
    #
    #       {
    #         client_token: "String",
    #         description: "String",
    #         encrypted: false,
    #         kms_key_id: "KmsKeyId",
    #         name: "String", # required
    #         source_image_id: "String", # required
    #         source_region: "String", # required
    #         destination_outpost_arn: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier you provide to ensure idempotency
    #   of the request. For more information, see [Ensuring idempotency][1]
    #   in the *Amazon EC2 API Reference*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A description for the new AMI in the destination Region.
    #   @return [String]
    #
    # @!attribute [rw] encrypted
    #   Specifies whether the destination snapshots of the copied image
    #   should be encrypted. You can encrypt a copy of an unencrypted
    #   snapshot, but you cannot create an unencrypted copy of an encrypted
    #   snapshot. The default CMK for EBS is used unless you specify a
    #   non-default AWS Key Management Service (AWS KMS) CMK using
    #   `KmsKeyId`. For more information, see [Amazon EBS Encryption][1] in
    #   the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html
    #   @return [Boolean]
    #
    # @!attribute [rw] kms_key_id
    #   The identifier of the symmetric AWS Key Management Service (AWS KMS)
    #   customer master key (CMK) to use when creating encrypted volumes. If
    #   this parameter is not specified, your AWS managed CMK for EBS is
    #   used. If you specify a CMK, you must also set the encrypted state to
    #   `true`.
    #
    #   You can specify a CMK using any of the following:
    #
    #   * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Key alias. For example, alias/ExampleAlias.
    #
    #   * Key ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Alias ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
    #
    #   AWS authenticates the CMK asynchronously. Therefore, if you specify
    #   an identifier that is not valid, the action can appear to complete,
    #   but eventually fails.
    #
    #   The specified CMK must exist in the destination Region.
    #
    #   Amazon EBS does not support asymmetric CMKs.
    #   @return [String]
    #
    # @!attribute [rw] name
    #   The name of the new AMI in the destination Region.
    #   @return [String]
    #
    # @!attribute [rw] source_image_id
    #   The ID of the AMI to copy.
    #   @return [String]
    #
    # @!attribute [rw] source_region
    #   The name of the Region that contains the AMI to copy.
    #   @return [String]
    #
    # @!attribute [rw] destination_outpost_arn
    #   The Amazon Resource Name (ARN) of the Outpost to which to copy the
    #   AMI. Only specify this parameter when copying an AMI from an AWS
    #   Region to an Outpost. The AMI must be in the Region of the
    #   destination Outpost. You cannot copy an AMI from an Outpost to a
    #   Region, from one Outpost to another, or within the same Outpost.
    #
    #   For more information, see [ Copying AMIs from an AWS Region to an
    #   Outpost][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-amis
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImageRequest AWS API Documentation
    #
    class CopyImageRequest < Struct.new(
      :client_token,
      :description,
      :encrypted,
      :kms_key_id,
      :name,
      :source_image_id,
      :source_region,
      :destination_outpost_arn,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CopyImage.
    #
    # @!attribute [rw] image_id
    #   The ID of the new AMI.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopyImageResult AWS API Documentation
    #
    class CopyImageResult < Struct.new(
      :image_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CopySnapshotRequest
    #   data as a hash:
    #
    #       {
    #         description: "String",
    #         destination_outpost_arn: "String",
    #         destination_region: "String",
    #         encrypted: false,
    #         kms_key_id: "KmsKeyId",
    #         presigned_url: "String",
    #         source_region: "String", # required
    #         source_snapshot_id: "String", # required
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] description
    #   A description for the EBS snapshot.
    #   @return [String]
    #
    # @!attribute [rw] destination_outpost_arn
    #   The Amazon Resource Name (ARN) of the Outpost to which to copy the
    #   snapshot. Only specify this parameter when copying a snapshot from
    #   an AWS Region to an Outpost. The snapshot must be in the Region for
    #   the destination Outpost. You cannot copy a snapshot from an Outpost
    #   to a Region, from one Outpost to another, or within the same
    #   Outpost.
    #
    #   For more information, see [ Copying snapshots from an AWS Region to
    #   an Outpost][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#copy-snapshots
    #   @return [String]
    #
    # @!attribute [rw] destination_region
    #   The destination Region to use in the `PresignedUrl` parameter of a
    #   snapshot copy operation. This parameter is only valid for specifying
    #   the destination Region in a `PresignedUrl` parameter, where it is
    #   required.
    #
    #   The snapshot copy is sent to the regional endpoint that you sent the
    #   HTTP request to (for example, `ec2.us-east-1.amazonaws.com`). With
    #   the AWS CLI, this is specified using the `--region` parameter or the
    #   default Region in your AWS configuration file.
    #   @return [String]
    #
    # @!attribute [rw] encrypted
    #   To encrypt a copy of an unencrypted snapshot if encryption by
    #   default is not enabled, enable encryption using this parameter.
    #   Otherwise, omit this parameter. Encrypted snapshots are encrypted,
    #   even if you omit this parameter and encryption by default is not
    #   enabled. You cannot set this parameter to false. For more
    #   information, see [Amazon EBS encryption][1] in the *Amazon Elastic
    #   Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html
    #   @return [Boolean]
    #
    # @!attribute [rw] kms_key_id
    #   The identifier of the AWS Key Management Service (AWS KMS) customer
    #   master key (CMK) to use for Amazon EBS encryption. If this parameter
    #   is not specified, your AWS managed CMK for EBS is used. If
    #   `KmsKeyId` is specified, the encrypted state must be `true`.
    #
    #   You can specify the CMK using any of the following:
    #
    #   * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Key alias. For example, alias/ExampleAlias.
    #
    #   * Key ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Alias ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
    #
    #   AWS authenticates the CMK asynchronously. Therefore, if you specify
    #   an ID, alias, or ARN that is not valid, the action can appear to
    #   complete, but eventually fails.
    #   @return [String]
    #
    # @!attribute [rw] presigned_url
    #   When you copy an encrypted source snapshot using the Amazon EC2
    #   Query API, you must supply a pre-signed URL. This parameter is
    #   optional for unencrypted snapshots. For more information, see [Query
    #   requests][1].
    #
    #   The `PresignedUrl` should use the snapshot source endpoint, the
    #   `CopySnapshot` action, and include the `SourceRegion`,
    #   `SourceSnapshotId`, and `DestinationRegion` parameters. The
    #   `PresignedUrl` must be signed using AWS Signature Version 4. Because
    #   EBS snapshots are stored in Amazon S3, the signing algorithm for
    #   this parameter uses the same logic that is described in
    #   [Authenticating Requests: Using Query Parameters (AWS Signature
    #   Version 4)][2] in the *Amazon Simple Storage Service API Reference*.
    #   An invalid or improperly signed `PresignedUrl` will cause the copy
    #   operation to fail asynchronously, and the snapshot will move to an
    #   `error` state.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html
    #   [2]: https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html
    #   @return [String]
    #
    # @!attribute [rw] source_region
    #   The ID of the Region that contains the snapshot to be copied.
    #   @return [String]
    #
    # @!attribute [rw] source_snapshot_id
    #   The ID of the EBS snapshot to copy.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the new snapshot.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshotRequest AWS API Documentation
    #
    class CopySnapshotRequest < Struct.new(
      :description,
      :destination_outpost_arn,
      :destination_region,
      :encrypted,
      :kms_key_id,
      :presigned_url,
      :source_region,
      :source_snapshot_id,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] snapshot_id
    #   The ID of the new snapshot.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   Any tags applied to the new snapshot.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CopySnapshotResult AWS API Documentation
    #
    class CopySnapshotResult < Struct.new(
      :snapshot_id,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # The CPU options for the instance.
    #
    # @!attribute [rw] core_count
    #   The number of CPU cores for the instance.
    #   @return [Integer]
    #
    # @!attribute [rw] threads_per_core
    #   The number of threads per CPU core.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CpuOptions AWS API Documentation
    #
    class CpuOptions < Struct.new(
      :core_count,
      :threads_per_core)
      SENSITIVE = []
      include Aws::Structure
    end

    # The CPU options for the instance. Both the core count and threads per
    # core must be specified in the request.
    #
    # @note When making an API call, you may pass CpuOptionsRequest
    #   data as a hash:
    #
    #       {
    #         core_count: 1,
    #         threads_per_core: 1,
    #       }
    #
    # @!attribute [rw] core_count
    #   The number of CPU cores for the instance.
    #   @return [Integer]
    #
    # @!attribute [rw] threads_per_core
    #   The number of threads per CPU core. To disable multithreading for
    #   the instance, specify a value of `1`. Otherwise, specify the default
    #   value of `2`.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CpuOptionsRequest AWS API Documentation
    #
    class CpuOptionsRequest < Struct.new(
      :core_count,
      :threads_per_core)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateCapacityReservationRequest
    #   data as a hash:
    #
    #       {
    #         client_token: "String",
    #         instance_type: "String", # required
    #         instance_platform: "Linux/UNIX", # required, accepts Linux/UNIX, Red Hat Enterprise Linux, SUSE Linux, Windows, Windows with SQL Server, Windows with SQL Server Enterprise, Windows with SQL Server Standard, Windows with SQL Server Web, Linux with SQL Server Standard, Linux with SQL Server Web, Linux with SQL Server Enterprise
    #         availability_zone: "String",
    #         availability_zone_id: "String",
    #         tenancy: "default", # accepts default, dedicated
    #         instance_count: 1, # required
    #         ebs_optimized: false,
    #         ephemeral_storage: false,
    #         end_date: Time.now,
    #         end_date_type: "unlimited", # accepts unlimited, limited
    #         instance_match_criteria: "open", # accepts open, targeted
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] instance_type
    #   The instance type for which to reserve capacity. For more
    #   information, see [Instance types][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html
    #   @return [String]
    #
    # @!attribute [rw] instance_platform
    #   The type of operating system for which to reserve capacity.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone in which to create the Capacity Reservation.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   The ID of the Availability Zone in which to create the Capacity
    #   Reservation.
    #   @return [String]
    #
    # @!attribute [rw] tenancy
    #   Indicates the tenancy of the Capacity Reservation. A Capacity
    #   Reservation can have one of the following tenancy settings:
    #
    #   * `default` - The Capacity Reservation is created on hardware that
    #     is shared with other AWS accounts.
    #
    #   * `dedicated` - The Capacity Reservation is created on single-tenant
    #     hardware that is dedicated to a single AWS account.
    #   @return [String]
    #
    # @!attribute [rw] instance_count
    #   The number of instances for which to reserve capacity.
    #   @return [Integer]
    #
    # @!attribute [rw] ebs_optimized
    #   Indicates whether the Capacity Reservation supports EBS-optimized
    #   instances. This optimization provides dedicated throughput to Amazon
    #   EBS and an optimized configuration stack to provide optimal I/O
    #   performance. This optimization isn't available with all instance
    #   types. Additional usage charges apply when using an EBS- optimized
    #   instance.
    #   @return [Boolean]
    #
    # @!attribute [rw] ephemeral_storage
    #   Indicates whether the Capacity Reservation supports instances with
    #   temporary, block-level storage.
    #   @return [Boolean]
    #
    # @!attribute [rw] end_date
    #   The date and time at which the Capacity Reservation expires. When a
    #   Capacity Reservation expires, the reserved capacity is released and
    #   you can no longer launch instances into it. The Capacity
    #   Reservation's state changes to `expired` when it reaches its end
    #   date and time.
    #
    #   You must provide an `EndDate` value if `EndDateType` is `limited`.
    #   Omit `EndDate` if `EndDateType` is `unlimited`.
    #
    #   If the `EndDateType` is `limited`, the Capacity Reservation is
    #   cancelled within an hour from the specified time. For example, if
    #   you specify 5/31/2019, 13:30:55, the Capacity Reservation is
    #   guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
    #   @return [Time]
    #
    # @!attribute [rw] end_date_type
    #   Indicates the way in which the Capacity Reservation ends. A Capacity
    #   Reservation can have one of the following end types:
    #
    #   * `unlimited` - The Capacity Reservation remains active until you
    #     explicitly cancel it. Do not provide an `EndDate` if the
    #     `EndDateType` is `unlimited`.
    #
    #   * `limited` - The Capacity Reservation expires automatically at a
    #     specified date and time. You must provide an `EndDate` value if
    #     the `EndDateType` value is `limited`.
    #   @return [String]
    #
    # @!attribute [rw] instance_match_criteria
    #   Indicates the type of instance launches that the Capacity
    #   Reservation accepts. The options include:
    #
    #   * `open` - The Capacity Reservation automatically matches all
    #     instances that have matching attributes (instance type, platform,
    #     and Availability Zone). Instances that have matching attributes
    #     run in the Capacity Reservation automatically without specifying
    #     any additional parameters.
    #
    #   * `targeted` - The Capacity Reservation only accepts instances that
    #     have matching attributes (instance type, platform, and
    #     Availability Zone), and explicitly target the Capacity
    #     Reservation. This ensures that only permitted instances can use
    #     the reserved capacity.
    #
    #   Default: `open`
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the Capacity Reservation during launch.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationRequest AWS API Documentation
    #
    class CreateCapacityReservationRequest < Struct.new(
      :client_token,
      :instance_type,
      :instance_platform,
      :availability_zone,
      :availability_zone_id,
      :tenancy,
      :instance_count,
      :ebs_optimized,
      :ephemeral_storage,
      :end_date,
      :end_date_type,
      :instance_match_criteria,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] capacity_reservation
    #   Information about the Capacity Reservation.
    #   @return [Types::CapacityReservation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCapacityReservationResult AWS API Documentation
    #
    class CreateCapacityReservationResult < Struct.new(
      :capacity_reservation)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateCarrierGatewayRequest
    #   data as a hash:
    #
    #       {
    #         vpc_id: "VpcId", # required
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #         client_token: "String",
    #       }
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC to associate with the carrier gateway.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to associate with the carrier gateway.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGatewayRequest AWS API Documentation
    #
    class CreateCarrierGatewayRequest < Struct.new(
      :vpc_id,
      :tag_specifications,
      :dry_run,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] carrier_gateway
    #   Information about the carrier gateway.
    #   @return [Types::CarrierGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCarrierGatewayResult AWS API Documentation
    #
    class CreateCarrierGatewayResult < Struct.new(
      :carrier_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateClientVpnEndpointRequest
    #   data as a hash:
    #
    #       {
    #         client_cidr_block: "String", # required
    #         server_certificate_arn: "String", # required
    #         authentication_options: [ # required
    #           {
    #             type: "certificate-authentication", # accepts certificate-authentication, directory-service-authentication, federated-authentication
    #             active_directory: {
    #               directory_id: "String",
    #             },
    #             mutual_authentication: {
    #               client_root_certificate_chain_arn: "String",
    #             },
    #             federated_authentication: {
    #               saml_provider_arn: "String",
    #               self_service_saml_provider_arn: "String",
    #             },
    #           },
    #         ],
    #         connection_log_options: { # required
    #           enabled: false,
    #           cloudwatch_log_group: "String",
    #           cloudwatch_log_stream: "String",
    #         },
    #         dns_servers: ["String"],
    #         transport_protocol: "tcp", # accepts tcp, udp
    #         vpn_port: 1,
    #         description: "String",
    #         split_tunnel: false,
    #         dry_run: false,
    #         client_token: "String",
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         security_group_ids: ["SecurityGroupId"],
    #         vpc_id: "VpcId",
    #         self_service_portal: "enabled", # accepts enabled, disabled
    #         client_connect_options: {
    #           enabled: false,
    #           lambda_function_arn: "String",
    #         },
    #       }
    #
    # @!attribute [rw] client_cidr_block
    #   The IPv4 address range, in CIDR notation, from which to assign
    #   client IP addresses. The address range cannot overlap with the local
    #   CIDR of the VPC in which the associated subnet is located, or the
    #   routes that you add manually. The address range cannot be changed
    #   after the Client VPN endpoint has been created. The CIDR block
    #   should be /22 or greater.
    #   @return [String]
    #
    # @!attribute [rw] server_certificate_arn
    #   The ARN of the server certificate. For more information, see the
    #   [AWS Certificate Manager User Guide][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/acm/latest/userguide/
    #   @return [String]
    #
    # @!attribute [rw] authentication_options
    #   Information about the authentication method to be used to
    #   authenticate clients.
    #   @return [Array<Types::ClientVpnAuthenticationRequest>]
    #
    # @!attribute [rw] connection_log_options
    #   Information about the client connection logging options.
    #
    #   If you enable client connection logging, data about client
    #   connections is sent to a Cloudwatch Logs log stream. The following
    #   information is logged:
    #
    #   * Client connection requests
    #
    #   * Client connection results (successful and unsuccessful)
    #
    #   * Reasons for unsuccessful client connection requests
    #
    #   * Client connection termination time
    #   @return [Types::ConnectionLogOptions]
    #
    # @!attribute [rw] dns_servers
    #   Information about the DNS servers to be used for DNS resolution. A
    #   Client VPN endpoint can have up to two DNS servers. If no DNS server
    #   is specified, the DNS address configured on the device is used for
    #   the DNS server.
    #   @return [Array<String>]
    #
    # @!attribute [rw] transport_protocol
    #   The transport protocol to be used by the VPN session.
    #
    #   Default value: `udp`
    #   @return [String]
    #
    # @!attribute [rw] vpn_port
    #   The port number to assign to the Client VPN endpoint for TCP and UDP
    #   traffic.
    #
    #   Valid Values: `443` \| `1194`
    #
    #   Default Value: `443`
    #   @return [Integer]
    #
    # @!attribute [rw] description
    #   A brief description of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] split_tunnel
    #   Indicates whether split-tunnel is enabled on the AWS Client VPN
    #   endpoint.
    #
    #   By default, split-tunnel on a VPN endpoint is disabled.
    #
    #   For information about split-tunnel VPN endpoints, see [Split-Tunnel
    #   AWS Client VPN Endpoint][1] in the *AWS Client VPN Administrator
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html
    #   @return [Boolean]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the Client VPN endpoint during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] security_group_ids
    #   The IDs of one or more security groups to apply to the target
    #   network. You must also specify the ID of the VPC that contains the
    #   security groups.
    #   @return [Array<String>]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC to associate with the Client VPN endpoint. If no
    #   security group IDs are specified in the request, the default
    #   security group for the VPC is applied.
    #   @return [String]
    #
    # @!attribute [rw] self_service_portal
    #   Specify whether to enable the self-service portal for the Client VPN
    #   endpoint.
    #
    #   Default Value: `enabled`
    #   @return [String]
    #
    # @!attribute [rw] client_connect_options
    #   The options for managing connection authorization for new client
    #   connections.
    #   @return [Types::ClientConnectOptions]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpointRequest AWS API Documentation
    #
    class CreateClientVpnEndpointRequest < Struct.new(
      :client_cidr_block,
      :server_certificate_arn,
      :authentication_options,
      :connection_log_options,
      :dns_servers,
      :transport_protocol,
      :vpn_port,
      :description,
      :split_tunnel,
      :dry_run,
      :client_token,
      :tag_specifications,
      :security_group_ids,
      :vpc_id,
      :self_service_portal,
      :client_connect_options)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] status
    #   The current state of the Client VPN endpoint.
    #   @return [Types::ClientVpnEndpointStatus]
    #
    # @!attribute [rw] dns_name
    #   The DNS name to be used by clients when establishing their VPN
    #   session.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnEndpointResult AWS API Documentation
    #
    class CreateClientVpnEndpointResult < Struct.new(
      :client_vpn_endpoint_id,
      :status,
      :dns_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateClientVpnRouteRequest
    #   data as a hash:
    #
    #       {
    #         client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #         destination_cidr_block: "String", # required
    #         target_vpc_subnet_id: "SubnetId", # required
    #         description: "String",
    #         client_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint to which to add the route.
    #   @return [String]
    #
    # @!attribute [rw] destination_cidr_block
    #   The IPv4 address range, in CIDR notation, of the route destination.
    #   For example:
    #
    #   * To add a route for Internet access, enter `0.0.0.0/0`
    #
    #   * To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR
    #     range
    #
    #   * To add a route for an on-premises network, enter the AWS
    #     Site-to-Site VPN connection's IPv4 CIDR range
    #
    #   * To add a route for the local network, enter the client CIDR range
    #   @return [String]
    #
    # @!attribute [rw] target_vpc_subnet_id
    #   The ID of the subnet through which you want to route traffic. The
    #   specified subnet must be an existing target network of the Client
    #   VPN endpoint.
    #
    #   Alternatively, if you're adding a route for the local network,
    #   specify `local`.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   A brief description of the route.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRouteRequest AWS API Documentation
    #
    class CreateClientVpnRouteRequest < Struct.new(
      :client_vpn_endpoint_id,
      :destination_cidr_block,
      :target_vpc_subnet_id,
      :description,
      :client_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] status
    #   The current state of the route.
    #   @return [Types::ClientVpnRouteStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateClientVpnRouteResult AWS API Documentation
    #
    class CreateClientVpnRouteResult < Struct.new(
      :status)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateCustomerGateway.
    #
    # @note When making an API call, you may pass CreateCustomerGatewayRequest
    #   data as a hash:
    #
    #       {
    #         bgp_asn: 1, # required
    #         public_ip: "String",
    #         certificate_arn: "String",
    #         type: "ipsec.1", # required, accepts ipsec.1
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         device_name: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] bgp_asn
    #   For devices that support BGP, the customer gateway's BGP ASN.
    #
    #   Default: 65000
    #   @return [Integer]
    #
    # @!attribute [rw] public_ip
    #   The Internet-routable IP address for the customer gateway's outside
    #   interface. The address must be static.
    #   @return [String]
    #
    # @!attribute [rw] certificate_arn
    #   The Amazon Resource Name (ARN) for the customer gateway certificate.
    #   @return [String]
    #
    # @!attribute [rw] type
    #   The type of VPN connection that this customer gateway supports
    #   (`ipsec.1`).
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the customer gateway.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] device_name
    #   A name for the customer gateway device.
    #
    #   Length Constraints: Up to 255 characters.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGatewayRequest AWS API Documentation
    #
    class CreateCustomerGatewayRequest < Struct.new(
      :bgp_asn,
      :public_ip,
      :certificate_arn,
      :type,
      :tag_specifications,
      :device_name,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CreateCustomerGateway.
    #
    # @!attribute [rw] customer_gateway
    #   Information about the customer gateway.
    #   @return [Types::CustomerGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateCustomerGatewayResult AWS API Documentation
    #
    class CreateCustomerGatewayResult < Struct.new(
      :customer_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateDefaultSubnetRequest
    #   data as a hash:
    #
    #       {
    #         availability_zone: "String", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone in which to create the default subnet.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnetRequest AWS API Documentation
    #
    class CreateDefaultSubnetRequest < Struct.new(
      :availability_zone,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] subnet
    #   Information about the subnet.
    #   @return [Types::Subnet]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultSubnetResult AWS API Documentation
    #
    class CreateDefaultSubnetResult < Struct.new(
      :subnet)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateDefaultVpcRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpcRequest AWS API Documentation
    #
    class CreateDefaultVpcRequest < Struct.new(
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc
    #   Information about the VPC.
    #   @return [Types::Vpc]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDefaultVpcResult AWS API Documentation
    #
    class CreateDefaultVpcResult < Struct.new(
      :vpc)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateDhcpOptionsRequest
    #   data as a hash:
    #
    #       {
    #         dhcp_configurations: [ # required
    #           {
    #             key: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] dhcp_configurations
    #   A DHCP configuration option.
    #   @return [Array<Types::NewDhcpConfiguration>]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the DHCP option.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptionsRequest AWS API Documentation
    #
    class CreateDhcpOptionsRequest < Struct.new(
      :dhcp_configurations,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dhcp_options
    #   A set of DHCP options.
    #   @return [Types::DhcpOptions]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateDhcpOptionsResult AWS API Documentation
    #
    class CreateDhcpOptionsResult < Struct.new(
      :dhcp_options)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateEgressOnlyInternetGatewayRequest
    #   data as a hash:
    #
    #       {
    #         client_token: "String",
    #         dry_run: false,
    #         vpc_id: "VpcId", # required
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC for which to create the egress-only internet
    #   gateway.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the egress-only internet gateway.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGatewayRequest AWS API Documentation
    #
    class CreateEgressOnlyInternetGatewayRequest < Struct.new(
      :client_token,
      :dry_run,
      :vpc_id,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request.
    #   @return [String]
    #
    # @!attribute [rw] egress_only_internet_gateway
    #   Information about the egress-only internet gateway.
    #   @return [Types::EgressOnlyInternetGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateEgressOnlyInternetGatewayResult AWS API Documentation
    #
    class CreateEgressOnlyInternetGatewayResult < Struct.new(
      :client_token,
      :egress_only_internet_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the instances that could not be launched by the fleet.
    #
    # @!attribute [rw] launch_template_and_overrides
    #   The launch templates and overrides that were used for launching the
    #   instances. The values that you specify in the Overrides replace the
    #   values in the launch template.
    #   @return [Types::LaunchTemplateAndOverridesResponse]
    #
    # @!attribute [rw] lifecycle
    #   Indicates if the instance that could not be launched was a Spot
    #   Instance or On-Demand Instance.
    #   @return [String]
    #
    # @!attribute [rw] error_code
    #   The error code that indicates why the instance could not be
    #   launched. For more information about error codes, see [Error
    #   Codes][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html
    #   @return [String]
    #
    # @!attribute [rw] error_message
    #   The error message that describes why the instance could not be
    #   launched. For more information about error messages, see [Error
    #   Codes][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleetError AWS API Documentation
    #
    class CreateFleetError < Struct.new(
      :launch_template_and_overrides,
      :lifecycle,
      :error_code,
      :error_message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the instances that were launched by the fleet.
    #
    # @!attribute [rw] launch_template_and_overrides
    #   The launch templates and overrides that were used for launching the
    #   instances. The values that you specify in the Overrides replace the
    #   values in the launch template.
    #   @return [Types::LaunchTemplateAndOverridesResponse]
    #
    # @!attribute [rw] lifecycle
    #   Indicates if the instance that was launched is a Spot Instance or
    #   On-Demand Instance.
    #   @return [String]
    #
    # @!attribute [rw] instance_ids
    #   The IDs of the instances.
    #   @return [Array<String>]
    #
    # @!attribute [rw] instance_type
    #   The instance type.
    #   @return [String]
    #
    # @!attribute [rw] platform
    #   The value is `Windows` for Windows instances. Otherwise, the value
    #   is blank.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleetInstance AWS API Documentation
    #
    class CreateFleetInstance < Struct.new(
      :launch_template_and_overrides,
      :lifecycle,
      :instance_ids,
      :instance_type,
      :platform)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateFleetRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         client_token: "String",
    #         spot_options: {
    #           allocation_strategy: "lowest-price", # accepts lowest-price, diversified, capacity-optimized, capacity-optimized-prioritized
    #           maintenance_strategies: {
    #             capacity_rebalance: {
    #               replacement_strategy: "launch", # accepts launch
    #             },
    #           },
    #           instance_interruption_behavior: "hibernate", # accepts hibernate, stop, terminate
    #           instance_pools_to_use_count: 1,
    #           single_instance_type: false,
    #           single_availability_zone: false,
    #           min_target_capacity: 1,
    #           max_total_price: "String",
    #         },
    #         on_demand_options: {
    #           allocation_strategy: "lowest-price", # accepts lowest-price, prioritized
    #           capacity_reservation_options: {
    #             usage_strategy: "use-capacity-reservations-first", # accepts use-capacity-reservations-first
    #           },
    #           single_instance_type: false,
    #           single_availability_zone: false,
    #           min_target_capacity: 1,
    #           max_total_price: "String",
    #         },
    #         excess_capacity_termination_policy: "no-termination", # accepts no-termination, termination
    #         launch_template_configs: [ # required
    #           {
    #             launch_template_specification: {
    #               launch_template_id: "LaunchTemplateId",
    #               launch_template_name: "LaunchTemplateName",
    #               version: "String",
    #             },
    #             overrides: [
    #               {
    #                 instance_type: "t1.micro", # accepts t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, t4g.nano, t4g.micro, t4g.small, t4g.medium, t4g.large, t4g.xlarge, t4g.2xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, cr1.8xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5b.large, r5b.xlarge, r5b.2xlarge, r5b.4xlarge, r5b.8xlarge, r5b.12xlarge, r5b.16xlarge, r5b.24xlarge, r5b.metal, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, r6g.metal, r6g.medium, r6g.large, r6g.xlarge, r6g.2xlarge, r6g.4xlarge, r6g.8xlarge, r6g.12xlarge, r6g.16xlarge, r6gd.metal, r6gd.medium, r6gd.large, r6gd.xlarge, r6gd.2xlarge, r6gd.4xlarge, r6gd.8xlarge, r6gd.12xlarge, r6gd.16xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, hi1.4xlarge, hs1.8xlarge, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5a.large, c5a.xlarge, c5a.2xlarge, c5a.4xlarge, c5a.8xlarge, c5a.12xlarge, c5a.16xlarge, c5a.24xlarge, c5ad.large, c5ad.xlarge, c5ad.2xlarge, c5ad.4xlarge, c5ad.8xlarge, c5ad.12xlarge, c5ad.16xlarge, c5ad.24xlarge, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.12xlarge, c5d.18xlarge, c5d.24xlarge, c5d.metal, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, c5n.metal, c6g.metal, c6g.medium, c6g.large, c6g.xlarge, c6g.2xlarge, c6g.4xlarge, c6g.8xlarge, c6g.12xlarge, c6g.16xlarge, c6gd.metal, c6gd.medium, c6gd.large, c6gd.xlarge, c6gd.2xlarge, c6gd.4xlarge, c6gd.8xlarge, c6gd.12xlarge, c6gd.16xlarge, c6gn.medium, c6gn.large, c6gn.xlarge, c6gn.2xlarge, c6gn.4xlarge, c6gn.8xlarge, c6gn.12xlarge, c6gn.16xlarge, cc1.4xlarge, cc2.8xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, g4ad.4xlarge, g4ad.8xlarge, g4ad.16xlarge, g4dn.xlarge, g4dn.2xlarge, g4dn.4xlarge, g4dn.8xlarge, g4dn.12xlarge, g4dn.16xlarge, g4dn.metal, cg1.4xlarge, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, p4d.24xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, d3.xlarge, d3.2xlarge, d3.4xlarge, d3.8xlarge, d3en.xlarge, d3en.2xlarge, d3en.4xlarge, d3en.6xlarge, d3en.8xlarge, d3en.12xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, m5zn.large, m5zn.xlarge, m5zn.2xlarge, m5zn.3xlarge, m5zn.6xlarge, m5zn.12xlarge, m5zn.metal, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, u-18tb1.metal, u-24tb1.metal, a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge, a1.metal, m5dn.large, m5dn.xlarge, m5dn.2xlarge, m5dn.4xlarge, m5dn.8xlarge, m5dn.12xlarge, m5dn.16xlarge, m5dn.24xlarge, m5n.large, m5n.xlarge, m5n.2xlarge, m5n.4xlarge, m5n.8xlarge, m5n.12xlarge, m5n.16xlarge, m5n.24xlarge, r5dn.large, r5dn.xlarge, r5dn.2xlarge, r5dn.4xlarge, r5dn.8xlarge, r5dn.12xlarge, r5dn.16xlarge, r5dn.24xlarge, r5n.large, r5n.xlarge, r5n.2xlarge, r5n.4xlarge, r5n.8xlarge, r5n.12xlarge, r5n.16xlarge, r5n.24xlarge, inf1.xlarge, inf1.2xlarge, inf1.6xlarge, inf1.24xlarge, m6g.metal, m6g.medium, m6g.large, m6g.xlarge, m6g.2xlarge, m6g.4xlarge, m6g.8xlarge, m6g.12xlarge, m6g.16xlarge, m6gd.metal, m6gd.medium, m6gd.large, m6gd.xlarge, m6gd.2xlarge, m6gd.4xlarge, m6gd.8xlarge, m6gd.12xlarge, m6gd.16xlarge, mac1.metal
    #                 max_price: "String",
    #                 subnet_id: "SubnetId",
    #                 availability_zone: "String",
    #                 weighted_capacity: 1.0,
    #                 priority: 1.0,
    #                 placement: {
    #                   availability_zone: "String",
    #                   affinity: "String",
    #                   group_name: "String",
    #                   partition_number: 1,
    #                   host_id: "String",
    #                   tenancy: "default", # accepts default, dedicated, host
    #                   spread_domain: "String",
    #                   host_resource_group_arn: "String",
    #                 },
    #               },
    #             ],
    #           },
    #         ],
    #         target_capacity_specification: { # required
    #           total_target_capacity: 1, # required
    #           on_demand_target_capacity: 1,
    #           spot_target_capacity: 1,
    #           default_target_capacity_type: "spot", # accepts spot, on-demand
    #         },
    #         terminate_instances_with_expiration: false,
    #         type: "request", # accepts request, maintain, instant
    #         valid_from: Time.now,
    #         valid_until: Time.now,
    #         replace_unhealthy_instances: false,
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] spot_options
    #   Describes the configuration of Spot Instances in an EC2 Fleet.
    #   @return [Types::SpotOptionsRequest]
    #
    # @!attribute [rw] on_demand_options
    #   Describes the configuration of On-Demand Instances in an EC2 Fleet.
    #   @return [Types::OnDemandOptionsRequest]
    #
    # @!attribute [rw] excess_capacity_termination_policy
    #   Indicates whether running instances should be terminated if the
    #   total target capacity of the EC2 Fleet is decreased below the
    #   current size of the EC2 Fleet.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_configs
    #   The configuration for the EC2 Fleet.
    #   @return [Array<Types::FleetLaunchTemplateConfigRequest>]
    #
    # @!attribute [rw] target_capacity_specification
    #   The number of units to request.
    #   @return [Types::TargetCapacitySpecificationRequest]
    #
    # @!attribute [rw] terminate_instances_with_expiration
    #   Indicates whether running instances should be terminated when the
    #   EC2 Fleet expires.
    #   @return [Boolean]
    #
    # @!attribute [rw] type
    #   The type of request. The default value is `maintain`.
    #
    #   * `maintain` - The EC2 Fleet places an asynchronous request for your
    #     desired capacity, and continues to maintain your desired Spot
    #     capacity by replenishing interrupted Spot Instances.
    #
    #   * `request` - The EC2 Fleet places an asynchronous one-time request
    #     for your desired capacity, but does submit Spot requests in
    #     alternative capacity pools if Spot capacity is unavailable, and
    #     does not maintain Spot capacity if Spot Instances are interrupted.
    #
    #   * `instant` - The EC2 Fleet places a synchronous one-time request
    #     for your desired capacity, and returns errors for any instances
    #     that could not be launched.
    #
    #   For more information, see [EC2 Fleet request types][1] in the
    #   *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type
    #   @return [String]
    #
    # @!attribute [rw] valid_from
    #   The start date and time of the request, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z). The default is to start
    #   fulfilling the request immediately.
    #   @return [Time]
    #
    # @!attribute [rw] valid_until
    #   The end date and time of the request, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z). At this point, no new EC2 Fleet
    #   requests are placed or able to fulfill the request. If no value is
    #   specified, the request remains until you cancel it.
    #   @return [Time]
    #
    # @!attribute [rw] replace_unhealthy_instances
    #   Indicates whether EC2 Fleet should replace unhealthy Spot Instances.
    #   Supported only for fleets of type `maintain`. For more information,
    #   see [EC2 Fleet health checks][1] in the *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/manage-ec2-fleet.html#ec2-fleet-health-checks
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The key-value pair for tagging the EC2 Fleet request on creation.
    #   The value for `ResourceType` must be `fleet`, otherwise the fleet
    #   request fails. To tag instances at launch, specify the tags in the
    #   [launch template][1]. For information about tagging after launch,
    #   see [Tagging your resources][2].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template
    #   [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleetRequest AWS API Documentation
    #
    class CreateFleetRequest < Struct.new(
      :dry_run,
      :client_token,
      :spot_options,
      :on_demand_options,
      :excess_capacity_termination_policy,
      :launch_template_configs,
      :target_capacity_specification,
      :terminate_instances_with_expiration,
      :type,
      :valid_from,
      :valid_until,
      :replace_unhealthy_instances,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] fleet_id
    #   The ID of the EC2 Fleet.
    #   @return [String]
    #
    # @!attribute [rw] errors
    #   Information about the instances that could not be launched by the
    #   fleet. Valid only when **Type** is set to `instant`.
    #   @return [Array<Types::CreateFleetError>]
    #
    # @!attribute [rw] instances
    #   Information about the instances that were launched by the fleet.
    #   Valid only when **Type** is set to `instant`.
    #   @return [Array<Types::CreateFleetInstance>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFleetResult AWS API Documentation
    #
    class CreateFleetResult < Struct.new(
      :fleet_id,
      :errors,
      :instances)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateFlowLogsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         client_token: "String",
    #         deliver_logs_permission_arn: "String",
    #         log_group_name: "String",
    #         resource_ids: ["FlowLogResourceId"], # required
    #         resource_type: "VPC", # required, accepts VPC, Subnet, NetworkInterface
    #         traffic_type: "ACCEPT", # required, accepts ACCEPT, REJECT, ALL
    #         log_destination_type: "cloud-watch-logs", # accepts cloud-watch-logs, s3
    #         log_destination: "String",
    #         log_format: "String",
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         max_aggregation_interval: 1,
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] deliver_logs_permission_arn
    #   The ARN for the IAM role that permits Amazon EC2 to publish flow
    #   logs to a CloudWatch Logs log group in your account.
    #
    #   If you specify `LogDestinationType` as `s3`, do not specify
    #   `DeliverLogsPermissionArn` or `LogGroupName`.
    #   @return [String]
    #
    # @!attribute [rw] log_group_name
    #   The name of a new or existing CloudWatch Logs log group where Amazon
    #   EC2 publishes your flow logs.
    #
    #   If you specify `LogDestinationType` as `s3`, do not specify
    #   `DeliverLogsPermissionArn` or `LogGroupName`.
    #   @return [String]
    #
    # @!attribute [rw] resource_ids
    #   The ID of the subnet, network interface, or VPC for which you want
    #   to create a flow log.
    #
    #   Constraints: Maximum of 1000 resources
    #   @return [Array<String>]
    #
    # @!attribute [rw] resource_type
    #   The type of resource for which to create the flow log. For example,
    #   if you specified a VPC ID for the `ResourceId` property, specify
    #   `VPC` for this property.
    #   @return [String]
    #
    # @!attribute [rw] traffic_type
    #   The type of traffic to log. You can log traffic that the resource
    #   accepts or rejects, or all traffic.
    #   @return [String]
    #
    # @!attribute [rw] log_destination_type
    #   Specifies the type of destination to which the flow log data is to
    #   be published. Flow log data can be published to CloudWatch Logs or
    #   Amazon S3. To publish flow log data to CloudWatch Logs, specify
    #   `cloud-watch-logs`. To publish flow log data to Amazon S3, specify
    #   `s3`.
    #
    #   If you specify `LogDestinationType` as `s3`, do not specify
    #   `DeliverLogsPermissionArn` or `LogGroupName`.
    #
    #   Default: `cloud-watch-logs`
    #   @return [String]
    #
    # @!attribute [rw] log_destination
    #   Specifies the destination to which the flow log data is to be
    #   published. Flow log data can be published to a CloudWatch Logs log
    #   group or an Amazon S3 bucket. The value specified for this parameter
    #   depends on the value specified for `LogDestinationType`.
    #
    #   If `LogDestinationType` is not specified or `cloud-watch-logs`,
    #   specify the Amazon Resource Name (ARN) of the CloudWatch Logs log
    #   group. For example, to publish to a log group called `my-logs`,
    #   specify `arn:aws:logs:us-east-1:123456789012:log-group:my-logs`.
    #   Alternatively, use `LogGroupName` instead.
    #
    #   If LogDestinationType is `s3`, specify the ARN of the Amazon S3
    #   bucket. You can also specify a subfolder in the bucket. To specify a
    #   subfolder in the bucket, use the following ARN format:
    #   `bucket_ARN/subfolder_name/`. For example, to specify a subfolder
    #   named `my-logs` in a bucket named `my-bucket`, use the following
    #   ARN: `arn:aws:s3:::my-bucket/my-logs/`. You cannot use `AWSLogs` as
    #   a subfolder name. This is a reserved term.
    #   @return [String]
    #
    # @!attribute [rw] log_format
    #   The fields to include in the flow log record, in the order in which
    #   they should appear. For a list of available fields, see [Flow Log
    #   Records][1]. If you omit this parameter, the flow log is created
    #   using the default format. If you specify this parameter, you must
    #   specify at least one field.
    #
    #   Specify the fields using the `$\{field-id\}` format, separated by
    #   spaces. For the AWS CLI, use single quotation marks (' ') to
    #   surround the parameter value.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the flow logs.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] max_aggregation_interval
    #   The maximum interval of time during which a flow of packets is
    #   captured and aggregated into a flow log record. You can specify 60
    #   seconds (1 minute) or 600 seconds (10 minutes).
    #
    #   When a network interface is attached to a [Nitro-based instance][1],
    #   the aggregation interval is always 60 seconds or less, regardless of
    #   the value that you specify.
    #
    #   Default: 600
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogsRequest AWS API Documentation
    #
    class CreateFlowLogsRequest < Struct.new(
      :dry_run,
      :client_token,
      :deliver_logs_permission_arn,
      :log_group_name,
      :resource_ids,
      :resource_type,
      :traffic_type,
      :log_destination_type,
      :log_destination,
      :log_format,
      :tag_specifications,
      :max_aggregation_interval)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request.
    #   @return [String]
    #
    # @!attribute [rw] flow_log_ids
    #   The IDs of the flow logs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] unsuccessful
    #   Information about the flow logs that could not be created
    #   successfully.
    #   @return [Array<Types::UnsuccessfulItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFlowLogsResult AWS API Documentation
    #
    class CreateFlowLogsResult < Struct.new(
      :client_token,
      :flow_log_ids,
      :unsuccessful)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateFpgaImageRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         input_storage_location: { # required
    #           bucket: "String",
    #           key: "String",
    #         },
    #         logs_storage_location: {
    #           bucket: "String",
    #           key: "String",
    #         },
    #         description: "String",
    #         name: "String",
    #         client_token: "String",
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] input_storage_location
    #   The location of the encrypted design checkpoint in Amazon S3. The
    #   input must be a tarball.
    #   @return [Types::StorageLocation]
    #
    # @!attribute [rw] logs_storage_location
    #   The location in Amazon S3 for the output logs.
    #   @return [Types::StorageLocation]
    #
    # @!attribute [rw] description
    #   A description for the AFI.
    #   @return [String]
    #
    # @!attribute [rw] name
    #   A name for the AFI.
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the FPGA image during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImageRequest AWS API Documentation
    #
    class CreateFpgaImageRequest < Struct.new(
      :dry_run,
      :input_storage_location,
      :logs_storage_location,
      :description,
      :name,
      :client_token,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] fpga_image_id
    #   The FPGA image identifier (AFI ID).
    #   @return [String]
    #
    # @!attribute [rw] fpga_image_global_id
    #   The global FPGA image identifier (AGFI ID).
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateFpgaImageResult AWS API Documentation
    #
    class CreateFpgaImageResult < Struct.new(
      :fpga_image_id,
      :fpga_image_global_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateImageRequest
    #   data as a hash:
    #
    #       {
    #         block_device_mappings: [
    #           {
    #             device_name: "String",
    #             virtual_name: "String",
    #             ebs: {
    #               delete_on_termination: false,
    #               iops: 1,
    #               snapshot_id: "String",
    #               volume_size: 1,
    #               volume_type: "standard", # accepts standard, io1, io2, gp2, sc1, st1, gp3
    #               kms_key_id: "String",
    #               throughput: 1,
    #               outpost_arn: "String",
    #               encrypted: false,
    #             },
    #             no_device: "String",
    #           },
    #         ],
    #         description: "String",
    #         dry_run: false,
    #         instance_id: "InstanceId", # required
    #         name: "String", # required
    #         no_reboot: false,
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] block_device_mappings
    #   The block device mappings. This parameter cannot be used to modify
    #   the encryption status of existing volumes or snapshots. To create an
    #   AMI with encrypted snapshots, use the CopyImage action.
    #   @return [Array<Types::BlockDeviceMapping>]
    #
    # @!attribute [rw] description
    #   A description for the new image.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @!attribute [rw] name
    #   A name for the new image.
    #
    #   Constraints: 3-128 alphanumeric characters, parentheses (()), square
    #   brackets (\[\]), spaces ( ), periods (.), slashes (/), dashes (-),
    #   single quotes ('), at-signs (@), or underscores(\_)
    #   @return [String]
    #
    # @!attribute [rw] no_reboot
    #   By default, Amazon EC2 attempts to shut down and reboot the instance
    #   before creating the image. If the `No Reboot` option is set, Amazon
    #   EC2 doesn't shut down the instance before creating the image. When
    #   this option is used, file system integrity on the created image
    #   can't be guaranteed.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the AMI and snapshots on creation. You can tag
    #   the AMI, the snapshots, or both.
    #
    #   * To tag the AMI, the value for `ResourceType` must be `image`.
    #
    #   * To tag the snapshots that are created of the root volume and of
    #     other EBS volumes that are attached to the instance, the value for
    #     `ResourceType` must be `snapshot`. The same tag is applied to all
    #     of the snapshots that are created.
    #
    #   If you specify other values for `ResourceType`, the request fails.
    #
    #   To tag an AMI or snapshot after it has been created, see
    #   [CreateTags][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImageRequest AWS API Documentation
    #
    class CreateImageRequest < Struct.new(
      :block_device_mappings,
      :description,
      :dry_run,
      :instance_id,
      :name,
      :no_reboot,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] image_id
    #   The ID of the new AMI.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateImageResult AWS API Documentation
    #
    class CreateImageResult < Struct.new(
      :image_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateInstanceExportTaskRequest
    #   data as a hash:
    #
    #       {
    #         description: "String",
    #         export_to_s3_task: { # required
    #           container_format: "ova", # accepts ova
    #           disk_image_format: "VMDK", # accepts VMDK, RAW, VHD
    #           s3_bucket: "String",
    #           s3_prefix: "String",
    #         },
    #         instance_id: "InstanceId", # required
    #         target_environment: "citrix", # required, accepts citrix, vmware, microsoft
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] description
    #   A description for the conversion task or the resource being
    #   exported. The maximum length is 255 characters.
    #   @return [String]
    #
    # @!attribute [rw] export_to_s3_task
    #   The format and location for an export instance task.
    #   @return [Types::ExportToS3TaskSpecification]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @!attribute [rw] target_environment
    #   The target virtualization environment.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the export instance task during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTaskRequest AWS API Documentation
    #
    class CreateInstanceExportTaskRequest < Struct.new(
      :description,
      :export_to_s3_task,
      :instance_id,
      :target_environment,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] export_task
    #   Information about the export instance task.
    #   @return [Types::ExportTask]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInstanceExportTaskResult AWS API Documentation
    #
    class CreateInstanceExportTaskResult < Struct.new(
      :export_task)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateInternetGatewayRequest
    #   data as a hash:
    #
    #       {
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the internet gateway.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGatewayRequest AWS API Documentation
    #
    class CreateInternetGatewayRequest < Struct.new(
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] internet_gateway
    #   Information about the internet gateway.
    #   @return [Types::InternetGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateInternetGatewayResult AWS API Documentation
    #
    class CreateInternetGatewayResult < Struct.new(
      :internet_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateKeyPairRequest
    #   data as a hash:
    #
    #       {
    #         key_name: "String", # required
    #         dry_run: false,
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] key_name
    #   A unique name for the key pair.
    #
    #   Constraints: Up to 255 ASCII characters
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the new key pair.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateKeyPairRequest AWS API Documentation
    #
    class CreateKeyPairRequest < Struct.new(
      :key_name,
      :dry_run,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateLaunchTemplateRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         client_token: "String",
    #         launch_template_name: "LaunchTemplateName", # required
    #         version_description: "VersionDescription",
    #         launch_template_data: { # required
    #           kernel_id: "KernelId",
    #           ebs_optimized: false,
    #           iam_instance_profile: {
    #             arn: "String",
    #             name: "String",
    #           },
    #           block_device_mappings: [
    #             {
    #               device_name: "String",
    #               virtual_name: "String",
    #               ebs: {
    #                 encrypted: false,
    #                 delete_on_termination: false,
    #                 iops: 1,
    #                 kms_key_id: "KmsKeyId",
    #                 snapshot_id: "SnapshotId",
    #                 volume_size: 1,
    #                 volume_type: "standard", # accepts standard, io1, io2, gp2, sc1, st1, gp3
    #                 throughput: 1,
    #               },
    #               no_device: "String",
    #             },
    #           ],
    #           network_interfaces: [
    #             {
    #               associate_carrier_ip_address: false,
    #               associate_public_ip_address: false,
    #               delete_on_termination: false,
    #               description: "String",
    #               device_index: 1,
    #               groups: ["SecurityGroupId"],
    #               interface_type: "String",
    #               ipv_6_address_count: 1,
    #               ipv_6_addresses: [
    #                 {
    #                   ipv_6_address: "String",
    #                 },
    #               ],
    #               network_interface_id: "NetworkInterfaceId",
    #               private_ip_address: "String",
    #               private_ip_addresses: [
    #                 {
    #                   primary: false,
    #                   private_ip_address: "String",
    #                 },
    #               ],
    #               secondary_private_ip_address_count: 1,
    #               subnet_id: "SubnetId",
    #               network_card_index: 1,
    #             },
    #           ],
    #           image_id: "ImageId",
    #           instance_type: "t1.micro", # accepts t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, t4g.nano, t4g.micro, t4g.small, t4g.medium, t4g.large, t4g.xlarge, t4g.2xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, cr1.8xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5b.large, r5b.xlarge, r5b.2xlarge, r5b.4xlarge, r5b.8xlarge, r5b.12xlarge, r5b.16xlarge, r5b.24xlarge, r5b.metal, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, r6g.metal, r6g.medium, r6g.large, r6g.xlarge, r6g.2xlarge, r6g.4xlarge, r6g.8xlarge, r6g.12xlarge, r6g.16xlarge, r6gd.metal, r6gd.medium, r6gd.large, r6gd.xlarge, r6gd.2xlarge, r6gd.4xlarge, r6gd.8xlarge, r6gd.12xlarge, r6gd.16xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, hi1.4xlarge, hs1.8xlarge, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5a.large, c5a.xlarge, c5a.2xlarge, c5a.4xlarge, c5a.8xlarge, c5a.12xlarge, c5a.16xlarge, c5a.24xlarge, c5ad.large, c5ad.xlarge, c5ad.2xlarge, c5ad.4xlarge, c5ad.8xlarge, c5ad.12xlarge, c5ad.16xlarge, c5ad.24xlarge, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.12xlarge, c5d.18xlarge, c5d.24xlarge, c5d.metal, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, c5n.metal, c6g.metal, c6g.medium, c6g.large, c6g.xlarge, c6g.2xlarge, c6g.4xlarge, c6g.8xlarge, c6g.12xlarge, c6g.16xlarge, c6gd.metal, c6gd.medium, c6gd.large, c6gd.xlarge, c6gd.2xlarge, c6gd.4xlarge, c6gd.8xlarge, c6gd.12xlarge, c6gd.16xlarge, c6gn.medium, c6gn.large, c6gn.xlarge, c6gn.2xlarge, c6gn.4xlarge, c6gn.8xlarge, c6gn.12xlarge, c6gn.16xlarge, cc1.4xlarge, cc2.8xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, g4ad.4xlarge, g4ad.8xlarge, g4ad.16xlarge, g4dn.xlarge, g4dn.2xlarge, g4dn.4xlarge, g4dn.8xlarge, g4dn.12xlarge, g4dn.16xlarge, g4dn.metal, cg1.4xlarge, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, p4d.24xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, d3.xlarge, d3.2xlarge, d3.4xlarge, d3.8xlarge, d3en.xlarge, d3en.2xlarge, d3en.4xlarge, d3en.6xlarge, d3en.8xlarge, d3en.12xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, m5zn.large, m5zn.xlarge, m5zn.2xlarge, m5zn.3xlarge, m5zn.6xlarge, m5zn.12xlarge, m5zn.metal, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, u-18tb1.metal, u-24tb1.metal, a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge, a1.metal, m5dn.large, m5dn.xlarge, m5dn.2xlarge, m5dn.4xlarge, m5dn.8xlarge, m5dn.12xlarge, m5dn.16xlarge, m5dn.24xlarge, m5n.large, m5n.xlarge, m5n.2xlarge, m5n.4xlarge, m5n.8xlarge, m5n.12xlarge, m5n.16xlarge, m5n.24xlarge, r5dn.large, r5dn.xlarge, r5dn.2xlarge, r5dn.4xlarge, r5dn.8xlarge, r5dn.12xlarge, r5dn.16xlarge, r5dn.24xlarge, r5n.large, r5n.xlarge, r5n.2xlarge, r5n.4xlarge, r5n.8xlarge, r5n.12xlarge, r5n.16xlarge, r5n.24xlarge, inf1.xlarge, inf1.2xlarge, inf1.6xlarge, inf1.24xlarge, m6g.metal, m6g.medium, m6g.large, m6g.xlarge, m6g.2xlarge, m6g.4xlarge, m6g.8xlarge, m6g.12xlarge, m6g.16xlarge, m6gd.metal, m6gd.medium, m6gd.large, m6gd.xlarge, m6gd.2xlarge, m6gd.4xlarge, m6gd.8xlarge, m6gd.12xlarge, m6gd.16xlarge, mac1.metal
    #           key_name: "KeyPairName",
    #           monitoring: {
    #             enabled: false,
    #           },
    #           placement: {
    #             availability_zone: "String",
    #             affinity: "String",
    #             group_name: "PlacementGroupName",
    #             host_id: "DedicatedHostId",
    #             tenancy: "default", # accepts default, dedicated, host
    #             spread_domain: "String",
    #             host_resource_group_arn: "String",
    #             partition_number: 1,
    #           },
    #           ram_disk_id: "RamdiskId",
    #           disable_api_termination: false,
    #           instance_initiated_shutdown_behavior: "stop", # accepts stop, terminate
    #           user_data: "String",
    #           tag_specifications: [
    #             {
    #               resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #               tags: [
    #                 {
    #                   key: "String",
    #                   value: "String",
    #                 },
    #               ],
    #             },
    #           ],
    #           elastic_gpu_specifications: [
    #             {
    #               type: "String", # required
    #             },
    #           ],
    #           elastic_inference_accelerators: [
    #             {
    #               type: "String", # required
    #               count: 1,
    #             },
    #           ],
    #           security_group_ids: ["SecurityGroupId"],
    #           security_groups: ["SecurityGroupName"],
    #           instance_market_options: {
    #             market_type: "spot", # accepts spot
    #             spot_options: {
    #               max_price: "String",
    #               spot_instance_type: "one-time", # accepts one-time, persistent
    #               block_duration_minutes: 1,
    #               valid_until: Time.now,
    #               instance_interruption_behavior: "hibernate", # accepts hibernate, stop, terminate
    #             },
    #           },
    #           credit_specification: {
    #             cpu_credits: "String", # required
    #           },
    #           cpu_options: {
    #             core_count: 1,
    #             threads_per_core: 1,
    #           },
    #           capacity_reservation_specification: {
    #             capacity_reservation_preference: "open", # accepts open, none
    #             capacity_reservation_target: {
    #               capacity_reservation_id: "CapacityReservationId",
    #               capacity_reservation_resource_group_arn: "String",
    #             },
    #           },
    #           license_specifications: [
    #             {
    #               license_configuration_arn: "String",
    #             },
    #           ],
    #           hibernation_options: {
    #             configured: false,
    #           },
    #           metadata_options: {
    #             http_tokens: "optional", # accepts optional, required
    #             http_put_response_hop_limit: 1,
    #             http_endpoint: "disabled", # accepts disabled, enabled
    #           },
    #           enclave_options: {
    #             enabled: false,
    #           },
    #         },
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #   Constraint: Maximum 128 ASCII characters.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] launch_template_name
    #   A name for the launch template.
    #   @return [String]
    #
    # @!attribute [rw] version_description
    #   A description for the first version of the launch template.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_data
    #   The information for the launch template.
    #   @return [Types::RequestLaunchTemplateData]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the launch template during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateRequest AWS API Documentation
    #
    class CreateLaunchTemplateRequest < Struct.new(
      :dry_run,
      :client_token,
      :launch_template_name,
      :version_description,
      :launch_template_data,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] launch_template
    #   Information about the launch template.
    #   @return [Types::LaunchTemplate]
    #
    # @!attribute [rw] warning
    #   If the launch template contains parameters or parameter combinations
    #   that are not valid, an error code and an error message are returned
    #   for each issue that's found.
    #   @return [Types::ValidationWarning]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateResult AWS API Documentation
    #
    class CreateLaunchTemplateResult < Struct.new(
      :launch_template,
      :warning)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateLaunchTemplateVersionRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         client_token: "String",
    #         launch_template_id: "LaunchTemplateId",
    #         launch_template_name: "LaunchTemplateName",
    #         source_version: "String",
    #         version_description: "VersionDescription",
    #         launch_template_data: { # required
    #           kernel_id: "KernelId",
    #           ebs_optimized: false,
    #           iam_instance_profile: {
    #             arn: "String",
    #             name: "String",
    #           },
    #           block_device_mappings: [
    #             {
    #               device_name: "String",
    #               virtual_name: "String",
    #               ebs: {
    #                 encrypted: false,
    #                 delete_on_termination: false,
    #                 iops: 1,
    #                 kms_key_id: "KmsKeyId",
    #                 snapshot_id: "SnapshotId",
    #                 volume_size: 1,
    #                 volume_type: "standard", # accepts standard, io1, io2, gp2, sc1, st1, gp3
    #                 throughput: 1,
    #               },
    #               no_device: "String",
    #             },
    #           ],
    #           network_interfaces: [
    #             {
    #               associate_carrier_ip_address: false,
    #               associate_public_ip_address: false,
    #               delete_on_termination: false,
    #               description: "String",
    #               device_index: 1,
    #               groups: ["SecurityGroupId"],
    #               interface_type: "String",
    #               ipv_6_address_count: 1,
    #               ipv_6_addresses: [
    #                 {
    #                   ipv_6_address: "String",
    #                 },
    #               ],
    #               network_interface_id: "NetworkInterfaceId",
    #               private_ip_address: "String",
    #               private_ip_addresses: [
    #                 {
    #                   primary: false,
    #                   private_ip_address: "String",
    #                 },
    #               ],
    #               secondary_private_ip_address_count: 1,
    #               subnet_id: "SubnetId",
    #               network_card_index: 1,
    #             },
    #           ],
    #           image_id: "ImageId",
    #           instance_type: "t1.micro", # accepts t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, t4g.nano, t4g.micro, t4g.small, t4g.medium, t4g.large, t4g.xlarge, t4g.2xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, cr1.8xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5b.large, r5b.xlarge, r5b.2xlarge, r5b.4xlarge, r5b.8xlarge, r5b.12xlarge, r5b.16xlarge, r5b.24xlarge, r5b.metal, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, r6g.metal, r6g.medium, r6g.large, r6g.xlarge, r6g.2xlarge, r6g.4xlarge, r6g.8xlarge, r6g.12xlarge, r6g.16xlarge, r6gd.metal, r6gd.medium, r6gd.large, r6gd.xlarge, r6gd.2xlarge, r6gd.4xlarge, r6gd.8xlarge, r6gd.12xlarge, r6gd.16xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, hi1.4xlarge, hs1.8xlarge, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5a.large, c5a.xlarge, c5a.2xlarge, c5a.4xlarge, c5a.8xlarge, c5a.12xlarge, c5a.16xlarge, c5a.24xlarge, c5ad.large, c5ad.xlarge, c5ad.2xlarge, c5ad.4xlarge, c5ad.8xlarge, c5ad.12xlarge, c5ad.16xlarge, c5ad.24xlarge, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.12xlarge, c5d.18xlarge, c5d.24xlarge, c5d.metal, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, c5n.metal, c6g.metal, c6g.medium, c6g.large, c6g.xlarge, c6g.2xlarge, c6g.4xlarge, c6g.8xlarge, c6g.12xlarge, c6g.16xlarge, c6gd.metal, c6gd.medium, c6gd.large, c6gd.xlarge, c6gd.2xlarge, c6gd.4xlarge, c6gd.8xlarge, c6gd.12xlarge, c6gd.16xlarge, c6gn.medium, c6gn.large, c6gn.xlarge, c6gn.2xlarge, c6gn.4xlarge, c6gn.8xlarge, c6gn.12xlarge, c6gn.16xlarge, cc1.4xlarge, cc2.8xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, g4ad.4xlarge, g4ad.8xlarge, g4ad.16xlarge, g4dn.xlarge, g4dn.2xlarge, g4dn.4xlarge, g4dn.8xlarge, g4dn.12xlarge, g4dn.16xlarge, g4dn.metal, cg1.4xlarge, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, p4d.24xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, d3.xlarge, d3.2xlarge, d3.4xlarge, d3.8xlarge, d3en.xlarge, d3en.2xlarge, d3en.4xlarge, d3en.6xlarge, d3en.8xlarge, d3en.12xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, m5zn.large, m5zn.xlarge, m5zn.2xlarge, m5zn.3xlarge, m5zn.6xlarge, m5zn.12xlarge, m5zn.metal, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, u-18tb1.metal, u-24tb1.metal, a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge, a1.metal, m5dn.large, m5dn.xlarge, m5dn.2xlarge, m5dn.4xlarge, m5dn.8xlarge, m5dn.12xlarge, m5dn.16xlarge, m5dn.24xlarge, m5n.large, m5n.xlarge, m5n.2xlarge, m5n.4xlarge, m5n.8xlarge, m5n.12xlarge, m5n.16xlarge, m5n.24xlarge, r5dn.large, r5dn.xlarge, r5dn.2xlarge, r5dn.4xlarge, r5dn.8xlarge, r5dn.12xlarge, r5dn.16xlarge, r5dn.24xlarge, r5n.large, r5n.xlarge, r5n.2xlarge, r5n.4xlarge, r5n.8xlarge, r5n.12xlarge, r5n.16xlarge, r5n.24xlarge, inf1.xlarge, inf1.2xlarge, inf1.6xlarge, inf1.24xlarge, m6g.metal, m6g.medium, m6g.large, m6g.xlarge, m6g.2xlarge, m6g.4xlarge, m6g.8xlarge, m6g.12xlarge, m6g.16xlarge, m6gd.metal, m6gd.medium, m6gd.large, m6gd.xlarge, m6gd.2xlarge, m6gd.4xlarge, m6gd.8xlarge, m6gd.12xlarge, m6gd.16xlarge, mac1.metal
    #           key_name: "KeyPairName",
    #           monitoring: {
    #             enabled: false,
    #           },
    #           placement: {
    #             availability_zone: "String",
    #             affinity: "String",
    #             group_name: "PlacementGroupName",
    #             host_id: "DedicatedHostId",
    #             tenancy: "default", # accepts default, dedicated, host
    #             spread_domain: "String",
    #             host_resource_group_arn: "String",
    #             partition_number: 1,
    #           },
    #           ram_disk_id: "RamdiskId",
    #           disable_api_termination: false,
    #           instance_initiated_shutdown_behavior: "stop", # accepts stop, terminate
    #           user_data: "String",
    #           tag_specifications: [
    #             {
    #               resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #               tags: [
    #                 {
    #                   key: "String",
    #                   value: "String",
    #                 },
    #               ],
    #             },
    #           ],
    #           elastic_gpu_specifications: [
    #             {
    #               type: "String", # required
    #             },
    #           ],
    #           elastic_inference_accelerators: [
    #             {
    #               type: "String", # required
    #               count: 1,
    #             },
    #           ],
    #           security_group_ids: ["SecurityGroupId"],
    #           security_groups: ["SecurityGroupName"],
    #           instance_market_options: {
    #             market_type: "spot", # accepts spot
    #             spot_options: {
    #               max_price: "String",
    #               spot_instance_type: "one-time", # accepts one-time, persistent
    #               block_duration_minutes: 1,
    #               valid_until: Time.now,
    #               instance_interruption_behavior: "hibernate", # accepts hibernate, stop, terminate
    #             },
    #           },
    #           credit_specification: {
    #             cpu_credits: "String", # required
    #           },
    #           cpu_options: {
    #             core_count: 1,
    #             threads_per_core: 1,
    #           },
    #           capacity_reservation_specification: {
    #             capacity_reservation_preference: "open", # accepts open, none
    #             capacity_reservation_target: {
    #               capacity_reservation_id: "CapacityReservationId",
    #               capacity_reservation_resource_group_arn: "String",
    #             },
    #           },
    #           license_specifications: [
    #             {
    #               license_configuration_arn: "String",
    #             },
    #           ],
    #           hibernation_options: {
    #             configured: false,
    #           },
    #           metadata_options: {
    #             http_tokens: "optional", # accepts optional, required
    #             http_put_response_hop_limit: 1,
    #             http_endpoint: "disabled", # accepts disabled, enabled
    #           },
    #           enclave_options: {
    #             enabled: false,
    #           },
    #         },
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #   Constraint: Maximum 128 ASCII characters.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] launch_template_id
    #   The ID of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_name
    #   The name of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #   @return [String]
    #
    # @!attribute [rw] source_version
    #   The version number of the launch template version on which to base
    #   the new version. The new version inherits the same launch parameters
    #   as the source version, except for parameters that you specify in
    #   `LaunchTemplateData`. Snapshots applied to the block device mapping
    #   are ignored when creating a new version unless they are explicitly
    #   included.
    #   @return [String]
    #
    # @!attribute [rw] version_description
    #   A description for the version of the launch template.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_data
    #   The information for the launch template.
    #   @return [Types::RequestLaunchTemplateData]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersionRequest AWS API Documentation
    #
    class CreateLaunchTemplateVersionRequest < Struct.new(
      :dry_run,
      :client_token,
      :launch_template_id,
      :launch_template_name,
      :source_version,
      :version_description,
      :launch_template_data)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] launch_template_version
    #   Information about the launch template version.
    #   @return [Types::LaunchTemplateVersion]
    #
    # @!attribute [rw] warning
    #   If the new version of the launch template contains parameters or
    #   parameter combinations that are not valid, an error code and an
    #   error message are returned for each issue that's found.
    #   @return [Types::ValidationWarning]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLaunchTemplateVersionResult AWS API Documentation
    #
    class CreateLaunchTemplateVersionResult < Struct.new(
      :launch_template_version,
      :warning)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateLocalGatewayRouteRequest
    #   data as a hash:
    #
    #       {
    #         destination_cidr_block: "String", # required
    #         local_gateway_route_table_id: "LocalGatewayRoutetableId", # required
    #         local_gateway_virtual_interface_group_id: "LocalGatewayVirtualInterfaceGroupId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] destination_cidr_block
    #   The CIDR range used for destination matches. Routing decisions are
    #   based on the most specific match.
    #   @return [String]
    #
    # @!attribute [rw] local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] local_gateway_virtual_interface_group_id
    #   The ID of the virtual interface group.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteRequest AWS API Documentation
    #
    class CreateLocalGatewayRouteRequest < Struct.new(
      :destination_cidr_block,
      :local_gateway_route_table_id,
      :local_gateway_virtual_interface_group_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route
    #   Information about the route.
    #   @return [Types::LocalGatewayRoute]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteResult AWS API Documentation
    #
    class CreateLocalGatewayRouteResult < Struct.new(
      :route)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateLocalGatewayRouteTableVpcAssociationRequest
    #   data as a hash:
    #
    #       {
    #         local_gateway_route_table_id: "LocalGatewayRoutetableId", # required
    #         vpc_id: "VpcId", # required
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the local gateway route table VPC association.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociationRequest AWS API Documentation
    #
    class CreateLocalGatewayRouteTableVpcAssociationRequest < Struct.new(
      :local_gateway_route_table_id,
      :vpc_id,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_table_vpc_association
    #   Information about the association.
    #   @return [Types::LocalGatewayRouteTableVpcAssociation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateLocalGatewayRouteTableVpcAssociationResult AWS API Documentation
    #
    class CreateLocalGatewayRouteTableVpcAssociationResult < Struct.new(
      :local_gateway_route_table_vpc_association)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateManagedPrefixListRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         prefix_list_name: "String", # required
    #         entries: [
    #           {
    #             cidr: "String", # required
    #             description: "String",
    #           },
    #         ],
    #         max_entries: 1, # required
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         address_family: "String", # required
    #         client_token: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] prefix_list_name
    #   A name for the prefix list.
    #
    #   Constraints: Up to 255 characters in length. The name cannot start
    #   with `com.amazonaws`.
    #   @return [String]
    #
    # @!attribute [rw] entries
    #   One or more entries for the prefix list.
    #   @return [Array<Types::AddPrefixListEntry>]
    #
    # @!attribute [rw] max_entries
    #   The maximum number of entries for the prefix list.
    #   @return [Integer]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the prefix list during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] address_family
    #   The IP address type.
    #
    #   Valid Values: `IPv4` \| `IPv6`
    #   @return [String]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier you provide to ensure the
    #   idempotency of the request. For more information, see [Ensuring
    #   Idempotency][1].
    #
    #   Constraints: Up to 255 UTF-8 characters in length.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixListRequest AWS API Documentation
    #
    class CreateManagedPrefixListRequest < Struct.new(
      :dry_run,
      :prefix_list_name,
      :entries,
      :max_entries,
      :tag_specifications,
      :address_family,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] prefix_list
    #   Information about the prefix list.
    #   @return [Types::ManagedPrefixList]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateManagedPrefixListResult AWS API Documentation
    #
    class CreateManagedPrefixListResult < Struct.new(
      :prefix_list)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateNatGatewayRequest
    #   data as a hash:
    #
    #       {
    #         client_token: "String",
    #         dry_run: false,
    #         subnet_id: "SubnetId", # required
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         allocation_id: "AllocationId", # required
    #       }
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   Constraint: Maximum 64 ASCII characters.
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] subnet_id
    #   The subnet in which to create the NAT gateway.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the NAT gateway.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] allocation_id
    #   The allocation ID of an Elastic IP address to associate with the NAT
    #   gateway. If the Elastic IP address is associated with another
    #   resource, you must first disassociate it.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGatewayRequest AWS API Documentation
    #
    class CreateNatGatewayRequest < Struct.new(
      :client_token,
      :dry_run,
      :subnet_id,
      :tag_specifications,
      :allocation_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier to ensure the idempotency of the
    #   request. Only returned if a client token was provided in the
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] nat_gateway
    #   Information about the NAT gateway.
    #   @return [Types::NatGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNatGatewayResult AWS API Documentation
    #
    class CreateNatGatewayResult < Struct.new(
      :client_token,
      :nat_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateNetworkAclEntryRequest
    #   data as a hash:
    #
    #       {
    #         cidr_block: "String",
    #         dry_run: false,
    #         egress: false, # required
    #         icmp_type_code: {
    #           code: 1,
    #           type: 1,
    #         },
    #         ipv_6_cidr_block: "String",
    #         network_acl_id: "NetworkAclId", # required
    #         port_range: {
    #           from: 1,
    #           to: 1,
    #         },
    #         protocol: "String", # required
    #         rule_action: "allow", # required, accepts allow, deny
    #         rule_number: 1, # required
    #       }
    #
    # @!attribute [rw] cidr_block
    #   The IPv4 network range to allow or deny, in CIDR notation (for
    #   example `172.16.0.0/24`). We modify the specified CIDR block to its
    #   canonical form; for example, if you specify `100.68.0.18/18`, we
    #   modify it to `100.68.0.0/18`.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] egress
    #   Indicates whether this is an egress rule (rule is applied to traffic
    #   leaving the subnet).
    #   @return [Boolean]
    #
    # @!attribute [rw] icmp_type_code
    #   ICMP protocol: The ICMP or ICMPv6 type and code. Required if
    #   specifying protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6
    #   CIDR block.
    #   @return [Types::IcmpTypeCode]
    #
    # @!attribute [rw] ipv_6_cidr_block
    #   The IPv6 network range to allow or deny, in CIDR notation (for
    #   example `2001:db8:1234:1a00::/64`).
    #   @return [String]
    #
    # @!attribute [rw] network_acl_id
    #   The ID of the network ACL.
    #   @return [String]
    #
    # @!attribute [rw] port_range
    #   TCP or UDP protocols: The range of ports the rule applies to.
    #   Required if specifying protocol 6 (TCP) or 17 (UDP).
    #   @return [Types::PortRange]
    #
    # @!attribute [rw] protocol
    #   The protocol number. A value of "-1" means all protocols. If you
    #   specify "-1" or a protocol number other than "6" (TCP), "17"
    #   (UDP), or "1" (ICMP), traffic on all ports is allowed, regardless
    #   of any ports or ICMP types or codes that you specify. If you specify
    #   protocol "58" (ICMPv6) and specify an IPv4 CIDR block, traffic for
    #   all ICMP types and codes allowed, regardless of any that you
    #   specify. If you specify protocol "58" (ICMPv6) and specify an IPv6
    #   CIDR block, you must specify an ICMP type and code.
    #   @return [String]
    #
    # @!attribute [rw] rule_action
    #   Indicates whether to allow or deny the traffic that matches the
    #   rule.
    #   @return [String]
    #
    # @!attribute [rw] rule_number
    #   The rule number for the entry (for example, 100). ACL entries are
    #   processed in ascending order by rule number.
    #
    #   Constraints: Positive integer from 1 to 32766. The range 32767 to
    #   65535 is reserved for internal use.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclEntryRequest AWS API Documentation
    #
    class CreateNetworkAclEntryRequest < Struct.new(
      :cidr_block,
      :dry_run,
      :egress,
      :icmp_type_code,
      :ipv_6_cidr_block,
      :network_acl_id,
      :port_range,
      :protocol,
      :rule_action,
      :rule_number)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateNetworkAclRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         vpc_id: "VpcId", # required
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the network ACL.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclRequest AWS API Documentation
    #
    class CreateNetworkAclRequest < Struct.new(
      :dry_run,
      :vpc_id,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_acl
    #   Information about the network ACL.
    #   @return [Types::NetworkAcl]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkAclResult AWS API Documentation
    #
    class CreateNetworkAclResult < Struct.new(
      :network_acl)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateNetworkInsightsPathRequest
    #   data as a hash:
    #
    #       {
    #         source_ip: "IpAddress",
    #         destination_ip: "IpAddress",
    #         source: "String", # required
    #         destination: "String", # required
    #         protocol: "tcp", # required, accepts tcp, udp
    #         destination_port: 1,
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #         client_token: "String", # required
    #       }
    #
    # @!attribute [rw] source_ip
    #   The IP address of the AWS resource that is the source of the path.
    #   @return [String]
    #
    # @!attribute [rw] destination_ip
    #   The IP address of the AWS resource that is the destination of the
    #   path.
    #   @return [String]
    #
    # @!attribute [rw] source
    #   The AWS resource that is the source of the path.
    #   @return [String]
    #
    # @!attribute [rw] destination
    #   The AWS resource that is the destination of the path.
    #   @return [String]
    #
    # @!attribute [rw] protocol
    #   The protocol.
    #   @return [String]
    #
    # @!attribute [rw] destination_port
    #   The destination port.
    #   @return [Integer]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to add to the path.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPathRequest AWS API Documentation
    #
    class CreateNetworkInsightsPathRequest < Struct.new(
      :source_ip,
      :destination_ip,
      :source,
      :destination,
      :protocol,
      :destination_port,
      :tag_specifications,
      :dry_run,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_insights_path
    #   Information about the path.
    #   @return [Types::NetworkInsightsPath]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInsightsPathResult AWS API Documentation
    #
    class CreateNetworkInsightsPathResult < Struct.new(
      :network_insights_path)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateNetworkInterfacePermission.
    #
    # @note When making an API call, you may pass CreateNetworkInterfacePermissionRequest
    #   data as a hash:
    #
    #       {
    #         network_interface_id: "NetworkInterfaceId", # required
    #         aws_account_id: "String",
    #         aws_service: "String",
    #         permission: "INSTANCE-ATTACH", # required, accepts INSTANCE-ATTACH, EIP-ASSOCIATE
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @!attribute [rw] aws_account_id
    #   The AWS account ID.
    #   @return [String]
    #
    # @!attribute [rw] aws_service
    #   The AWS service. Currently not supported.
    #   @return [String]
    #
    # @!attribute [rw] permission
    #   The type of permission to grant.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermissionRequest AWS API Documentation
    #
    class CreateNetworkInterfacePermissionRequest < Struct.new(
      :network_interface_id,
      :aws_account_id,
      :aws_service,
      :permission,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CreateNetworkInterfacePermission.
    #
    # @!attribute [rw] interface_permission
    #   Information about the permission for the network interface.
    #   @return [Types::NetworkInterfacePermission]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfacePermissionResult AWS API Documentation
    #
    class CreateNetworkInterfacePermissionResult < Struct.new(
      :interface_permission)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateNetworkInterface.
    #
    # @note When making an API call, you may pass CreateNetworkInterfaceRequest
    #   data as a hash:
    #
    #       {
    #         description: "String",
    #         dry_run: false,
    #         groups: ["SecurityGroupId"],
    #         ipv_6_address_count: 1,
    #         ipv_6_addresses: [
    #           {
    #             ipv_6_address: "String",
    #           },
    #         ],
    #         private_ip_address: "String",
    #         private_ip_addresses: [
    #           {
    #             primary: false,
    #             private_ip_address: "String",
    #           },
    #         ],
    #         secondary_private_ip_address_count: 1,
    #         interface_type: "efa", # accepts efa
    #         subnet_id: "SubnetId", # required
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] description
    #   A description for the network interface.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] groups
    #   The IDs of one or more security groups.
    #   @return [Array<String>]
    #
    # @!attribute [rw] ipv_6_address_count
    #   The number of IPv6 addresses to assign to a network interface.
    #   Amazon EC2 automatically selects the IPv6 addresses from the subnet
    #   range. You can't use this option if specifying specific IPv6
    #   addresses. If your subnet has the `AssignIpv6AddressOnCreation`
    #   attribute set to `true`, you can specify `0` to override this
    #   setting.
    #   @return [Integer]
    #
    # @!attribute [rw] ipv_6_addresses
    #   One or more specific IPv6 addresses from the IPv6 CIDR block range
    #   of your subnet. You can't use this option if you're specifying a
    #   number of IPv6 addresses.
    #   @return [Array<Types::InstanceIpv6Address>]
    #
    # @!attribute [rw] private_ip_address
    #   The primary private IPv4 address of the network interface. If you
    #   don't specify an IPv4 address, Amazon EC2 selects one for you from
    #   the subnet's IPv4 CIDR range. If you specify an IP address, you
    #   cannot indicate any IP addresses specified in `privateIpAddresses`
    #   as primary (only one IP address can be designated as primary).
    #   @return [String]
    #
    # @!attribute [rw] private_ip_addresses
    #   One or more private IPv4 addresses.
    #   @return [Array<Types::PrivateIpAddressSpecification>]
    #
    # @!attribute [rw] secondary_private_ip_address_count
    #   The number of secondary private IPv4 addresses to assign to a
    #   network interface. When you specify a number of secondary IPv4
    #   addresses, Amazon EC2 selects these IP addresses within the
    #   subnet's IPv4 CIDR range. You can't specify this option and
    #   specify more than one private IP address using `privateIpAddresses`.
    #
    #   The number of IP addresses you can assign to a network interface
    #   varies by instance type. For more information, see [IP Addresses Per
    #   ENI Per Instance Type][1] in the *Amazon Virtual Private Cloud User
    #   Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI
    #   @return [Integer]
    #
    # @!attribute [rw] interface_type
    #   Indicates the type of network interface. To create an Elastic Fabric
    #   Adapter (EFA), specify `efa`. For more information, see [ Elastic
    #   Fabric Adapter][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html
    #   @return [String]
    #
    # @!attribute [rw] subnet_id
    #   The ID of the subnet to associate with the network interface.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the new network interface.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfaceRequest AWS API Documentation
    #
    class CreateNetworkInterfaceRequest < Struct.new(
      :description,
      :dry_run,
      :groups,
      :ipv_6_address_count,
      :ipv_6_addresses,
      :private_ip_address,
      :private_ip_addresses,
      :secondary_private_ip_address_count,
      :interface_type,
      :subnet_id,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CreateNetworkInterface.
    #
    # @!attribute [rw] network_interface
    #   Information about the network interface.
    #   @return [Types::NetworkInterface]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateNetworkInterfaceResult AWS API Documentation
    #
    class CreateNetworkInterfaceResult < Struct.new(
      :network_interface)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreatePlacementGroupRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         group_name: "String",
    #         strategy: "cluster", # accepts cluster, spread, partition
    #         partition_count: 1,
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] group_name
    #   A name for the placement group. Must be unique within the scope of
    #   your account for the Region.
    #
    #   Constraints: Up to 255 ASCII characters
    #   @return [String]
    #
    # @!attribute [rw] strategy
    #   The placement strategy.
    #   @return [String]
    #
    # @!attribute [rw] partition_count
    #   The number of partitions. Valid only when **Strategy** is set to
    #   `partition`.
    #   @return [Integer]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the new placement group.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroupRequest AWS API Documentation
    #
    class CreatePlacementGroupRequest < Struct.new(
      :dry_run,
      :group_name,
      :strategy,
      :partition_count,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] placement_group
    #   Describes a placement group.
    #   @return [Types::PlacementGroup]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreatePlacementGroupResult AWS API Documentation
    #
    class CreatePlacementGroupResult < Struct.new(
      :placement_group)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateReservedInstancesListing.
    #
    # @note When making an API call, you may pass CreateReservedInstancesListingRequest
    #   data as a hash:
    #
    #       {
    #         client_token: "String", # required
    #         instance_count: 1, # required
    #         price_schedules: [ # required
    #           {
    #             currency_code: "USD", # accepts USD
    #             price: 1.0,
    #             term: 1,
    #           },
    #         ],
    #         reserved_instances_id: "ReservationId", # required
    #       }
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier you provide to ensure idempotency
    #   of your listings. This helps avoid duplicate listings. For more
    #   information, see [Ensuring Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] instance_count
    #   The number of instances that are a part of a Reserved Instance
    #   account to be listed in the Reserved Instance Marketplace. This
    #   number should be less than or equal to the instance count associated
    #   with the Reserved Instance ID specified in this call.
    #   @return [Integer]
    #
    # @!attribute [rw] price_schedules
    #   A list specifying the price of the Standard Reserved Instance for
    #   each month remaining in the Reserved Instance term.
    #   @return [Array<Types::PriceScheduleSpecification>]
    #
    # @!attribute [rw] reserved_instances_id
    #   The ID of the active Standard Reserved Instance.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListingRequest AWS API Documentation
    #
    class CreateReservedInstancesListingRequest < Struct.new(
      :client_token,
      :instance_count,
      :price_schedules,
      :reserved_instances_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CreateReservedInstancesListing.
    #
    # @!attribute [rw] reserved_instances_listings
    #   Information about the Standard Reserved Instance listing.
    #   @return [Array<Types::ReservedInstancesListing>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateReservedInstancesListingResult AWS API Documentation
    #
    class CreateReservedInstancesListingResult < Struct.new(
      :reserved_instances_listings)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateRouteRequest
    #   data as a hash:
    #
    #       {
    #         destination_cidr_block: "String",
    #         destination_ipv_6_cidr_block: "String",
    #         destination_prefix_list_id: "PrefixListResourceId",
    #         dry_run: false,
    #         vpc_endpoint_id: "VpcEndpointId",
    #         egress_only_internet_gateway_id: "EgressOnlyInternetGatewayId",
    #         gateway_id: "RouteGatewayId",
    #         instance_id: "InstanceId",
    #         nat_gateway_id: "NatGatewayId",
    #         transit_gateway_id: "TransitGatewayId",
    #         local_gateway_id: "LocalGatewayId",
    #         carrier_gateway_id: "CarrierGatewayId",
    #         network_interface_id: "NetworkInterfaceId",
    #         route_table_id: "RouteTableId", # required
    #         vpc_peering_connection_id: "VpcPeeringConnectionId",
    #       }
    #
    # @!attribute [rw] destination_cidr_block
    #   The IPv4 CIDR address block used for the destination match. Routing
    #   decisions are based on the most specific match. We modify the
    #   specified CIDR block to its canonical form; for example, if you
    #   specify `100.68.0.18/18`, we modify it to `100.68.0.0/18`.
    #   @return [String]
    #
    # @!attribute [rw] destination_ipv_6_cidr_block
    #   The IPv6 CIDR block used for the destination match. Routing
    #   decisions are based on the most specific match.
    #   @return [String]
    #
    # @!attribute [rw] destination_prefix_list_id
    #   The ID of a prefix list used for the destination match.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_endpoint_id
    #   The ID of a VPC endpoint. Supported for Gateway Load Balancer
    #   endpoints only.
    #   @return [String]
    #
    # @!attribute [rw] egress_only_internet_gateway_id
    #   \[IPv6 traffic only\] The ID of an egress-only internet gateway.
    #   @return [String]
    #
    # @!attribute [rw] gateway_id
    #   The ID of an internet gateway or virtual private gateway attached to
    #   your VPC.
    #   @return [String]
    #
    # @!attribute [rw] instance_id
    #   The ID of a NAT instance in your VPC. The operation fails if you
    #   specify an instance ID unless exactly one network interface is
    #   attached.
    #   @return [String]
    #
    # @!attribute [rw] nat_gateway_id
    #   \[IPv4 traffic only\] The ID of a NAT gateway.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_id
    #   The ID of a transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] local_gateway_id
    #   The ID of the local gateway.
    #   @return [String]
    #
    # @!attribute [rw] carrier_gateway_id
    #   The ID of the carrier gateway.
    #
    #   You can only use this option when the VPC contains a subnet which is
    #   associated with a Wavelength Zone.
    #   @return [String]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of a network interface.
    #   @return [String]
    #
    # @!attribute [rw] route_table_id
    #   The ID of the route table for the route.
    #   @return [String]
    #
    # @!attribute [rw] vpc_peering_connection_id
    #   The ID of a VPC peering connection.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteRequest AWS API Documentation
    #
    class CreateRouteRequest < Struct.new(
      :destination_cidr_block,
      :destination_ipv_6_cidr_block,
      :destination_prefix_list_id,
      :dry_run,
      :vpc_endpoint_id,
      :egress_only_internet_gateway_id,
      :gateway_id,
      :instance_id,
      :nat_gateway_id,
      :transit_gateway_id,
      :local_gateway_id,
      :carrier_gateway_id,
      :network_interface_id,
      :route_table_id,
      :vpc_peering_connection_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteResult AWS API Documentation
    #
    class CreateRouteResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateRouteTableRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         vpc_id: "VpcId", # required
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the route table.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTableRequest AWS API Documentation
    #
    class CreateRouteTableRequest < Struct.new(
      :dry_run,
      :vpc_id,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route_table
    #   Information about the route table.
    #   @return [Types::RouteTable]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRouteTableResult AWS API Documentation
    #
    class CreateRouteTableResult < Struct.new(
      :route_table)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateSecurityGroupRequest
    #   data as a hash:
    #
    #       {
    #         description: "String", # required
    #         group_name: "String", # required
    #         vpc_id: "VpcId",
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] description
    #   A description for the security group. This is informational only.
    #
    #   Constraints: Up to 255 characters in length
    #
    #   Constraints for EC2-Classic: ASCII characters
    #
    #   Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
    #   .\_-:/()#,@\[\]+=&amp;;\\\{\\}!$*
    #   @return [String]
    #
    # @!attribute [rw] group_name
    #   The name of the security group.
    #
    #   Constraints: Up to 255 characters in length. Cannot start with
    #   `sg-`.
    #
    #   Constraints for EC2-Classic: ASCII characters
    #
    #   Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
    #   .\_-:/()#,@\[\]+=&amp;;\\\{\\}!$*
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   \[EC2-VPC\] The ID of the VPC. Required for EC2-VPC.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the security group.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroupRequest AWS API Documentation
    #
    class CreateSecurityGroupRequest < Struct.new(
      :description,
      :group_name,
      :vpc_id,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] group_id
    #   The ID of the security group.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   The tags assigned to the security group.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSecurityGroupResult AWS API Documentation
    #
    class CreateSecurityGroupResult < Struct.new(
      :group_id,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateSnapshotRequest
    #   data as a hash:
    #
    #       {
    #         description: "String",
    #         outpost_arn: "String",
    #         volume_id: "VolumeId", # required
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] description
    #   A description for the snapshot.
    #   @return [String]
    #
    # @!attribute [rw] outpost_arn
    #   The Amazon Resource Name (ARN) of the AWS Outpost on which to create
    #   a local snapshot.
    #
    #   * To create a snapshot of a volume in a Region, omit this parameter.
    #     The snapshot is created in the same Region as the volume.
    #
    #   * To create a snapshot of a volume on an Outpost and store the
    #     snapshot in the Region, omit this parameter. The snapshot is
    #     created in the Region for the Outpost.
    #
    #   * To create a snapshot of a volume on an Outpost and store the
    #     snapshot on an Outpost, specify the ARN of the destination
    #     Outpost. The snapshot must be created on the same Outpost as the
    #     volume.
    #
    #   For more information, see [ Creating local snapshots from volumes on
    #   an Outpost][1] in the *Amazon Elastic Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-snapshot
    #   @return [String]
    #
    # @!attribute [rw] volume_id
    #   The ID of the EBS volume.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the snapshot during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshotRequest AWS API Documentation
    #
    class CreateSnapshotRequest < Struct.new(
      :description,
      :outpost_arn,
      :volume_id,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateSnapshotsRequest
    #   data as a hash:
    #
    #       {
    #         description: "String",
    #         instance_specification: { # required
    #           instance_id: "InstanceId",
    #           exclude_boot_volume: false,
    #         },
    #         outpost_arn: "String",
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #         copy_tags_from_source: "volume", # accepts volume
    #       }
    #
    # @!attribute [rw] description
    #   A description propagated to every snapshot specified by the
    #   instance.
    #   @return [String]
    #
    # @!attribute [rw] instance_specification
    #   The instance to specify which volumes should be included in the
    #   snapshots.
    #   @return [Types::InstanceSpecification]
    #
    # @!attribute [rw] outpost_arn
    #   The Amazon Resource Name (ARN) of the AWS Outpost on which to create
    #   the local snapshots.
    #
    #   * To create snapshots from an instance in a Region, omit this
    #     parameter. The snapshots are created in the same Region as the
    #     instance.
    #
    #   * To create snapshots from an instance on an Outpost and store the
    #     snapshots in the Region, omit this parameter. The snapshots are
    #     created in the Region for the Outpost.
    #
    #   * To create snapshots from an instance on an Outpost and store the
    #     snapshots on an Outpost, specify the ARN of the destination
    #     Outpost. The snapshots must be created on the same Outpost as the
    #     instance.
    #
    #   For more information, see [ Creating multi-volume local snapshots
    #   from instances on an Outpost][1] in the *Amazon Elastic Compute
    #   Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html#create-multivol-snapshot
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   Tags to apply to every snapshot specified by the instance.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] copy_tags_from_source
    #   Copies the tags from the specified volume to corresponding snapshot.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshotsRequest AWS API Documentation
    #
    class CreateSnapshotsRequest < Struct.new(
      :description,
      :instance_specification,
      :outpost_arn,
      :tag_specifications,
      :dry_run,
      :copy_tags_from_source)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] snapshots
    #   List of snapshots.
    #   @return [Array<Types::SnapshotInfo>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSnapshotsResult AWS API Documentation
    #
    class CreateSnapshotsResult < Struct.new(
      :snapshots)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateSpotDatafeedSubscription.
    #
    # @note When making an API call, you may pass CreateSpotDatafeedSubscriptionRequest
    #   data as a hash:
    #
    #       {
    #         bucket: "String", # required
    #         dry_run: false,
    #         prefix: "String",
    #       }
    #
    # @!attribute [rw] bucket
    #   The name of the Amazon S3 bucket in which to store the Spot Instance
    #   data feed. For more information about bucket names, see [Rules for
    #   bucket naming][1] in the *Amazon S3 Developer Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] prefix
    #   The prefix for the data feed file names.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscriptionRequest AWS API Documentation
    #
    class CreateSpotDatafeedSubscriptionRequest < Struct.new(
      :bucket,
      :dry_run,
      :prefix)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CreateSpotDatafeedSubscription.
    #
    # @!attribute [rw] spot_datafeed_subscription
    #   The Spot Instance data feed subscription.
    #   @return [Types::SpotDatafeedSubscription]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSpotDatafeedSubscriptionResult AWS API Documentation
    #
    class CreateSpotDatafeedSubscriptionResult < Struct.new(
      :spot_datafeed_subscription)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateSubnetRequest
    #   data as a hash:
    #
    #       {
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         availability_zone: "String",
    #         availability_zone_id: "String",
    #         ipv_6_cidr_block: "String",
    #         outpost_arn: "String",
    #         vpc_id: "VpcId", # required
    #         dry_run: false,
    #         cidr_block: "String", # required
    #       }
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the subnet.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone or Local Zone for the subnet.
    #
    #   Default: AWS selects one for you. If you create more than one subnet
    #   in your VPC, we do not necessarily select a different zone for each
    #   subnet.
    #
    #   To create a subnet in a Local Zone, set this value to the Local Zone
    #   ID, for example `us-west-2-lax-1a`. For information about the
    #   Regions that support Local Zones, see [Available Regions][1] in the
    #   *Amazon Elastic Compute Cloud User Guide*.
    #
    #   To create a subnet in an Outpost, set this value to the Availability
    #   Zone for the Outpost and specify the Outpost ARN.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions
    #   @return [String]
    #
    # @!attribute [rw] availability_zone_id
    #   The AZ ID or the Local Zone ID of the subnet.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_cidr_block
    #   The IPv6 network range for the subnet, in CIDR notation. The subnet
    #   size must use a /64 prefix length.
    #   @return [String]
    #
    # @!attribute [rw] outpost_arn
    #   The Amazon Resource Name (ARN) of the Outpost. If you specify an
    #   Outpost ARN, you must also specify the Availability Zone of the
    #   Outpost subnet.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] cidr_block
    #   The IPv4 network range for the subnet, in CIDR notation. For
    #   example, `10.0.0.0/24`. We modify the specified CIDR block to its
    #   canonical form; for example, if you specify `100.68.0.18/18`, we
    #   modify it to `100.68.0.0/18`.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetRequest AWS API Documentation
    #
    class CreateSubnetRequest < Struct.new(
      :tag_specifications,
      :availability_zone,
      :availability_zone_id,
      :ipv_6_cidr_block,
      :outpost_arn,
      :vpc_id,
      :dry_run,
      :cidr_block)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] subnet
    #   Information about the subnet.
    #   @return [Types::Subnet]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateSubnetResult AWS API Documentation
    #
    class CreateSubnetResult < Struct.new(
      :subnet)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateTagsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         resources: ["TaggableResourceId"], # required
    #         tags: [ # required
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] resources
    #   The IDs of the resources, separated by spaces.
    #
    #   Constraints: Up to 1000 resource IDs. We recommend breaking up this
    #   request into smaller batches.
    #   @return [Array<String>]
    #
    # @!attribute [rw] tags
    #   The tags. The `value` parameter is required, but if you don't want
    #   the tag to have a value, specify the parameter with no value, and we
    #   set the value to an empty string.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTagsRequest AWS API Documentation
    #
    class CreateTagsRequest < Struct.new(
      :dry_run,
      :resources,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateTrafficMirrorFilterRequest
    #   data as a hash:
    #
    #       {
    #         description: "String",
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #         client_token: "String",
    #       }
    #
    # @!attribute [rw] description
    #   The description of the Traffic Mirror filter.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to a Traffic Mirror filter.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRequest AWS API Documentation
    #
    class CreateTrafficMirrorFilterRequest < Struct.new(
      :description,
      :tag_specifications,
      :dry_run,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_filter
    #   Information about the Traffic Mirror filter.
    #   @return [Types::TrafficMirrorFilter]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterResult AWS API Documentation
    #
    class CreateTrafficMirrorFilterResult < Struct.new(
      :traffic_mirror_filter,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateTrafficMirrorFilterRuleRequest
    #   data as a hash:
    #
    #       {
    #         traffic_mirror_filter_id: "TrafficMirrorFilterId", # required
    #         traffic_direction: "ingress", # required, accepts ingress, egress
    #         rule_number: 1, # required
    #         rule_action: "accept", # required, accepts accept, reject
    #         destination_port_range: {
    #           from_port: 1,
    #           to_port: 1,
    #         },
    #         source_port_range: {
    #           from_port: 1,
    #           to_port: 1,
    #         },
    #         protocol: 1,
    #         destination_cidr_block: "String", # required
    #         source_cidr_block: "String", # required
    #         description: "String",
    #         dry_run: false,
    #         client_token: "String",
    #       }
    #
    # @!attribute [rw] traffic_mirror_filter_id
    #   The ID of the filter that this rule is associated with.
    #   @return [String]
    #
    # @!attribute [rw] traffic_direction
    #   The type of traffic (`ingress` \| `egress`).
    #   @return [String]
    #
    # @!attribute [rw] rule_number
    #   The number of the Traffic Mirror rule. This number must be unique
    #   for each Traffic Mirror rule in a given direction. The rules are
    #   processed in ascending order by rule number.
    #   @return [Integer]
    #
    # @!attribute [rw] rule_action
    #   The action to take (`accept` \| `reject`) on the filtered traffic.
    #   @return [String]
    #
    # @!attribute [rw] destination_port_range
    #   The destination port range.
    #   @return [Types::TrafficMirrorPortRangeRequest]
    #
    # @!attribute [rw] source_port_range
    #   The source port range.
    #   @return [Types::TrafficMirrorPortRangeRequest]
    #
    # @!attribute [rw] protocol
    #   The protocol, for example UDP, to assign to the Traffic Mirror rule.
    #
    #   For information about the protocol value, see [Protocol Numbers][1]
    #   on the Internet Assigned Numbers Authority (IANA) website.
    #
    #
    #
    #   [1]: https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml
    #   @return [Integer]
    #
    # @!attribute [rw] destination_cidr_block
    #   The destination CIDR block to assign to the Traffic Mirror rule.
    #   @return [String]
    #
    # @!attribute [rw] source_cidr_block
    #   The source CIDR block to assign to the Traffic Mirror rule.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   The description of the Traffic Mirror rule.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRuleRequest AWS API Documentation
    #
    class CreateTrafficMirrorFilterRuleRequest < Struct.new(
      :traffic_mirror_filter_id,
      :traffic_direction,
      :rule_number,
      :rule_action,
      :destination_port_range,
      :source_port_range,
      :protocol,
      :destination_cidr_block,
      :source_cidr_block,
      :description,
      :dry_run,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_filter_rule
    #   The Traffic Mirror rule.
    #   @return [Types::TrafficMirrorFilterRule]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorFilterRuleResult AWS API Documentation
    #
    class CreateTrafficMirrorFilterRuleResult < Struct.new(
      :traffic_mirror_filter_rule,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateTrafficMirrorSessionRequest
    #   data as a hash:
    #
    #       {
    #         network_interface_id: "NetworkInterfaceId", # required
    #         traffic_mirror_target_id: "TrafficMirrorTargetId", # required
    #         traffic_mirror_filter_id: "TrafficMirrorFilterId", # required
    #         packet_length: 1,
    #         session_number: 1, # required
    #         virtual_network_id: 1,
    #         description: "String",
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #         client_token: "String",
    #       }
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the source network interface.
    #   @return [String]
    #
    # @!attribute [rw] traffic_mirror_target_id
    #   The ID of the Traffic Mirror target.
    #   @return [String]
    #
    # @!attribute [rw] traffic_mirror_filter_id
    #   The ID of the Traffic Mirror filter.
    #   @return [String]
    #
    # @!attribute [rw] packet_length
    #   The number of bytes in each packet to mirror. These are bytes after
    #   the VXLAN header. Do not specify this parameter when you want to
    #   mirror the entire packet. To mirror a subset of the packet, set this
    #   to the length (in bytes) that you want to mirror. For example, if
    #   you set this value to 100, then the first 100 bytes that meet the
    #   filter criteria are copied to the target.
    #
    #   If you do not want to mirror the entire packet, use the
    #   `PacketLength` parameter to specify the number of bytes in each
    #   packet to mirror.
    #   @return [Integer]
    #
    # @!attribute [rw] session_number
    #   The session number determines the order in which sessions are
    #   evaluated when an interface is used by multiple sessions. The first
    #   session with a matching filter is the one that mirrors the packets.
    #
    #   Valid values are 1-32766.
    #   @return [Integer]
    #
    # @!attribute [rw] virtual_network_id
    #   The VXLAN ID for the Traffic Mirror session. For more information
    #   about the VXLAN protocol, see [RFC 7348][1]. If you do not specify a
    #   `VirtualNetworkId`, an account-wide unique id is chosen at random.
    #
    #
    #
    #   [1]: https://tools.ietf.org/html/rfc7348
    #   @return [Integer]
    #
    # @!attribute [rw] description
    #   The description of the Traffic Mirror session.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to a Traffic Mirror session.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSessionRequest AWS API Documentation
    #
    class CreateTrafficMirrorSessionRequest < Struct.new(
      :network_interface_id,
      :traffic_mirror_target_id,
      :traffic_mirror_filter_id,
      :packet_length,
      :session_number,
      :virtual_network_id,
      :description,
      :tag_specifications,
      :dry_run,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_session
    #   Information about the Traffic Mirror session.
    #   @return [Types::TrafficMirrorSession]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorSessionResult AWS API Documentation
    #
    class CreateTrafficMirrorSessionResult < Struct.new(
      :traffic_mirror_session,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateTrafficMirrorTargetRequest
    #   data as a hash:
    #
    #       {
    #         network_interface_id: "NetworkInterfaceId",
    #         network_load_balancer_arn: "String",
    #         description: "String",
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #         client_token: "String",
    #       }
    #
    # @!attribute [rw] network_interface_id
    #   The network interface ID that is associated with the target.
    #   @return [String]
    #
    # @!attribute [rw] network_load_balancer_arn
    #   The Amazon Resource Name (ARN) of the Network Load Balancer that is
    #   associated with the target.
    #   @return [String]
    #
    # @!attribute [rw] description
    #   The description of the Traffic Mirror target.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the Traffic Mirror target.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #   **A suitable default value is auto-generated.** You should normally
    #   not need to pass this option.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTargetRequest AWS API Documentation
    #
    class CreateTrafficMirrorTargetRequest < Struct.new(
      :network_interface_id,
      :network_load_balancer_arn,
      :description,
      :tag_specifications,
      :dry_run,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_target
    #   Information about the Traffic Mirror target.
    #   @return [Types::TrafficMirrorTarget]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTrafficMirrorTargetResult AWS API Documentation
    #
    class CreateTrafficMirrorTargetResult < Struct.new(
      :traffic_mirror_target,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateTransitGatewayConnectPeerRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #         transit_gateway_address: "String",
    #         peer_address: "String", # required
    #         bgp_options: {
    #           peer_asn: 1,
    #         },
    #         inside_cidr_blocks: ["String"], # required
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the Connect attachment.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_address
    #   The peer IP address (GRE outer IP address) on the transit gateway
    #   side of the Connect peer, which must be specified from a transit
    #   gateway CIDR block. If not specified, Amazon automatically assigns
    #   the first available IP address from the transit gateway CIDR block.
    #   @return [String]
    #
    # @!attribute [rw] peer_address
    #   The peer IP address (GRE outer IP address) on the appliance side of
    #   the Connect peer.
    #   @return [String]
    #
    # @!attribute [rw] bgp_options
    #   The BGP options for the Connect peer.
    #   @return [Types::TransitGatewayConnectRequestBgpOptions]
    #
    # @!attribute [rw] inside_cidr_blocks
    #   The range of inside IP addresses that are used for BGP peering. You
    #   must specify a size /29 IPv4 CIDR block from the `169.254.0.0/16`
    #   range. The first address from the range must be configured on the
    #   appliance as the BGP IP address. You can also optionally specify a
    #   size /125 IPv6 CIDR block from the `fd00::/8` range.
    #   @return [Array<String>]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the Connect peer.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeerRequest AWS API Documentation
    #
    class CreateTransitGatewayConnectPeerRequest < Struct.new(
      :transit_gateway_attachment_id,
      :transit_gateway_address,
      :peer_address,
      :bgp_options,
      :inside_cidr_blocks,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_connect_peer
    #   Information about the Connect peer.
    #   @return [Types::TransitGatewayConnectPeer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectPeerResult AWS API Documentation
    #
    class CreateTransitGatewayConnectPeerResult < Struct.new(
      :transit_gateway_connect_peer)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateTransitGatewayConnectRequest
    #   data as a hash:
    #
    #       {
    #         transport_transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #         options: { # required
    #           protocol: "gre", # required, accepts gre
    #         },
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transport_transit_gateway_attachment_id
    #   The ID of the transit gateway attachment. You can specify a VPC
    #   attachment or a AWS Direct Connect attachment.
    #   @return [String]
    #
    # @!attribute [rw] options
    #   The Connect attachment options.
    #   @return [Types::CreateTransitGatewayConnectRequestOptions]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the Connect attachment.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectRequest AWS API Documentation
    #
    class CreateTransitGatewayConnectRequest < Struct.new(
      :transport_transit_gateway_attachment_id,
      :options,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # The options for a Connect attachment.
    #
    # @note When making an API call, you may pass CreateTransitGatewayConnectRequestOptions
    #   data as a hash:
    #
    #       {
    #         protocol: "gre", # required, accepts gre
    #       }
    #
    # @!attribute [rw] protocol
    #   The tunnel protocol.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectRequestOptions AWS API Documentation
    #
    class CreateTransitGatewayConnectRequestOptions < Struct.new(
      :protocol)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_connect
    #   Information about the Connect attachment.
    #   @return [Types::TransitGatewayConnect]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayConnectResult AWS API Documentation
    #
    class CreateTransitGatewayConnectResult < Struct.new(
      :transit_gateway_connect)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateTransitGatewayMulticastDomainRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_id: "TransitGatewayId", # required
    #         options: {
    #           igmpv_2_support: "enable", # accepts enable, disable
    #           static_sources_support: "enable", # accepts enable, disable
    #           auto_accept_shared_associations: "enable", # accepts enable, disable
    #         },
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_id
    #   The ID of the transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] options
    #   The options for the transit gateway multicast domain.
    #   @return [Types::CreateTransitGatewayMulticastDomainRequestOptions]
    #
    # @!attribute [rw] tag_specifications
    #   The tags for the transit gateway multicast domain.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomainRequest AWS API Documentation
    #
    class CreateTransitGatewayMulticastDomainRequest < Struct.new(
      :transit_gateway_id,
      :options,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # The options for the transit gateway multicast domain.
    #
    # @note When making an API call, you may pass CreateTransitGatewayMulticastDomainRequestOptions
    #   data as a hash:
    #
    #       {
    #         igmpv_2_support: "enable", # accepts enable, disable
    #         static_sources_support: "enable", # accepts enable, disable
    #         auto_accept_shared_associations: "enable", # accepts enable, disable
    #       }
    #
    # @!attribute [rw] igmpv_2_support
    #   Specify whether to enable Internet Group Management Protocol (IGMP)
    #   version 2 for the transit gateway multicast domain.
    #   @return [String]
    #
    # @!attribute [rw] static_sources_support
    #   Specify whether to enable support for statically configuring
    #   multicast group sources for a domain.
    #   @return [String]
    #
    # @!attribute [rw] auto_accept_shared_associations
    #   Indicates whether to automatically accept cross-account subnet
    #   associations that are associated with the transit gateway multicast
    #   domain.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomainRequestOptions AWS API Documentation
    #
    class CreateTransitGatewayMulticastDomainRequestOptions < Struct.new(
      :igmpv_2_support,
      :static_sources_support,
      :auto_accept_shared_associations)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_multicast_domain
    #   Information about the transit gateway multicast domain.
    #   @return [Types::TransitGatewayMulticastDomain]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayMulticastDomainResult AWS API Documentation
    #
    class CreateTransitGatewayMulticastDomainResult < Struct.new(
      :transit_gateway_multicast_domain)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateTransitGatewayPeeringAttachmentRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_id: "TransitGatewayId", # required
    #         peer_transit_gateway_id: "TransitAssociationGatewayId", # required
    #         peer_account_id: "String", # required
    #         peer_region: "String", # required
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_id
    #   The ID of the transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] peer_transit_gateway_id
    #   The ID of the peer transit gateway with which to create the peering
    #   attachment.
    #   @return [String]
    #
    # @!attribute [rw] peer_account_id
    #   The AWS account ID of the owner of the peer transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] peer_region
    #   The Region where the peer transit gateway is located.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the transit gateway peering attachment.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachmentRequest AWS API Documentation
    #
    class CreateTransitGatewayPeeringAttachmentRequest < Struct.new(
      :transit_gateway_id,
      :peer_transit_gateway_id,
      :peer_account_id,
      :peer_region,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_peering_attachment
    #   The transit gateway peering attachment.
    #   @return [Types::TransitGatewayPeeringAttachment]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPeeringAttachmentResult AWS API Documentation
    #
    class CreateTransitGatewayPeeringAttachmentResult < Struct.new(
      :transit_gateway_peering_attachment)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateTransitGatewayPrefixListReferenceRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_route_table_id: "TransitGatewayRouteTableId", # required
    #         prefix_list_id: "PrefixListResourceId", # required
    #         transit_gateway_attachment_id: "TransitGatewayAttachmentId",
    #         blackhole: false,
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] prefix_list_id
    #   The ID of the prefix list that is used for destination matches.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the attachment to which traffic is routed.
    #   @return [String]
    #
    # @!attribute [rw] blackhole
    #   Indicates whether to drop traffic that matches this route.
    #   @return [Boolean]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReferenceRequest AWS API Documentation
    #
    class CreateTransitGatewayPrefixListReferenceRequest < Struct.new(
      :transit_gateway_route_table_id,
      :prefix_list_id,
      :transit_gateway_attachment_id,
      :blackhole,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_prefix_list_reference
    #   Information about the prefix list reference.
    #   @return [Types::TransitGatewayPrefixListReference]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayPrefixListReferenceResult AWS API Documentation
    #
    class CreateTransitGatewayPrefixListReferenceResult < Struct.new(
      :transit_gateway_prefix_list_reference)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateTransitGatewayRequest
    #   data as a hash:
    #
    #       {
    #         description: "String",
    #         options: {
    #           amazon_side_asn: 1,
    #           auto_accept_shared_attachments: "enable", # accepts enable, disable
    #           default_route_table_association: "enable", # accepts enable, disable
    #           default_route_table_propagation: "enable", # accepts enable, disable
    #           vpn_ecmp_support: "enable", # accepts enable, disable
    #           dns_support: "enable", # accepts enable, disable
    #           multicast_support: "enable", # accepts enable, disable
    #           transit_gateway_cidr_blocks: ["String"],
    #         },
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] description
    #   A description of the transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] options
    #   The transit gateway options.
    #   @return [Types::TransitGatewayRequestOptions]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the transit gateway.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRequest AWS API Documentation
    #
    class CreateTransitGatewayRequest < Struct.new(
      :description,
      :options,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway
    #   Information about the transit gateway.
    #   @return [Types::TransitGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayResult AWS API Documentation
    #
    class CreateTransitGatewayResult < Struct.new(
      :transit_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateTransitGatewayRouteRequest
    #   data as a hash:
    #
    #       {
    #         destination_cidr_block: "String", # required
    #         transit_gateway_route_table_id: "TransitGatewayRouteTableId", # required
    #         transit_gateway_attachment_id: "TransitGatewayAttachmentId",
    #         blackhole: false,
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] destination_cidr_block
    #   The CIDR range used for destination matches. Routing decisions are
    #   based on the most specific match.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the attachment.
    #   @return [String]
    #
    # @!attribute [rw] blackhole
    #   Indicates whether to drop traffic that matches this route.
    #   @return [Boolean]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteRequest AWS API Documentation
    #
    class CreateTransitGatewayRouteRequest < Struct.new(
      :destination_cidr_block,
      :transit_gateway_route_table_id,
      :transit_gateway_attachment_id,
      :blackhole,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route
    #   Information about the route.
    #   @return [Types::TransitGatewayRoute]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteResult AWS API Documentation
    #
    class CreateTransitGatewayRouteResult < Struct.new(
      :route)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateTransitGatewayRouteTableRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_id: "TransitGatewayId", # required
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_id
    #   The ID of the transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the transit gateway route table.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTableRequest AWS API Documentation
    #
    class CreateTransitGatewayRouteTableRequest < Struct.new(
      :transit_gateway_id,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_route_table
    #   Information about the transit gateway route table.
    #   @return [Types::TransitGatewayRouteTable]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayRouteTableResult AWS API Documentation
    #
    class CreateTransitGatewayRouteTableResult < Struct.new(
      :transit_gateway_route_table)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateTransitGatewayVpcAttachmentRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_id: "TransitGatewayId", # required
    #         vpc_id: "VpcId", # required
    #         subnet_ids: ["SubnetId"], # required
    #         options: {
    #           dns_support: "enable", # accepts enable, disable
    #           ipv_6_support: "enable", # accepts enable, disable
    #           appliance_mode_support: "enable", # accepts enable, disable
    #         },
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_id
    #   The ID of the transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] subnet_ids
    #   The IDs of one or more subnets. You can specify only one subnet per
    #   Availability Zone. You must specify at least one subnet, but we
    #   recommend that you specify two subnets for better availability. The
    #   transit gateway uses one IP address from each specified subnet.
    #   @return [Array<String>]
    #
    # @!attribute [rw] options
    #   The VPC attachment options.
    #   @return [Types::CreateTransitGatewayVpcAttachmentRequestOptions]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the VPC attachment.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachmentRequest AWS API Documentation
    #
    class CreateTransitGatewayVpcAttachmentRequest < Struct.new(
      :transit_gateway_id,
      :vpc_id,
      :subnet_ids,
      :options,
      :tag_specifications,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the options for a VPC attachment.
    #
    # @note When making an API call, you may pass CreateTransitGatewayVpcAttachmentRequestOptions
    #   data as a hash:
    #
    #       {
    #         dns_support: "enable", # accepts enable, disable
    #         ipv_6_support: "enable", # accepts enable, disable
    #         appliance_mode_support: "enable", # accepts enable, disable
    #       }
    #
    # @!attribute [rw] dns_support
    #   Enable or disable DNS support. The default is `enable`.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_support
    #   Enable or disable IPv6 support. The default is `disable`.
    #   @return [String]
    #
    # @!attribute [rw] appliance_mode_support
    #   Enable or disable support for appliance mode. If enabled, a traffic
    #   flow between a source and destination uses the same Availability
    #   Zone for the VPC attachment for the lifetime of that flow. The
    #   default is `disable`.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachmentRequestOptions AWS API Documentation
    #
    class CreateTransitGatewayVpcAttachmentRequestOptions < Struct.new(
      :dns_support,
      :ipv_6_support,
      :appliance_mode_support)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_vpc_attachment
    #   Information about the VPC attachment.
    #   @return [Types::TransitGatewayVpcAttachment]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateTransitGatewayVpcAttachmentResult AWS API Documentation
    #
    class CreateTransitGatewayVpcAttachmentResult < Struct.new(
      :transit_gateway_vpc_attachment)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the user or group to be added or removed from the list of
    # create volume permissions for a volume.
    #
    # @note When making an API call, you may pass CreateVolumePermission
    #   data as a hash:
    #
    #       {
    #         group: "all", # accepts all
    #         user_id: "String",
    #       }
    #
    # @!attribute [rw] group
    #   The group to be added or removed. The possible value is `all`.
    #   @return [String]
    #
    # @!attribute [rw] user_id
    #   The AWS account ID to be added or removed.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolumePermission AWS API Documentation
    #
    class CreateVolumePermission < Struct.new(
      :group,
      :user_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes modifications to the list of create volume permissions for a
    # volume.
    #
    # @note When making an API call, you may pass CreateVolumePermissionModifications
    #   data as a hash:
    #
    #       {
    #         add: [
    #           {
    #             group: "all", # accepts all
    #             user_id: "String",
    #           },
    #         ],
    #         remove: [
    #           {
    #             group: "all", # accepts all
    #             user_id: "String",
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] add
    #   Adds the specified AWS account ID or group to the list.
    #   @return [Array<Types::CreateVolumePermission>]
    #
    # @!attribute [rw] remove
    #   Removes the specified AWS account ID or group from the list.
    #   @return [Array<Types::CreateVolumePermission>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolumePermissionModifications AWS API Documentation
    #
    class CreateVolumePermissionModifications < Struct.new(
      :add,
      :remove)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateVolumeRequest
    #   data as a hash:
    #
    #       {
    #         availability_zone: "String", # required
    #         encrypted: false,
    #         iops: 1,
    #         kms_key_id: "KmsKeyId",
    #         outpost_arn: "String",
    #         size: 1,
    #         snapshot_id: "SnapshotId",
    #         volume_type: "standard", # accepts standard, io1, io2, gp2, sc1, st1, gp3
    #         dry_run: false,
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         multi_attach_enabled: false,
    #         throughput: 1,
    #       }
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone in which to create the volume.
    #   @return [String]
    #
    # @!attribute [rw] encrypted
    #   Indicates whether the volume should be encrypted. The effect of
    #   setting the encryption state to `true` depends on the volume origin
    #   (new or from a snapshot), starting encryption state, ownership, and
    #   whether encryption by default is enabled. For more information, see
    #   [Encryption by default][1] in the *Amazon Elastic Compute Cloud User
    #   Guide*.
    #
    #   Encrypted Amazon EBS volumes must be attached to instances that
    #   support Amazon EBS encryption. For more information, see [Supported
    #   instance types][2].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default
    #   [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances
    #   @return [Boolean]
    #
    # @!attribute [rw] iops
    #   The number of I/O operations per second (IOPS). For `gp3`, `io1`,
    #   and `io2` volumes, this represents the number of IOPS that are
    #   provisioned for the volume. For `gp2` volumes, this represents the
    #   baseline performance of the volume and the rate at which the volume
    #   accumulates I/O credits for bursting.
    #
    #   The following are the supported values for each volume type:
    #
    #   * `gp3`\: 3,000-16,000 IOPS
    #
    #   * `io1`\: 100-64,000 IOPS
    #
    #   * `io2`\: 100-64,000 IOPS
    #
    #   For `io1` and `io2` volumes, we guarantee 64,000 IOPS only for
    #   [Instances built on the Nitro System][1]. Other instance families
    #   guarantee performance up to 32,000 IOPS.
    #
    #   This parameter is required for `io1` and `io2` volumes. The default
    #   for `gp3` volumes is 3,000 IOPS. This parameter is not supported for
    #   `gp2`, `st1`, `sc1`, or `standard` volumes.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances
    #   @return [Integer]
    #
    # @!attribute [rw] kms_key_id
    #   The identifier of the AWS Key Management Service (AWS KMS) customer
    #   master key (CMK) to use for Amazon EBS encryption. If this parameter
    #   is not specified, your AWS managed CMK for EBS is used. If
    #   `KmsKeyId` is specified, the encrypted state must be `true`.
    #
    #   You can specify the CMK using any of the following:
    #
    #   * Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Key alias. For example, alias/ExampleAlias.
    #
    #   * Key ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
    #
    #   * Alias ARN. For example,
    #     arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
    #
    #   AWS authenticates the CMK asynchronously. Therefore, if you specify
    #   an ID, alias, or ARN that is not valid, the action can appear to
    #   complete, but eventually fails.
    #   @return [String]
    #
    # @!attribute [rw] outpost_arn
    #   The Amazon Resource Name (ARN) of the Outpost.
    #   @return [String]
    #
    # @!attribute [rw] size
    #   The size of the volume, in GiBs. You must specify either a snapshot
    #   ID or a volume size. If you specify a snapshot, the default is the
    #   snapshot size. You can specify a volume size that is equal to or
    #   larger than the snapshot size.
    #
    #   The following are the supported volumes sizes for each volume type:
    #
    #   * `gp2` and `gp3`\: 1-16,384
    #
    #   * `io1` and `io2`\: 4-16,384
    #
    #   * `st1` and `sc1`\: 125-16,384
    #
    #   * `standard`\: 1-1,024
    #   @return [Integer]
    #
    # @!attribute [rw] snapshot_id
    #   The snapshot from which to create the volume. You must specify
    #   either a snapshot ID or a volume size.
    #   @return [String]
    #
    # @!attribute [rw] volume_type
    #   The volume type. This parameter can be one of the following values:
    #
    #   * General Purpose SSD: `gp2` \| `gp3`
    #
    #   * Provisioned IOPS SSD: `io1` \| `io2`
    #
    #   * Throughput Optimized HDD: `st1`
    #
    #   * Cold HDD: `sc1`
    #
    #   * Magnetic: `standard`
    #
    #   For more information, see [Amazon EBS volume types][1] in the
    #   *Amazon Elastic Compute Cloud User Guide*.
    #
    #   Default: `gp2`
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the volume during creation.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] multi_attach_enabled
    #   Indicates whether to enable Amazon EBS Multi-Attach. If you enable
    #   Multi-Attach, you can attach the volume to up to 16 [Instances built
    #   on the Nitro System][1] in the same Availability Zone. This
    #   parameter is supported with `io1` and `io2` volumes only. For more
    #   information, see [ Amazon EBS Multi-Attach][2] in the *Amazon
    #   Elastic Compute Cloud User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances
    #   [2]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes-multi.html
    #   @return [Boolean]
    #
    # @!attribute [rw] throughput
    #   The throughput to provision for a volume, with a maximum of 1,000
    #   MiB/s.
    #
    #   This parameter is valid only for `gp3` volumes.
    #
    #   Valid Range: Minimum value of 125. Maximum value of 1000.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVolumeRequest AWS API Documentation
    #
    class CreateVolumeRequest < Struct.new(
      :availability_zone,
      :encrypted,
      :iops,
      :kms_key_id,
      :outpost_arn,
      :size,
      :snapshot_id,
      :volume_type,
      :dry_run,
      :tag_specifications,
      :multi_attach_enabled,
      :throughput)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateVpcEndpointConnectionNotificationRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         service_id: "VpcEndpointServiceId",
    #         vpc_endpoint_id: "VpcEndpointId",
    #         connection_notification_arn: "String", # required
    #         connection_events: ["String"], # required
    #         client_token: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] service_id
    #   The ID of the endpoint service.
    #   @return [String]
    #
    # @!attribute [rw] vpc_endpoint_id
    #   The ID of the endpoint.
    #   @return [String]
    #
    # @!attribute [rw] connection_notification_arn
    #   The ARN of the SNS topic for the notifications.
    #   @return [String]
    #
    # @!attribute [rw] connection_events
    #   One or more endpoint events for which to receive notifications.
    #   Valid values are `Accept`, `Connect`, `Delete`, and `Reject`.
    #   @return [Array<String>]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotificationRequest AWS API Documentation
    #
    class CreateVpcEndpointConnectionNotificationRequest < Struct.new(
      :dry_run,
      :service_id,
      :vpc_endpoint_id,
      :connection_notification_arn,
      :connection_events,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] connection_notification
    #   Information about the notification.
    #   @return [Types::ConnectionNotification]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointConnectionNotificationResult AWS API Documentation
    #
    class CreateVpcEndpointConnectionNotificationResult < Struct.new(
      :connection_notification,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateVpcEndpoint.
    #
    # @note When making an API call, you may pass CreateVpcEndpointRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         vpc_endpoint_type: "Interface", # accepts Interface, Gateway, GatewayLoadBalancer
    #         vpc_id: "VpcId", # required
    #         service_name: "String", # required
    #         policy_document: "String",
    #         route_table_ids: ["RouteTableId"],
    #         subnet_ids: ["SubnetId"],
    #         security_group_ids: ["SecurityGroupId"],
    #         client_token: "String",
    #         private_dns_enabled: false,
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_endpoint_type
    #   The type of endpoint.
    #
    #   Default: Gateway
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC in which the endpoint will be used.
    #   @return [String]
    #
    # @!attribute [rw] service_name
    #   The service name. To get a list of available services, use the
    #   DescribeVpcEndpointServices request, or get the name from the
    #   service provider.
    #   @return [String]
    #
    # @!attribute [rw] policy_document
    #   (Interface and gateway endpoints) A policy to attach to the endpoint
    #   that controls access to the service. The policy must be in valid
    #   JSON format. If this parameter is not specified, we attach a default
    #   policy that allows full access to the service.
    #   @return [String]
    #
    # @!attribute [rw] route_table_ids
    #   (Gateway endpoint) One or more route table IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] subnet_ids
    #   (Interface and Gateway Load Balancer endpoints) The ID of one or
    #   more subnets in which to create an endpoint network interface. For a
    #   Gateway Load Balancer endpoint, you can specify one subnet only.
    #   @return [Array<String>]
    #
    # @!attribute [rw] security_group_ids
    #   (Interface endpoint) The ID of one or more security groups to
    #   associate with the endpoint network interface.
    #   @return [Array<String>]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] private_dns_enabled
    #   (Interface endpoint) Indicates whether to associate a private hosted
    #   zone with the specified VPC. The private hosted zone contains a
    #   record set for the default public DNS name for the service for the
    #   Region (for example, `kinesis.us-east-1.amazonaws.com`), which
    #   resolves to the private IP addresses of the endpoint network
    #   interfaces in the VPC. This enables you to make requests to the
    #   default public DNS name for the service instead of the public DNS
    #   names that are automatically generated by the VPC endpoint service.
    #
    #   To use a private hosted zone, you must set the following VPC
    #   attributes to `true`\: `enableDnsHostnames` and `enableDnsSupport`.
    #   Use ModifyVpcAttribute to set the VPC attributes.
    #
    #   Default: `true`
    #   @return [Boolean]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to associate with the endpoint.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointRequest AWS API Documentation
    #
    class CreateVpcEndpointRequest < Struct.new(
      :dry_run,
      :vpc_endpoint_type,
      :vpc_id,
      :service_name,
      :policy_document,
      :route_table_ids,
      :subnet_ids,
      :security_group_ids,
      :client_token,
      :private_dns_enabled,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CreateVpcEndpoint.
    #
    # @!attribute [rw] vpc_endpoint
    #   Information about the endpoint.
    #   @return [Types::VpcEndpoint]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointResult AWS API Documentation
    #
    class CreateVpcEndpointResult < Struct.new(
      :vpc_endpoint,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateVpcEndpointServiceConfigurationRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         acceptance_required: false,
    #         private_dns_name: "String",
    #         network_load_balancer_arns: ["String"],
    #         gateway_load_balancer_arns: ["String"],
    #         client_token: "String",
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] acceptance_required
    #   Indicates whether requests from service consumers to create an
    #   endpoint to your service must be accepted. To accept a request, use
    #   AcceptVpcEndpointConnections.
    #   @return [Boolean]
    #
    # @!attribute [rw] private_dns_name
    #   (Interface endpoint configuration) The private DNS name to assign to
    #   the VPC endpoint service.
    #   @return [String]
    #
    # @!attribute [rw] network_load_balancer_arns
    #   The Amazon Resource Names (ARNs) of one or more Network Load
    #   Balancers for your service.
    #   @return [Array<String>]
    #
    # @!attribute [rw] gateway_load_balancer_arns
    #   The Amazon Resource Names (ARNs) of one or more Gateway Load
    #   Balancers.
    #   @return [Array<String>]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request. For more information, see [How to Ensure
    #   Idempotency][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to associate with the service.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfigurationRequest AWS API Documentation
    #
    class CreateVpcEndpointServiceConfigurationRequest < Struct.new(
      :dry_run,
      :acceptance_required,
      :private_dns_name,
      :network_load_balancer_arns,
      :gateway_load_balancer_arns,
      :client_token,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] service_configuration
    #   Information about the service configuration.
    #   @return [Types::ServiceConfiguration]
    #
    # @!attribute [rw] client_token
    #   Unique, case-sensitive identifier that you provide to ensure the
    #   idempotency of the request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcEndpointServiceConfigurationResult AWS API Documentation
    #
    class CreateVpcEndpointServiceConfigurationResult < Struct.new(
      :service_configuration,
      :client_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateVpcPeeringConnectionRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         peer_owner_id: "String",
    #         peer_vpc_id: "String",
    #         vpc_id: "VpcId",
    #         peer_region: "String",
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] peer_owner_id
    #   The AWS account ID of the owner of the accepter VPC.
    #
    #   Default: Your AWS account ID
    #   @return [String]
    #
    # @!attribute [rw] peer_vpc_id
    #   The ID of the VPC with which you are creating the VPC peering
    #   connection. You must specify this parameter in the request.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the requester VPC. You must specify this parameter in the
    #   request.
    #   @return [String]
    #
    # @!attribute [rw] peer_region
    #   The Region code for the accepter VPC, if the accepter VPC is located
    #   in a Region other than the Region in which you make the request.
    #
    #   Default: The Region in which you make the request.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the peering connection.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnectionRequest AWS API Documentation
    #
    class CreateVpcPeeringConnectionRequest < Struct.new(
      :dry_run,
      :peer_owner_id,
      :peer_vpc_id,
      :vpc_id,
      :peer_region,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc_peering_connection
    #   Information about the VPC peering connection.
    #   @return [Types::VpcPeeringConnection]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcPeeringConnectionResult AWS API Documentation
    #
    class CreateVpcPeeringConnectionResult < Struct.new(
      :vpc_peering_connection)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass CreateVpcRequest
    #   data as a hash:
    #
    #       {
    #         cidr_block: "String", # required
    #         amazon_provided_ipv_6_cidr_block: false,
    #         ipv_6_pool: "Ipv6PoolEc2Id",
    #         ipv_6_cidr_block: "String",
    #         dry_run: false,
    #         instance_tenancy: "default", # accepts default, dedicated, host
    #         ipv_6_cidr_block_network_border_group: "String",
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] cidr_block
    #   The IPv4 network range for the VPC, in CIDR notation. For example,
    #   `10.0.0.0/16`. We modify the specified CIDR block to its canonical
    #   form; for example, if you specify `100.68.0.18/18`, we modify it to
    #   `100.68.0.0/18`.
    #   @return [String]
    #
    # @!attribute [rw] amazon_provided_ipv_6_cidr_block
    #   Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length
    #   for the VPC. You cannot specify the range of IP addresses, or the
    #   size of the CIDR block.
    #   @return [Boolean]
    #
    # @!attribute [rw] ipv_6_pool
    #   The ID of an IPv6 address pool from which to allocate the IPv6 CIDR
    #   block.
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_cidr_block
    #   The IPv6 CIDR block from the IPv6 address pool. You must also
    #   specify `Ipv6Pool` in the request.
    #
    #   To let Amazon choose the IPv6 CIDR block for you, omit this
    #   parameter.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_tenancy
    #   The tenancy options for instances launched into the VPC. For
    #   `default`, instances are launched with shared tenancy by default.
    #   You can launch instances with any tenancy into a shared tenancy VPC.
    #   For `dedicated`, instances are launched as dedicated tenancy
    #   instances by default. You can only launch instances with a tenancy
    #   of `dedicated` or `host` into a dedicated tenancy VPC.
    #
    #   **Important:** The `host` value cannot be used with this parameter.
    #   Use the `default` or `dedicated` values only.
    #
    #   Default: `default`
    #   @return [String]
    #
    # @!attribute [rw] ipv_6_cidr_block_network_border_group
    #   The name of the location from which we advertise the IPV6 CIDR
    #   block. Use this parameter to limit the address to this location.
    #
    #   You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this
    #   parameter.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to assign to the VPC.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcRequest AWS API Documentation
    #
    class CreateVpcRequest < Struct.new(
      :cidr_block,
      :amazon_provided_ipv_6_cidr_block,
      :ipv_6_pool,
      :ipv_6_cidr_block,
      :dry_run,
      :instance_tenancy,
      :ipv_6_cidr_block_network_border_group,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc
    #   Information about the VPC.
    #   @return [Types::Vpc]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpcResult AWS API Documentation
    #
    class CreateVpcResult < Struct.new(
      :vpc)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateVpnConnection.
    #
    # @note When making an API call, you may pass CreateVpnConnectionRequest
    #   data as a hash:
    #
    #       {
    #         customer_gateway_id: "CustomerGatewayId", # required
    #         type: "String", # required
    #         vpn_gateway_id: "VpnGatewayId",
    #         transit_gateway_id: "TransitGatewayId",
    #         dry_run: false,
    #         options: {
    #           enable_acceleration: false,
    #           static_routes_only: false,
    #           tunnel_inside_ip_version: "ipv4", # accepts ipv4, ipv6
    #           tunnel_options: [
    #             {
    #               tunnel_inside_cidr: "String",
    #               tunnel_inside_ipv_6_cidr: "String",
    #               pre_shared_key: "String",
    #               phase_1_lifetime_seconds: 1,
    #               phase_2_lifetime_seconds: 1,
    #               rekey_margin_time_seconds: 1,
    #               rekey_fuzz_percentage: 1,
    #               replay_window_size: 1,
    #               dpd_timeout_seconds: 1,
    #               dpd_timeout_action: "String",
    #               phase_1_encryption_algorithms: [
    #                 {
    #                   value: "String",
    #                 },
    #               ],
    #               phase_2_encryption_algorithms: [
    #                 {
    #                   value: "String",
    #                 },
    #               ],
    #               phase_1_integrity_algorithms: [
    #                 {
    #                   value: "String",
    #                 },
    #               ],
    #               phase_2_integrity_algorithms: [
    #                 {
    #                   value: "String",
    #                 },
    #               ],
    #               phase_1_dh_group_numbers: [
    #                 {
    #                   value: 1,
    #                 },
    #               ],
    #               phase_2_dh_group_numbers: [
    #                 {
    #                   value: 1,
    #                 },
    #               ],
    #               ike_versions: [
    #                 {
    #                   value: "String",
    #                 },
    #               ],
    #               startup_action: "String",
    #             },
    #           ],
    #           local_ipv_4_network_cidr: "String",
    #           remote_ipv_4_network_cidr: "String",
    #           local_ipv_6_network_cidr: "String",
    #           remote_ipv_6_network_cidr: "String",
    #         },
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] customer_gateway_id
    #   The ID of the customer gateway.
    #   @return [String]
    #
    # @!attribute [rw] type
    #   The type of VPN connection (`ipsec.1`).
    #   @return [String]
    #
    # @!attribute [rw] vpn_gateway_id
    #   The ID of the virtual private gateway. If you specify a virtual
    #   private gateway, you cannot specify a transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_id
    #   The ID of the transit gateway. If you specify a transit gateway, you
    #   cannot specify a virtual private gateway.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] options
    #   The options for the VPN connection.
    #   @return [Types::VpnConnectionOptionsSpecification]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the VPN connection.
    #   @return [Array<Types::TagSpecification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRequest AWS API Documentation
    #
    class CreateVpnConnectionRequest < Struct.new(
      :customer_gateway_id,
      :type,
      :vpn_gateway_id,
      :transit_gateway_id,
      :dry_run,
      :options,
      :tag_specifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CreateVpnConnection.
    #
    # @!attribute [rw] vpn_connection
    #   Information about the VPN connection.
    #   @return [Types::VpnConnection]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionResult AWS API Documentation
    #
    class CreateVpnConnectionResult < Struct.new(
      :vpn_connection)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateVpnConnectionRoute.
    #
    # @note When making an API call, you may pass CreateVpnConnectionRouteRequest
    #   data as a hash:
    #
    #       {
    #         destination_cidr_block: "String", # required
    #         vpn_connection_id: "VpnConnectionId", # required
    #       }
    #
    # @!attribute [rw] destination_cidr_block
    #   The CIDR block associated with the local subnet of the customer
    #   network.
    #   @return [String]
    #
    # @!attribute [rw] vpn_connection_id
    #   The ID of the VPN connection.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnConnectionRouteRequest AWS API Documentation
    #
    class CreateVpnConnectionRouteRequest < Struct.new(
      :destination_cidr_block,
      :vpn_connection_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for CreateVpnGateway.
    #
    # @note When making an API call, you may pass CreateVpnGatewayRequest
    #   data as a hash:
    #
    #       {
    #         availability_zone: "String",
    #         type: "ipsec.1", # required, accepts ipsec.1
    #         tag_specifications: [
    #           {
    #             resource_type: "client-vpn-endpoint", # accepts client-vpn-endpoint, customer-gateway, dedicated-host, dhcp-options, egress-only-internet-gateway, elastic-ip, elastic-gpu, export-image-task, export-instance-task, fleet, fpga-image, host-reservation, image, import-image-task, import-snapshot-task, instance, internet-gateway, key-pair, launch-template, local-gateway-route-table-vpc-association, natgateway, network-acl, network-interface, network-insights-analysis, network-insights-path, placement-group, reserved-instances, route-table, security-group, snapshot, spot-fleet-request, spot-instances-request, subnet, traffic-mirror-filter, traffic-mirror-session, traffic-mirror-target, transit-gateway, transit-gateway-attachment, transit-gateway-connect-peer, transit-gateway-multicast-domain, transit-gateway-route-table, volume, vpc, vpc-peering-connection, vpn-connection, vpn-gateway, vpc-flow-log
    #             tags: [
    #               {
    #                 key: "String",
    #                 value: "String",
    #               },
    #             ],
    #           },
    #         ],
    #         amazon_side_asn: 1,
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone for the virtual private gateway.
    #   @return [String]
    #
    # @!attribute [rw] type
    #   The type of VPN connection this virtual private gateway supports.
    #   @return [String]
    #
    # @!attribute [rw] tag_specifications
    #   The tags to apply to the virtual private gateway.
    #   @return [Array<Types::TagSpecification>]
    #
    # @!attribute [rw] amazon_side_asn
    #   A private Autonomous System Number (ASN) for the Amazon side of a
    #   BGP session. If you're using a 16-bit ASN, it must be in the 64512
    #   to 65534 range. If you're using a 32-bit ASN, it must be in the
    #   4200000000 to 4294967294 range.
    #
    #   Default: 64512
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGatewayRequest AWS API Documentation
    #
    class CreateVpnGatewayRequest < Struct.new(
      :availability_zone,
      :type,
      :tag_specifications,
      :amazon_side_asn,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of CreateVpnGateway.
    #
    # @!attribute [rw] vpn_gateway
    #   Information about the virtual private gateway.
    #   @return [Types::VpnGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateVpnGatewayResult AWS API Documentation
    #
    class CreateVpnGatewayResult < Struct.new(
      :vpn_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the credit option for CPU usage of a T2, T3, or T3a
    # instance.
    #
    # @!attribute [rw] cpu_credits
    #   The credit option for CPU usage of a T2, T3, or T3a instance. Valid
    #   values are `standard` and `unlimited`.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreditSpecification AWS API Documentation
    #
    class CreditSpecification < Struct.new(
      :cpu_credits)
      SENSITIVE = []
      include Aws::Structure
    end

    # The credit option for CPU usage of a T2, T3, or T3a instance.
    #
    # @note When making an API call, you may pass CreditSpecificationRequest
    #   data as a hash:
    #
    #       {
    #         cpu_credits: "String", # required
    #       }
    #
    # @!attribute [rw] cpu_credits
    #   The credit option for CPU usage of a T2, T3, or T3a instance. Valid
    #   values are `standard` and `unlimited`.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreditSpecificationRequest AWS API Documentation
    #
    class CreditSpecificationRequest < Struct.new(
      :cpu_credits)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a customer gateway.
    #
    # @!attribute [rw] bgp_asn
    #   The customer gateway's Border Gateway Protocol (BGP) Autonomous
    #   System Number (ASN).
    #   @return [String]
    #
    # @!attribute [rw] customer_gateway_id
    #   The ID of the customer gateway.
    #   @return [String]
    #
    # @!attribute [rw] ip_address
    #   The Internet-routable IP address of the customer gateway's outside
    #   interface.
    #   @return [String]
    #
    # @!attribute [rw] certificate_arn
    #   The Amazon Resource Name (ARN) for the customer gateway certificate.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The current state of the customer gateway (`pending | available |
    #   deleting | deleted`).
    #   @return [String]
    #
    # @!attribute [rw] type
    #   The type of VPN connection the customer gateway supports
    #   (`ipsec.1`).
    #   @return [String]
    #
    # @!attribute [rw] device_name
    #   The name of customer gateway device.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   Any tags assigned to the customer gateway.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CustomerGateway AWS API Documentation
    #
    class CustomerGateway < Struct.new(
      :bgp_asn,
      :customer_gateway_id,
      :ip_address,
      :certificate_arn,
      :state,
      :type,
      :device_name,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteCarrierGatewayRequest
    #   data as a hash:
    #
    #       {
    #         carrier_gateway_id: "CarrierGatewayId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] carrier_gateway_id
    #   The ID of the carrier gateway.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGatewayRequest AWS API Documentation
    #
    class DeleteCarrierGatewayRequest < Struct.new(
      :carrier_gateway_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] carrier_gateway
    #   Information about the carrier gateway.
    #   @return [Types::CarrierGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCarrierGatewayResult AWS API Documentation
    #
    class DeleteCarrierGatewayResult < Struct.new(
      :carrier_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteClientVpnEndpointRequest
    #   data as a hash:
    #
    #       {
    #         client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN to be deleted.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpointRequest AWS API Documentation
    #
    class DeleteClientVpnEndpointRequest < Struct.new(
      :client_vpn_endpoint_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] status
    #   The current state of the Client VPN endpoint.
    #   @return [Types::ClientVpnEndpointStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnEndpointResult AWS API Documentation
    #
    class DeleteClientVpnEndpointResult < Struct.new(
      :status)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteClientVpnRouteRequest
    #   data as a hash:
    #
    #       {
    #         client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #         target_vpc_subnet_id: "SubnetId",
    #         destination_cidr_block: "String", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint from which the route is to be
    #   deleted.
    #   @return [String]
    #
    # @!attribute [rw] target_vpc_subnet_id
    #   The ID of the target subnet used by the route.
    #   @return [String]
    #
    # @!attribute [rw] destination_cidr_block
    #   The IPv4 address range, in CIDR notation, of the route to be
    #   deleted.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRouteRequest AWS API Documentation
    #
    class DeleteClientVpnRouteRequest < Struct.new(
      :client_vpn_endpoint_id,
      :target_vpc_subnet_id,
      :destination_cidr_block,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] status
    #   The current state of the route.
    #   @return [Types::ClientVpnRouteStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteClientVpnRouteResult AWS API Documentation
    #
    class DeleteClientVpnRouteResult < Struct.new(
      :status)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeleteCustomerGateway.
    #
    # @note When making an API call, you may pass DeleteCustomerGatewayRequest
    #   data as a hash:
    #
    #       {
    #         customer_gateway_id: "CustomerGatewayId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] customer_gateway_id
    #   The ID of the customer gateway.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteCustomerGatewayRequest AWS API Documentation
    #
    class DeleteCustomerGatewayRequest < Struct.new(
      :customer_gateway_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteDhcpOptionsRequest
    #   data as a hash:
    #
    #       {
    #         dhcp_options_id: "DhcpOptionsId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] dhcp_options_id
    #   The ID of the DHCP options set.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteDhcpOptionsRequest AWS API Documentation
    #
    class DeleteDhcpOptionsRequest < Struct.new(
      :dhcp_options_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteEgressOnlyInternetGatewayRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         egress_only_internet_gateway_id: "EgressOnlyInternetGatewayId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] egress_only_internet_gateway_id
    #   The ID of the egress-only internet gateway.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGatewayRequest AWS API Documentation
    #
    class DeleteEgressOnlyInternetGatewayRequest < Struct.new(
      :dry_run,
      :egress_only_internet_gateway_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return_code
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteEgressOnlyInternetGatewayResult AWS API Documentation
    #
    class DeleteEgressOnlyInternetGatewayResult < Struct.new(
      :return_code)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an EC2 Fleet error.
    #
    # @!attribute [rw] code
    #   The error code.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   The description for the error code.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleetError AWS API Documentation
    #
    class DeleteFleetError < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an EC2 Fleet that was not successfully deleted.
    #
    # @!attribute [rw] error
    #   The error.
    #   @return [Types::DeleteFleetError]
    #
    # @!attribute [rw] fleet_id
    #   The ID of the EC2 Fleet.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleetErrorItem AWS API Documentation
    #
    class DeleteFleetErrorItem < Struct.new(
      :error,
      :fleet_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an EC2 Fleet that was successfully deleted.
    #
    # @!attribute [rw] current_fleet_state
    #   The current state of the EC2 Fleet.
    #   @return [String]
    #
    # @!attribute [rw] previous_fleet_state
    #   The previous state of the EC2 Fleet.
    #   @return [String]
    #
    # @!attribute [rw] fleet_id
    #   The ID of the EC2 Fleet.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleetSuccessItem AWS API Documentation
    #
    class DeleteFleetSuccessItem < Struct.new(
      :current_fleet_state,
      :previous_fleet_state,
      :fleet_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteFleetsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         fleet_ids: ["FleetId"], # required
    #         terminate_instances: false, # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] fleet_ids
    #   The IDs of the EC2 Fleets.
    #   @return [Array<String>]
    #
    # @!attribute [rw] terminate_instances
    #   Indicates whether to terminate the instances when the EC2 Fleet is
    #   deleted. The default is to terminate the instances.
    #
    #   To let the instances continue to run after the EC2 Fleet is deleted,
    #   specify `NoTerminateInstances`. Supported only for fleets of type
    #   `maintain` and `request`.
    #
    #   For `instant` fleets, you cannot specify `NoTerminateInstances`. A
    #   deleted `instant` fleet with running instances is not supported.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleetsRequest AWS API Documentation
    #
    class DeleteFleetsRequest < Struct.new(
      :dry_run,
      :fleet_ids,
      :terminate_instances)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] successful_fleet_deletions
    #   Information about the EC2 Fleets that are successfully deleted.
    #   @return [Array<Types::DeleteFleetSuccessItem>]
    #
    # @!attribute [rw] unsuccessful_fleet_deletions
    #   Information about the EC2 Fleets that are not successfully deleted.
    #   @return [Array<Types::DeleteFleetErrorItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFleetsResult AWS API Documentation
    #
    class DeleteFleetsResult < Struct.new(
      :successful_fleet_deletions,
      :unsuccessful_fleet_deletions)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteFlowLogsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         flow_log_ids: ["VpcFlowLogId"], # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] flow_log_ids
    #   One or more flow log IDs.
    #
    #   Constraint: Maximum of 1000 flow log IDs.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogsRequest AWS API Documentation
    #
    class DeleteFlowLogsRequest < Struct.new(
      :dry_run,
      :flow_log_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] unsuccessful
    #   Information about the flow logs that could not be deleted
    #   successfully.
    #   @return [Array<Types::UnsuccessfulItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFlowLogsResult AWS API Documentation
    #
    class DeleteFlowLogsResult < Struct.new(
      :unsuccessful)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteFpgaImageRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         fpga_image_id: "FpgaImageId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] fpga_image_id
    #   The ID of the AFI.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImageRequest AWS API Documentation
    #
    class DeleteFpgaImageRequest < Struct.new(
      :dry_run,
      :fpga_image_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Is `true` if the request succeeds, and an error otherwise.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteFpgaImageResult AWS API Documentation
    #
    class DeleteFpgaImageResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteInternetGatewayRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         internet_gateway_id: "InternetGatewayId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] internet_gateway_id
    #   The ID of the internet gateway.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteInternetGatewayRequest AWS API Documentation
    #
    class DeleteInternetGatewayRequest < Struct.new(
      :dry_run,
      :internet_gateway_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteKeyPairRequest
    #   data as a hash:
    #
    #       {
    #         key_name: "KeyPairName",
    #         key_pair_id: "KeyPairId",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] key_name
    #   The name of the key pair.
    #   @return [String]
    #
    # @!attribute [rw] key_pair_id
    #   The ID of the key pair.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteKeyPairRequest AWS API Documentation
    #
    class DeleteKeyPairRequest < Struct.new(
      :key_name,
      :key_pair_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteLaunchTemplateRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         launch_template_id: "LaunchTemplateId",
    #         launch_template_name: "LaunchTemplateName",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] launch_template_id
    #   The ID of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_name
    #   The name of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateRequest AWS API Documentation
    #
    class DeleteLaunchTemplateRequest < Struct.new(
      :dry_run,
      :launch_template_id,
      :launch_template_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] launch_template
    #   Information about the launch template.
    #   @return [Types::LaunchTemplate]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateResult AWS API Documentation
    #
    class DeleteLaunchTemplateResult < Struct.new(
      :launch_template)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteLaunchTemplateVersionsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         launch_template_id: "LaunchTemplateId",
    #         launch_template_name: "LaunchTemplateName",
    #         versions: ["String"], # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] launch_template_id
    #   The ID of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_name
    #   The name of the launch template. You must specify either the launch
    #   template ID or launch template name in the request.
    #   @return [String]
    #
    # @!attribute [rw] versions
    #   The version numbers of one or more launch template versions to
    #   delete.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersionsRequest AWS API Documentation
    #
    class DeleteLaunchTemplateVersionsRequest < Struct.new(
      :dry_run,
      :launch_template_id,
      :launch_template_name,
      :versions)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a launch template version that could not be deleted.
    #
    # @!attribute [rw] launch_template_id
    #   The ID of the launch template.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_name
    #   The name of the launch template.
    #   @return [String]
    #
    # @!attribute [rw] version_number
    #   The version number of the launch template.
    #   @return [Integer]
    #
    # @!attribute [rw] response_error
    #   Information about the error.
    #   @return [Types::ResponseError]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersionsResponseErrorItem AWS API Documentation
    #
    class DeleteLaunchTemplateVersionsResponseErrorItem < Struct.new(
      :launch_template_id,
      :launch_template_name,
      :version_number,
      :response_error)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a launch template version that was successfully deleted.
    #
    # @!attribute [rw] launch_template_id
    #   The ID of the launch template.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_name
    #   The name of the launch template.
    #   @return [String]
    #
    # @!attribute [rw] version_number
    #   The version number of the launch template.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersionsResponseSuccessItem AWS API Documentation
    #
    class DeleteLaunchTemplateVersionsResponseSuccessItem < Struct.new(
      :launch_template_id,
      :launch_template_name,
      :version_number)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] successfully_deleted_launch_template_versions
    #   Information about the launch template versions that were
    #   successfully deleted.
    #   @return [Array<Types::DeleteLaunchTemplateVersionsResponseSuccessItem>]
    #
    # @!attribute [rw] unsuccessfully_deleted_launch_template_versions
    #   Information about the launch template versions that could not be
    #   deleted.
    #   @return [Array<Types::DeleteLaunchTemplateVersionsResponseErrorItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLaunchTemplateVersionsResult AWS API Documentation
    #
    class DeleteLaunchTemplateVersionsResult < Struct.new(
      :successfully_deleted_launch_template_versions,
      :unsuccessfully_deleted_launch_template_versions)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteLocalGatewayRouteRequest
    #   data as a hash:
    #
    #       {
    #         destination_cidr_block: "String", # required
    #         local_gateway_route_table_id: "LocalGatewayRoutetableId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] destination_cidr_block
    #   The CIDR range for the route. This must match the CIDR for the route
    #   exactly.
    #   @return [String]
    #
    # @!attribute [rw] local_gateway_route_table_id
    #   The ID of the local gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteRequest AWS API Documentation
    #
    class DeleteLocalGatewayRouteRequest < Struct.new(
      :destination_cidr_block,
      :local_gateway_route_table_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route
    #   Information about the route.
    #   @return [Types::LocalGatewayRoute]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteResult AWS API Documentation
    #
    class DeleteLocalGatewayRouteResult < Struct.new(
      :route)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteLocalGatewayRouteTableVpcAssociationRequest
    #   data as a hash:
    #
    #       {
    #         local_gateway_route_table_vpc_association_id: "LocalGatewayRouteTableVpcAssociationId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] local_gateway_route_table_vpc_association_id
    #   The ID of the association.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociationRequest AWS API Documentation
    #
    class DeleteLocalGatewayRouteTableVpcAssociationRequest < Struct.new(
      :local_gateway_route_table_vpc_association_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_table_vpc_association
    #   Information about the association.
    #   @return [Types::LocalGatewayRouteTableVpcAssociation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteLocalGatewayRouteTableVpcAssociationResult AWS API Documentation
    #
    class DeleteLocalGatewayRouteTableVpcAssociationResult < Struct.new(
      :local_gateway_route_table_vpc_association)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteManagedPrefixListRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         prefix_list_id: "PrefixListResourceId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] prefix_list_id
    #   The ID of the prefix list.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixListRequest AWS API Documentation
    #
    class DeleteManagedPrefixListRequest < Struct.new(
      :dry_run,
      :prefix_list_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] prefix_list
    #   Information about the prefix list.
    #   @return [Types::ManagedPrefixList]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteManagedPrefixListResult AWS API Documentation
    #
    class DeleteManagedPrefixListResult < Struct.new(
      :prefix_list)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteNatGatewayRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         nat_gateway_id: "NatGatewayId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] nat_gateway_id
    #   The ID of the NAT gateway.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGatewayRequest AWS API Documentation
    #
    class DeleteNatGatewayRequest < Struct.new(
      :dry_run,
      :nat_gateway_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] nat_gateway_id
    #   The ID of the NAT gateway.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNatGatewayResult AWS API Documentation
    #
    class DeleteNatGatewayResult < Struct.new(
      :nat_gateway_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteNetworkAclEntryRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         egress: false, # required
    #         network_acl_id: "NetworkAclId", # required
    #         rule_number: 1, # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] egress
    #   Indicates whether the rule is an egress rule.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_acl_id
    #   The ID of the network ACL.
    #   @return [String]
    #
    # @!attribute [rw] rule_number
    #   The rule number of the entry to delete.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclEntryRequest AWS API Documentation
    #
    class DeleteNetworkAclEntryRequest < Struct.new(
      :dry_run,
      :egress,
      :network_acl_id,
      :rule_number)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteNetworkAclRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         network_acl_id: "NetworkAclId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_acl_id
    #   The ID of the network ACL.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkAclRequest AWS API Documentation
    #
    class DeleteNetworkAclRequest < Struct.new(
      :dry_run,
      :network_acl_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteNetworkInsightsAnalysisRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         network_insights_analysis_id: "NetworkInsightsAnalysisId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_insights_analysis_id
    #   The ID of the network insights analysis.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysisRequest AWS API Documentation
    #
    class DeleteNetworkInsightsAnalysisRequest < Struct.new(
      :dry_run,
      :network_insights_analysis_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_insights_analysis_id
    #   The ID of the network insights analysis.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsAnalysisResult AWS API Documentation
    #
    class DeleteNetworkInsightsAnalysisResult < Struct.new(
      :network_insights_analysis_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteNetworkInsightsPathRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         network_insights_path_id: "NetworkInsightsPathId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_insights_path_id
    #   The ID of the path.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPathRequest AWS API Documentation
    #
    class DeleteNetworkInsightsPathRequest < Struct.new(
      :dry_run,
      :network_insights_path_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_insights_path_id
    #   The ID of the path.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInsightsPathResult AWS API Documentation
    #
    class DeleteNetworkInsightsPathResult < Struct.new(
      :network_insights_path_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeleteNetworkInterfacePermission.
    #
    # @note When making an API call, you may pass DeleteNetworkInterfacePermissionRequest
    #   data as a hash:
    #
    #       {
    #         network_interface_permission_id: "NetworkInterfacePermissionId", # required
    #         force: false,
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] network_interface_permission_id
    #   The ID of the network interface permission.
    #   @return [String]
    #
    # @!attribute [rw] force
    #   Specify `true` to remove the permission even if the network
    #   interface is attached to an instance.
    #   @return [Boolean]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermissionRequest AWS API Documentation
    #
    class DeleteNetworkInterfacePermissionRequest < Struct.new(
      :network_interface_permission_id,
      :force,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output for DeleteNetworkInterfacePermission.
    #
    # @!attribute [rw] return
    #   Returns `true` if the request succeeds, otherwise returns an error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermissionResult AWS API Documentation
    #
    class DeleteNetworkInterfacePermissionResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeleteNetworkInterface.
    #
    # @note When making an API call, you may pass DeleteNetworkInterfaceRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         network_interface_id: "NetworkInterfaceId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfaceRequest AWS API Documentation
    #
    class DeleteNetworkInterfaceRequest < Struct.new(
      :dry_run,
      :network_interface_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeletePlacementGroupRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         group_name: "PlacementGroupName", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] group_name
    #   The name of the placement group.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeletePlacementGroupRequest AWS API Documentation
    #
    class DeletePlacementGroupRequest < Struct.new(
      :dry_run,
      :group_name)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the error for a Reserved Instance whose queued purchase
    # could not be deleted.
    #
    # @!attribute [rw] code
    #   The error code.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   The error message.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstancesError AWS API Documentation
    #
    class DeleteQueuedReservedInstancesError < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteQueuedReservedInstancesRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         reserved_instances_ids: ["ReservationId"], # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] reserved_instances_ids
    #   The IDs of the Reserved Instances.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstancesRequest AWS API Documentation
    #
    class DeleteQueuedReservedInstancesRequest < Struct.new(
      :dry_run,
      :reserved_instances_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] successful_queued_purchase_deletions
    #   Information about the queued purchases that were successfully
    #   deleted.
    #   @return [Array<Types::SuccessfulQueuedPurchaseDeletion>]
    #
    # @!attribute [rw] failed_queued_purchase_deletions
    #   Information about the queued purchases that could not be deleted.
    #   @return [Array<Types::FailedQueuedPurchaseDeletion>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteQueuedReservedInstancesResult AWS API Documentation
    #
    class DeleteQueuedReservedInstancesResult < Struct.new(
      :successful_queued_purchase_deletions,
      :failed_queued_purchase_deletions)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteRouteRequest
    #   data as a hash:
    #
    #       {
    #         destination_cidr_block: "String",
    #         destination_ipv_6_cidr_block: "String",
    #         destination_prefix_list_id: "PrefixListResourceId",
    #         dry_run: false,
    #         route_table_id: "RouteTableId", # required
    #       }
    #
    # @!attribute [rw] destination_cidr_block
    #   The IPv4 CIDR range for the route. The value you specify must match
    #   the CIDR for the route exactly.
    #   @return [String]
    #
    # @!attribute [rw] destination_ipv_6_cidr_block
    #   The IPv6 CIDR range for the route. The value you specify must match
    #   the CIDR for the route exactly.
    #   @return [String]
    #
    # @!attribute [rw] destination_prefix_list_id
    #   The ID of the prefix list for the route.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] route_table_id
    #   The ID of the route table.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteRequest AWS API Documentation
    #
    class DeleteRouteRequest < Struct.new(
      :destination_cidr_block,
      :destination_ipv_6_cidr_block,
      :destination_prefix_list_id,
      :dry_run,
      :route_table_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteRouteTableRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         route_table_id: "RouteTableId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] route_table_id
    #   The ID of the route table.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteRouteTableRequest AWS API Documentation
    #
    class DeleteRouteTableRequest < Struct.new(
      :dry_run,
      :route_table_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteSecurityGroupRequest
    #   data as a hash:
    #
    #       {
    #         group_id: "SecurityGroupId",
    #         group_name: "SecurityGroupName",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] group_id
    #   The ID of the security group. Required for a nondefault VPC.
    #   @return [String]
    #
    # @!attribute [rw] group_name
    #   \[EC2-Classic, default VPC\] The name of the security group. You can
    #   specify either the security group name or the security group ID.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSecurityGroupRequest AWS API Documentation
    #
    class DeleteSecurityGroupRequest < Struct.new(
      :group_id,
      :group_name,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteSnapshotRequest
    #   data as a hash:
    #
    #       {
    #         snapshot_id: "SnapshotId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] snapshot_id
    #   The ID of the EBS snapshot.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSnapshotRequest AWS API Documentation
    #
    class DeleteSnapshotRequest < Struct.new(
      :snapshot_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeleteSpotDatafeedSubscription.
    #
    # @note When making an API call, you may pass DeleteSpotDatafeedSubscriptionRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSpotDatafeedSubscriptionRequest AWS API Documentation
    #
    class DeleteSpotDatafeedSubscriptionRequest < Struct.new(
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteSubnetRequest
    #   data as a hash:
    #
    #       {
    #         subnet_id: "SubnetId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] subnet_id
    #   The ID of the subnet.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteSubnetRequest AWS API Documentation
    #
    class DeleteSubnetRequest < Struct.new(
      :subnet_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteTagsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         resources: ["TaggableResourceId"], # required
    #         tags: [
    #           {
    #             key: "String",
    #             value: "String",
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] resources
    #   The IDs of the resources, separated by spaces.
    #
    #   Constraints: Up to 1000 resource IDs. We recommend breaking up this
    #   request into smaller batches.
    #   @return [Array<String>]
    #
    # @!attribute [rw] tags
    #   The tags to delete. Specify a tag key and an optional tag value to
    #   delete specific tags. If you specify a tag key without a tag value,
    #   we delete any tag with this key regardless of its value. If you
    #   specify a tag key with an empty string as the tag value, we delete
    #   the tag only if its value is an empty string.
    #
    #   If you omit this parameter, we delete all user-defined tags for the
    #   specified resources. We do not delete AWS-generated tags (tags that
    #   have the `aws:` prefix).
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTagsRequest AWS API Documentation
    #
    class DeleteTagsRequest < Struct.new(
      :dry_run,
      :resources,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteTrafficMirrorFilterRequest
    #   data as a hash:
    #
    #       {
    #         traffic_mirror_filter_id: "TrafficMirrorFilterId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] traffic_mirror_filter_id
    #   The ID of the Traffic Mirror filter.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRequest AWS API Documentation
    #
    class DeleteTrafficMirrorFilterRequest < Struct.new(
      :traffic_mirror_filter_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_filter_id
    #   The ID of the Traffic Mirror filter.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterResult AWS API Documentation
    #
    class DeleteTrafficMirrorFilterResult < Struct.new(
      :traffic_mirror_filter_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteTrafficMirrorFilterRuleRequest
    #   data as a hash:
    #
    #       {
    #         traffic_mirror_filter_rule_id: "TrafficMirrorFilterRuleId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] traffic_mirror_filter_rule_id
    #   The ID of the Traffic Mirror rule.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRuleRequest AWS API Documentation
    #
    class DeleteTrafficMirrorFilterRuleRequest < Struct.new(
      :traffic_mirror_filter_rule_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_filter_rule_id
    #   The ID of the deleted Traffic Mirror rule.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorFilterRuleResult AWS API Documentation
    #
    class DeleteTrafficMirrorFilterRuleResult < Struct.new(
      :traffic_mirror_filter_rule_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteTrafficMirrorSessionRequest
    #   data as a hash:
    #
    #       {
    #         traffic_mirror_session_id: "TrafficMirrorSessionId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] traffic_mirror_session_id
    #   The ID of the Traffic Mirror session.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSessionRequest AWS API Documentation
    #
    class DeleteTrafficMirrorSessionRequest < Struct.new(
      :traffic_mirror_session_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_session_id
    #   The ID of the deleted Traffic Mirror session.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorSessionResult AWS API Documentation
    #
    class DeleteTrafficMirrorSessionResult < Struct.new(
      :traffic_mirror_session_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteTrafficMirrorTargetRequest
    #   data as a hash:
    #
    #       {
    #         traffic_mirror_target_id: "TrafficMirrorTargetId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] traffic_mirror_target_id
    #   The ID of the Traffic Mirror target.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTargetRequest AWS API Documentation
    #
    class DeleteTrafficMirrorTargetRequest < Struct.new(
      :traffic_mirror_target_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_target_id
    #   The ID of the deleted Traffic Mirror target.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTrafficMirrorTargetResult AWS API Documentation
    #
    class DeleteTrafficMirrorTargetResult < Struct.new(
      :traffic_mirror_target_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteTransitGatewayConnectPeerRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_connect_peer_id: "TransitGatewayConnectPeerId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_connect_peer_id
    #   The ID of the Connect peer.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeerRequest AWS API Documentation
    #
    class DeleteTransitGatewayConnectPeerRequest < Struct.new(
      :transit_gateway_connect_peer_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_connect_peer
    #   Information about the deleted Connect peer.
    #   @return [Types::TransitGatewayConnectPeer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectPeerResult AWS API Documentation
    #
    class DeleteTransitGatewayConnectPeerResult < Struct.new(
      :transit_gateway_connect_peer)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteTransitGatewayConnectRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the Connect attachment.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectRequest AWS API Documentation
    #
    class DeleteTransitGatewayConnectRequest < Struct.new(
      :transit_gateway_attachment_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_connect
    #   Information about the deleted Connect attachment.
    #   @return [Types::TransitGatewayConnect]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayConnectResult AWS API Documentation
    #
    class DeleteTransitGatewayConnectResult < Struct.new(
      :transit_gateway_connect)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteTransitGatewayMulticastDomainRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_multicast_domain_id: "TransitGatewayMulticastDomainId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomainRequest AWS API Documentation
    #
    class DeleteTransitGatewayMulticastDomainRequest < Struct.new(
      :transit_gateway_multicast_domain_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_multicast_domain
    #   Information about the deleted transit gateway multicast domain.
    #   @return [Types::TransitGatewayMulticastDomain]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayMulticastDomainResult AWS API Documentation
    #
    class DeleteTransitGatewayMulticastDomainResult < Struct.new(
      :transit_gateway_multicast_domain)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteTransitGatewayPeeringAttachmentRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the transit gateway peering attachment.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachmentRequest AWS API Documentation
    #
    class DeleteTransitGatewayPeeringAttachmentRequest < Struct.new(
      :transit_gateway_attachment_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_peering_attachment
    #   The transit gateway peering attachment.
    #   @return [Types::TransitGatewayPeeringAttachment]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPeeringAttachmentResult AWS API Documentation
    #
    class DeleteTransitGatewayPeeringAttachmentResult < Struct.new(
      :transit_gateway_peering_attachment)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteTransitGatewayPrefixListReferenceRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_route_table_id: "TransitGatewayRouteTableId", # required
    #         prefix_list_id: "PrefixListResourceId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_route_table_id
    #   The ID of the route table.
    #   @return [String]
    #
    # @!attribute [rw] prefix_list_id
    #   The ID of the prefix list.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReferenceRequest AWS API Documentation
    #
    class DeleteTransitGatewayPrefixListReferenceRequest < Struct.new(
      :transit_gateway_route_table_id,
      :prefix_list_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_prefix_list_reference
    #   Information about the deleted prefix list reference.
    #   @return [Types::TransitGatewayPrefixListReference]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayPrefixListReferenceResult AWS API Documentation
    #
    class DeleteTransitGatewayPrefixListReferenceResult < Struct.new(
      :transit_gateway_prefix_list_reference)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteTransitGatewayRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_id: "TransitGatewayId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_id
    #   The ID of the transit gateway.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRequest AWS API Documentation
    #
    class DeleteTransitGatewayRequest < Struct.new(
      :transit_gateway_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway
    #   Information about the deleted transit gateway.
    #   @return [Types::TransitGateway]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayResult AWS API Documentation
    #
    class DeleteTransitGatewayResult < Struct.new(
      :transit_gateway)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteTransitGatewayRouteRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_route_table_id: "TransitGatewayRouteTableId", # required
    #         destination_cidr_block: "String", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] destination_cidr_block
    #   The CIDR range for the route. This must match the CIDR for the route
    #   exactly.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteRequest AWS API Documentation
    #
    class DeleteTransitGatewayRouteRequest < Struct.new(
      :transit_gateway_route_table_id,
      :destination_cidr_block,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] route
    #   Information about the route.
    #   @return [Types::TransitGatewayRoute]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteResult AWS API Documentation
    #
    class DeleteTransitGatewayRouteResult < Struct.new(
      :route)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteTransitGatewayRouteTableRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_route_table_id: "TransitGatewayRouteTableId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTableRequest AWS API Documentation
    #
    class DeleteTransitGatewayRouteTableRequest < Struct.new(
      :transit_gateway_route_table_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_route_table
    #   Information about the deleted transit gateway route table.
    #   @return [Types::TransitGatewayRouteTable]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayRouteTableResult AWS API Documentation
    #
    class DeleteTransitGatewayRouteTableResult < Struct.new(
      :transit_gateway_route_table)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteTransitGatewayVpcAttachmentRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the attachment.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachmentRequest AWS API Documentation
    #
    class DeleteTransitGatewayVpcAttachmentRequest < Struct.new(
      :transit_gateway_attachment_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_vpc_attachment
    #   Information about the deleted VPC attachment.
    #   @return [Types::TransitGatewayVpcAttachment]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteTransitGatewayVpcAttachmentResult AWS API Documentation
    #
    class DeleteTransitGatewayVpcAttachmentResult < Struct.new(
      :transit_gateway_vpc_attachment)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteVolumeRequest
    #   data as a hash:
    #
    #       {
    #         volume_id: "VolumeId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] volume_id
    #   The ID of the volume.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVolumeRequest AWS API Documentation
    #
    class DeleteVolumeRequest < Struct.new(
      :volume_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteVpcEndpointConnectionNotificationsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         connection_notification_ids: ["ConnectionNotificationId"], # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] connection_notification_ids
    #   One or more notification IDs.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotificationsRequest AWS API Documentation
    #
    class DeleteVpcEndpointConnectionNotificationsRequest < Struct.new(
      :dry_run,
      :connection_notification_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] unsuccessful
    #   Information about the notifications that could not be deleted
    #   successfully.
    #   @return [Array<Types::UnsuccessfulItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointConnectionNotificationsResult AWS API Documentation
    #
    class DeleteVpcEndpointConnectionNotificationsResult < Struct.new(
      :unsuccessful)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteVpcEndpointServiceConfigurationsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         service_ids: ["VpcEndpointServiceId"], # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] service_ids
    #   The IDs of one or more services.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurationsRequest AWS API Documentation
    #
    class DeleteVpcEndpointServiceConfigurationsRequest < Struct.new(
      :dry_run,
      :service_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] unsuccessful
    #   Information about the service configurations that were not deleted,
    #   if applicable.
    #   @return [Array<Types::UnsuccessfulItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointServiceConfigurationsResult AWS API Documentation
    #
    class DeleteVpcEndpointServiceConfigurationsResult < Struct.new(
      :unsuccessful)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeleteVpcEndpoints.
    #
    # @note When making an API call, you may pass DeleteVpcEndpointsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         vpc_endpoint_ids: ["VpcEndpointId"], # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_endpoint_ids
    #   One or more VPC endpoint IDs.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointsRequest AWS API Documentation
    #
    class DeleteVpcEndpointsRequest < Struct.new(
      :dry_run,
      :vpc_endpoint_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DeleteVpcEndpoints.
    #
    # @!attribute [rw] unsuccessful
    #   Information about the VPC endpoints that were not successfully
    #   deleted.
    #   @return [Array<Types::UnsuccessfulItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcEndpointsResult AWS API Documentation
    #
    class DeleteVpcEndpointsResult < Struct.new(
      :unsuccessful)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteVpcPeeringConnectionRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         vpc_peering_connection_id: "VpcPeeringConnectionId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_peering_connection_id
    #   The ID of the VPC peering connection.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnectionRequest AWS API Documentation
    #
    class DeleteVpcPeeringConnectionRequest < Struct.new(
      :dry_run,
      :vpc_peering_connection_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcPeeringConnectionResult AWS API Documentation
    #
    class DeleteVpcPeeringConnectionResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeleteVpcRequest
    #   data as a hash:
    #
    #       {
    #         vpc_id: "VpcId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpcRequest AWS API Documentation
    #
    class DeleteVpcRequest < Struct.new(
      :vpc_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeleteVpnConnection.
    #
    # @note When making an API call, you may pass DeleteVpnConnectionRequest
    #   data as a hash:
    #
    #       {
    #         vpn_connection_id: "VpnConnectionId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] vpn_connection_id
    #   The ID of the VPN connection.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRequest AWS API Documentation
    #
    class DeleteVpnConnectionRequest < Struct.new(
      :vpn_connection_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeleteVpnConnectionRoute.
    #
    # @note When making an API call, you may pass DeleteVpnConnectionRouteRequest
    #   data as a hash:
    #
    #       {
    #         destination_cidr_block: "String", # required
    #         vpn_connection_id: "VpnConnectionId", # required
    #       }
    #
    # @!attribute [rw] destination_cidr_block
    #   The CIDR block associated with the local subnet of the customer
    #   network.
    #   @return [String]
    #
    # @!attribute [rw] vpn_connection_id
    #   The ID of the VPN connection.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnConnectionRouteRequest AWS API Documentation
    #
    class DeleteVpnConnectionRouteRequest < Struct.new(
      :destination_cidr_block,
      :vpn_connection_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeleteVpnGateway.
    #
    # @note When making an API call, you may pass DeleteVpnGatewayRequest
    #   data as a hash:
    #
    #       {
    #         vpn_gateway_id: "VpnGatewayId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] vpn_gateway_id
    #   The ID of the virtual private gateway.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteVpnGatewayRequest AWS API Documentation
    #
    class DeleteVpnGatewayRequest < Struct.new(
      :vpn_gateway_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeprovisionByoipCidrRequest
    #   data as a hash:
    #
    #       {
    #         cidr: "String", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] cidr
    #   The address range, in CIDR notation. The prefix must be the same
    #   prefix that you specified when you provisioned the address range.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidrRequest AWS API Documentation
    #
    class DeprovisionByoipCidrRequest < Struct.new(
      :cidr,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] byoip_cidr
    #   Information about the address range.
    #   @return [Types::ByoipCidr]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeprovisionByoipCidrResult AWS API Documentation
    #
    class DeprovisionByoipCidrResult < Struct.new(
      :byoip_cidr)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DeregisterImage.
    #
    # @note When making an API call, you may pass DeregisterImageRequest
    #   data as a hash:
    #
    #       {
    #         image_id: "ImageId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] image_id
    #   The ID of the AMI.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterImageRequest AWS API Documentation
    #
    class DeregisterImageRequest < Struct.new(
      :image_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeregisterInstanceEventNotificationAttributesRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         instance_tag_attribute: {
    #           include_all_tags_of_instance: false,
    #           instance_tag_keys: ["String"],
    #         },
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_tag_attribute
    #   Information about the tag keys to deregister.
    #   @return [Types::DeregisterInstanceTagAttributeRequest]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceEventNotificationAttributesRequest AWS API Documentation
    #
    class DeregisterInstanceEventNotificationAttributesRequest < Struct.new(
      :dry_run,
      :instance_tag_attribute)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_tag_attribute
    #   The resulting set of tag keys.
    #   @return [Types::InstanceTagNotificationAttribute]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceEventNotificationAttributesResult AWS API Documentation
    #
    class DeregisterInstanceEventNotificationAttributesResult < Struct.new(
      :instance_tag_attribute)
      SENSITIVE = []
      include Aws::Structure
    end

    # Information about the tag keys to deregister for the current Region.
    # You can either specify individual tag keys or deregister all tag keys
    # in the current Region. You must specify either
    # `IncludeAllTagsOfInstance` or `InstanceTagKeys` in the request
    #
    # @note When making an API call, you may pass DeregisterInstanceTagAttributeRequest
    #   data as a hash:
    #
    #       {
    #         include_all_tags_of_instance: false,
    #         instance_tag_keys: ["String"],
    #       }
    #
    # @!attribute [rw] include_all_tags_of_instance
    #   Indicates whether to deregister all tag keys in the current Region.
    #   Specify `false` to deregister all tag keys.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_tag_keys
    #   Information about the tag keys to deregister.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterInstanceTagAttributeRequest AWS API Documentation
    #
    class DeregisterInstanceTagAttributeRequest < Struct.new(
      :include_all_tags_of_instance,
      :instance_tag_keys)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeregisterTransitGatewayMulticastGroupMembersRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_multicast_domain_id: "TransitGatewayMulticastDomainId",
    #         group_ip_address: "String",
    #         network_interface_ids: ["NetworkInterfaceId"],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #   @return [String]
    #
    # @!attribute [rw] group_ip_address
    #   The IP address assigned to the transit gateway multicast group.
    #   @return [String]
    #
    # @!attribute [rw] network_interface_ids
    #   The IDs of the group members' network interfaces.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupMembersRequest AWS API Documentation
    #
    class DeregisterTransitGatewayMulticastGroupMembersRequest < Struct.new(
      :transit_gateway_multicast_domain_id,
      :group_ip_address,
      :network_interface_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] deregistered_multicast_group_members
    #   Information about the deregistered members.
    #   @return [Types::TransitGatewayMulticastDeregisteredGroupMembers]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupMembersResult AWS API Documentation
    #
    class DeregisterTransitGatewayMulticastGroupMembersResult < Struct.new(
      :deregistered_multicast_group_members)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DeregisterTransitGatewayMulticastGroupSourcesRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_multicast_domain_id: "TransitGatewayMulticastDomainId",
    #         group_ip_address: "String",
    #         network_interface_ids: ["NetworkInterfaceId"],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #   @return [String]
    #
    # @!attribute [rw] group_ip_address
    #   The IP address assigned to the transit gateway multicast group.
    #   @return [String]
    #
    # @!attribute [rw] network_interface_ids
    #   The IDs of the group sources' network interfaces.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupSourcesRequest AWS API Documentation
    #
    class DeregisterTransitGatewayMulticastGroupSourcesRequest < Struct.new(
      :transit_gateway_multicast_domain_id,
      :group_ip_address,
      :network_interface_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] deregistered_multicast_group_sources
    #   Information about the deregistered group sources.
    #   @return [Types::TransitGatewayMulticastDeregisteredGroupSources]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeregisterTransitGatewayMulticastGroupSourcesResult AWS API Documentation
    #
    class DeregisterTransitGatewayMulticastGroupSourcesResult < Struct.new(
      :deregistered_multicast_group_sources)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeAccountAttributesRequest
    #   data as a hash:
    #
    #       {
    #         attribute_names: ["supported-platforms"], # accepts supported-platforms, default-vpc
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] attribute_names
    #   The account attribute names.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributesRequest AWS API Documentation
    #
    class DescribeAccountAttributesRequest < Struct.new(
      :attribute_names,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] account_attributes
    #   Information about the account attributes.
    #   @return [Array<Types::AccountAttribute>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAccountAttributesResult AWS API Documentation
    #
    class DescribeAccountAttributesResult < Struct.new(
      :account_attributes)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeAddressesAttributeRequest
    #   data as a hash:
    #
    #       {
    #         allocation_ids: ["AllocationId"],
    #         attribute: "domain-name", # accepts domain-name
    #         next_token: "NextToken",
    #         max_results: 1,
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] allocation_ids
    #   \[EC2-VPC\] The allocation IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] attribute
    #   The attribute of the IP address.
    #   @return [String]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesAttributeRequest AWS API Documentation
    #
    class DescribeAddressesAttributeRequest < Struct.new(
      :allocation_ids,
      :attribute,
      :next_token,
      :max_results,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] addresses
    #   Information about the IP addresses.
    #   @return [Array<Types::AddressAttribute>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesAttributeResult AWS API Documentation
    #
    class DescribeAddressesAttributeResult < Struct.new(
      :addresses,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeAddressesRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         public_ips: ["String"],
    #         allocation_ids: ["AllocationId"],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `allocation-id` - \[EC2-VPC\] The allocation ID for the address.
    #
    #   * `association-id` - \[EC2-VPC\] The association ID for the address.
    #
    #   * `domain` - Indicates whether the address is for use in EC2-Classic
    #     (`standard`) or in a VPC (`vpc`).
    #
    #   * `instance-id` - The ID of the instance the address is associated
    #     with, if any.
    #
    #   * `network-border-group` - A unique set of Availability Zones, Local
    #     Zones, or Wavelength Zones from where AWS advertises IP addresses.
    #
    #   * `network-interface-id` - \[EC2-VPC\] The ID of the network
    #     interface that the address is associated with, if any.
    #
    #   * `network-interface-owner-id` - The AWS account ID of the owner.
    #
    #   * `private-ip-address` - \[EC2-VPC\] The private IP address
    #     associated with the Elastic IP address.
    #
    #   * `public-ip` - The Elastic IP address, or the carrier IP address.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] public_ips
    #   One or more Elastic IP addresses.
    #
    #   Default: Describes all your Elastic IP addresses.
    #   @return [Array<String>]
    #
    # @!attribute [rw] allocation_ids
    #   \[EC2-VPC\] Information about the allocation IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesRequest AWS API Documentation
    #
    class DescribeAddressesRequest < Struct.new(
      :filters,
      :public_ips,
      :allocation_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] addresses
    #   Information about the Elastic IP addresses.
    #   @return [Array<Types::Address>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAddressesResult AWS API Documentation
    #
    class DescribeAddressesResult < Struct.new(
      :addresses)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeAggregateIdFormatRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAggregateIdFormatRequest AWS API Documentation
    #
    class DescribeAggregateIdFormatRequest < Struct.new(
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] use_long_ids_aggregated
    #   Indicates whether all resource types in the Region are configured to
    #   use longer IDs. This value is only `true` if all users are
    #   configured to use longer IDs for all resources types in the Region.
    #   @return [Boolean]
    #
    # @!attribute [rw] statuses
    #   Information about each resource's ID format.
    #   @return [Array<Types::IdFormat>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAggregateIdFormatResult AWS API Documentation
    #
    class DescribeAggregateIdFormatResult < Struct.new(
      :use_long_ids_aggregated,
      :statuses)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeAvailabilityZonesRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         zone_names: ["String"],
    #         zone_ids: ["String"],
    #         all_availability_zones: false,
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `group-name` - For Availability Zones, use the Region name. For
    #     Local Zones, use the name of the group associated with the Local
    #     Zone (for example, `us-west-2-lax-1`) For Wavelength Zones, use
    #     the name of the group associated with the Wavelength Zone (for
    #     example, `us-east-1-wl1-bos-wlz-1`).
    #
    #   * `message` - The Zone message.
    #
    #   * `opt-in-status` - The opt-in status (`opted-in`, and
    #     `not-opted-in` \| `opt-in-not-required`).
    #
    #   * `parent-zoneID` - The ID of the zone that handles some of the
    #     Local Zone and Wavelength Zone control plane operations, such as
    #     API calls.
    #
    #   * `parent-zoneName` - The ID of the zone that handles some of the
    #     Local Zone and Wavelength Zone control plane operations, such as
    #     API calls.
    #
    #   * `region-name` - The name of the Region for the Zone (for example,
    #     `us-east-1`).
    #
    #   * `state` - The state of the Availability Zone, the Local Zone, or
    #     the Wavelength Zone (`available` \| `information` \| `impaired` \|
    #     `unavailable`).
    #
    #   * `zone-id` - The ID of the Availability Zone (for example,
    #     `use1-az1`), the Local Zone (for example, `usw2-lax1-az1`), or the
    #     Wavelength Zone (for example, `us-east-1-wl1-bos-wlz-1`).
    #
    #   * `zone-type` - The type of zone, for example, `local-zone`.
    #
    #   * `zone-name` - The name of the Availability Zone (for example,
    #     `us-east-1a`), the Local Zone (for example, `us-west-2-lax-1a`),
    #     or the Wavelength Zone (for example, `us-east-1-wl1-bos-wlz-1`).
    #
    #   * `zone-type` - The type of zone, for example, `local-zone`.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] zone_names
    #   The names of the Availability Zones, Local Zones, and Wavelength
    #   Zones.
    #   @return [Array<String>]
    #
    # @!attribute [rw] zone_ids
    #   The IDs of the Availability Zones, Local Zones, and Wavelength
    #   Zones.
    #   @return [Array<String>]
    #
    # @!attribute [rw] all_availability_zones
    #   Include all Availability Zones, Local Zones, and Wavelength Zones
    #   regardless of your opt-in status.
    #
    #   If you do not use this parameter, the results include only the zones
    #   for the Regions where you have chosen the option to opt in.
    #   @return [Boolean]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZonesRequest AWS API Documentation
    #
    class DescribeAvailabilityZonesRequest < Struct.new(
      :filters,
      :zone_names,
      :zone_ids,
      :all_availability_zones,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] availability_zones
    #   Information about the Availability Zones, Local Zones, and
    #   Wavelength Zones.
    #   @return [Array<Types::AvailabilityZone>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeAvailabilityZonesResult AWS API Documentation
    #
    class DescribeAvailabilityZonesResult < Struct.new(
      :availability_zones)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeBundleTasksRequest
    #   data as a hash:
    #
    #       {
    #         bundle_ids: ["BundleId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] bundle_ids
    #   The bundle task IDs.
    #
    #   Default: Describes all your bundle tasks.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `bundle-id` - The ID of the bundle task.
    #
    #   * `error-code` - If the task failed, the error code returned.
    #
    #   * `error-message` - If the task failed, the error message returned.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `progress` - The level of task completion, as a percentage (for
    #     example, 20%).
    #
    #   * `s3-bucket` - The Amazon S3 bucket to store the AMI.
    #
    #   * `s3-prefix` - The beginning of the AMI name.
    #
    #   * `start-time` - The time the task started (for example,
    #     2013-09-15T17:15:20.000Z).
    #
    #   * `state` - The state of the task (`pending` \|
    #     `waiting-for-shutdown` \| `bundling` \| `storing` \| `cancelling`
    #     \| `complete` \| `failed`).
    #
    #   * `update-time` - The time of the most recent update for the task.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasksRequest AWS API Documentation
    #
    class DescribeBundleTasksRequest < Struct.new(
      :bundle_ids,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] bundle_tasks
    #   Information about the bundle tasks.
    #   @return [Array<Types::BundleTask>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeBundleTasksResult AWS API Documentation
    #
    class DescribeBundleTasksResult < Struct.new(
      :bundle_tasks)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeByoipCidrsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         max_results: 1, # required
    #         next_token: "NextToken",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrsRequest AWS API Documentation
    #
    class DescribeByoipCidrsRequest < Struct.new(
      :dry_run,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] byoip_cidrs
    #   Information about your address ranges.
    #   @return [Array<Types::ByoipCidr>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeByoipCidrsResult AWS API Documentation
    #
    class DescribeByoipCidrsResult < Struct.new(
      :byoip_cidrs,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeCapacityReservationsRequest
    #   data as a hash:
    #
    #       {
    #         capacity_reservation_ids: ["CapacityReservationId"],
    #         next_token: "String",
    #         max_results: 1,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] capacity_reservation_ids
    #   The ID of the Capacity Reservation.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned `nextToken` value. This value can be between 5 and
    #   500. If `maxResults` is given a larger value than 500, you receive
    #   an error.
    #   @return [Integer]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `instance-type` - The type of instance for which the Capacity
    #     Reservation reserves capacity.
    #
    #   * `owner-id` - The ID of the AWS account that owns the Capacity
    #     Reservation.
    #
    #   * `availability-zone-id` - The Availability Zone ID of the Capacity
    #     Reservation.
    #
    #   * `instance-platform` - The type of operating system for which the
    #     Capacity Reservation reserves capacity.
    #
    #   * `availability-zone` - The Availability Zone ID of the Capacity
    #     Reservation.
    #
    #   * `tenancy` - Indicates the tenancy of the Capacity Reservation. A
    #     Capacity Reservation can have one of the following tenancy
    #     settings:
    #
    #     * `default` - The Capacity Reservation is created on hardware that
    #       is shared with other AWS accounts.
    #
    #     * `dedicated` - The Capacity Reservation is created on
    #       single-tenant hardware that is dedicated to a single AWS
    #       account.
    #
    #   * `state` - The current state of the Capacity Reservation. A
    #     Capacity Reservation can be in one of the following states:
    #
    #     * `active`- The Capacity Reservation is active and the capacity is
    #       available for your use.
    #
    #     * `expired` - The Capacity Reservation expired automatically at
    #       the date and time specified in your request. The reserved
    #       capacity is no longer available for your use.
    #
    #     * `cancelled` - The Capacity Reservation was cancelled. The
    #       reserved capacity is no longer available for your use.
    #
    #     * `pending` - The Capacity Reservation request was successful but
    #       the capacity provisioning is still pending.
    #
    #     * `failed` - The Capacity Reservation request has failed. A
    #       request might fail due to invalid request parameters, capacity
    #       constraints, or instance limit constraints. Failed requests are
    #       retained for 60 minutes.
    #
    #   * `end-date` - The date and time at which the Capacity Reservation
    #     expires. When a Capacity Reservation expires, the reserved
    #     capacity is released and you can no longer launch instances into
    #     it. The Capacity Reservation's state changes to expired when it
    #     reaches its end date and time.
    #
    #   * `end-date-type` - Indicates the way in which the Capacity
    #     Reservation ends. A Capacity Reservation can have one of the
    #     following end types:
    #
    #     * `unlimited` - The Capacity Reservation remains active until you
    #       explicitly cancel it.
    #
    #     * `limited` - The Capacity Reservation expires automatically at a
    #       specified date and time.
    #
    #   * `instance-match-criteria` - Indicates the type of instance
    #     launches that the Capacity Reservation accepts. The options
    #     include:
    #
    #     * `open` - The Capacity Reservation accepts all instances that
    #       have matching attributes (instance type, platform, and
    #       Availability Zone). Instances that have matching attributes
    #       launch into the Capacity Reservation automatically without
    #       specifying any additional parameters.
    #
    #     * `targeted` - The Capacity Reservation only accepts instances
    #       that have matching attributes (instance type, platform, and
    #       Availability Zone), and explicitly target the Capacity
    #       Reservation. This ensures that only permitted instances can use
    #       the reserved capacity.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationsRequest AWS API Documentation
    #
    class DescribeCapacityReservationsRequest < Struct.new(
      :capacity_reservation_ids,
      :next_token,
      :max_results,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] capacity_reservations
    #   Information about the Capacity Reservations.
    #   @return [Array<Types::CapacityReservation>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCapacityReservationsResult AWS API Documentation
    #
    class DescribeCapacityReservationsResult < Struct.new(
      :next_token,
      :capacity_reservations)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeCarrierGatewaysRequest
    #   data as a hash:
    #
    #       {
    #         carrier_gateway_ids: ["CarrierGatewayId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] carrier_gateway_ids
    #   One or more carrier gateway IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `carrier-gateway-id` - The ID of the carrier gateway.
    #
    #   * `state` - The state of the carrier gateway (`pending` \| `failed`
    #     \| `available` \| `deleting` \| `deleted`).
    #
    #   * `owner-id` - The AWS account ID of the owner of the carrier
    #     gateway.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC associated with the carrier gateway.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCarrierGatewaysRequest AWS API Documentation
    #
    class DescribeCarrierGatewaysRequest < Struct.new(
      :carrier_gateway_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] carrier_gateways
    #   Information about the carrier gateway.
    #   @return [Array<Types::CarrierGateway>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCarrierGatewaysResult AWS API Documentation
    #
    class DescribeCarrierGatewaysResult < Struct.new(
      :carrier_gateways,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeClassicLinkInstancesRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         dry_run: false,
    #         instance_ids: ["InstanceId"],
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `group-id` - The ID of a VPC security group that's associated
    #     with the instance.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC to which the instance is linked.
    #
    #     `vpc-id` - The ID of the VPC that the instance is linked to.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_ids
    #   One or more instance IDs. Must be instances linked to a VPC through
    #   ClassicLink.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #
    #   Constraint: If the value is greater than 1000, we return only 1000
    #   items.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstancesRequest AWS API Documentation
    #
    class DescribeClassicLinkInstancesRequest < Struct.new(
      :filters,
      :dry_run,
      :instance_ids,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instances
    #   Information about one or more linked EC2-Classic instances.
    #   @return [Array<Types::ClassicLinkInstance>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClassicLinkInstancesResult AWS API Documentation
    #
    class DescribeClassicLinkInstancesResult < Struct.new(
      :instances,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeClientVpnAuthorizationRulesRequest
    #   data as a hash:
    #
    #       {
    #         client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #         dry_run: false,
    #         next_token: "NextToken",
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #       }
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `description` - The description of the authorization rule.
    #
    #   * `destination-cidr` - The CIDR of the network to which the
    #     authorization rule applies.
    #
    #   * `group-id` - The ID of the Active Directory group to which the
    #     authorization rule grants access.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnAuthorizationRulesRequest AWS API Documentation
    #
    class DescribeClientVpnAuthorizationRulesRequest < Struct.new(
      :client_vpn_endpoint_id,
      :dry_run,
      :next_token,
      :filters,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] authorization_rules
    #   Information about the authorization rules.
    #   @return [Array<Types::AuthorizationRule>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnAuthorizationRulesResult AWS API Documentation
    #
    class DescribeClientVpnAuthorizationRulesResult < Struct.new(
      :authorization_rules,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeClientVpnConnectionsRequest
    #   data as a hash:
    #
    #       {
    #         client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         next_token: "NextToken",
    #         max_results: 1,
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `connection-id` - The ID of the connection.
    #
    #   * `username` - For Active Directory client authentication, the user
    #     name of the client who established the client connection.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnConnectionsRequest AWS API Documentation
    #
    class DescribeClientVpnConnectionsRequest < Struct.new(
      :client_vpn_endpoint_id,
      :filters,
      :next_token,
      :max_results,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] connections
    #   Information about the active and terminated client connections.
    #   @return [Array<Types::ClientVpnConnection>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnConnectionsResult AWS API Documentation
    #
    class DescribeClientVpnConnectionsResult < Struct.new(
      :connections,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeClientVpnEndpointsRequest
    #   data as a hash:
    #
    #       {
    #         client_vpn_endpoint_ids: ["ClientVpnEndpointId"],
    #         max_results: 1,
    #         next_token: "NextToken",
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] client_vpn_endpoint_ids
    #   The ID of the Client VPN endpoint.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `endpoint-id` - The ID of the Client VPN endpoint.
    #
    #   * `transport-protocol` - The transport protocol (`tcp` \| `udp`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnEndpointsRequest AWS API Documentation
    #
    class DescribeClientVpnEndpointsRequest < Struct.new(
      :client_vpn_endpoint_ids,
      :max_results,
      :next_token,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_endpoints
    #   Information about the Client VPN endpoints.
    #   @return [Array<Types::ClientVpnEndpoint>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnEndpointsResult AWS API Documentation
    #
    class DescribeClientVpnEndpointsResult < Struct.new(
      :client_vpn_endpoints,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeClientVpnRoutesRequest
    #   data as a hash:
    #
    #       {
    #         client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "NextToken",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `destination-cidr` - The CIDR of the route destination.
    #
    #   * `origin` - How the route was associated with the Client VPN
    #     endpoint (`associate` \| `add-route`).
    #
    #   * `target-subnet` - The ID of the subnet through which traffic is
    #     routed.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnRoutesRequest AWS API Documentation
    #
    class DescribeClientVpnRoutesRequest < Struct.new(
      :client_vpn_endpoint_id,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] routes
    #   Information about the Client VPN endpoint routes.
    #   @return [Array<Types::ClientVpnRoute>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnRoutesResult AWS API Documentation
    #
    class DescribeClientVpnRoutesResult < Struct.new(
      :routes,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeClientVpnTargetNetworksRequest
    #   data as a hash:
    #
    #       {
    #         client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #         association_ids: ["String"],
    #         max_results: 1,
    #         next_token: "NextToken",
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint.
    #   @return [String]
    #
    # @!attribute [rw] association_ids
    #   The IDs of the target network associations.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the nextToken value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `association-id` - The ID of the association.
    #
    #   * `target-network-id` - The ID of the subnet specified as the target
    #     network.
    #
    #   * `vpc-id` - The ID of the VPC in which the target network is
    #     located.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnTargetNetworksRequest AWS API Documentation
    #
    class DescribeClientVpnTargetNetworksRequest < Struct.new(
      :client_vpn_endpoint_id,
      :association_ids,
      :max_results,
      :next_token,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] client_vpn_target_networks
    #   Information about the associated target networks.
    #   @return [Array<Types::TargetNetwork>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeClientVpnTargetNetworksResult AWS API Documentation
    #
    class DescribeClientVpnTargetNetworksResult < Struct.new(
      :client_vpn_target_networks,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeCoipPoolsRequest
    #   data as a hash:
    #
    #       {
    #         pool_ids: ["CoipPoolId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] pool_ids
    #   The IDs of the address pools.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   The filters. The following are the possible values:
    #
    #   * `coip-pool.pool-id`
    #
    #   ^
    #   ^
    #
    #   * `coip-pool.local-gateway-route-table-id`
    #
    #   ^
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCoipPoolsRequest AWS API Documentation
    #
    class DescribeCoipPoolsRequest < Struct.new(
      :pool_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] coip_pools
    #   Information about the address pools.
    #   @return [Array<Types::CoipPool>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCoipPoolsResult AWS API Documentation
    #
    class DescribeCoipPoolsResult < Struct.new(
      :coip_pools,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeConversionTasksRequest
    #   data as a hash:
    #
    #       {
    #         conversion_task_ids: ["ConversionTaskId"],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] conversion_task_ids
    #   The conversion task IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasksRequest AWS API Documentation
    #
    class DescribeConversionTasksRequest < Struct.new(
      :conversion_task_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] conversion_tasks
    #   Information about the conversion tasks.
    #   @return [Array<Types::ConversionTask>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeConversionTasksResult AWS API Documentation
    #
    class DescribeConversionTasksResult < Struct.new(
      :conversion_tasks)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeCustomerGateways.
    #
    # @note When making an API call, you may pass DescribeCustomerGatewaysRequest
    #   data as a hash:
    #
    #       {
    #         customer_gateway_ids: ["CustomerGatewayId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] customer_gateway_ids
    #   One or more customer gateway IDs.
    #
    #   Default: Describes all your customer gateways.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `bgp-asn` - The customer gateway's Border Gateway Protocol (BGP)
    #     Autonomous System Number (ASN).
    #
    #   * `customer-gateway-id` - The ID of the customer gateway.
    #
    #   * `ip-address` - The IP address of the customer gateway's
    #     Internet-routable external interface.
    #
    #   * `state` - The state of the customer gateway (`pending` \|
    #     `available` \| `deleting` \| `deleted`).
    #
    #   * `type` - The type of customer gateway. Currently, the only
    #     supported type is `ipsec.1`.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGatewaysRequest AWS API Documentation
    #
    class DescribeCustomerGatewaysRequest < Struct.new(
      :customer_gateway_ids,
      :filters,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeCustomerGateways.
    #
    # @!attribute [rw] customer_gateways
    #   Information about one or more customer gateways.
    #   @return [Array<Types::CustomerGateway>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeCustomerGatewaysResult AWS API Documentation
    #
    class DescribeCustomerGatewaysResult < Struct.new(
      :customer_gateways)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeDhcpOptionsRequest
    #   data as a hash:
    #
    #       {
    #         dhcp_options_ids: ["DhcpOptionsId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         dry_run: false,
    #         next_token: "String",
    #         max_results: 1,
    #       }
    #
    # @!attribute [rw] dhcp_options_ids
    #   The IDs of one or more DHCP options sets.
    #
    #   Default: Describes all your DHCP options sets.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `dhcp-options-id` - The ID of a DHCP options set.
    #
    #   * `key` - The key for one of the options (for example,
    #     `domain-name`).
    #
    #   * `value` - The value for one of the options.
    #
    #   * `owner-id` - The ID of the AWS account that owns the DHCP options
    #     set.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptionsRequest AWS API Documentation
    #
    class DescribeDhcpOptionsRequest < Struct.new(
      :dhcp_options_ids,
      :filters,
      :dry_run,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] dhcp_options
    #   Information about one or more DHCP options sets.
    #   @return [Array<Types::DhcpOptions>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeDhcpOptionsResult AWS API Documentation
    #
    class DescribeDhcpOptionsResult < Struct.new(
      :dhcp_options,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeEgressOnlyInternetGatewaysRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         egress_only_internet_gateway_ids: ["EgressOnlyInternetGatewayId"],
    #         max_results: 1,
    #         next_token: "String",
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] egress_only_internet_gateway_ids
    #   One or more egress-only internet gateway IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGatewaysRequest AWS API Documentation
    #
    class DescribeEgressOnlyInternetGatewaysRequest < Struct.new(
      :dry_run,
      :egress_only_internet_gateway_ids,
      :max_results,
      :next_token,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] egress_only_internet_gateways
    #   Information about the egress-only internet gateways.
    #   @return [Array<Types::EgressOnlyInternetGateway>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeEgressOnlyInternetGatewaysResult AWS API Documentation
    #
    class DescribeEgressOnlyInternetGatewaysResult < Struct.new(
      :egress_only_internet_gateways,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeElasticGpusRequest
    #   data as a hash:
    #
    #       {
    #         elastic_gpu_ids: ["ElasticGpuId"],
    #         dry_run: false,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] elastic_gpu_ids
    #   The Elastic Graphics accelerator IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `availability-zone` - The Availability Zone in which the Elastic
    #     Graphics accelerator resides.
    #
    #   * `elastic-gpu-health` - The status of the Elastic Graphics
    #     accelerator (`OK` \| `IMPAIRED`).
    #
    #   * `elastic-gpu-state` - The state of the Elastic Graphics
    #     accelerator (`ATTACHED`).
    #
    #   * `elastic-gpu-type` - The type of Elastic Graphics accelerator; for
    #     example, `eg1.medium`.
    #
    #   * `instance-id` - The ID of the instance to which the Elastic
    #     Graphics accelerator is associated.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `NextToken` value. This value can be between 5 and 1000.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to request the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeElasticGpusRequest AWS API Documentation
    #
    class DescribeElasticGpusRequest < Struct.new(
      :elastic_gpu_ids,
      :dry_run,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] elastic_gpu_set
    #   Information about the Elastic Graphics accelerators.
    #   @return [Array<Types::ElasticGpus>]
    #
    # @!attribute [rw] max_results
    #   The total number of items to return. If the total number of items
    #   available is more than the value specified in max-items then a
    #   Next-Token will be provided in the output that you can use to resume
    #   pagination.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeElasticGpusResult AWS API Documentation
    #
    class DescribeElasticGpusResult < Struct.new(
      :elastic_gpu_set,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeExportImageTasksRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         export_image_task_ids: ["ExportImageTaskId"],
    #         max_results: 1,
    #         next_token: "NextToken",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   Filter tasks using the `task-state` filter and one of the following
    #   values: `active`, `completed`, `deleting`, or `deleted`.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] export_image_task_ids
    #   The IDs of the export image tasks.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   A token that indicates the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportImageTasksRequest AWS API Documentation
    #
    class DescribeExportImageTasksRequest < Struct.new(
      :dry_run,
      :filters,
      :export_image_task_ids,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] export_image_tasks
    #   Information about the export image tasks.
    #   @return [Array<Types::ExportImageTask>]
    #
    # @!attribute [rw] next_token
    #   The token to use to get the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportImageTasksResult AWS API Documentation
    #
    class DescribeExportImageTasksResult < Struct.new(
      :export_image_tasks,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeExportTasksRequest
    #   data as a hash:
    #
    #       {
    #         export_task_ids: ["ExportTaskId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] export_task_ids
    #   The export task IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   the filters for the export tasks.
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasksRequest AWS API Documentation
    #
    class DescribeExportTasksRequest < Struct.new(
      :export_task_ids,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] export_tasks
    #   Information about the export tasks.
    #   @return [Array<Types::ExportTask>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeExportTasksResult AWS API Documentation
    #
    class DescribeExportTasksResult < Struct.new(
      :export_tasks)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes fast snapshot restores for a snapshot.
    #
    # @!attribute [rw] snapshot_id
    #   The ID of the snapshot.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The state of fast snapshot restores.
    #   @return [String]
    #
    # @!attribute [rw] state_transition_reason
    #   The reason for the state transition. The possible values are as
    #   follows:
    #
    #   * `Client.UserInitiated` - The state successfully transitioned to
    #     `enabling` or `disabling`.
    #
    #   * `Client.UserInitiated - Lifecycle state transition` - The state
    #     successfully transitioned to `optimizing`, `enabled`, or
    #     `disabled`.
    #   @return [String]
    #
    # @!attribute [rw] owner_id
    #   The ID of the AWS account that enabled fast snapshot restores on the
    #   snapshot.
    #   @return [String]
    #
    # @!attribute [rw] owner_alias
    #   The AWS owner alias that enabled fast snapshot restores on the
    #   snapshot. This is intended for future use.
    #   @return [String]
    #
    # @!attribute [rw] enabling_time
    #   The time at which fast snapshot restores entered the `enabling`
    #   state.
    #   @return [Time]
    #
    # @!attribute [rw] optimizing_time
    #   The time at which fast snapshot restores entered the `optimizing`
    #   state.
    #   @return [Time]
    #
    # @!attribute [rw] enabled_time
    #   The time at which fast snapshot restores entered the `enabled`
    #   state.
    #   @return [Time]
    #
    # @!attribute [rw] disabling_time
    #   The time at which fast snapshot restores entered the `disabling`
    #   state.
    #   @return [Time]
    #
    # @!attribute [rw] disabled_time
    #   The time at which fast snapshot restores entered the `disabled`
    #   state.
    #   @return [Time]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastSnapshotRestoreSuccessItem AWS API Documentation
    #
    class DescribeFastSnapshotRestoreSuccessItem < Struct.new(
      :snapshot_id,
      :availability_zone,
      :state,
      :state_transition_reason,
      :owner_id,
      :owner_alias,
      :enabling_time,
      :optimizing_time,
      :enabled_time,
      :disabling_time,
      :disabled_time)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeFastSnapshotRestoresRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "NextToken",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] filters
    #   The filters. The possible values are:
    #
    #   * `availability-zone`\: The Availability Zone of the snapshot.
    #
    #   * `owner-id`\: The ID of the AWS account that enabled fast snapshot
    #     restore on the snapshot.
    #
    #   * `snapshot-id`\: The ID of the snapshot.
    #
    #   * `state`\: The state of fast snapshot restores for the snapshot
    #     (`enabling` \| `optimizing` \| `enabled` \| `disabling` \|
    #     `disabled`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastSnapshotRestoresRequest AWS API Documentation
    #
    class DescribeFastSnapshotRestoresRequest < Struct.new(
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] fast_snapshot_restores
    #   Information about the state of fast snapshot restores.
    #   @return [Array<Types::DescribeFastSnapshotRestoreSuccessItem>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFastSnapshotRestoresResult AWS API Documentation
    #
    class DescribeFastSnapshotRestoresResult < Struct.new(
      :fast_snapshot_restores,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the instances that could not be launched by the fleet.
    #
    # @!attribute [rw] launch_template_and_overrides
    #   The launch templates and overrides that were used for launching the
    #   instances. The values that you specify in the Overrides replace the
    #   values in the launch template.
    #   @return [Types::LaunchTemplateAndOverridesResponse]
    #
    # @!attribute [rw] lifecycle
    #   Indicates if the instance that could not be launched was a Spot
    #   Instance or On-Demand Instance.
    #   @return [String]
    #
    # @!attribute [rw] error_code
    #   The error code that indicates why the instance could not be
    #   launched. For more information about error codes, see [Error
    #   Codes][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html
    #   @return [String]
    #
    # @!attribute [rw] error_message
    #   The error message that describes why the instance could not be
    #   launched. For more information about error messages, see [Error
    #   Codes][1].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetError AWS API Documentation
    #
    class DescribeFleetError < Struct.new(
      :launch_template_and_overrides,
      :lifecycle,
      :error_code,
      :error_message)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeFleetHistoryRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         event_type: "instance-change", # accepts instance-change, fleet-change, service-error
    #         max_results: 1,
    #         next_token: "String",
    #         fleet_id: "FleetId", # required
    #         start_time: Time.now, # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] event_type
    #   The type of events to describe. By default, all events are
    #   described.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next set of results.
    #   @return [String]
    #
    # @!attribute [rw] fleet_id
    #   The ID of the EC2 Fleet.
    #   @return [String]
    #
    # @!attribute [rw] start_time
    #   The start date and time for the events, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z).
    #   @return [Time]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetHistoryRequest AWS API Documentation
    #
    class DescribeFleetHistoryRequest < Struct.new(
      :dry_run,
      :event_type,
      :max_results,
      :next_token,
      :fleet_id,
      :start_time)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] history_records
    #   Information about the events in the history of the EC2 Fleet.
    #   @return [Array<Types::HistoryRecordEntry>]
    #
    # @!attribute [rw] last_evaluated_time
    #   The last date and time for the events, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z). All records up to this time
    #   were retrieved.
    #
    #   If `nextToken` indicates that there are more results, this value is
    #   not present.
    #   @return [Time]
    #
    # @!attribute [rw] next_token
    #   The token for the next set of results.
    #   @return [String]
    #
    # @!attribute [rw] fleet_id
    #   The ID of the EC Fleet.
    #   @return [String]
    #
    # @!attribute [rw] start_time
    #   The start date and time for the events, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z).
    #   @return [Time]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetHistoryResult AWS API Documentation
    #
    class DescribeFleetHistoryResult < Struct.new(
      :history_records,
      :last_evaluated_time,
      :next_token,
      :fleet_id,
      :start_time)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeFleetInstancesRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         max_results: 1,
    #         next_token: "String",
    #         fleet_id: "FleetId", # required
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next set of results.
    #   @return [String]
    #
    # @!attribute [rw] fleet_id
    #   The ID of the EC2 Fleet.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `instance-type` - The instance type.
    #
    #   ^
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetInstancesRequest AWS API Documentation
    #
    class DescribeFleetInstancesRequest < Struct.new(
      :dry_run,
      :max_results,
      :next_token,
      :fleet_id,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] active_instances
    #   The running instances. This list is refreshed periodically and might
    #   be out of date.
    #   @return [Array<Types::ActiveInstance>]
    #
    # @!attribute [rw] next_token
    #   The token for the next set of results.
    #   @return [String]
    #
    # @!attribute [rw] fleet_id
    #   The ID of the EC2 Fleet.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetInstancesResult AWS API Documentation
    #
    class DescribeFleetInstancesResult < Struct.new(
      :active_instances,
      :next_token,
      :fleet_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the instances that were launched by the fleet.
    #
    # @!attribute [rw] launch_template_and_overrides
    #   The launch templates and overrides that were used for launching the
    #   instances. The values that you specify in the Overrides replace the
    #   values in the launch template.
    #   @return [Types::LaunchTemplateAndOverridesResponse]
    #
    # @!attribute [rw] lifecycle
    #   Indicates if the instance that was launched is a Spot Instance or
    #   On-Demand Instance.
    #   @return [String]
    #
    # @!attribute [rw] instance_ids
    #   The IDs of the instances.
    #   @return [Array<String>]
    #
    # @!attribute [rw] instance_type
    #   The instance type.
    #   @return [String]
    #
    # @!attribute [rw] platform
    #   The value is `Windows` for Windows instances. Otherwise, the value
    #   is blank.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetsInstances AWS API Documentation
    #
    class DescribeFleetsInstances < Struct.new(
      :launch_template_and_overrides,
      :lifecycle,
      :instance_ids,
      :instance_type,
      :platform)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeFleetsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         max_results: 1,
    #         next_token: "String",
    #         fleet_ids: ["FleetId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next set of results.
    #   @return [String]
    #
    # @!attribute [rw] fleet_ids
    #   The ID of the EC2 Fleets.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `activity-status` - The progress of the EC2 Fleet ( `error` \|
    #     `pending-fulfillment` \| `pending-termination` \| `fulfilled`).
    #
    #   * `excess-capacity-termination-policy` - Indicates whether to
    #     terminate running instances if the target capacity is decreased
    #     below the current EC2 Fleet size (`true` \| `false`).
    #
    #   * `fleet-state` - The state of the EC2 Fleet (`submitted` \|
    #     `active` \| `deleted` \| `failed` \| `deleted-running` \|
    #     `deleted-terminating` \| `modifying`).
    #
    #   * `replace-unhealthy-instances` - Indicates whether EC2 Fleet should
    #     replace unhealthy instances (`true` \| `false`).
    #
    #   * `type` - The type of request (`instant` \| `request` \|
    #     `maintain`).
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetsRequest AWS API Documentation
    #
    class DescribeFleetsRequest < Struct.new(
      :dry_run,
      :max_results,
      :next_token,
      :fleet_ids,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token for the next set of results.
    #   @return [String]
    #
    # @!attribute [rw] fleets
    #   Information about the EC2 Fleets.
    #   @return [Array<Types::FleetData>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFleetsResult AWS API Documentation
    #
    class DescribeFleetsResult < Struct.new(
      :next_token,
      :fleets)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeFlowLogsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         filter: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         flow_log_ids: ["VpcFlowLogId"],
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filter
    #   One or more filters.
    #
    #   * `deliver-log-status` - The status of the logs delivery (`SUCCESS`
    #     \| `FAILED`).
    #
    #   * `log-destination-type` - The type of destination to which the flow
    #     log publishes data. Possible destination types include
    #     `cloud-watch-logs` and `s3`.
    #
    #   * `flow-log-id` - The ID of the flow log.
    #
    #   * `log-group-name` - The name of the log group.
    #
    #   * `resource-id` - The ID of the VPC, subnet, or network interface.
    #
    #   * `traffic-type` - The type of traffic (`ACCEPT` \| `REJECT` \|
    #     `ALL`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] flow_log_ids
    #   One or more flow log IDs.
    #
    #   Constraint: Maximum of 1000 flow log IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogsRequest AWS API Documentation
    #
    class DescribeFlowLogsRequest < Struct.new(
      :dry_run,
      :filter,
      :flow_log_ids,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] flow_logs
    #   Information about the flow logs.
    #   @return [Array<Types::FlowLog>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFlowLogsResult AWS API Documentation
    #
    class DescribeFlowLogsResult < Struct.new(
      :flow_logs,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeFpgaImageAttributeRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         fpga_image_id: "FpgaImageId", # required
    #         attribute: "description", # required, accepts description, name, loadPermission, productCodes
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] fpga_image_id
    #   The ID of the AFI.
    #   @return [String]
    #
    # @!attribute [rw] attribute
    #   The AFI attribute.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImageAttributeRequest AWS API Documentation
    #
    class DescribeFpgaImageAttributeRequest < Struct.new(
      :dry_run,
      :fpga_image_id,
      :attribute)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] fpga_image_attribute
    #   Information about the attribute.
    #   @return [Types::FpgaImageAttribute]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImageAttributeResult AWS API Documentation
    #
    class DescribeFpgaImageAttributeResult < Struct.new(
      :fpga_image_attribute)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeFpgaImagesRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         fpga_image_ids: ["FpgaImageId"],
    #         owners: ["String"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         next_token: "NextToken",
    #         max_results: 1,
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] fpga_image_ids
    #   The AFI IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] owners
    #   Filters the AFI by owner. Specify an AWS account ID, `self` (owner
    #   is the sender of the request), or an AWS owner alias (valid values
    #   are `amazon` \| `aws-marketplace`).
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `create-time` - The creation time of the AFI.
    #
    #   * `fpga-image-id` - The FPGA image identifier (AFI ID).
    #
    #   * `fpga-image-global-id` - The global FPGA image identifier (AGFI
    #     ID).
    #
    #   * `name` - The name of the AFI.
    #
    #   * `owner-id` - The AWS account ID of the AFI owner.
    #
    #   * `product-code` - The product code.
    #
    #   * `shell-version` - The version of the AWS Shell that was used to
    #     create the bitstream.
    #
    #   * `state` - The state of the AFI (`pending` \| `failed` \|
    #     `available` \| `unavailable`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `update-time` - The time of the most recent update.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImagesRequest AWS API Documentation
    #
    class DescribeFpgaImagesRequest < Struct.new(
      :dry_run,
      :fpga_image_ids,
      :owners,
      :filters,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] fpga_images
    #   Information about the FPGA images.
    #   @return [Array<Types::FpgaImage>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeFpgaImagesResult AWS API Documentation
    #
    class DescribeFpgaImagesResult < Struct.new(
      :fpga_images,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeHostReservationOfferingsRequest
    #   data as a hash:
    #
    #       {
    #         filter: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_duration: 1,
    #         max_results: 1,
    #         min_duration: 1,
    #         next_token: "String",
    #         offering_id: "OfferingId",
    #       }
    #
    # @!attribute [rw] filter
    #   The filters.
    #
    #   * `instance-family` - The instance family of the offering (for
    #     example, `m4`).
    #
    #   * `payment-option` - The payment option (`NoUpfront` \|
    #     `PartialUpfront` \| `AllUpfront`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_duration
    #   This is the maximum duration of the reservation to purchase,
    #   specified in seconds. Reservations are available in one-year and
    #   three-year terms. The number of seconds specified must be the number
    #   of seconds in a year (365x24x60x60) times one of the supported
    #   durations (1 or 3). For example, specify 94608000 for three years.
    #   @return [Integer]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned `nextToken` value. This value can be between 5 and
    #   500. If `maxResults` is given a larger value than 500, you receive
    #   an error.
    #   @return [Integer]
    #
    # @!attribute [rw] min_duration
    #   This is the minimum duration of the reservation you'd like to
    #   purchase, specified in seconds. Reservations are available in
    #   one-year and three-year terms. The number of seconds specified must
    #   be the number of seconds in a year (365x24x60x60) times one of the
    #   supported durations (1 or 3). For example, specify 31536000 for one
    #   year.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] offering_id
    #   The ID of the reservation offering.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferingsRequest AWS API Documentation
    #
    class DescribeHostReservationOfferingsRequest < Struct.new(
      :filter,
      :max_duration,
      :max_results,
      :min_duration,
      :next_token,
      :offering_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] offering_set
    #   Information about the offerings.
    #   @return [Array<Types::HostOffering>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationOfferingsResult AWS API Documentation
    #
    class DescribeHostReservationOfferingsResult < Struct.new(
      :next_token,
      :offering_set)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeHostReservationsRequest
    #   data as a hash:
    #
    #       {
    #         filter: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         host_reservation_id_set: ["HostReservationId"],
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] filter
    #   The filters.
    #
    #   * `instance-family` - The instance family (for example, `m4`).
    #
    #   * `payment-option` - The payment option (`NoUpfront` \|
    #     `PartialUpfront` \| `AllUpfront`).
    #
    #   * `state` - The state of the reservation (`payment-pending` \|
    #     `payment-failed` \| `active` \| `retired`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] host_reservation_id_set
    #   The host reservation IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned `nextToken` value. This value can be between 5 and
    #   500. If `maxResults` is given a larger value than 500, you receive
    #   an error.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationsRequest AWS API Documentation
    #
    class DescribeHostReservationsRequest < Struct.new(
      :filter,
      :host_reservation_id_set,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] host_reservation_set
    #   Details about the reservation's configuration.
    #   @return [Array<Types::HostReservation>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostReservationsResult AWS API Documentation
    #
    class DescribeHostReservationsResult < Struct.new(
      :host_reservation_set,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeHostsRequest
    #   data as a hash:
    #
    #       {
    #         filter: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         host_ids: ["DedicatedHostId"],
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] filter
    #   The filters.
    #
    #   * `auto-placement` - Whether auto-placement is enabled or disabled
    #     (`on` \| `off`).
    #
    #   * `availability-zone` - The Availability Zone of the host.
    #
    #   * `client-token` - The idempotency token that you provided when you
    #     allocated the host.
    #
    #   * `host-reservation-id` - The ID of the reservation assigned to this
    #     host.
    #
    #   * `instance-type` - The instance type size that the Dedicated Host
    #     is configured to support.
    #
    #   * `state` - The allocation state of the Dedicated Host (`available`
    #     \| `under-assessment` \| `permanent-failure` \| `released` \|
    #     `released-permanent-failure`).
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] host_ids
    #   The IDs of the Dedicated Hosts. The IDs are used for targeted
    #   instance launches.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the returned `nextToken` value. This value can be between 5 and
    #   500. If `maxResults` is given a larger value than 500, you receive
    #   an error.
    #
    #   You cannot specify this parameter and the host IDs parameter in the
    #   same request.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostsRequest AWS API Documentation
    #
    class DescribeHostsRequest < Struct.new(
      :filter,
      :host_ids,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] hosts
    #   Information about the Dedicated Hosts.
    #   @return [Array<Types::Host>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeHostsResult AWS API Documentation
    #
    class DescribeHostsResult < Struct.new(
      :hosts,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeIamInstanceProfileAssociationsRequest
    #   data as a hash:
    #
    #       {
    #         association_ids: ["IamInstanceProfileAssociationId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "NextToken",
    #       }
    #
    # @!attribute [rw] association_ids
    #   The IAM instance profile associations.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `state` - The state of the association (`associating` \|
    #     `associated` \| `disassociating`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `NextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to request the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIamInstanceProfileAssociationsRequest AWS API Documentation
    #
    class DescribeIamInstanceProfileAssociationsRequest < Struct.new(
      :association_ids,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] iam_instance_profile_associations
    #   Information about the IAM instance profile associations.
    #   @return [Array<Types::IamInstanceProfileAssociation>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIamInstanceProfileAssociationsResult AWS API Documentation
    #
    class DescribeIamInstanceProfileAssociationsResult < Struct.new(
      :iam_instance_profile_associations,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeIdFormatRequest
    #   data as a hash:
    #
    #       {
    #         resource: "String",
    #       }
    #
    # @!attribute [rw] resource
    #   The type of resource: `bundle` \| `conversion-task` \|
    #   `customer-gateway` \| `dhcp-options` \| `elastic-ip-allocation` \|
    #   `elastic-ip-association` \| `export-task` \| `flow-log` \| `image`
    #   \| `import-task` \| `instance` \| `internet-gateway` \|
    #   `network-acl` \| `network-acl-association` \| `network-interface` \|
    #   `network-interface-attachment` \| `prefix-list` \| `reservation` \|
    #   `route-table` \| `route-table-association` \| `security-group` \|
    #   `snapshot` \| `subnet` \| `subnet-cidr-block-association` \|
    #   `volume` \| `vpc` \| `vpc-cidr-block-association` \| `vpc-endpoint`
    #   \| `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormatRequest AWS API Documentation
    #
    class DescribeIdFormatRequest < Struct.new(
      :resource)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] statuses
    #   Information about the ID format for the resource.
    #   @return [Array<Types::IdFormat>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdFormatResult AWS API Documentation
    #
    class DescribeIdFormatResult < Struct.new(
      :statuses)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeIdentityIdFormatRequest
    #   data as a hash:
    #
    #       {
    #         principal_arn: "String", # required
    #         resource: "String",
    #       }
    #
    # @!attribute [rw] principal_arn
    #   The ARN of the principal, which can be an IAM role, IAM user, or the
    #   root user.
    #   @return [String]
    #
    # @!attribute [rw] resource
    #   The type of resource: `bundle` \| `conversion-task` \|
    #   `customer-gateway` \| `dhcp-options` \| `elastic-ip-allocation` \|
    #   `elastic-ip-association` \| `export-task` \| `flow-log` \| `image`
    #   \| `import-task` \| `instance` \| `internet-gateway` \|
    #   `network-acl` \| `network-acl-association` \| `network-interface` \|
    #   `network-interface-attachment` \| `prefix-list` \| `reservation` \|
    #   `route-table` \| `route-table-association` \| `security-group` \|
    #   `snapshot` \| `subnet` \| `subnet-cidr-block-association` \|
    #   `volume` \| `vpc` \| `vpc-cidr-block-association` \| `vpc-endpoint`
    #   \| `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormatRequest AWS API Documentation
    #
    class DescribeIdentityIdFormatRequest < Struct.new(
      :principal_arn,
      :resource)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] statuses
    #   Information about the ID format for the resources.
    #   @return [Array<Types::IdFormat>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIdentityIdFormatResult AWS API Documentation
    #
    class DescribeIdentityIdFormatResult < Struct.new(
      :statuses)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeImageAttribute.
    #
    # @note When making an API call, you may pass DescribeImageAttributeRequest
    #   data as a hash:
    #
    #       {
    #         attribute: "description", # required, accepts description, kernel, ramdisk, launchPermission, productCodes, blockDeviceMapping, sriovNetSupport
    #         image_id: "ImageId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] attribute
    #   The AMI attribute.
    #
    #   **Note**\: The `blockDeviceMapping` attribute is deprecated. Using
    #   this attribute returns the `Client.AuthFailure` error. To get
    #   information about the block device mappings for an AMI, use the
    #   DescribeImages action.
    #   @return [String]
    #
    # @!attribute [rw] image_id
    #   The ID of the AMI.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImageAttributeRequest AWS API Documentation
    #
    class DescribeImageAttributeRequest < Struct.new(
      :attribute,
      :image_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeImagesRequest
    #   data as a hash:
    #
    #       {
    #         executable_users: ["String"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         image_ids: ["ImageId"],
    #         owners: ["String"],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] executable_users
    #   Scopes the images by users with explicit launch permissions. Specify
    #   an AWS account ID, `self` (the sender of the request), or `all`
    #   (public AMIs).
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `architecture` - The image architecture (`i386` \| `x86_64` \|
    #     `arm64`).
    #
    #   * `block-device-mapping.delete-on-termination` - A Boolean value
    #     that indicates whether the Amazon EBS volume is deleted on
    #     instance termination.
    #
    #   * `block-device-mapping.device-name` - The device name specified in
    #     the block device mapping (for example, `/dev/sdh` or `xvdh`).
    #
    #   * `block-device-mapping.snapshot-id` - The ID of the snapshot used
    #     for the EBS volume.
    #
    #   * `block-device-mapping.volume-size` - The volume size of the EBS
    #     volume, in GiB.
    #
    #   * `block-device-mapping.volume-type` - The volume type of the EBS
    #     volume (`gp2` \| `io1` \| `io2` \| `st1 `\| `sc1` \| `standard`).
    #
    #   * `block-device-mapping.encrypted` - A Boolean that indicates
    #     whether the EBS volume is encrypted.
    #
    #   * `description` - The description of the image (provided during
    #     image creation).
    #
    #   * `ena-support` - A Boolean that indicates whether enhanced
    #     networking with ENA is enabled.
    #
    #   * `hypervisor` - The hypervisor type (`ovm` \| `xen`).
    #
    #   * `image-id` - The ID of the image.
    #
    #   * `image-type` - The image type (`machine` \| `kernel` \|
    #     `ramdisk`).
    #
    #   * `is-public` - A Boolean that indicates whether the image is
    #     public.
    #
    #   * `kernel-id` - The kernel ID.
    #
    #   * `manifest-location` - The location of the image manifest.
    #
    #   * `name` - The name of the AMI (provided during image creation).
    #
    #   * `owner-alias` - The owner alias (`amazon` \| `aws-marketplace`).
    #     The valid aliases are defined in an Amazon-maintained list. This
    #     is not the AWS account alias that can be set using the IAM
    #     console. We recommend that you use the **Owner** request parameter
    #     instead of this filter.
    #
    #   * `owner-id` - The AWS account ID of the owner. We recommend that
    #     you use the **Owner** request parameter instead of this filter.
    #
    #   * `platform` - The platform. To only list Windows-based AMIs, use
    #     `windows`.
    #
    #   * `product-code` - The product code.
    #
    #   * `product-code.type` - The type of the product code (`devpay` \|
    #     `marketplace`).
    #
    #   * `ramdisk-id` - The RAM disk ID.
    #
    #   * `root-device-name` - The device name of the root device volume
    #     (for example, `/dev/sda1`).
    #
    #   * `root-device-type` - The type of the root device volume (`ebs` \|
    #     `instance-store`).
    #
    #   * `state` - The state of the image (`available` \| `pending` \|
    #     `failed`).
    #
    #   * `state-reason-code` - The reason code for the state change.
    #
    #   * `state-reason-message` - The message for the state change.
    #
    #   * `sriov-net-support` - A value of `simple` indicates that enhanced
    #     networking with the Intel 82599 VF interface is enabled.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `virtualization-type` - The virtualization type (`paravirtual` \|
    #     `hvm`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] image_ids
    #   The image IDs.
    #
    #   Default: Describes all images available to you.
    #   @return [Array<String>]
    #
    # @!attribute [rw] owners
    #   Scopes the results to images with the specified owners. You can
    #   specify a combination of AWS account IDs, `self`, `amazon`, and
    #   `aws-marketplace`. If you omit this parameter, the results include
    #   all images for which you have launch permissions, regardless of
    #   ownership.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImagesRequest AWS API Documentation
    #
    class DescribeImagesRequest < Struct.new(
      :executable_users,
      :filters,
      :image_ids,
      :owners,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] images
    #   Information about the images.
    #   @return [Array<Types::Image>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImagesResult AWS API Documentation
    #
    class DescribeImagesResult < Struct.new(
      :images)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeImportImageTasksRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         import_task_ids: ["ImportImageTaskId"],
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   Filter tasks using the `task-state` filter and one of the following
    #   values: `active`, `completed`, `deleting`, or `deleted`.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] import_task_ids
    #   The IDs of the import image tasks.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   A token that indicates the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasksRequest AWS API Documentation
    #
    class DescribeImportImageTasksRequest < Struct.new(
      :dry_run,
      :filters,
      :import_task_ids,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] import_image_tasks
    #   A list of zero or more import image tasks that are currently active
    #   or were completed or canceled in the previous 7 days.
    #   @return [Array<Types::ImportImageTask>]
    #
    # @!attribute [rw] next_token
    #   The token to use to get the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportImageTasksResult AWS API Documentation
    #
    class DescribeImportImageTasksResult < Struct.new(
      :import_image_tasks,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeImportSnapshotTasksRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         import_task_ids: ["ImportSnapshotTaskId"],
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   The filters.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] import_task_ids
    #   A list of import snapshot task IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `NextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   A token that indicates the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasksRequest AWS API Documentation
    #
    class DescribeImportSnapshotTasksRequest < Struct.new(
      :dry_run,
      :filters,
      :import_task_ids,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] import_snapshot_tasks
    #   A list of zero or more import snapshot tasks that are currently
    #   active or were completed or canceled in the previous 7 days.
    #   @return [Array<Types::ImportSnapshotTask>]
    #
    # @!attribute [rw] next_token
    #   The token to use to get the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeImportSnapshotTasksResult AWS API Documentation
    #
    class DescribeImportSnapshotTasksResult < Struct.new(
      :import_snapshot_tasks,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeInstanceAttributeRequest
    #   data as a hash:
    #
    #       {
    #         attribute: "instanceType", # required, accepts instanceType, kernel, ramdisk, userData, disableApiTermination, instanceInitiatedShutdownBehavior, rootDeviceName, blockDeviceMapping, productCodes, sourceDestCheck, groupSet, ebsOptimized, sriovNetSupport, enaSupport, enclaveOptions
    #         dry_run: false,
    #         instance_id: "InstanceId", # required
    #       }
    #
    # @!attribute [rw] attribute
    #   The instance attribute.
    #
    #   Note: The `enaSupport` attribute is not supported at this time.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceAttributeRequest AWS API Documentation
    #
    class DescribeInstanceAttributeRequest < Struct.new(
      :attribute,
      :dry_run,
      :instance_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeInstanceCreditSpecificationsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         instance_ids: ["InstanceId"],
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   ^
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] instance_ids
    #   The instance IDs.
    #
    #   Default: Describes all your instances.
    #
    #   Constraints: Maximum 1000 explicitly specified instance IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `NextToken` value. This value can be between 5 and 1000. You cannot
    #   specify this parameter and the instance IDs parameter in the same
    #   call.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceCreditSpecificationsRequest AWS API Documentation
    #
    class DescribeInstanceCreditSpecificationsRequest < Struct.new(
      :dry_run,
      :filters,
      :instance_ids,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_credit_specifications
    #   Information about the credit option for CPU usage of an instance.
    #   @return [Array<Types::InstanceCreditSpecification>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceCreditSpecificationsResult AWS API Documentation
    #
    class DescribeInstanceCreditSpecificationsResult < Struct.new(
      :instance_credit_specifications,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeInstanceEventNotificationAttributesRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceEventNotificationAttributesRequest AWS API Documentation
    #
    class DescribeInstanceEventNotificationAttributesRequest < Struct.new(
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_tag_attribute
    #   Information about the registered tag keys.
    #   @return [Types::InstanceTagNotificationAttribute]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceEventNotificationAttributesResult AWS API Documentation
    #
    class DescribeInstanceEventNotificationAttributesResult < Struct.new(
      :instance_tag_attribute)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeInstanceStatusRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         instance_ids: ["InstanceId"],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #         include_all_instances: false,
    #       }
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `availability-zone` - The Availability Zone of the instance.
    #
    #   * `event.code` - The code for the scheduled event (`instance-reboot`
    #     \| `system-reboot` \| `system-maintenance` \|
    #     `instance-retirement` \| `instance-stop`).
    #
    #   * `event.description` - A description of the event.
    #
    #   * `event.instance-event-id` - The ID of the event whose date and
    #     time you are modifying.
    #
    #   * `event.not-after` - The latest end time for the scheduled event
    #     (for example, `2014-09-15T17:15:20.000Z`).
    #
    #   * `event.not-before` - The earliest start time for the scheduled
    #     event (for example, `2014-09-15T17:15:20.000Z`).
    #
    #   * `event.not-before-deadline` - The deadline for starting the event
    #     (for example, `2014-09-15T17:15:20.000Z`).
    #
    #   * `instance-state-code` - The code for the instance state, as a
    #     16-bit unsigned integer. The high byte is used for internal
    #     purposes and should be ignored. The low byte is set based on the
    #     state represented. The valid values are 0 (pending), 16 (running),
    #     32 (shutting-down), 48 (terminated), 64 (stopping), and 80
    #     (stopped).
    #
    #   * `instance-state-name` - The state of the instance (`pending` \|
    #     `running` \| `shutting-down` \| `terminated` \| `stopping` \|
    #     `stopped`).
    #
    #   * `instance-status.reachability` - Filters on instance status where
    #     the name is `reachability` (`passed` \| `failed` \| `initializing`
    #     \| `insufficient-data`).
    #
    #   * `instance-status.status` - The status of the instance (`ok` \|
    #     `impaired` \| `initializing` \| `insufficient-data` \|
    #     `not-applicable`).
    #
    #   * `system-status.reachability` - Filters on system status where the
    #     name is `reachability` (`passed` \| `failed` \| `initializing` \|
    #     `insufficient-data`).
    #
    #   * `system-status.status` - The system status of the instance (`ok`
    #     \| `impaired` \| `initializing` \| `insufficient-data` \|
    #     `not-applicable`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] instance_ids
    #   The instance IDs.
    #
    #   Default: Describes all your instances.
    #
    #   Constraints: Maximum 100 explicitly specified instance IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `NextToken` value. This value can be between 5 and 1000. You cannot
    #   specify this parameter and the instance IDs parameter in the same
    #   call.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] include_all_instances
    #   When `true`, includes the health status for all instances. When
    #   `false`, includes the health status for running instances only.
    #
    #   Default: `false`
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceStatusRequest AWS API Documentation
    #
    class DescribeInstanceStatusRequest < Struct.new(
      :filters,
      :instance_ids,
      :max_results,
      :next_token,
      :dry_run,
      :include_all_instances)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_statuses
    #   Information about the status of the instances.
    #   @return [Array<Types::InstanceStatus>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceStatusResult AWS API Documentation
    #
    class DescribeInstanceStatusResult < Struct.new(
      :instance_statuses,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeInstanceTypeOfferingsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         location_type: "region", # accepts region, availability-zone, availability-zone-id
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "NextToken",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] location_type
    #   The location type.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `location` - This depends on the location type. For example, if
    #     the location type is `region` (default), the location is the
    #     Region code (for example, `us-east-2`.)
    #
    #   * `instance-type` - The instance type. For example, `c5.2xlarge`.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the next token value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypeOfferingsRequest AWS API Documentation
    #
    class DescribeInstanceTypeOfferingsRequest < Struct.new(
      :dry_run,
      :location_type,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_type_offerings
    #   The instance types offered.
    #   @return [Array<Types::InstanceTypeOffering>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypeOfferingsResult AWS API Documentation
    #
    class DescribeInstanceTypeOfferingsResult < Struct.new(
      :instance_type_offerings,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeInstanceTypesRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         instance_types: ["t1.micro"], # accepts t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, t4g.nano, t4g.micro, t4g.small, t4g.medium, t4g.large, t4g.xlarge, t4g.2xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, cr1.8xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5b.large, r5b.xlarge, r5b.2xlarge, r5b.4xlarge, r5b.8xlarge, r5b.12xlarge, r5b.16xlarge, r5b.24xlarge, r5b.metal, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, r6g.metal, r6g.medium, r6g.large, r6g.xlarge, r6g.2xlarge, r6g.4xlarge, r6g.8xlarge, r6g.12xlarge, r6g.16xlarge, r6gd.metal, r6gd.medium, r6gd.large, r6gd.xlarge, r6gd.2xlarge, r6gd.4xlarge, r6gd.8xlarge, r6gd.12xlarge, r6gd.16xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, hi1.4xlarge, hs1.8xlarge, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5a.large, c5a.xlarge, c5a.2xlarge, c5a.4xlarge, c5a.8xlarge, c5a.12xlarge, c5a.16xlarge, c5a.24xlarge, c5ad.large, c5ad.xlarge, c5ad.2xlarge, c5ad.4xlarge, c5ad.8xlarge, c5ad.12xlarge, c5ad.16xlarge, c5ad.24xlarge, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.12xlarge, c5d.18xlarge, c5d.24xlarge, c5d.metal, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, c5n.metal, c6g.metal, c6g.medium, c6g.large, c6g.xlarge, c6g.2xlarge, c6g.4xlarge, c6g.8xlarge, c6g.12xlarge, c6g.16xlarge, c6gd.metal, c6gd.medium, c6gd.large, c6gd.xlarge, c6gd.2xlarge, c6gd.4xlarge, c6gd.8xlarge, c6gd.12xlarge, c6gd.16xlarge, c6gn.medium, c6gn.large, c6gn.xlarge, c6gn.2xlarge, c6gn.4xlarge, c6gn.8xlarge, c6gn.12xlarge, c6gn.16xlarge, cc1.4xlarge, cc2.8xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, g4ad.4xlarge, g4ad.8xlarge, g4ad.16xlarge, g4dn.xlarge, g4dn.2xlarge, g4dn.4xlarge, g4dn.8xlarge, g4dn.12xlarge, g4dn.16xlarge, g4dn.metal, cg1.4xlarge, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, p4d.24xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, d3.xlarge, d3.2xlarge, d3.4xlarge, d3.8xlarge, d3en.xlarge, d3en.2xlarge, d3en.4xlarge, d3en.6xlarge, d3en.8xlarge, d3en.12xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, m5zn.large, m5zn.xlarge, m5zn.2xlarge, m5zn.3xlarge, m5zn.6xlarge, m5zn.12xlarge, m5zn.metal, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, u-18tb1.metal, u-24tb1.metal, a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge, a1.metal, m5dn.large, m5dn.xlarge, m5dn.2xlarge, m5dn.4xlarge, m5dn.8xlarge, m5dn.12xlarge, m5dn.16xlarge, m5dn.24xlarge, m5n.large, m5n.xlarge, m5n.2xlarge, m5n.4xlarge, m5n.8xlarge, m5n.12xlarge, m5n.16xlarge, m5n.24xlarge, r5dn.large, r5dn.xlarge, r5dn.2xlarge, r5dn.4xlarge, r5dn.8xlarge, r5dn.12xlarge, r5dn.16xlarge, r5dn.24xlarge, r5n.large, r5n.xlarge, r5n.2xlarge, r5n.4xlarge, r5n.8xlarge, r5n.12xlarge, r5n.16xlarge, r5n.24xlarge, inf1.xlarge, inf1.2xlarge, inf1.6xlarge, inf1.24xlarge, m6g.metal, m6g.medium, m6g.large, m6g.xlarge, m6g.2xlarge, m6g.4xlarge, m6g.8xlarge, m6g.12xlarge, m6g.16xlarge, m6gd.metal, m6gd.medium, m6gd.large, m6gd.xlarge, m6gd.2xlarge, m6gd.4xlarge, m6gd.8xlarge, m6gd.12xlarge, m6gd.16xlarge, mac1.metal
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "NextToken",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_types
    #   The instance types. For more information, see [Instance types][1] in
    #   the *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters. Filter names and values are case-sensitive.
    #
    #   * `auto-recovery-supported` - Indicates whether auto recovery is
    #     supported (`true` \| `false`).
    #
    #   * `bare-metal` - Indicates whether it is a bare metal instance type
    #     (`true` \| `false`).
    #
    #   * `burstable-performance-supported` - Indicates whether it is a
    #     burstable performance instance type (`true` \| `false`).
    #
    #   * `current-generation` - Indicates whether this instance type is the
    #     latest generation instance type of an instance family (`true` \|
    #     `false`).
    #
    #   * `ebs-info.ebs-optimized-info.baseline-bandwidth-in-mbps` - The
    #     baseline bandwidth performance for an EBS-optimized instance type,
    #     in Mbps.
    #
    #   * `ebs-info.ebs-optimized-info.baseline-iops` - The baseline
    #     input/output storage operations per second for an EBS-optimized
    #     instance type.
    #
    #   * `ebs-info.ebs-optimized-info.baseline-throughput-in-mbps` - The
    #     baseline throughput performance for an EBS-optimized instance
    #     type, in MB/s.
    #
    #   * `ebs-info.ebs-optimized-info.maximum-bandwidth-in-mbps` - The
    #     maximum bandwidth performance for an EBS-optimized instance type,
    #     in Mbps.
    #
    #   * `ebs-info.ebs-optimized-info.maximum-iops` - The maximum
    #     input/output storage operations per second for an EBS-optimized
    #     instance type.
    #
    #   * `ebs-info.ebs-optimized-info.maximum-throughput-in-mbps` - The
    #     maximum throughput performance for an EBS-optimized instance type,
    #     in MB/s.
    #
    #   * `ebs-info.ebs-optimized-support` - Indicates whether the instance
    #     type is EBS-optimized (`supported` \| `unsupported` \| `default`).
    #
    #   * `ebs-info.encryption-support` - Indicates whether EBS encryption
    #     is supported (`supported` \| `unsupported`).
    #
    #   * `ebs-info.nvme-support` - Indicates whether non-volatile memory
    #     express (NVMe) is supported for EBS volumes (`required` \|
    #     `supported` \| `unsupported`).
    #
    #   * `free-tier-eligible` - Indicates whether the instance type is
    #     eligible to use in the free tier (`true` \| `false`).
    #
    #   * `hibernation-supported` - Indicates whether On-Demand hibernation
    #     is supported (`true` \| `false`).
    #
    #   * `hypervisor` - The hypervisor (`nitro` \| `xen`).
    #
    #   * `instance-storage-info.disk.count` - The number of local disks.
    #
    #   * `instance-storage-info.disk.size-in-gb` - The storage size of each
    #     instance storage disk, in GB.
    #
    #   * `instance-storage-info.disk.type` - The storage technology for the
    #     local instance storage disks (`hdd` \| `ssd`).
    #
    #   * `instance-storage-info.nvme-support` - Indicates whether
    #     non-volatile memory express (NVMe) is supported for instance store
    #     (`required` \| `supported`) \| `unsupported`).
    #
    #   * `instance-storage-info.total-size-in-gb` - The total amount of
    #     storage available from all local instance storage, in GB.
    #
    #   * `instance-storage-supported` - Indicates whether the instance type
    #     has local instance storage (`true` \| `false`).
    #
    #   * `instance-type` - The instance type (for example `c5.2xlarge` or
    #     c5*).
    #
    #   * `memory-info.size-in-mib` - The memory size.
    #
    #   * `network-info.efa-supported` - Indicates whether the instance type
    #     supports Elastic Fabric Adapter (EFA) (`true` \| `false`).
    #
    #   * `network-info.ena-support` - Indicates whether Elastic Network
    #     Adapter (ENA) is supported or required (`required` \| `supported`
    #     \| `unsupported`).
    #
    #   * `network-info.ipv4-addresses-per-interface` - The maximum number
    #     of private IPv4 addresses per network interface.
    #
    #   * `network-info.ipv6-addresses-per-interface` - The maximum number
    #     of private IPv6 addresses per network interface.
    #
    #   * `network-info.ipv6-supported` - Indicates whether the instance
    #     type supports IPv6 (`true` \| `false`).
    #
    #   * `network-info.maximum-network-interfaces` - The maximum number of
    #     network interfaces per instance.
    #
    #   * `network-info.network-performance` - The network performance (for
    #     example, "25 Gigabit").
    #
    #   * `processor-info.supported-architecture` - The CPU architecture
    #     (`arm64` \| `i386` \| `x86_64`).
    #
    #   * `processor-info.sustained-clock-speed-in-ghz` - The CPU clock
    #     speed, in GHz.
    #
    #   * `supported-root-device-type` - The root device type (`ebs` \|
    #     `instance-store`).
    #
    #   * `supported-usage-class` - The usage class (`on-demand` \| `spot`).
    #
    #   * `supported-virtualization-type` - The virtualization type (`hvm`
    #     \| `paravirtual`).
    #
    #   * `vcpu-info.default-cores` - The default number of cores for the
    #     instance type.
    #
    #   * `vcpu-info.default-threads-per-core` - The default number of
    #     threads per core for the instance type.
    #
    #   * `vcpu-info.default-vcpus` - The default number of vCPUs for the
    #     instance type.
    #
    #   * `vcpu-info.valid-cores` - The number of cores that can be
    #     configured for the instance type.
    #
    #   * `vcpu-info.valid-threads-per-core` - The number of threads per
    #     core that can be configured for the instance type. For example,
    #     "1" or "1,2".
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results can be seen by sending another request
    #   with the next token value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypesRequest AWS API Documentation
    #
    class DescribeInstanceTypesRequest < Struct.new(
      :dry_run,
      :instance_types,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] instance_types
    #   The instance type. For more information, see [Instance types][1] in
    #   the *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html
    #   @return [Array<Types::InstanceTypeInfo>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstanceTypesResult AWS API Documentation
    #
    class DescribeInstanceTypesResult < Struct.new(
      :instance_types,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeInstancesRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         instance_ids: ["InstanceId"],
    #         dry_run: false,
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `affinity` - The affinity setting for an instance running on a
    #     Dedicated Host (`default` \| `host`).
    #
    #   * `architecture` - The instance architecture (`i386` \| `x86_64` \|
    #     `arm64`).
    #
    #   * `availability-zone` - The Availability Zone of the instance.
    #
    #   * `block-device-mapping.attach-time` - The attach time for an EBS
    #     volume mapped to the instance, for example,
    #     `2010-09-15T17:15:20.000Z`.
    #
    #   * `block-device-mapping.delete-on-termination` - A Boolean that
    #     indicates whether the EBS volume is deleted on instance
    #     termination.
    #
    #   * `block-device-mapping.device-name` - The device name specified in
    #     the block device mapping (for example, `/dev/sdh` or `xvdh`).
    #
    #   * `block-device-mapping.status` - The status for the EBS volume
    #     (`attaching` \| `attached` \| `detaching` \| `detached`).
    #
    #   * `block-device-mapping.volume-id` - The volume ID of the EBS
    #     volume.
    #
    #   * `client-token` - The idempotency token you provided when you
    #     launched the instance.
    #
    #   * `dns-name` - The public DNS name of the instance.
    #
    #   * `group-id` - The ID of the security group for the instance.
    #     EC2-Classic only.
    #
    #   * `group-name` - The name of the security group for the instance.
    #     EC2-Classic only.
    #
    #   * `hibernation-options.configured` - A Boolean that indicates
    #     whether the instance is enabled for hibernation. A value of `true`
    #     means that the instance is enabled for hibernation.
    #
    #   * `host-id` - The ID of the Dedicated Host on which the instance is
    #     running, if applicable.
    #
    #   * `hypervisor` - The hypervisor type of the instance (`ovm` \|
    #     `xen`). The value `xen` is used for both Xen and Nitro
    #     hypervisors.
    #
    #   * `iam-instance-profile.arn` - The instance profile associated with
    #     the instance. Specified as an ARN.
    #
    #   * `image-id` - The ID of the image used to launch the instance.
    #
    #   * `instance-id` - The ID of the instance.
    #
    #   * `instance-lifecycle` - Indicates whether this is a Spot Instance
    #     or a Scheduled Instance (`spot` \| `scheduled`).
    #
    #   * `instance-state-code` - The state of the instance, as a 16-bit
    #     unsigned integer. The high byte is used for internal purposes and
    #     should be ignored. The low byte is set based on the state
    #     represented. The valid values are: 0 (pending), 16 (running), 32
    #     (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
    #
    #   * `instance-state-name` - The state of the instance (`pending` \|
    #     `running` \| `shutting-down` \| `terminated` \| `stopping` \|
    #     `stopped`).
    #
    #   * `instance-type` - The type of instance (for example, `t2.micro`).
    #
    #   * `instance.group-id` - The ID of the security group for the
    #     instance.
    #
    #   * `instance.group-name` - The name of the security group for the
    #     instance.
    #
    #   * `ip-address` - The public IPv4 address of the instance.
    #
    #   * `kernel-id` - The kernel ID.
    #
    #   * `key-name` - The name of the key pair used when the instance was
    #     launched.
    #
    #   * `launch-index` - When launching multiple instances, this is the
    #     index for the instance in the launch group (for example, 0, 1, 2,
    #     and so on).
    #
    #   * `launch-time` - The time when the instance was launched.
    #
    #   * `metadata-options.http-tokens` - The metadata request
    #     authorization state (`optional` \| `required`)
    #
    #   * `metadata-options.http-put-response-hop-limit` - The http metadata
    #     request put response hop limit (integer, possible values `1` to
    #     `64`)
    #
    #   * `metadata-options.http-endpoint` - Enable or disable metadata
    #     access on http endpoint (`enabled` \| `disabled`)
    #
    #   * `monitoring-state` - Indicates whether detailed monitoring is
    #     enabled (`disabled` \| `enabled`).
    #
    #   * `network-interface.addresses.private-ip-address` - The private
    #     IPv4 address associated with the network interface.
    #
    #   * `network-interface.addresses.primary` - Specifies whether the IPv4
    #     address of the network interface is the primary private IPv4
    #     address.
    #
    #   * `network-interface.addresses.association.public-ip` - The ID of
    #     the association of an Elastic IP address (IPv4) with a network
    #     interface.
    #
    #   * `network-interface.addresses.association.ip-owner-id` - The owner
    #     ID of the private IPv4 address associated with the network
    #     interface.
    #
    #   * `network-interface.association.public-ip` - The address of the
    #     Elastic IP address (IPv4) bound to the network interface.
    #
    #   * `network-interface.association.ip-owner-id` - The owner of the
    #     Elastic IP address (IPv4) associated with the network interface.
    #
    #   * `network-interface.association.allocation-id` - The allocation ID
    #     returned when you allocated the Elastic IP address (IPv4) for your
    #     network interface.
    #
    #   * `network-interface.association.association-id` - The association
    #     ID returned when the network interface was associated with an IPv4
    #     address.
    #
    #   * `network-interface.attachment.attachment-id` - The ID of the
    #     interface attachment.
    #
    #   * `network-interface.attachment.instance-id` - The ID of the
    #     instance to which the network interface is attached.
    #
    #   * `network-interface.attachment.instance-owner-id` - The owner ID of
    #     the instance to which the network interface is attached.
    #
    #   * `network-interface.attachment.device-index` - The device index to
    #     which the network interface is attached.
    #
    #   * `network-interface.attachment.status` - The status of the
    #     attachment (`attaching` \| `attached` \| `detaching` \|
    #     `detached`).
    #
    #   * `network-interface.attachment.attach-time` - The time that the
    #     network interface was attached to an instance.
    #
    #   * `network-interface.attachment.delete-on-termination` - Specifies
    #     whether the attachment is deleted when an instance is terminated.
    #
    #   * `network-interface.availability-zone` - The Availability Zone for
    #     the network interface.
    #
    #   * `network-interface.description` - The description of the network
    #     interface.
    #
    #   * `network-interface.group-id` - The ID of a security group
    #     associated with the network interface.
    #
    #   * `network-interface.group-name` - The name of a security group
    #     associated with the network interface.
    #
    #   * `network-interface.ipv6-addresses.ipv6-address` - The IPv6 address
    #     associated with the network interface.
    #
    #   * `network-interface.mac-address` - The MAC address of the network
    #     interface.
    #
    #   * `network-interface.network-interface-id` - The ID of the network
    #     interface.
    #
    #   * `network-interface.owner-id` - The ID of the owner of the network
    #     interface.
    #
    #   * `network-interface.private-dns-name` - The private DNS name of the
    #     network interface.
    #
    #   * `network-interface.requester-id` - The requester ID for the
    #     network interface.
    #
    #   * `network-interface.requester-managed` - Indicates whether the
    #     network interface is being managed by AWS.
    #
    #   * `network-interface.status` - The status of the network interface
    #     (`available`) \| `in-use`).
    #
    #   * `network-interface.source-dest-check` - Whether the network
    #     interface performs source/destination checking. A value of `true`
    #     means that checking is enabled, and `false` means that checking is
    #     disabled. The value must be `false` for the network interface to
    #     perform network address translation (NAT) in your VPC.
    #
    #   * `network-interface.subnet-id` - The ID of the subnet for the
    #     network interface.
    #
    #   * `network-interface.vpc-id` - The ID of the VPC for the network
    #     interface.
    #
    #   * `owner-id` - The AWS account ID of the instance owner.
    #
    #   * `placement-group-name` - The name of the placement group for the
    #     instance.
    #
    #   * `placement-partition-number` - The partition in which the instance
    #     is located.
    #
    #   * `platform` - The platform. To list only Windows instances, use
    #     `windows`.
    #
    #   * `private-dns-name` - The private IPv4 DNS name of the instance.
    #
    #   * `private-ip-address` - The private IPv4 address of the instance.
    #
    #   * `product-code` - The product code associated with the AMI used to
    #     launch the instance.
    #
    #   * `product-code.type` - The type of product code (`devpay` \|
    #     `marketplace`).
    #
    #   * `ramdisk-id` - The RAM disk ID.
    #
    #   * `reason` - The reason for the current state of the instance (for
    #     example, shows "User Initiated \[date\]" when you stop or
    #     terminate the instance). Similar to the state-reason-code filter.
    #
    #   * `requester-id` - The ID of the entity that launched the instance
    #     on your behalf (for example, AWS Management Console, Auto Scaling,
    #     and so on).
    #
    #   * `reservation-id` - The ID of the instance's reservation. A
    #     reservation ID is created any time you launch an instance. A
    #     reservation ID has a one-to-one relationship with an instance
    #     launch request, but can be associated with more than one instance
    #     if you launch multiple instances using the same launch request.
    #     For example, if you launch one instance, you get one reservation
    #     ID. If you launch ten instances using the same launch request, you
    #     also get one reservation ID.
    #
    #   * `root-device-name` - The device name of the root device volume
    #     (for example, `/dev/sda1`).
    #
    #   * `root-device-type` - The type of the root device volume (`ebs` \|
    #     `instance-store`).
    #
    #   * `source-dest-check` - Indicates whether the instance performs
    #     source/destination checking. A value of `true` means that checking
    #     is enabled, and `false` means that checking is disabled. The value
    #     must be `false` for the instance to perform network address
    #     translation (NAT) in your VPC.
    #
    #   * `spot-instance-request-id` - The ID of the Spot Instance request.
    #
    #   * `state-reason-code` - The reason code for the state change.
    #
    #   * `state-reason-message` - A message that describes the state
    #     change.
    #
    #   * `subnet-id` - The ID of the subnet for the instance.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources that have a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `tenancy` - The tenancy of an instance (`dedicated` \| `default`
    #     \| `host`).
    #
    #   * `virtualization-type` - The virtualization type of the instance
    #     (`paravirtual` \| `hvm`).
    #
    #   * `vpc-id` - The ID of the VPC that the instance is running in.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] instance_ids
    #   The instance IDs.
    #
    #   Default: Describes all your instances.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `NextToken` value. This value can be between 5 and 1000. You cannot
    #   specify this parameter and the instance IDs parameter in the same
    #   call.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to request the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstancesRequest AWS API Documentation
    #
    class DescribeInstancesRequest < Struct.new(
      :filters,
      :instance_ids,
      :dry_run,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] reservations
    #   Information about the reservations.
    #   @return [Array<Types::Reservation>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInstancesResult AWS API Documentation
    #
    class DescribeInstancesResult < Struct.new(
      :reservations,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeInternetGatewaysRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         dry_run: false,
    #         internet_gateway_ids: ["InternetGatewayId"],
    #         next_token: "String",
    #         max_results: 1,
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `attachment.state` - The current state of the attachment between
    #     the gateway and the VPC (`available`). Present only if a VPC is
    #     attached.
    #
    #   * `attachment.vpc-id` - The ID of an attached VPC.
    #
    #   * `internet-gateway-id` - The ID of the Internet gateway.
    #
    #   * `owner-id` - The ID of the AWS account that owns the internet
    #     gateway.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] internet_gateway_ids
    #   One or more internet gateway IDs.
    #
    #   Default: Describes all your internet gateways.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInternetGatewaysRequest AWS API Documentation
    #
    class DescribeInternetGatewaysRequest < Struct.new(
      :filters,
      :dry_run,
      :internet_gateway_ids,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] internet_gateways
    #   Information about one or more internet gateways.
    #   @return [Array<Types::InternetGateway>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeInternetGatewaysResult AWS API Documentation
    #
    class DescribeInternetGatewaysResult < Struct.new(
      :internet_gateways,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeIpv6PoolsRequest
    #   data as a hash:
    #
    #       {
    #         pool_ids: ["Ipv6PoolEc2Id"],
    #         next_token: "NextToken",
    #         max_results: 1,
    #         dry_run: false,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] pool_ids
    #   The IDs of the IPv6 address pools.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpv6PoolsRequest AWS API Documentation
    #
    class DescribeIpv6PoolsRequest < Struct.new(
      :pool_ids,
      :next_token,
      :max_results,
      :dry_run,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipv_6_pools
    #   Information about the IPv6 address pools.
    #   @return [Array<Types::Ipv6Pool>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeIpv6PoolsResult AWS API Documentation
    #
    class DescribeIpv6PoolsResult < Struct.new(
      :ipv_6_pools,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeKeyPairsRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         key_names: ["KeyPairName"],
    #         key_pair_ids: ["KeyPairId"],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `key-pair-id` - The ID of the key pair.
    #
    #   * `fingerprint` - The fingerprint of the key pair.
    #
    #   * `key-name` - The name of the key pair.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] key_names
    #   The key pair names.
    #
    #   Default: Describes all your key pairs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] key_pair_ids
    #   The IDs of the key pairs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeKeyPairsRequest AWS API Documentation
    #
    class DescribeKeyPairsRequest < Struct.new(
      :filters,
      :key_names,
      :key_pair_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] key_pairs
    #   Information about the key pairs.
    #   @return [Array<Types::KeyPairInfo>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeKeyPairsResult AWS API Documentation
    #
    class DescribeKeyPairsResult < Struct.new(
      :key_pairs)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeLaunchTemplateVersionsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         launch_template_id: "LaunchTemplateId",
    #         launch_template_name: "LaunchTemplateName",
    #         versions: ["String"],
    #         min_version: "String",
    #         max_version: "String",
    #         next_token: "String",
    #         max_results: 1,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] launch_template_id
    #   The ID of the launch template. To describe one or more versions of a
    #   specified launch template, you must specify either the launch
    #   template ID or the launch template name in the request. To describe
    #   all the latest or default launch template versions in your account,
    #   you must omit this parameter.
    #   @return [String]
    #
    # @!attribute [rw] launch_template_name
    #   The name of the launch template. To describe one or more versions of
    #   a specified launch template, you must specify either the launch
    #   template ID or the launch template name in the request. To describe
    #   all the latest or default launch template versions in your account,
    #   you must omit this parameter.
    #   @return [String]
    #
    # @!attribute [rw] versions
    #   One or more versions of the launch template. Valid values depend on
    #   whether you are describing a specified launch template (by ID or
    #   name) or all launch templates in your account.
    #
    #   To describe one or more versions of a specified launch template,
    #   valid values are `$Latest`, `$Default`, and numbers.
    #
    #   To describe all launch templates in your account that are defined as
    #   the latest version, the valid value is `$Latest`. To describe all
    #   launch templates in your account that are defined as the default
    #   version, the valid value is `$Default`. You can specify `$Latest`
    #   and `$Default` in the same call. You cannot specify numbers.
    #   @return [Array<String>]
    #
    # @!attribute [rw] min_version
    #   The version number after which to describe launch template versions.
    #   @return [String]
    #
    # @!attribute [rw] max_version
    #   The version number up to which to describe launch template versions.
    #   @return [String]
    #
    # @!attribute [rw] next_token
    #   The token to request the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `NextToken` value. This value can be between 1 and 200.
    #   @return [Integer]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `create-time` - The time the launch template version was created.
    #
    #   * `ebs-optimized` - A boolean that indicates whether the instance is
    #     optimized for Amazon EBS I/O.
    #
    #   * `iam-instance-profile` - The ARN of the IAM instance profile.
    #
    #   * `image-id` - The ID of the AMI.
    #
    #   * `instance-type` - The instance type.
    #
    #   * `is-default-version` - A boolean that indicates whether the launch
    #     template version is the default version.
    #
    #   * `kernel-id` - The kernel ID.
    #
    #   * `ram-disk-id` - The RAM disk ID.
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplateVersionsRequest AWS API Documentation
    #
    class DescribeLaunchTemplateVersionsRequest < Struct.new(
      :dry_run,
      :launch_template_id,
      :launch_template_name,
      :versions,
      :min_version,
      :max_version,
      :next_token,
      :max_results,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] launch_template_versions
    #   Information about the launch template versions.
    #   @return [Array<Types::LaunchTemplateVersion>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplateVersionsResult AWS API Documentation
    #
    class DescribeLaunchTemplateVersionsResult < Struct.new(
      :launch_template_versions,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeLaunchTemplatesRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         launch_template_ids: ["LaunchTemplateId"],
    #         launch_template_names: ["LaunchTemplateName"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         next_token: "String",
    #         max_results: 1,
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] launch_template_ids
    #   One or more launch template IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] launch_template_names
    #   One or more launch template names.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `create-time` - The time the launch template was created.
    #
    #   * `launch-template-name` - The name of the launch template.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] next_token
    #   The token to request the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `NextToken` value. This value can be between 1 and 200.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplatesRequest AWS API Documentation
    #
    class DescribeLaunchTemplatesRequest < Struct.new(
      :dry_run,
      :launch_template_ids,
      :launch_template_names,
      :filters,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] launch_templates
    #   Information about the launch templates.
    #   @return [Array<Types::LaunchTemplate>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplatesResult AWS API Documentation
    #
    class DescribeLaunchTemplatesResult < Struct.new(
      :launch_templates,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
    #   data as a hash:
    #
    #       {
    #         local_gateway_route_table_virtual_interface_group_association_ids: ["LocalGatewayRouteTableVirtualInterfaceGroupAssociationId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] local_gateway_route_table_virtual_interface_group_association_ids
    #   The IDs of the associations.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `local-gateway-id` - The ID of a local gateway.
    #
    #   * `local-gateway-route-table-id` - The ID of the local gateway route
    #     table.
    #
    #   * `local-gateway-route-table-virtual-interface-group-association-id`
    #     - The ID of the association.
    #
    #   * `local-gateway-route-table-virtual-interface-group-id` - The ID of
    #     the virtual interface group.
    #
    #   * `state` - The state of the association.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest AWS API Documentation
    #
    class DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest < Struct.new(
      :local_gateway_route_table_virtual_interface_group_association_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_table_virtual_interface_group_associations
    #   Information about the associations.
    #   @return [Array<Types::LocalGatewayRouteTableVirtualInterfaceGroupAssociation>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult AWS API Documentation
    #
    class DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResult < Struct.new(
      :local_gateway_route_table_virtual_interface_group_associations,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeLocalGatewayRouteTableVpcAssociationsRequest
    #   data as a hash:
    #
    #       {
    #         local_gateway_route_table_vpc_association_ids: ["LocalGatewayRouteTableVpcAssociationId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] local_gateway_route_table_vpc_association_ids
    #   The IDs of the associations.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `local-gateway-id` - The ID of a local gateway.
    #
    #   * `local-gateway-route-table-id` - The ID of the local gateway route
    #     table.
    #
    #   * `local-gateway-route-table-vpc-association-id` - The ID of the
    #     association.
    #
    #   * `state` - The state of the association.
    #
    #   * `vpc-id` - The ID of the VPC.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVpcAssociationsRequest AWS API Documentation
    #
    class DescribeLocalGatewayRouteTableVpcAssociationsRequest < Struct.new(
      :local_gateway_route_table_vpc_association_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_table_vpc_associations
    #   Information about the associations.
    #   @return [Array<Types::LocalGatewayRouteTableVpcAssociation>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTableVpcAssociationsResult AWS API Documentation
    #
    class DescribeLocalGatewayRouteTableVpcAssociationsResult < Struct.new(
      :local_gateway_route_table_vpc_associations,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeLocalGatewayRouteTablesRequest
    #   data as a hash:
    #
    #       {
    #         local_gateway_route_table_ids: ["LocalGatewayRoutetableId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] local_gateway_route_table_ids
    #   The IDs of the local gateway route tables.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `local-gateway-id` - The ID of a local gateway.
    #
    #   * `local-gateway-route-table-id` - The ID of a local gateway route
    #     table.
    #
    #   * `outpost-arn` - The Amazon Resource Name (ARN) of the Outpost.
    #
    #   * `state` - The state of the local gateway route table.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTablesRequest AWS API Documentation
    #
    class DescribeLocalGatewayRouteTablesRequest < Struct.new(
      :local_gateway_route_table_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_route_tables
    #   Information about the local gateway route tables.
    #   @return [Array<Types::LocalGatewayRouteTable>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayRouteTablesResult AWS API Documentation
    #
    class DescribeLocalGatewayRouteTablesResult < Struct.new(
      :local_gateway_route_tables,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeLocalGatewayVirtualInterfaceGroupsRequest
    #   data as a hash:
    #
    #       {
    #         local_gateway_virtual_interface_group_ids: ["LocalGatewayVirtualInterfaceGroupId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] local_gateway_virtual_interface_group_ids
    #   The IDs of the virtual interface groups.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `local-gateway-id` - The ID of a local gateway.
    #
    #   * `local-gateway-virtual-interface-id` - The ID of the virtual
    #     interface.
    #
    #   * `local-gateway-virtual-interface-group-id` - The ID of the virtual
    #     interface group.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayVirtualInterfaceGroupsRequest AWS API Documentation
    #
    class DescribeLocalGatewayVirtualInterfaceGroupsRequest < Struct.new(
      :local_gateway_virtual_interface_group_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_virtual_interface_groups
    #   The virtual interface groups.
    #   @return [Array<Types::LocalGatewayVirtualInterfaceGroup>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayVirtualInterfaceGroupsResult AWS API Documentation
    #
    class DescribeLocalGatewayVirtualInterfaceGroupsResult < Struct.new(
      :local_gateway_virtual_interface_groups,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeLocalGatewayVirtualInterfacesRequest
    #   data as a hash:
    #
    #       {
    #         local_gateway_virtual_interface_ids: ["LocalGatewayVirtualInterfaceId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] local_gateway_virtual_interface_ids
    #   The IDs of the virtual interfaces.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayVirtualInterfacesRequest AWS API Documentation
    #
    class DescribeLocalGatewayVirtualInterfacesRequest < Struct.new(
      :local_gateway_virtual_interface_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateway_virtual_interfaces
    #   Information about the virtual interfaces.
    #   @return [Array<Types::LocalGatewayVirtualInterface>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewayVirtualInterfacesResult AWS API Documentation
    #
    class DescribeLocalGatewayVirtualInterfacesResult < Struct.new(
      :local_gateway_virtual_interfaces,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeLocalGatewaysRequest
    #   data as a hash:
    #
    #       {
    #         local_gateway_ids: ["LocalGatewayId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] local_gateway_ids
    #   One or more filters.
    #
    #   * `local-gateway-id` - The ID of a local gateway.
    #
    #   * `local-gateway-route-table-id` - The ID of the local gateway route
    #     table.
    #
    #   * `local-gateway-route-table-virtual-interface-group-association-id`
    #     - The ID of the association.
    #
    #   * `local-gateway-route-table-virtual-interface-group-id` - The ID of
    #     the virtual interface group.
    #
    #   * `outpost-arn` - The Amazon Resource Name (ARN) of the Outpost.
    #
    #   * `state` - The state of the association.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewaysRequest AWS API Documentation
    #
    class DescribeLocalGatewaysRequest < Struct.new(
      :local_gateway_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] local_gateways
    #   Information about the local gateways.
    #   @return [Array<Types::LocalGateway>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLocalGatewaysResult AWS API Documentation
    #
    class DescribeLocalGatewaysResult < Struct.new(
      :local_gateways,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeManagedPrefixListsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "NextToken",
    #         prefix_list_ids: ["String"],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `owner-id` - The ID of the prefix list owner.
    #
    #   * `prefix-list-id` - The ID of the prefix list.
    #
    #   * `prefix-list-name` - The name of the prefix list.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] prefix_list_ids
    #   One or more prefix list IDs.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeManagedPrefixListsRequest AWS API Documentation
    #
    class DescribeManagedPrefixListsRequest < Struct.new(
      :dry_run,
      :filters,
      :max_results,
      :next_token,
      :prefix_list_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] prefix_lists
    #   Information about the prefix lists.
    #   @return [Array<Types::ManagedPrefixList>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeManagedPrefixListsResult AWS API Documentation
    #
    class DescribeManagedPrefixListsResult < Struct.new(
      :next_token,
      :prefix_lists)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeMovingAddressesRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         dry_run: false,
    #         max_results: 1,
    #         next_token: "String",
    #         public_ips: ["String"],
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `moving-status` - The status of the Elastic IP address
    #     (`MovingToVpc` \| `RestoringToClassic`).
    #
    #   ^
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results of the initial request can be seen by
    #   sending another request with the returned `NextToken` value. This
    #   value can be between 5 and 1000; if `MaxResults` is given a value
    #   outside of this range, an error is returned.
    #
    #   Default: If no value is provided, the default is 1000.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] public_ips
    #   One or more Elastic IP addresses.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeMovingAddressesRequest AWS API Documentation
    #
    class DescribeMovingAddressesRequest < Struct.new(
      :filters,
      :dry_run,
      :max_results,
      :next_token,
      :public_ips)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] moving_address_statuses
    #   The status for each Elastic IP address.
    #   @return [Array<Types::MovingAddressStatus>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeMovingAddressesResult AWS API Documentation
    #
    class DescribeMovingAddressesResult < Struct.new(
      :moving_address_statuses,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeNatGatewaysRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         filter: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         nat_gateway_ids: ["NatGatewayId"],
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filter
    #   One or more filters.
    #
    #   * `nat-gateway-id` - The ID of the NAT gateway.
    #
    #   * `state` - The state of the NAT gateway (`pending` \| `failed` \|
    #     `available` \| `deleting` \| `deleted`).
    #
    #   * `subnet-id` - The ID of the subnet in which the NAT gateway
    #     resides.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC in which the NAT gateway resides.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] nat_gateway_ids
    #   One or more NAT gateway IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNatGatewaysRequest AWS API Documentation
    #
    class DescribeNatGatewaysRequest < Struct.new(
      :dry_run,
      :filter,
      :max_results,
      :nat_gateway_ids,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] nat_gateways
    #   Information about the NAT gateways.
    #   @return [Array<Types::NatGateway>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNatGatewaysResult AWS API Documentation
    #
    class DescribeNatGatewaysResult < Struct.new(
      :nat_gateways,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeNetworkAclsRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         dry_run: false,
    #         network_acl_ids: ["NetworkAclId"],
    #         next_token: "String",
    #         max_results: 1,
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `association.association-id` - The ID of an association ID for the
    #     ACL.
    #
    #   * `association.network-acl-id` - The ID of the network ACL involved
    #     in the association.
    #
    #   * `association.subnet-id` - The ID of the subnet involved in the
    #     association.
    #
    #   * `default` - Indicates whether the ACL is the default network ACL
    #     for the VPC.
    #
    #   * `entry.cidr` - The IPv4 CIDR range specified in the entry.
    #
    #   * `entry.icmp.code` - The ICMP code specified in the entry, if any.
    #
    #   * `entry.icmp.type` - The ICMP type specified in the entry, if any.
    #
    #   * `entry.ipv6-cidr` - The IPv6 CIDR range specified in the entry.
    #
    #   * `entry.port-range.from` - The start of the port range specified in
    #     the entry.
    #
    #   * `entry.port-range.to` - The end of the port range specified in the
    #     entry.
    #
    #   * `entry.protocol` - The protocol specified in the entry (`tcp` \|
    #     `udp` \| `icmp` or a protocol number).
    #
    #   * `entry.rule-action` - Allows or denies the matching traffic
    #     (`allow` \| `deny`).
    #
    #   * `entry.rule-number` - The number of an entry (in other words,
    #     rule) in the set of ACL entries.
    #
    #   * `network-acl-id` - The ID of the network ACL.
    #
    #   * `owner-id` - The ID of the AWS account that owns the network ACL.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC for the network ACL.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_acl_ids
    #   One or more network ACL IDs.
    #
    #   Default: Describes all your network ACLs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkAclsRequest AWS API Documentation
    #
    class DescribeNetworkAclsRequest < Struct.new(
      :filters,
      :dry_run,
      :network_acl_ids,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_acls
    #   Information about one or more network ACLs.
    #   @return [Array<Types::NetworkAcl>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkAclsResult AWS API Documentation
    #
    class DescribeNetworkAclsResult < Struct.new(
      :network_acls,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeNetworkInsightsAnalysesRequest
    #   data as a hash:
    #
    #       {
    #         network_insights_analysis_ids: ["NetworkInsightsAnalysisId"],
    #         network_insights_path_id: "NetworkInsightsPathId",
    #         analysis_start_time: Time.now,
    #         analysis_end_time: Time.now,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         dry_run: false,
    #         next_token: "NextToken",
    #       }
    #
    # @!attribute [rw] network_insights_analysis_ids
    #   The ID of the network insights analyses. You must specify either
    #   analysis IDs or a path ID.
    #   @return [Array<String>]
    #
    # @!attribute [rw] network_insights_path_id
    #   The ID of the path. You must specify either a path ID or analysis
    #   IDs.
    #   @return [String]
    #
    # @!attribute [rw] analysis_start_time
    #   The time when the network insights analyses started.
    #   @return [Time]
    #
    # @!attribute [rw] analysis_end_time
    #   The time when the network insights analyses ended.
    #   @return [Time]
    #
    # @!attribute [rw] filters
    #   The filters. The following are possible values:
    #
    #   * PathFound - A Boolean value that indicates whether a feasible path
    #     is found.
    #
    #   * Status - The status of the analysis (running \| succeeded \|
    #     failed).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInsightsAnalysesRequest AWS API Documentation
    #
    class DescribeNetworkInsightsAnalysesRequest < Struct.new(
      :network_insights_analysis_ids,
      :network_insights_path_id,
      :analysis_start_time,
      :analysis_end_time,
      :filters,
      :max_results,
      :dry_run,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_insights_analyses
    #   Information about the network insights analyses.
    #   @return [Array<Types::NetworkInsightsAnalysis>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInsightsAnalysesResult AWS API Documentation
    #
    class DescribeNetworkInsightsAnalysesResult < Struct.new(
      :network_insights_analyses,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeNetworkInsightsPathsRequest
    #   data as a hash:
    #
    #       {
    #         network_insights_path_ids: ["NetworkInsightsPathId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         dry_run: false,
    #         next_token: "NextToken",
    #       }
    #
    # @!attribute [rw] network_insights_path_ids
    #   The IDs of the paths.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   The filters. The following are possible values:
    #
    #   * Destination - The ID of the resource.
    #
    #   * DestinationPort - The destination port.
    #
    #   * Name - The path name.
    #
    #   * Protocol - The protocol.
    #
    #   * Source - The ID of the resource.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInsightsPathsRequest AWS API Documentation
    #
    class DescribeNetworkInsightsPathsRequest < Struct.new(
      :network_insights_path_ids,
      :filters,
      :max_results,
      :dry_run,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] network_insights_paths
    #   Information about the paths.
    #   @return [Array<Types::NetworkInsightsPath>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInsightsPathsResult AWS API Documentation
    #
    class DescribeNetworkInsightsPathsResult < Struct.new(
      :network_insights_paths,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeNetworkInterfaceAttribute.
    #
    # @note When making an API call, you may pass DescribeNetworkInterfaceAttributeRequest
    #   data as a hash:
    #
    #       {
    #         attribute: "description", # accepts description, groupSet, sourceDestCheck, attachment
    #         dry_run: false,
    #         network_interface_id: "NetworkInterfaceId", # required
    #       }
    #
    # @!attribute [rw] attribute
    #   The attribute of the network interface. This parameter is required.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaceAttributeRequest AWS API Documentation
    #
    class DescribeNetworkInterfaceAttributeRequest < Struct.new(
      :attribute,
      :dry_run,
      :network_interface_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeNetworkInterfaceAttribute.
    #
    # @!attribute [rw] attachment
    #   The attachment (if any) of the network interface.
    #   @return [Types::NetworkInterfaceAttachment]
    #
    # @!attribute [rw] description
    #   The description of the network interface.
    #   @return [Types::AttributeValue]
    #
    # @!attribute [rw] groups
    #   The security groups associated with the network interface.
    #   @return [Array<Types::GroupIdentifier>]
    #
    # @!attribute [rw] network_interface_id
    #   The ID of the network interface.
    #   @return [String]
    #
    # @!attribute [rw] source_dest_check
    #   Indicates whether source/destination checking is enabled.
    #   @return [Types::AttributeBooleanValue]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfaceAttributeResult AWS API Documentation
    #
    class DescribeNetworkInterfaceAttributeResult < Struct.new(
      :attachment,
      :description,
      :groups,
      :network_interface_id,
      :source_dest_check)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeNetworkInterfacePermissions.
    #
    # @note When making an API call, you may pass DescribeNetworkInterfacePermissionsRequest
    #   data as a hash:
    #
    #       {
    #         network_interface_permission_ids: ["NetworkInterfacePermissionId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         next_token: "String",
    #         max_results: 1,
    #       }
    #
    # @!attribute [rw] network_interface_permission_ids
    #   One or more network interface permission IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `network-interface-permission.network-interface-permission-id` -
    #     The ID of the permission.
    #
    #   * `network-interface-permission.network-interface-id` - The ID of
    #     the network interface.
    #
    #   * `network-interface-permission.aws-account-id` - The AWS account
    #     ID.
    #
    #   * `network-interface-permission.aws-service` - The AWS service.
    #
    #   * `network-interface-permission.permission` - The type of permission
    #     (`INSTANCE-ATTACH` \| `EIP-ASSOCIATE`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] next_token
    #   The token to request the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `NextToken` value. If this parameter is not specified, up to 50
    #   results are returned by default.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfacePermissionsRequest AWS API Documentation
    #
    class DescribeNetworkInterfacePermissionsRequest < Struct.new(
      :network_interface_permission_ids,
      :filters,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output for DescribeNetworkInterfacePermissions.
    #
    # @!attribute [rw] network_interface_permissions
    #   The network interface permissions.
    #   @return [Array<Types::NetworkInterfacePermission>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfacePermissionsResult AWS API Documentation
    #
    class DescribeNetworkInterfacePermissionsResult < Struct.new(
      :network_interface_permissions,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeNetworkInterfaces.
    #
    # @note When making an API call, you may pass DescribeNetworkInterfacesRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         dry_run: false,
    #         network_interface_ids: ["NetworkInterfaceId"],
    #         next_token: "String",
    #         max_results: 1,
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `addresses.private-ip-address` - The private IPv4 addresses
    #     associated with the network interface.
    #
    #   * `addresses.primary` - Whether the private IPv4 address is the
    #     primary IP address associated with the network interface.
    #
    #   * `addresses.association.public-ip` - The association ID returned
    #     when the network interface was associated with the Elastic IP
    #     address (IPv4).
    #
    #   * `addresses.association.owner-id` - The owner ID of the addresses
    #     associated with the network interface.
    #
    #   * `association.association-id` - The association ID returned when
    #     the network interface was associated with an IPv4 address.
    #
    #   * `association.allocation-id` - The allocation ID returned when you
    #     allocated the Elastic IP address (IPv4) for your network
    #     interface.
    #
    #   * `association.ip-owner-id` - The owner of the Elastic IP address
    #     (IPv4) associated with the network interface.
    #
    #   * `association.public-ip` - The address of the Elastic IP address
    #     (IPv4) bound to the network interface.
    #
    #   * `association.public-dns-name` - The public DNS name for the
    #     network interface (IPv4).
    #
    #   * `attachment.attachment-id` - The ID of the interface attachment.
    #
    #   * `attachment.attach-time` - The time that the network interface was
    #     attached to an instance.
    #
    #   * `attachment.delete-on-termination` - Indicates whether the
    #     attachment is deleted when an instance is terminated.
    #
    #   * `attachment.device-index` - The device index to which the network
    #     interface is attached.
    #
    #   * `attachment.instance-id` - The ID of the instance to which the
    #     network interface is attached.
    #
    #   * `attachment.instance-owner-id` - The owner ID of the instance to
    #     which the network interface is attached.
    #
    #   * `attachment.status` - The status of the attachment (`attaching` \|
    #     `attached` \| `detaching` \| `detached`).
    #
    #   * `availability-zone` - The Availability Zone of the network
    #     interface.
    #
    #   * `description` - The description of the network interface.
    #
    #   * `group-id` - The ID of a security group associated with the
    #     network interface.
    #
    #   * `group-name` - The name of a security group associated with the
    #     network interface.
    #
    #   * `ipv6-addresses.ipv6-address` - An IPv6 address associated with
    #     the network interface.
    #
    #   * `mac-address` - The MAC address of the network interface.
    #
    #   * `network-interface-id` - The ID of the network interface.
    #
    #   * `owner-id` - The AWS account ID of the network interface owner.
    #
    #   * `private-ip-address` - The private IPv4 address or addresses of
    #     the network interface.
    #
    #   * `private-dns-name` - The private DNS name of the network interface
    #     (IPv4).
    #
    #   * `requester-id` - The alias or AWS account ID of the principal or
    #     service that created the network interface.
    #
    #   * `requester-managed` - Indicates whether the network interface is
    #     being managed by an AWS service (for example, AWS Management
    #     Console, Auto Scaling, and so on).
    #
    #   * `source-dest-check` - Indicates whether the network interface
    #     performs source/destination checking. A value of `true` means
    #     checking is enabled, and `false` means checking is disabled. The
    #     value must be `false` for the network interface to perform network
    #     address translation (NAT) in your VPC.
    #
    #   * `status` - The status of the network interface. If the network
    #     interface is not attached to an instance, the status is
    #     `available`; if a network interface is attached to an instance the
    #     status is `in-use`.
    #
    #   * `subnet-id` - The ID of the subnet for the network interface.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC for the network interface.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] network_interface_ids
    #   One or more network interface IDs.
    #
    #   Default: Describes all your network interfaces.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. The request
    #   returns a token that you can specify in a subsequent call to get the
    #   next set of results. You cannot specify this parameter and the
    #   network interface IDs parameter in the same request.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfacesRequest AWS API Documentation
    #
    class DescribeNetworkInterfacesRequest < Struct.new(
      :filters,
      :dry_run,
      :network_interface_ids,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeNetworkInterfaces.
    #
    # @!attribute [rw] network_interfaces
    #   Information about one or more network interfaces.
    #   @return [Array<Types::NetworkInterface>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeNetworkInterfacesResult AWS API Documentation
    #
    class DescribeNetworkInterfacesResult < Struct.new(
      :network_interfaces,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribePlacementGroupsRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         dry_run: false,
    #         group_names: ["PlacementGroupName"],
    #         group_ids: ["PlacementGroupId"],
    #       }
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `group-name` - The name of the placement group.
    #
    #   * `state` - The state of the placement group (`pending` \|
    #     `available` \| `deleting` \| `deleted`).
    #
    #   * `strategy` - The strategy of the placement group (`cluster` \|
    #     `spread` \| `partition`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources that have a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] group_names
    #   The names of the placement groups.
    #
    #   Default: Describes all your placement groups, or only those
    #   otherwise specified.
    #   @return [Array<String>]
    #
    # @!attribute [rw] group_ids
    #   The IDs of the placement groups.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePlacementGroupsRequest AWS API Documentation
    #
    class DescribePlacementGroupsRequest < Struct.new(
      :filters,
      :dry_run,
      :group_names,
      :group_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] placement_groups
    #   Information about the placement groups.
    #   @return [Array<Types::PlacementGroup>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePlacementGroupsResult AWS API Documentation
    #
    class DescribePlacementGroupsResult < Struct.new(
      :placement_groups)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribePrefixListsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         prefix_list_ids: ["PrefixListResourceId"],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `prefix-list-id`\: The ID of a prefix list.
    #
    #   * `prefix-list-name`\: The name of a prefix list.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] prefix_list_ids
    #   One or more prefix list IDs.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrefixListsRequest AWS API Documentation
    #
    class DescribePrefixListsRequest < Struct.new(
      :dry_run,
      :filters,
      :max_results,
      :next_token,
      :prefix_list_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] prefix_lists
    #   All available prefix lists.
    #   @return [Array<Types::PrefixList>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrefixListsResult AWS API Documentation
    #
    class DescribePrefixListsResult < Struct.new(
      :next_token,
      :prefix_lists)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribePrincipalIdFormatRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         resources: ["String"],
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] resources
    #   The type of resource: `bundle` \| `conversion-task` \|
    #   `customer-gateway` \| `dhcp-options` \| `elastic-ip-allocation` \|
    #   `elastic-ip-association` \| `export-task` \| `flow-log` \| `image`
    #   \| `import-task` \| `instance` \| `internet-gateway` \|
    #   `network-acl` \| `network-acl-association` \| `network-interface` \|
    #   `network-interface-attachment` \| `prefix-list` \| `reservation` \|
    #   `route-table` \| `route-table-association` \| `security-group` \|
    #   `snapshot` \| `subnet` \| `subnet-cidr-block-association` \|
    #   `volume` \| `vpc` \| `vpc-cidr-block-association` \| `vpc-endpoint`
    #   \| `vpc-peering-connection` \| `vpn-connection` \| `vpn-gateway`
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   NextToken value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to request the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrincipalIdFormatRequest AWS API Documentation
    #
    class DescribePrincipalIdFormatRequest < Struct.new(
      :dry_run,
      :resources,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] principals
    #   Information about the ID format settings for the ARN.
    #   @return [Array<Types::PrincipalIdFormat>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   null when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePrincipalIdFormatResult AWS API Documentation
    #
    class DescribePrincipalIdFormatResult < Struct.new(
      :principals,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribePublicIpv4PoolsRequest
    #   data as a hash:
    #
    #       {
    #         pool_ids: ["Ipv4PoolEc2Id"],
    #         next_token: "NextToken",
    #         max_results: 1,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #       }
    #
    # @!attribute [rw] pool_ids
    #   The IDs of the address pools.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePublicIpv4PoolsRequest AWS API Documentation
    #
    class DescribePublicIpv4PoolsRequest < Struct.new(
      :pool_ids,
      :next_token,
      :max_results,
      :filters)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] public_ipv_4_pools
    #   Information about the address pools.
    #   @return [Array<Types::PublicIpv4Pool>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribePublicIpv4PoolsResult AWS API Documentation
    #
    class DescribePublicIpv4PoolsResult < Struct.new(
      :public_ipv_4_pools,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeRegionsRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         region_names: ["String"],
    #         dry_run: false,
    #         all_regions: false,
    #       }
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `endpoint` - The endpoint of the Region (for example,
    #     `ec2.us-east-1.amazonaws.com`).
    #
    #   * `opt-in-status` - The opt-in status of the Region
    #     (`opt-in-not-required` \| `opted-in` \| `not-opted-in`).
    #
    #   * `region-name` - The name of the Region (for example, `us-east-1`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] region_names
    #   The names of the Regions. You can specify any Regions, whether they
    #   are enabled and disabled for your account.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] all_regions
    #   Indicates whether to display all Regions, including Regions that are
    #   disabled for your account.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRegionsRequest AWS API Documentation
    #
    class DescribeRegionsRequest < Struct.new(
      :filters,
      :region_names,
      :dry_run,
      :all_regions)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] regions
    #   Information about the Regions.
    #   @return [Array<Types::Region>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRegionsResult AWS API Documentation
    #
    class DescribeRegionsResult < Struct.new(
      :regions)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeReservedInstancesListings.
    #
    # @note When making an API call, you may pass DescribeReservedInstancesListingsRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         reserved_instances_id: "ReservationId",
    #         reserved_instances_listing_id: "ReservedInstancesListingId",
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `reserved-instances-id` - The ID of the Reserved Instances.
    #
    #   * `reserved-instances-listing-id` - The ID of the Reserved Instances
    #     listing.
    #
    #   * `status` - The status of the Reserved Instance listing (`pending`
    #     \| `active` \| `cancelled` \| `closed`).
    #
    #   * `status-message` - The reason for the status.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] reserved_instances_id
    #   One or more Reserved Instance IDs.
    #   @return [String]
    #
    # @!attribute [rw] reserved_instances_listing_id
    #   One or more Reserved Instance listing IDs.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesListingsRequest AWS API Documentation
    #
    class DescribeReservedInstancesListingsRequest < Struct.new(
      :filters,
      :reserved_instances_id,
      :reserved_instances_listing_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeReservedInstancesListings.
    #
    # @!attribute [rw] reserved_instances_listings
    #   Information about the Reserved Instance listing.
    #   @return [Array<Types::ReservedInstancesListing>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesListingsResult AWS API Documentation
    #
    class DescribeReservedInstancesListingsResult < Struct.new(
      :reserved_instances_listings)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeReservedInstancesModifications.
    #
    # @note When making an API call, you may pass DescribeReservedInstancesModificationsRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         reserved_instances_modification_ids: ["ReservedInstancesModificationId"],
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `client-token` - The idempotency token for the modification
    #     request.
    #
    #   * `create-date` - The time when the modification request was
    #     created.
    #
    #   * `effective-date` - The time when the modification becomes
    #     effective.
    #
    #   * `modification-result.reserved-instances-id` - The ID for the
    #     Reserved Instances created as part of the modification request.
    #     This ID is only available when the status of the modification is
    #     `fulfilled`.
    #
    #   * `modification-result.target-configuration.availability-zone` - The
    #     Availability Zone for the new Reserved Instances.
    #
    #   * `modification-result.target-configuration.instance-count ` - The
    #     number of new Reserved Instances.
    #
    #   * `modification-result.target-configuration.instance-type` - The
    #     instance type of the new Reserved Instances.
    #
    #   * `modification-result.target-configuration.platform` - The network
    #     platform of the new Reserved Instances (`EC2-Classic` \|
    #     `EC2-VPC`).
    #
    #   * `reserved-instances-id` - The ID of the Reserved Instances
    #     modified.
    #
    #   * `reserved-instances-modification-id` - The ID of the modification
    #     request.
    #
    #   * `status` - The status of the Reserved Instances modification
    #     request (`processing` \| `fulfilled` \| `failed`).
    #
    #   * `status-message` - The reason for the status.
    #
    #   * `update-date` - The time when the modification request was last
    #     updated.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] reserved_instances_modification_ids
    #   IDs for the submitted modification request.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesModificationsRequest AWS API Documentation
    #
    class DescribeReservedInstancesModificationsRequest < Struct.new(
      :filters,
      :reserved_instances_modification_ids,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeReservedInstancesModifications.
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] reserved_instances_modifications
    #   The Reserved Instance modification information.
    #   @return [Array<Types::ReservedInstancesModification>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesModificationsResult AWS API Documentation
    #
    class DescribeReservedInstancesModificationsResult < Struct.new(
      :next_token,
      :reserved_instances_modifications)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeReservedInstancesOfferings.
    #
    # @note When making an API call, you may pass DescribeReservedInstancesOfferingsRequest
    #   data as a hash:
    #
    #       {
    #         availability_zone: "String",
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         include_marketplace: false,
    #         instance_type: "t1.micro", # accepts t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, t4g.nano, t4g.micro, t4g.small, t4g.medium, t4g.large, t4g.xlarge, t4g.2xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, cr1.8xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5b.large, r5b.xlarge, r5b.2xlarge, r5b.4xlarge, r5b.8xlarge, r5b.12xlarge, r5b.16xlarge, r5b.24xlarge, r5b.metal, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, r6g.metal, r6g.medium, r6g.large, r6g.xlarge, r6g.2xlarge, r6g.4xlarge, r6g.8xlarge, r6g.12xlarge, r6g.16xlarge, r6gd.metal, r6gd.medium, r6gd.large, r6gd.xlarge, r6gd.2xlarge, r6gd.4xlarge, r6gd.8xlarge, r6gd.12xlarge, r6gd.16xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, hi1.4xlarge, hs1.8xlarge, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5a.large, c5a.xlarge, c5a.2xlarge, c5a.4xlarge, c5a.8xlarge, c5a.12xlarge, c5a.16xlarge, c5a.24xlarge, c5ad.large, c5ad.xlarge, c5ad.2xlarge, c5ad.4xlarge, c5ad.8xlarge, c5ad.12xlarge, c5ad.16xlarge, c5ad.24xlarge, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.12xlarge, c5d.18xlarge, c5d.24xlarge, c5d.metal, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, c5n.metal, c6g.metal, c6g.medium, c6g.large, c6g.xlarge, c6g.2xlarge, c6g.4xlarge, c6g.8xlarge, c6g.12xlarge, c6g.16xlarge, c6gd.metal, c6gd.medium, c6gd.large, c6gd.xlarge, c6gd.2xlarge, c6gd.4xlarge, c6gd.8xlarge, c6gd.12xlarge, c6gd.16xlarge, c6gn.medium, c6gn.large, c6gn.xlarge, c6gn.2xlarge, c6gn.4xlarge, c6gn.8xlarge, c6gn.12xlarge, c6gn.16xlarge, cc1.4xlarge, cc2.8xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, g4ad.4xlarge, g4ad.8xlarge, g4ad.16xlarge, g4dn.xlarge, g4dn.2xlarge, g4dn.4xlarge, g4dn.8xlarge, g4dn.12xlarge, g4dn.16xlarge, g4dn.metal, cg1.4xlarge, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, p4d.24xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, d3.xlarge, d3.2xlarge, d3.4xlarge, d3.8xlarge, d3en.xlarge, d3en.2xlarge, d3en.4xlarge, d3en.6xlarge, d3en.8xlarge, d3en.12xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, m5zn.large, m5zn.xlarge, m5zn.2xlarge, m5zn.3xlarge, m5zn.6xlarge, m5zn.12xlarge, m5zn.metal, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, u-18tb1.metal, u-24tb1.metal, a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge, a1.metal, m5dn.large, m5dn.xlarge, m5dn.2xlarge, m5dn.4xlarge, m5dn.8xlarge, m5dn.12xlarge, m5dn.16xlarge, m5dn.24xlarge, m5n.large, m5n.xlarge, m5n.2xlarge, m5n.4xlarge, m5n.8xlarge, m5n.12xlarge, m5n.16xlarge, m5n.24xlarge, r5dn.large, r5dn.xlarge, r5dn.2xlarge, r5dn.4xlarge, r5dn.8xlarge, r5dn.12xlarge, r5dn.16xlarge, r5dn.24xlarge, r5n.large, r5n.xlarge, r5n.2xlarge, r5n.4xlarge, r5n.8xlarge, r5n.12xlarge, r5n.16xlarge, r5n.24xlarge, inf1.xlarge, inf1.2xlarge, inf1.6xlarge, inf1.24xlarge, m6g.metal, m6g.medium, m6g.large, m6g.xlarge, m6g.2xlarge, m6g.4xlarge, m6g.8xlarge, m6g.12xlarge, m6g.16xlarge, m6gd.metal, m6gd.medium, m6gd.large, m6gd.xlarge, m6gd.2xlarge, m6gd.4xlarge, m6gd.8xlarge, m6gd.12xlarge, m6gd.16xlarge, mac1.metal
    #         max_duration: 1,
    #         max_instance_count: 1,
    #         min_duration: 1,
    #         offering_class: "standard", # accepts standard, convertible
    #         product_description: "Linux/UNIX", # accepts Linux/UNIX, Linux/UNIX (Amazon VPC), Windows, Windows (Amazon VPC)
    #         reserved_instances_offering_ids: ["ReservedInstancesOfferingId"],
    #         dry_run: false,
    #         instance_tenancy: "default", # accepts default, dedicated, host
    #         max_results: 1,
    #         next_token: "String",
    #         offering_type: "Heavy Utilization", # accepts Heavy Utilization, Medium Utilization, Light Utilization, No Upfront, Partial Upfront, All Upfront
    #       }
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone in which the Reserved Instance can be used.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `availability-zone` - The Availability Zone where the Reserved
    #     Instance can be used.
    #
    #   * `duration` - The duration of the Reserved Instance (for example,
    #     one year or three years), in seconds (`31536000` \| `94608000`).
    #
    #   * `fixed-price` - The purchase price of the Reserved Instance (for
    #     example, 9800.0).
    #
    #   * `instance-type` - The instance type that is covered by the
    #     reservation.
    #
    #   * `marketplace` - Set to `true` to show only Reserved Instance
    #     Marketplace offerings. When this filter is not used, which is the
    #     default behavior, all offerings from both AWS and the Reserved
    #     Instance Marketplace are listed.
    #
    #   * `product-description` - The Reserved Instance product platform
    #     description. Instances that include `(Amazon VPC)` in the product
    #     platform description will only be displayed to EC2-Classic account
    #     holders and are for use with Amazon VPC. (`Linux/UNIX` \|
    #     `Linux/UNIX (Amazon VPC)` \| `SUSE Linux` \| `SUSE Linux (Amazon
    #     VPC)` \| `Red Hat Enterprise Linux` \| `Red Hat Enterprise Linux
    #     (Amazon VPC)` \| `Windows` \| `Windows (Amazon VPC)` \| `Windows
    #     with SQL Server Standard` \| `Windows with SQL Server Standard
    #     (Amazon VPC)` \| `Windows with SQL Server Web` \| ` Windows with
    #     SQL Server Web (Amazon VPC)` \| `Windows with SQL Server
    #     Enterprise` \| `Windows with SQL Server Enterprise (Amazon VPC)`)
    #
    #   * `reserved-instances-offering-id` - The Reserved Instances offering
    #     ID.
    #
    #   * `scope` - The scope of the Reserved Instance (`Availability Zone`
    #     or `Region`).
    #
    #   * `usage-price` - The usage price of the Reserved Instance, per hour
    #     (for example, 0.84).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] include_marketplace
    #   Include Reserved Instance Marketplace offerings in the response.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_type
    #   The instance type that the reservation will cover (for example,
    #   `m1.small`). For more information, see [Instance types][1] in the
    #   *Amazon EC2 User Guide*.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html
    #   @return [String]
    #
    # @!attribute [rw] max_duration
    #   The maximum duration (in seconds) to filter when searching for
    #   offerings.
    #
    #   Default: 94608000 (3 years)
    #   @return [Integer]
    #
    # @!attribute [rw] max_instance_count
    #   The maximum number of instances to filter when searching for
    #   offerings.
    #
    #   Default: 20
    #   @return [Integer]
    #
    # @!attribute [rw] min_duration
    #   The minimum duration (in seconds) to filter when searching for
    #   offerings.
    #
    #   Default: 2592000 (1 month)
    #   @return [Integer]
    #
    # @!attribute [rw] offering_class
    #   The offering class of the Reserved Instance. Can be `standard` or
    #   `convertible`.
    #   @return [String]
    #
    # @!attribute [rw] product_description
    #   The Reserved Instance product platform description. Instances that
    #   include `(Amazon VPC)` in the description are for use with Amazon
    #   VPC.
    #   @return [String]
    #
    # @!attribute [rw] reserved_instances_offering_ids
    #   One or more Reserved Instances offering IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_tenancy
    #   The tenancy of the instances covered by the reservation. A Reserved
    #   Instance with a tenancy of `dedicated` is applied to instances that
    #   run in a VPC on single-tenant hardware (i.e., Dedicated Instances).
    #
    #   **Important:** The `host` value cannot be used with this parameter.
    #   Use the `default` or `dedicated` values only.
    #
    #   Default: `default`
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results of the initial request can be seen by
    #   sending another request with the returned `NextToken` value. The
    #   maximum is 100.
    #
    #   Default: 100
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] offering_type
    #   The Reserved Instance offering type. If you are using tools that
    #   predate the 2011-11-01 API version, you only have access to the
    #   `Medium Utilization` Reserved Instance offering type.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesOfferingsRequest AWS API Documentation
    #
    class DescribeReservedInstancesOfferingsRequest < Struct.new(
      :availability_zone,
      :filters,
      :include_marketplace,
      :instance_type,
      :max_duration,
      :max_instance_count,
      :min_duration,
      :offering_class,
      :product_description,
      :reserved_instances_offering_ids,
      :dry_run,
      :instance_tenancy,
      :max_results,
      :next_token,
      :offering_type)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeReservedInstancesOfferings.
    #
    # @!attribute [rw] reserved_instances_offerings
    #   A list of Reserved Instances offerings.
    #   @return [Array<Types::ReservedInstancesOffering>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesOfferingsResult AWS API Documentation
    #
    class DescribeReservedInstancesOfferingsResult < Struct.new(
      :reserved_instances_offerings,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeReservedInstances.
    #
    # @note When making an API call, you may pass DescribeReservedInstancesRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         offering_class: "standard", # accepts standard, convertible
    #         reserved_instances_ids: ["ReservationId"],
    #         dry_run: false,
    #         offering_type: "Heavy Utilization", # accepts Heavy Utilization, Medium Utilization, Light Utilization, No Upfront, Partial Upfront, All Upfront
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `availability-zone` - The Availability Zone where the Reserved
    #     Instance can be used.
    #
    #   * `duration` - The duration of the Reserved Instance (one year or
    #     three years), in seconds (`31536000` \| `94608000`).
    #
    #   * `end` - The time when the Reserved Instance expires (for example,
    #     2015-08-07T11:54:42.000Z).
    #
    #   * `fixed-price` - The purchase price of the Reserved Instance (for
    #     example, 9800.0).
    #
    #   * `instance-type` - The instance type that is covered by the
    #     reservation.
    #
    #   * `scope` - The scope of the Reserved Instance (`Region` or
    #     `Availability Zone`).
    #
    #   * `product-description` - The Reserved Instance product platform
    #     description. Instances that include `(Amazon VPC)` in the product
    #     platform description will only be displayed to EC2-Classic account
    #     holders and are for use with Amazon VPC (`Linux/UNIX` \|
    #     `Linux/UNIX (Amazon VPC)` \| `SUSE Linux` \| `SUSE Linux (Amazon
    #     VPC)` \| `Red Hat Enterprise Linux` \| `Red Hat Enterprise Linux
    #     (Amazon VPC)` \| `Windows` \| `Windows (Amazon VPC)` \| `Windows
    #     with SQL Server Standard` \| `Windows with SQL Server Standard
    #     (Amazon VPC)` \| `Windows with SQL Server Web` \| `Windows with
    #     SQL Server Web (Amazon VPC)` \| `Windows with SQL Server
    #     Enterprise` \| `Windows with SQL Server Enterprise (Amazon VPC)`).
    #
    #   * `reserved-instances-id` - The ID of the Reserved Instance.
    #
    #   * `start` - The time at which the Reserved Instance purchase request
    #     was placed (for example, 2014-08-07T11:54:42.000Z).
    #
    #   * `state` - The state of the Reserved Instance (`payment-pending` \|
    #     `active` \| `payment-failed` \| `retired`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `usage-price` - The usage price of the Reserved Instance, per hour
    #     (for example, 0.84).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] offering_class
    #   Describes whether the Reserved Instance is Standard or Convertible.
    #   @return [String]
    #
    # @!attribute [rw] reserved_instances_ids
    #   One or more Reserved Instance IDs.
    #
    #   Default: Describes all your Reserved Instances, or only those
    #   otherwise specified.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] offering_type
    #   The Reserved Instance offering type. If you are using tools that
    #   predate the 2011-11-01 API version, you only have access to the
    #   `Medium Utilization` Reserved Instance offering type.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesRequest AWS API Documentation
    #
    class DescribeReservedInstancesRequest < Struct.new(
      :filters,
      :offering_class,
      :reserved_instances_ids,
      :dry_run,
      :offering_type)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output for DescribeReservedInstances.
    #
    # @!attribute [rw] reserved_instances
    #   A list of Reserved Instances.
    #   @return [Array<Types::ReservedInstances>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeReservedInstancesResult AWS API Documentation
    #
    class DescribeReservedInstancesResult < Struct.new(
      :reserved_instances)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeRouteTablesRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         dry_run: false,
    #         route_table_ids: ["RouteTableId"],
    #         next_token: "String",
    #         max_results: 1,
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `association.route-table-association-id` - The ID of an
    #     association ID for the route table.
    #
    #   * `association.route-table-id` - The ID of the route table involved
    #     in the association.
    #
    #   * `association.subnet-id` - The ID of the subnet involved in the
    #     association.
    #
    #   * `association.main` - Indicates whether the route table is the main
    #     route table for the VPC (`true` \| `false`). Route tables that do
    #     not have an association ID are not returned in the response.
    #
    #   * `owner-id` - The ID of the AWS account that owns the route table.
    #
    #   * `route-table-id` - The ID of the route table.
    #
    #   * `route.destination-cidr-block` - The IPv4 CIDR range specified in
    #     a route in the table.
    #
    #   * `route.destination-ipv6-cidr-block` - The IPv6 CIDR range
    #     specified in a route in the route table.
    #
    #   * `route.destination-prefix-list-id` - The ID (prefix) of the AWS
    #     service specified in a route in the table.
    #
    #   * `route.egress-only-internet-gateway-id` - The ID of an egress-only
    #     Internet gateway specified in a route in the route table.
    #
    #   * `route.gateway-id` - The ID of a gateway specified in a route in
    #     the table.
    #
    #   * `route.instance-id` - The ID of an instance specified in a route
    #     in the table.
    #
    #   * `route.nat-gateway-id` - The ID of a NAT gateway.
    #
    #   * `route.transit-gateway-id` - The ID of a transit gateway.
    #
    #   * `route.origin` - Describes how the route was created.
    #     `CreateRouteTable` indicates that the route was automatically
    #     created when the route table was created; `CreateRoute` indicates
    #     that the route was manually added to the route table;
    #     `EnableVgwRoutePropagation` indicates that the route was
    #     propagated by route propagation.
    #
    #   * `route.state` - The state of a route in the route table (`active`
    #     \| `blackhole`). The blackhole state indicates that the route's
    #     target isn't available (for example, the specified gateway isn't
    #     attached to the VPC, the specified NAT instance has been
    #     terminated, and so on).
    #
    #   * `route.vpc-peering-connection-id` - The ID of a VPC peering
    #     connection specified in a route in the table.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC for the route table.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] route_table_ids
    #   One or more route table IDs.
    #
    #   Default: Describes all your route tables.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRouteTablesRequest AWS API Documentation
    #
    class DescribeRouteTablesRequest < Struct.new(
      :filters,
      :dry_run,
      :route_table_ids,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeRouteTables.
    #
    # @!attribute [rw] route_tables
    #   Information about one or more route tables.
    #   @return [Array<Types::RouteTable>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeRouteTablesResult AWS API Documentation
    #
    class DescribeRouteTablesResult < Struct.new(
      :route_tables,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeScheduledInstanceAvailability.
    #
    # @note When making an API call, you may pass DescribeScheduledInstanceAvailabilityRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         first_slot_start_time_range: { # required
    #           earliest_time: Time.now, # required
    #           latest_time: Time.now, # required
    #         },
    #         max_results: 1,
    #         max_slot_duration_in_hours: 1,
    #         min_slot_duration_in_hours: 1,
    #         next_token: "String",
    #         recurrence: { # required
    #           frequency: "String",
    #           interval: 1,
    #           occurrence_days: [1],
    #           occurrence_relative_to_end: false,
    #           occurrence_unit: "String",
    #         },
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `availability-zone` - The Availability Zone (for example,
    #     `us-west-2a`).
    #
    #   * `instance-type` - The instance type (for example, `c4.large`).
    #
    #   * `network-platform` - The network platform (`EC2-Classic` or
    #     `EC2-VPC`).
    #
    #   * `platform` - The platform (`Linux/UNIX` or `Windows`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] first_slot_start_time_range
    #   The time period for the first schedule to start.
    #   @return [Types::SlotDateTimeRangeRequest]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. This value
    #   can be between 5 and 300. The default value is 300. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #   @return [Integer]
    #
    # @!attribute [rw] max_slot_duration_in_hours
    #   The maximum available duration, in hours. This value must be greater
    #   than `MinSlotDurationInHours` and less than 1,720.
    #   @return [Integer]
    #
    # @!attribute [rw] min_slot_duration_in_hours
    #   The minimum available duration, in hours. The minimum required
    #   duration is 1,200 hours per year. For example, the minimum daily
    #   schedule is 4 hours, the minimum weekly schedule is 24 hours, and
    #   the minimum monthly schedule is 100 hours.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next set of results.
    #   @return [String]
    #
    # @!attribute [rw] recurrence
    #   The schedule recurrence.
    #   @return [Types::ScheduledInstanceRecurrenceRequest]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstanceAvailabilityRequest AWS API Documentation
    #
    class DescribeScheduledInstanceAvailabilityRequest < Struct.new(
      :dry_run,
      :filters,
      :first_slot_start_time_range,
      :max_results,
      :max_slot_duration_in_hours,
      :min_slot_duration_in_hours,
      :next_token,
      :recurrence)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeScheduledInstanceAvailability.
    #
    # @!attribute [rw] next_token
    #   The token required to retrieve the next set of results. This value
    #   is `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] scheduled_instance_availability_set
    #   Information about the available Scheduled Instances.
    #   @return [Array<Types::ScheduledInstanceAvailability>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstanceAvailabilityResult AWS API Documentation
    #
    class DescribeScheduledInstanceAvailabilityResult < Struct.new(
      :next_token,
      :scheduled_instance_availability_set)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeScheduledInstances.
    #
    # @note When making an API call, you may pass DescribeScheduledInstancesRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         scheduled_instance_ids: ["ScheduledInstanceId"],
    #         slot_start_time_range: {
    #           earliest_time: Time.now,
    #           latest_time: Time.now,
    #         },
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `availability-zone` - The Availability Zone (for example,
    #     `us-west-2a`).
    #
    #   * `instance-type` - The instance type (for example, `c4.large`).
    #
    #   * `network-platform` - The network platform (`EC2-Classic` or
    #     `EC2-VPC`).
    #
    #   * `platform` - The platform (`Linux/UNIX` or `Windows`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. This value
    #   can be between 5 and 300. The default value is 100. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next set of results.
    #   @return [String]
    #
    # @!attribute [rw] scheduled_instance_ids
    #   The Scheduled Instance IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] slot_start_time_range
    #   The time period for the first schedule to start.
    #   @return [Types::SlotStartTimeRangeRequest]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstancesRequest AWS API Documentation
    #
    class DescribeScheduledInstancesRequest < Struct.new(
      :dry_run,
      :filters,
      :max_results,
      :next_token,
      :scheduled_instance_ids,
      :slot_start_time_range)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeScheduledInstances.
    #
    # @!attribute [rw] next_token
    #   The token required to retrieve the next set of results. This value
    #   is `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] scheduled_instance_set
    #   Information about the Scheduled Instances.
    #   @return [Array<Types::ScheduledInstance>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeScheduledInstancesResult AWS API Documentation
    #
    class DescribeScheduledInstancesResult < Struct.new(
      :next_token,
      :scheduled_instance_set)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeSecurityGroupReferencesRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         group_id: ["SecurityGroupId"], # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] group_id
    #   The IDs of the security groups in your account.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroupReferencesRequest AWS API Documentation
    #
    class DescribeSecurityGroupReferencesRequest < Struct.new(
      :dry_run,
      :group_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] security_group_reference_set
    #   Information about the VPCs with the referencing security groups.
    #   @return [Array<Types::SecurityGroupReference>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroupReferencesResult AWS API Documentation
    #
    class DescribeSecurityGroupReferencesResult < Struct.new(
      :security_group_reference_set)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeSecurityGroupsRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         group_ids: ["String"],
    #         group_names: ["SecurityGroupName"],
    #         dry_run: false,
    #         next_token: "String",
    #         max_results: 1,
    #       }
    #
    # @!attribute [rw] filters
    #   The filters. If using multiple filters for rules, the results
    #   include security groups for which any combination of rules - not
    #   necessarily a single rule - match all filters.
    #
    #   * `description` - The description of the security group.
    #
    #   * `egress.ip-permission.cidr` - An IPv4 CIDR block for an outbound
    #     security group rule.
    #
    #   * `egress.ip-permission.from-port` - For an outbound rule, the start
    #     of port range for the TCP and UDP protocols, or an ICMP type
    #     number.
    #
    #   * `egress.ip-permission.group-id` - The ID of a security group that
    #     has been referenced in an outbound security group rule.
    #
    #   * `egress.ip-permission.group-name` - The name of a security group
    #     that is referenced in an outbound security group rule.
    #
    #   * `egress.ip-permission.ipv6-cidr` - An IPv6 CIDR block for an
    #     outbound security group rule.
    #
    #   * `egress.ip-permission.prefix-list-id` - The ID of a prefix list to
    #     which a security group rule allows outbound access.
    #
    #   * `egress.ip-permission.protocol` - The IP protocol for an outbound
    #     security group rule (`tcp` \| `udp` \| `icmp`, a protocol number,
    #     or -1 for all protocols).
    #
    #   * `egress.ip-permission.to-port` - For an outbound rule, the end of
    #     port range for the TCP and UDP protocols, or an ICMP code.
    #
    #   * `egress.ip-permission.user-id` - The ID of an AWS account that has
    #     been referenced in an outbound security group rule.
    #
    #   * `group-id` - The ID of the security group.
    #
    #   * `group-name` - The name of the security group.
    #
    #   * `ip-permission.cidr` - An IPv4 CIDR block for an inbound security
    #     group rule.
    #
    #   * `ip-permission.from-port` - For an inbound rule, the start of port
    #     range for the TCP and UDP protocols, or an ICMP type number.
    #
    #   * `ip-permission.group-id` - The ID of a security group that has
    #     been referenced in an inbound security group rule.
    #
    #   * `ip-permission.group-name` - The name of a security group that is
    #     referenced in an inbound security group rule.
    #
    #   * `ip-permission.ipv6-cidr` - An IPv6 CIDR block for an inbound
    #     security group rule.
    #
    #   * `ip-permission.prefix-list-id` - The ID of a prefix list from
    #     which a security group rule allows inbound access.
    #
    #   * `ip-permission.protocol` - The IP protocol for an inbound security
    #     group rule (`tcp` \| `udp` \| `icmp`, a protocol number, or -1 for
    #     all protocols).
    #
    #   * `ip-permission.to-port` - For an inbound rule, the end of port
    #     range for the TCP and UDP protocols, or an ICMP code.
    #
    #   * `ip-permission.user-id` - The ID of an AWS account that has been
    #     referenced in an inbound security group rule.
    #
    #   * `owner-id` - The AWS account ID of the owner of the security
    #     group.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC specified when the security group was
    #     created.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] group_ids
    #   The IDs of the security groups. Required for security groups in a
    #   nondefault VPC.
    #
    #   Default: Describes all your security groups.
    #   @return [Array<String>]
    #
    # @!attribute [rw] group_names
    #   \[EC2-Classic and default VPC only\] The names of the security
    #   groups. You can specify either the security group name or the
    #   security group ID. For security groups in a nondefault VPC, use the
    #   `group-name` filter to describe security groups by name.
    #
    #   Default: Describes all your security groups.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] next_token
    #   The token to request the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. To
    #   retrieve the remaining results, make another request with the
    #   returned `NextToken` value. This value can be between 5 and 1000. If
    #   this parameter is not specified, then all results are returned.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroupsRequest AWS API Documentation
    #
    class DescribeSecurityGroupsRequest < Struct.new(
      :filters,
      :group_ids,
      :group_names,
      :dry_run,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] security_groups
    #   Information about the security groups.
    #   @return [Array<Types::SecurityGroup>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSecurityGroupsResult AWS API Documentation
    #
    class DescribeSecurityGroupsResult < Struct.new(
      :security_groups,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeSnapshotAttributeRequest
    #   data as a hash:
    #
    #       {
    #         attribute: "productCodes", # required, accepts productCodes, createVolumePermission
    #         snapshot_id: "SnapshotId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] attribute
    #   The snapshot attribute you would like to view.
    #   @return [String]
    #
    # @!attribute [rw] snapshot_id
    #   The ID of the EBS snapshot.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshotAttributeRequest AWS API Documentation
    #
    class DescribeSnapshotAttributeRequest < Struct.new(
      :attribute,
      :snapshot_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] create_volume_permissions
    #   The users and groups that have the permissions for creating volumes
    #   from the snapshot.
    #   @return [Array<Types::CreateVolumePermission>]
    #
    # @!attribute [rw] product_codes
    #   The product codes.
    #   @return [Array<Types::ProductCode>]
    #
    # @!attribute [rw] snapshot_id
    #   The ID of the EBS snapshot.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshotAttributeResult AWS API Documentation
    #
    class DescribeSnapshotAttributeResult < Struct.new(
      :create_volume_permissions,
      :product_codes,
      :snapshot_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeSnapshotsRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         owner_ids: ["String"],
    #         restorable_by_user_ids: ["String"],
    #         snapshot_ids: ["SnapshotId"],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `description` - A description of the snapshot.
    #
    #   * `encrypted` - Indicates whether the snapshot is encrypted (`true`
    #     \| `false`)
    #
    #   * `owner-alias` - The owner alias, from an Amazon-maintained list
    #     (`amazon`). This is not the user-configured AWS account alias set
    #     using the IAM console. We recommend that you use the related
    #     parameter instead of this filter.
    #
    #   * `owner-id` - The AWS account ID of the owner. We recommend that
    #     you use the related parameter instead of this filter.
    #
    #   * `progress` - The progress of the snapshot, as a percentage (for
    #     example, 80%).
    #
    #   * `snapshot-id` - The snapshot ID.
    #
    #   * `start-time` - The time stamp when the snapshot was initiated.
    #
    #   * `status` - The status of the snapshot (`pending` \| `completed` \|
    #     `error`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `volume-id` - The ID of the volume the snapshot is for.
    #
    #   * `volume-size` - The size of the volume, in GiB.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of snapshot results returned by
    #   `DescribeSnapshots` in paginated output. When this parameter is
    #   used, `DescribeSnapshots` only returns `MaxResults` results in a
    #   single page along with a `NextToken` response element. The remaining
    #   results of the initial request can be seen by sending another
    #   `DescribeSnapshots` request with the returned `NextToken` value.
    #   This value can be between 5 and 1,000; if `MaxResults` is given a
    #   value larger than 1,000, only 1,000 results are returned. If this
    #   parameter is not used, then `DescribeSnapshots` returns all results.
    #   You cannot specify this parameter and the snapshot IDs parameter in
    #   the same request.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The `NextToken` value returned from a previous paginated
    #   `DescribeSnapshots` request where `MaxResults` was used and the
    #   results exceeded the value of that parameter. Pagination continues
    #   from the end of the previous results that returned the `NextToken`
    #   value. This value is `null` when there are no more results to
    #   return.
    #   @return [String]
    #
    # @!attribute [rw] owner_ids
    #   Scopes the results to snapshots with the specified owners. You can
    #   specify a combination of AWS account IDs, `self`, and `amazon`.
    #   @return [Array<String>]
    #
    # @!attribute [rw] restorable_by_user_ids
    #   The IDs of the AWS accounts that can create volumes from the
    #   snapshot.
    #   @return [Array<String>]
    #
    # @!attribute [rw] snapshot_ids
    #   The snapshot IDs.
    #
    #   Default: Describes the snapshots for which you have create volume
    #   permissions.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshotsRequest AWS API Documentation
    #
    class DescribeSnapshotsRequest < Struct.new(
      :filters,
      :max_results,
      :next_token,
      :owner_ids,
      :restorable_by_user_ids,
      :snapshot_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] snapshots
    #   Information about the snapshots.
    #   @return [Array<Types::Snapshot>]
    #
    # @!attribute [rw] next_token
    #   The `NextToken` value to include in a future `DescribeSnapshots`
    #   request. When the results of a `DescribeSnapshots` request exceed
    #   `MaxResults`, this value can be used to retrieve the next page of
    #   results. This value is `null` when there are no more results to
    #   return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSnapshotsResult AWS API Documentation
    #
    class DescribeSnapshotsResult < Struct.new(
      :snapshots,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeSpotDatafeedSubscription.
    #
    # @note When making an API call, you may pass DescribeSpotDatafeedSubscriptionRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotDatafeedSubscriptionRequest AWS API Documentation
    #
    class DescribeSpotDatafeedSubscriptionRequest < Struct.new(
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeSpotDatafeedSubscription.
    #
    # @!attribute [rw] spot_datafeed_subscription
    #   The Spot Instance data feed subscription.
    #   @return [Types::SpotDatafeedSubscription]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotDatafeedSubscriptionResult AWS API Documentation
    #
    class DescribeSpotDatafeedSubscriptionResult < Struct.new(
      :spot_datafeed_subscription)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeSpotFleetInstances.
    #
    # @note When making an API call, you may pass DescribeSpotFleetInstancesRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         max_results: 1,
    #         next_token: "String",
    #         spot_fleet_request_id: "SpotFleetRequestId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next set of results.
    #   @return [String]
    #
    # @!attribute [rw] spot_fleet_request_id
    #   The ID of the Spot Fleet request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetInstancesRequest AWS API Documentation
    #
    class DescribeSpotFleetInstancesRequest < Struct.new(
      :dry_run,
      :max_results,
      :next_token,
      :spot_fleet_request_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeSpotFleetInstances.
    #
    # @!attribute [rw] active_instances
    #   The running instances. This list is refreshed periodically and might
    #   be out of date.
    #   @return [Array<Types::ActiveInstance>]
    #
    # @!attribute [rw] next_token
    #   The token required to retrieve the next set of results. This value
    #   is `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] spot_fleet_request_id
    #   The ID of the Spot Fleet request.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetInstancesResponse AWS API Documentation
    #
    class DescribeSpotFleetInstancesResponse < Struct.new(
      :active_instances,
      :next_token,
      :spot_fleet_request_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeSpotFleetRequestHistory.
    #
    # @note When making an API call, you may pass DescribeSpotFleetRequestHistoryRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         event_type: "instanceChange", # accepts instanceChange, fleetRequestChange, error, information
    #         max_results: 1,
    #         next_token: "String",
    #         spot_fleet_request_id: "SpotFleetRequestId", # required
    #         start_time: Time.now, # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] event_type
    #   The type of events to describe. By default, all events are
    #   described.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next set of results.
    #   @return [String]
    #
    # @!attribute [rw] spot_fleet_request_id
    #   The ID of the Spot Fleet request.
    #   @return [String]
    #
    # @!attribute [rw] start_time
    #   The starting date and time for the events, in UTC format (for
    #   example, *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z).
    #   @return [Time]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequestHistoryRequest AWS API Documentation
    #
    class DescribeSpotFleetRequestHistoryRequest < Struct.new(
      :dry_run,
      :event_type,
      :max_results,
      :next_token,
      :spot_fleet_request_id,
      :start_time)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeSpotFleetRequestHistory.
    #
    # @!attribute [rw] history_records
    #   Information about the events in the history of the Spot Fleet
    #   request.
    #   @return [Array<Types::HistoryRecord>]
    #
    # @!attribute [rw] last_evaluated_time
    #   The last date and time for the events, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z). All records up to this time
    #   were retrieved.
    #
    #   If `nextToken` indicates that there are more results, this value is
    #   not present.
    #   @return [Time]
    #
    # @!attribute [rw] next_token
    #   The token required to retrieve the next set of results. This value
    #   is `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] spot_fleet_request_id
    #   The ID of the Spot Fleet request.
    #   @return [String]
    #
    # @!attribute [rw] start_time
    #   The starting date and time for the events, in UTC format (for
    #   example, *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z).
    #   @return [Time]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequestHistoryResponse AWS API Documentation
    #
    class DescribeSpotFleetRequestHistoryResponse < Struct.new(
      :history_records,
      :last_evaluated_time,
      :next_token,
      :spot_fleet_request_id,
      :start_time)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeSpotFleetRequests.
    #
    # @note When making an API call, you may pass DescribeSpotFleetRequestsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         max_results: 1,
    #         next_token: "String",
    #         spot_fleet_request_ids: ["SpotFleetRequestId"],
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next set of results.
    #   @return [String]
    #
    # @!attribute [rw] spot_fleet_request_ids
    #   The IDs of the Spot Fleet requests.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequestsRequest AWS API Documentation
    #
    class DescribeSpotFleetRequestsRequest < Struct.new(
      :dry_run,
      :max_results,
      :next_token,
      :spot_fleet_request_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeSpotFleetRequests.
    #
    # @!attribute [rw] next_token
    #   The token required to retrieve the next set of results. This value
    #   is `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] spot_fleet_request_configs
    #   Information about the configuration of your Spot Fleet.
    #   @return [Array<Types::SpotFleetRequestConfig>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotFleetRequestsResponse AWS API Documentation
    #
    class DescribeSpotFleetRequestsResponse < Struct.new(
      :next_token,
      :spot_fleet_request_configs)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeSpotInstanceRequests.
    #
    # @note When making an API call, you may pass DescribeSpotInstanceRequestsRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         dry_run: false,
    #         spot_instance_request_ids: ["SpotInstanceRequestId"],
    #         next_token: "String",
    #         max_results: 1,
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `availability-zone-group` - The Availability Zone group.
    #
    #   * `create-time` - The time stamp when the Spot Instance request was
    #     created.
    #
    #   * `fault-code` - The fault code related to the request.
    #
    #   * `fault-message` - The fault message related to the request.
    #
    #   * `instance-id` - The ID of the instance that fulfilled the request.
    #
    #   * `launch-group` - The Spot Instance launch group.
    #
    #   * `launch.block-device-mapping.delete-on-termination` - Indicates
    #     whether the EBS volume is deleted on instance termination.
    #
    #   * `launch.block-device-mapping.device-name` - The device name for
    #     the volume in the block device mapping (for example, `/dev/sdh` or
    #     `xvdh`).
    #
    #   * `launch.block-device-mapping.snapshot-id` - The ID of the snapshot
    #     for the EBS volume.
    #
    #   * `launch.block-device-mapping.volume-size` - The size of the EBS
    #     volume, in GiB.
    #
    #   * `launch.block-device-mapping.volume-type` - The type of EBS
    #     volume: `gp2` for General Purpose SSD, `io1` or `io2` for
    #     Provisioned IOPS SSD, `st1` for Throughput Optimized HDD, `sc1`for
    #     Cold HDD, or `standard` for Magnetic.
    #
    #   * `launch.group-id` - The ID of the security group for the instance.
    #
    #   * `launch.group-name` - The name of the security group for the
    #     instance.
    #
    #   * `launch.image-id` - The ID of the AMI.
    #
    #   * `launch.instance-type` - The type of instance (for example,
    #     `m3.medium`).
    #
    #   * `launch.kernel-id` - The kernel ID.
    #
    #   * `launch.key-name` - The name of the key pair the instance launched
    #     with.
    #
    #   * `launch.monitoring-enabled` - Whether detailed monitoring is
    #     enabled for the Spot Instance.
    #
    #   * `launch.ramdisk-id` - The RAM disk ID.
    #
    #   * `launched-availability-zone` - The Availability Zone in which the
    #     request is launched.
    #
    #   * `network-interface.addresses.primary` - Indicates whether the IP
    #     address is the primary private IP address.
    #
    #   * `network-interface.delete-on-termination` - Indicates whether the
    #     network interface is deleted when the instance is terminated.
    #
    #   * `network-interface.description` - A description of the network
    #     interface.
    #
    #   * `network-interface.device-index` - The index of the device for the
    #     network interface attachment on the instance.
    #
    #   * `network-interface.group-id` - The ID of the security group
    #     associated with the network interface.
    #
    #   * `network-interface.network-interface-id` - The ID of the network
    #     interface.
    #
    #   * `network-interface.private-ip-address` - The primary private IP
    #     address of the network interface.
    #
    #   * `network-interface.subnet-id` - The ID of the subnet for the
    #     instance.
    #
    #   * `product-description` - The product description associated with
    #     the instance (`Linux/UNIX` \| `Windows`).
    #
    #   * `spot-instance-request-id` - The Spot Instance request ID.
    #
    #   * `spot-price` - The maximum hourly price for any Spot Instance
    #     launched to fulfill the request.
    #
    #   * `state` - The state of the Spot Instance request (`open` \|
    #     `active` \| `closed` \| `cancelled` \| `failed`). Spot request
    #     status information can help you track your Amazon EC2 Spot
    #     Instance requests. For more information, see [Spot request
    #     status][1] in the *Amazon EC2 User Guide for Linux Instances*.
    #
    #   * `status-code` - The short code describing the most recent
    #     evaluation of your Spot Instance request.
    #
    #   * `status-message` - The message explaining the status of the Spot
    #     Instance request.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `type` - The type of Spot Instance request (`one-time` \|
    #     `persistent`).
    #
    #   * `valid-from` - The start date of the request.
    #
    #   * `valid-until` - The end date of the request.
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] spot_instance_request_ids
    #   One or more Spot Instance request IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token to request the next set of results. This value is `null`
    #   when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 5 and 1000. To retrieve the remaining results, make
    #   another call with the returned `NextToken` value.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotInstanceRequestsRequest AWS API Documentation
    #
    class DescribeSpotInstanceRequestsRequest < Struct.new(
      :filters,
      :dry_run,
      :spot_instance_request_ids,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeSpotInstanceRequests.
    #
    # @!attribute [rw] spot_instance_requests
    #   One or more Spot Instance requests.
    #   @return [Array<Types::SpotInstanceRequest>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next set of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotInstanceRequestsResult AWS API Documentation
    #
    class DescribeSpotInstanceRequestsResult < Struct.new(
      :spot_instance_requests,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeSpotPriceHistory.
    #
    # @note When making an API call, you may pass DescribeSpotPriceHistoryRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         availability_zone: "String",
    #         dry_run: false,
    #         end_time: Time.now,
    #         instance_types: ["t1.micro"], # accepts t1.micro, t2.nano, t2.micro, t2.small, t2.medium, t2.large, t2.xlarge, t2.2xlarge, t3.nano, t3.micro, t3.small, t3.medium, t3.large, t3.xlarge, t3.2xlarge, t3a.nano, t3a.micro, t3a.small, t3a.medium, t3a.large, t3a.xlarge, t3a.2xlarge, t4g.nano, t4g.micro, t4g.small, t4g.medium, t4g.large, t4g.xlarge, t4g.2xlarge, m1.small, m1.medium, m1.large, m1.xlarge, m3.medium, m3.large, m3.xlarge, m3.2xlarge, m4.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m4.10xlarge, m4.16xlarge, m2.xlarge, m2.2xlarge, m2.4xlarge, cr1.8xlarge, r3.large, r3.xlarge, r3.2xlarge, r3.4xlarge, r3.8xlarge, r4.large, r4.xlarge, r4.2xlarge, r4.4xlarge, r4.8xlarge, r4.16xlarge, r5.large, r5.xlarge, r5.2xlarge, r5.4xlarge, r5.8xlarge, r5.12xlarge, r5.16xlarge, r5.24xlarge, r5.metal, r5a.large, r5a.xlarge, r5a.2xlarge, r5a.4xlarge, r5a.8xlarge, r5a.12xlarge, r5a.16xlarge, r5a.24xlarge, r5b.large, r5b.xlarge, r5b.2xlarge, r5b.4xlarge, r5b.8xlarge, r5b.12xlarge, r5b.16xlarge, r5b.24xlarge, r5b.metal, r5d.large, r5d.xlarge, r5d.2xlarge, r5d.4xlarge, r5d.8xlarge, r5d.12xlarge, r5d.16xlarge, r5d.24xlarge, r5d.metal, r5ad.large, r5ad.xlarge, r5ad.2xlarge, r5ad.4xlarge, r5ad.8xlarge, r5ad.12xlarge, r5ad.16xlarge, r5ad.24xlarge, r6g.metal, r6g.medium, r6g.large, r6g.xlarge, r6g.2xlarge, r6g.4xlarge, r6g.8xlarge, r6g.12xlarge, r6g.16xlarge, r6gd.metal, r6gd.medium, r6gd.large, r6gd.xlarge, r6gd.2xlarge, r6gd.4xlarge, r6gd.8xlarge, r6gd.12xlarge, r6gd.16xlarge, x1.16xlarge, x1.32xlarge, x1e.xlarge, x1e.2xlarge, x1e.4xlarge, x1e.8xlarge, x1e.16xlarge, x1e.32xlarge, i2.xlarge, i2.2xlarge, i2.4xlarge, i2.8xlarge, i3.large, i3.xlarge, i3.2xlarge, i3.4xlarge, i3.8xlarge, i3.16xlarge, i3.metal, i3en.large, i3en.xlarge, i3en.2xlarge, i3en.3xlarge, i3en.6xlarge, i3en.12xlarge, i3en.24xlarge, i3en.metal, hi1.4xlarge, hs1.8xlarge, c1.medium, c1.xlarge, c3.large, c3.xlarge, c3.2xlarge, c3.4xlarge, c3.8xlarge, c4.large, c4.xlarge, c4.2xlarge, c4.4xlarge, c4.8xlarge, c5.large, c5.xlarge, c5.2xlarge, c5.4xlarge, c5.9xlarge, c5.12xlarge, c5.18xlarge, c5.24xlarge, c5.metal, c5a.large, c5a.xlarge, c5a.2xlarge, c5a.4xlarge, c5a.8xlarge, c5a.12xlarge, c5a.16xlarge, c5a.24xlarge, c5ad.large, c5ad.xlarge, c5ad.2xlarge, c5ad.4xlarge, c5ad.8xlarge, c5ad.12xlarge, c5ad.16xlarge, c5ad.24xlarge, c5d.large, c5d.xlarge, c5d.2xlarge, c5d.4xlarge, c5d.9xlarge, c5d.12xlarge, c5d.18xlarge, c5d.24xlarge, c5d.metal, c5n.large, c5n.xlarge, c5n.2xlarge, c5n.4xlarge, c5n.9xlarge, c5n.18xlarge, c5n.metal, c6g.metal, c6g.medium, c6g.large, c6g.xlarge, c6g.2xlarge, c6g.4xlarge, c6g.8xlarge, c6g.12xlarge, c6g.16xlarge, c6gd.metal, c6gd.medium, c6gd.large, c6gd.xlarge, c6gd.2xlarge, c6gd.4xlarge, c6gd.8xlarge, c6gd.12xlarge, c6gd.16xlarge, c6gn.medium, c6gn.large, c6gn.xlarge, c6gn.2xlarge, c6gn.4xlarge, c6gn.8xlarge, c6gn.12xlarge, c6gn.16xlarge, cc1.4xlarge, cc2.8xlarge, g2.2xlarge, g2.8xlarge, g3.4xlarge, g3.8xlarge, g3.16xlarge, g3s.xlarge, g4ad.4xlarge, g4ad.8xlarge, g4ad.16xlarge, g4dn.xlarge, g4dn.2xlarge, g4dn.4xlarge, g4dn.8xlarge, g4dn.12xlarge, g4dn.16xlarge, g4dn.metal, cg1.4xlarge, p2.xlarge, p2.8xlarge, p2.16xlarge, p3.2xlarge, p3.8xlarge, p3.16xlarge, p3dn.24xlarge, p4d.24xlarge, d2.xlarge, d2.2xlarge, d2.4xlarge, d2.8xlarge, d3.xlarge, d3.2xlarge, d3.4xlarge, d3.8xlarge, d3en.xlarge, d3en.2xlarge, d3en.4xlarge, d3en.6xlarge, d3en.8xlarge, d3en.12xlarge, f1.2xlarge, f1.4xlarge, f1.16xlarge, m5.large, m5.xlarge, m5.2xlarge, m5.4xlarge, m5.8xlarge, m5.12xlarge, m5.16xlarge, m5.24xlarge, m5.metal, m5a.large, m5a.xlarge, m5a.2xlarge, m5a.4xlarge, m5a.8xlarge, m5a.12xlarge, m5a.16xlarge, m5a.24xlarge, m5d.large, m5d.xlarge, m5d.2xlarge, m5d.4xlarge, m5d.8xlarge, m5d.12xlarge, m5d.16xlarge, m5d.24xlarge, m5d.metal, m5ad.large, m5ad.xlarge, m5ad.2xlarge, m5ad.4xlarge, m5ad.8xlarge, m5ad.12xlarge, m5ad.16xlarge, m5ad.24xlarge, m5zn.large, m5zn.xlarge, m5zn.2xlarge, m5zn.3xlarge, m5zn.6xlarge, m5zn.12xlarge, m5zn.metal, h1.2xlarge, h1.4xlarge, h1.8xlarge, h1.16xlarge, z1d.large, z1d.xlarge, z1d.2xlarge, z1d.3xlarge, z1d.6xlarge, z1d.12xlarge, z1d.metal, u-6tb1.metal, u-9tb1.metal, u-12tb1.metal, u-18tb1.metal, u-24tb1.metal, a1.medium, a1.large, a1.xlarge, a1.2xlarge, a1.4xlarge, a1.metal, m5dn.large, m5dn.xlarge, m5dn.2xlarge, m5dn.4xlarge, m5dn.8xlarge, m5dn.12xlarge, m5dn.16xlarge, m5dn.24xlarge, m5n.large, m5n.xlarge, m5n.2xlarge, m5n.4xlarge, m5n.8xlarge, m5n.12xlarge, m5n.16xlarge, m5n.24xlarge, r5dn.large, r5dn.xlarge, r5dn.2xlarge, r5dn.4xlarge, r5dn.8xlarge, r5dn.12xlarge, r5dn.16xlarge, r5dn.24xlarge, r5n.large, r5n.xlarge, r5n.2xlarge, r5n.4xlarge, r5n.8xlarge, r5n.12xlarge, r5n.16xlarge, r5n.24xlarge, inf1.xlarge, inf1.2xlarge, inf1.6xlarge, inf1.24xlarge, m6g.metal, m6g.medium, m6g.large, m6g.xlarge, m6g.2xlarge, m6g.4xlarge, m6g.8xlarge, m6g.12xlarge, m6g.16xlarge, m6gd.metal, m6gd.medium, m6gd.large, m6gd.xlarge, m6gd.2xlarge, m6gd.4xlarge, m6gd.8xlarge, m6gd.12xlarge, m6gd.16xlarge, mac1.metal
    #         max_results: 1,
    #         next_token: "String",
    #         product_descriptions: ["String"],
    #         start_time: Time.now,
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `availability-zone` - The Availability Zone for which prices
    #     should be returned.
    #
    #   * `instance-type` - The type of instance (for example, `m3.medium`).
    #
    #   * `product-description` - The product description for the Spot price
    #     (`Linux/UNIX` \| `Red Hat Enterprise Linux` \| `SUSE Linux` \|
    #     `Windows` \| `Linux/UNIX (Amazon VPC)` \| `Red Hat Enterprise
    #     Linux (Amazon VPC)` \| `SUSE Linux (Amazon VPC)` \| `Windows
    #     (Amazon VPC)`).
    #
    #   * `spot-price` - The Spot price. The value must match exactly (or
    #     use wildcards; greater than or less than comparison is not
    #     supported).
    #
    #   * `timestamp` - The time stamp of the Spot price history, in UTC
    #     format (for example, *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z). You can
    #     use wildcards (* and ?). Greater than or less than comparison is
    #     not supported.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] availability_zone
    #   Filters the results by the specified Availability Zone.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] end_time
    #   The date and time, up to the current date, from which to stop
    #   retrieving the price history data, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z).
    #   @return [Time]
    #
    # @!attribute [rw] instance_types
    #   Filters the results by the specified instance types.
    #   @return [Array<String>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. Specify a
    #   value between 1 and 1000. The default value is 1000. To retrieve the
    #   remaining results, make another call with the returned `NextToken`
    #   value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next set of results.
    #   @return [String]
    #
    # @!attribute [rw] product_descriptions
    #   Filters the results by the specified basic product descriptions.
    #   @return [Array<String>]
    #
    # @!attribute [rw] start_time
    #   The date and time, up to the past 90 days, from which to start
    #   retrieving the price history data, in UTC format (for example,
    #   *YYYY*-*MM*-*DD*T*HH*\:*MM*\:*SS*Z).
    #   @return [Time]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotPriceHistoryRequest AWS API Documentation
    #
    class DescribeSpotPriceHistoryRequest < Struct.new(
      :filters,
      :availability_zone,
      :dry_run,
      :end_time,
      :instance_types,
      :max_results,
      :next_token,
      :product_descriptions,
      :start_time)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeSpotPriceHistory.
    #
    # @!attribute [rw] next_token
    #   The token required to retrieve the next set of results. This value
    #   is null or an empty string when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] spot_price_history
    #   The historical Spot prices.
    #   @return [Array<Types::SpotPrice>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSpotPriceHistoryResult AWS API Documentation
    #
    class DescribeSpotPriceHistoryResult < Struct.new(
      :next_token,
      :spot_price_history)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeStaleSecurityGroupsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         max_results: 1,
    #         next_token: "DescribeStaleSecurityGroupsNextToken",
    #         vpc_id: "VpcId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. The request
    #   returns a token that you can specify in a subsequent call to get the
    #   next set of results.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next set of items to return. (You received this
    #   token from a prior call.)
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeStaleSecurityGroupsRequest AWS API Documentation
    #
    class DescribeStaleSecurityGroupsRequest < Struct.new(
      :dry_run,
      :max_results,
      :next_token,
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to use when requesting the next set of items. If there are
    #   no additional items to return, the string is empty.
    #   @return [String]
    #
    # @!attribute [rw] stale_security_group_set
    #   Information about the stale security groups.
    #   @return [Array<Types::StaleSecurityGroup>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeStaleSecurityGroupsResult AWS API Documentation
    #
    class DescribeStaleSecurityGroupsResult < Struct.new(
      :next_token,
      :stale_security_group_set)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeSubnetsRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         subnet_ids: ["SubnetId"],
    #         dry_run: false,
    #         next_token: "String",
    #         max_results: 1,
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `availability-zone` - The Availability Zone for the subnet. You
    #     can also use `availabilityZone` as the filter name.
    #
    #   * `availability-zone-id` - The ID of the Availability Zone for the
    #     subnet. You can also use `availabilityZoneId` as the filter name.
    #
    #   * `available-ip-address-count` - The number of IPv4 addresses in the
    #     subnet that are available.
    #
    #   * `cidr-block` - The IPv4 CIDR block of the subnet. The CIDR block
    #     you specify must exactly match the subnet's CIDR block for
    #     information to be returned for the subnet. You can also use `cidr`
    #     or `cidrBlock` as the filter names.
    #
    #   * `default-for-az` - Indicates whether this is the default subnet
    #     for the Availability Zone. You can also use `defaultForAz` as the
    #     filter name.
    #
    #   * `ipv6-cidr-block-association.ipv6-cidr-block` - An IPv6 CIDR block
    #     associated with the subnet.
    #
    #   * `ipv6-cidr-block-association.association-id` - An association ID
    #     for an IPv6 CIDR block associated with the subnet.
    #
    #   * `ipv6-cidr-block-association.state` - The state of an IPv6 CIDR
    #     block associated with the subnet.
    #
    #   * `owner-id` - The ID of the AWS account that owns the subnet.
    #
    #   * `state` - The state of the subnet (`pending` \| `available`).
    #
    #   * `subnet-arn` - The Amazon Resource Name (ARN) of the subnet.
    #
    #   * `subnet-id` - The ID of the subnet.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC for the subnet.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] subnet_ids
    #   One or more subnet IDs.
    #
    #   Default: Describes all your subnets.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSubnetsRequest AWS API Documentation
    #
    class DescribeSubnetsRequest < Struct.new(
      :filters,
      :subnet_ids,
      :dry_run,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] subnets
    #   Information about one or more subnets.
    #   @return [Array<Types::Subnet>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeSubnetsResult AWS API Documentation
    #
    class DescribeSubnetsResult < Struct.new(
      :subnets,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeTagsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `key` - The tag key.
    #
    #   * `resource-id` - The ID of the resource.
    #
    #   * `resource-type` - The resource type (`customer-gateway` \|
    #     `dedicated-host` \| `dhcp-options` \| `elastic-ip` \| `fleet` \|
    #     `fpga-image` \| `host-reservation` \| `image` \| `instance` \|
    #     `internet-gateway` \| `key-pair` \| `launch-template` \|
    #     `natgateway` \| `network-acl` \| `network-interface` \|
    #     `placement-group` \| `reserved-instances` \| `route-table` \|
    #     `security-group` \| `snapshot` \| `spot-instances-request` \|
    #     `subnet` \| `volume` \| `vpc` \| `vpc-endpoint` \|
    #     `vpc-endpoint-service` \| `vpc-peering-connection` \|
    #     `vpn-connection` \| `vpn-gateway`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of the tag. For
    #     example, specify "tag:Owner" for the filter name and "TeamA"
    #     for the filter value to find resources with the tag
    #     "Owner=TeamA".
    #
    #   * `value` - The tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. This value
    #   can be between 5 and 1000. To retrieve the remaining results, make
    #   another call with the returned `NextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTagsRequest AWS API Documentation
    #
    class DescribeTagsRequest < Struct.new(
      :dry_run,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   The tags.
    #   @return [Array<Types::TagDescription>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTagsResult AWS API Documentation
    #
    class DescribeTagsResult < Struct.new(
      :next_token,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeTrafficMirrorFiltersRequest
    #   data as a hash:
    #
    #       {
    #         traffic_mirror_filter_ids: ["TrafficMirrorFilterId"],
    #         dry_run: false,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "NextToken",
    #       }
    #
    # @!attribute [rw] traffic_mirror_filter_ids
    #   The ID of the Traffic Mirror filter.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   One or more filters. The possible values are:
    #
    #   * `description`\: The Traffic Mirror filter description.
    #
    #   * `traffic-mirror-filter-id`\: The ID of the Traffic Mirror filter.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrafficMirrorFiltersRequest AWS API Documentation
    #
    class DescribeTrafficMirrorFiltersRequest < Struct.new(
      :traffic_mirror_filter_ids,
      :dry_run,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_filters
    #   Information about one or more Traffic Mirror filters.
    #   @return [Array<Types::TrafficMirrorFilter>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. The value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrafficMirrorFiltersResult AWS API Documentation
    #
    class DescribeTrafficMirrorFiltersResult < Struct.new(
      :traffic_mirror_filters,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeTrafficMirrorSessionsRequest
    #   data as a hash:
    #
    #       {
    #         traffic_mirror_session_ids: ["TrafficMirrorSessionId"],
    #         dry_run: false,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "NextToken",
    #       }
    #
    # @!attribute [rw] traffic_mirror_session_ids
    #   The ID of the Traffic Mirror session.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   One or more filters. The possible values are:
    #
    #   * `description`\: The Traffic Mirror session description.
    #
    #   * `network-interface-id`\: The ID of the Traffic Mirror session
    #     network interface.
    #
    #   * `owner-id`\: The ID of the account that owns the Traffic Mirror
    #     session.
    #
    #   * `packet-length`\: The assigned number of packets to mirror.
    #
    #   * `session-number`\: The assigned session number.
    #
    #   * `traffic-mirror-filter-id`\: The ID of the Traffic Mirror filter.
    #
    #   * `traffic-mirror-session-id`\: The ID of the Traffic Mirror
    #     session.
    #
    #   * `traffic-mirror-target-id`\: The ID of the Traffic Mirror target.
    #
    #   * `virtual-network-id`\: The virtual network ID of the Traffic
    #     Mirror session.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrafficMirrorSessionsRequest AWS API Documentation
    #
    class DescribeTrafficMirrorSessionsRequest < Struct.new(
      :traffic_mirror_session_ids,
      :dry_run,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_sessions
    #   Describes one or more Traffic Mirror sessions. By default, all
    #   Traffic Mirror sessions are described. Alternatively, you can filter
    #   the results.
    #   @return [Array<Types::TrafficMirrorSession>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. The value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrafficMirrorSessionsResult AWS API Documentation
    #
    class DescribeTrafficMirrorSessionsResult < Struct.new(
      :traffic_mirror_sessions,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeTrafficMirrorTargetsRequest
    #   data as a hash:
    #
    #       {
    #         traffic_mirror_target_ids: ["TrafficMirrorTargetId"],
    #         dry_run: false,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "NextToken",
    #       }
    #
    # @!attribute [rw] traffic_mirror_target_ids
    #   The ID of the Traffic Mirror targets.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   One or more filters. The possible values are:
    #
    #   * `description`\: The Traffic Mirror target description.
    #
    #   * `network-interface-id`\: The ID of the Traffic Mirror session
    #     network interface.
    #
    #   * `network-load-balancer-arn`\: The Amazon Resource Name (ARN) of
    #     the Network Load Balancer that is associated with the session.
    #
    #   * `owner-id`\: The ID of the account that owns the Traffic Mirror
    #     session.
    #
    #   * `traffic-mirror-target-id`\: The ID of the Traffic Mirror target.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrafficMirrorTargetsRequest AWS API Documentation
    #
    class DescribeTrafficMirrorTargetsRequest < Struct.new(
      :traffic_mirror_target_ids,
      :dry_run,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] traffic_mirror_targets
    #   Information about one or more Traffic Mirror targets.
    #   @return [Array<Types::TrafficMirrorTarget>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. The value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTrafficMirrorTargetsResult AWS API Documentation
    #
    class DescribeTrafficMirrorTargetsResult < Struct.new(
      :traffic_mirror_targets,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeTransitGatewayAttachmentsRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_attachment_ids: ["TransitGatewayAttachmentId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_attachment_ids
    #   The IDs of the attachments.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters. The possible values are:
    #
    #   * `association.state` - The state of the association (`associating`
    #     \| `associated` \| `disassociating`).
    #
    #   * `association.transit-gateway-route-table-id` - The ID of the route
    #     table for the transit gateway.
    #
    #   * `resource-id` - The ID of the resource.
    #
    #   * `resource-owner-id` - The ID of the AWS account that owns the
    #     resource.
    #
    #   * `resource-type` - The resource type. Valid values are `vpc` \|
    #     `vpn` \| `direct-connect-gateway` \| `peering` \| `connect`.
    #
    #   * `state` - The state of the attachment. Valid values are
    #     `available` \| `deleted` \| `deleting` \| `failed` \| `failing` \|
    #     `initiatingRequest` \| `modifying` \| `pendingAcceptance` \|
    #     `pending` \| `rollingBack` \| `rejected` \| `rejecting`.
    #
    #   * `transit-gateway-attachment-id` - The ID of the attachment.
    #
    #   * `transit-gateway-id` - The ID of the transit gateway.
    #
    #   * `transit-gateway-owner-id` - The ID of the AWS account that owns
    #     the transit gateway.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayAttachmentsRequest AWS API Documentation
    #
    class DescribeTransitGatewayAttachmentsRequest < Struct.new(
      :transit_gateway_attachment_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_attachments
    #   Information about the attachments.
    #   @return [Array<Types::TransitGatewayAttachment>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayAttachmentsResult AWS API Documentation
    #
    class DescribeTransitGatewayAttachmentsResult < Struct.new(
      :transit_gateway_attachments,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeTransitGatewayConnectPeersRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_connect_peer_ids: ["TransitGatewayConnectPeerId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_connect_peer_ids
    #   The IDs of the Connect peers.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters. The possible values are:
    #
    #   * `state` - The state of the Connect peer (`pending` \| `available`
    #     \| `deleting` \| `deleted`).
    #
    #   * `transit-gateway-attachment-id` - The ID of the attachment.
    #
    #   * `transit-gateway-connect-peer-id` - The ID of the Connect peer.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayConnectPeersRequest AWS API Documentation
    #
    class DescribeTransitGatewayConnectPeersRequest < Struct.new(
      :transit_gateway_connect_peer_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_connect_peers
    #   Information about the Connect peers.
    #   @return [Array<Types::TransitGatewayConnectPeer>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayConnectPeersResult AWS API Documentation
    #
    class DescribeTransitGatewayConnectPeersResult < Struct.new(
      :transit_gateway_connect_peers,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeTransitGatewayConnectsRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_attachment_ids: ["TransitGatewayAttachmentId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_attachment_ids
    #   The IDs of the attachments.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters. The possible values are:
    #
    #   * `options.protocol` - The tunnel protocol (`gre`).
    #
    #   * `state` - The state of the attachment (`initiating` \|
    #     `initiatingRequest` \| `pendingAcceptance` \| `rollingBack` \|
    #     `pending` \| `available` \| `modifying` \| `deleting` \| `deleted`
    #     \| `failed` \| `rejected` \| `rejecting` \| `failing`).
    #
    #   * `transit-gateway-attachment-id` - The ID of the Connect
    #     attachment.
    #
    #   * `transit-gateway-id` - The ID of the transit gateway.
    #
    #   * `transport-transit-gateway-attachment-id` - The ID of the transit
    #     gateway attachment from which the Connect attachment was created.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayConnectsRequest AWS API Documentation
    #
    class DescribeTransitGatewayConnectsRequest < Struct.new(
      :transit_gateway_attachment_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_connects
    #   Information about the Connect attachments.
    #   @return [Array<Types::TransitGatewayConnect>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayConnectsResult AWS API Documentation
    #
    class DescribeTransitGatewayConnectsResult < Struct.new(
      :transit_gateway_connects,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeTransitGatewayMulticastDomainsRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_multicast_domain_ids: ["TransitGatewayMulticastDomainId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_multicast_domain_ids
    #   The ID of the transit gateway multicast domain.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters. The possible values are:
    #
    #   * `state` - The state of the transit gateway multicast domain. Valid
    #     values are `pending` \| `available` \| `deleting` \| `deleted`.
    #
    #   * `transit-gateway-id` - The ID of the transit gateway.
    #
    #   * `transit-gateway-multicast-domain-id` - The ID of the transit
    #     gateway multicast domain.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayMulticastDomainsRequest AWS API Documentation
    #
    class DescribeTransitGatewayMulticastDomainsRequest < Struct.new(
      :transit_gateway_multicast_domain_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_multicast_domains
    #   Information about the transit gateway multicast domains.
    #   @return [Array<Types::TransitGatewayMulticastDomain>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayMulticastDomainsResult AWS API Documentation
    #
    class DescribeTransitGatewayMulticastDomainsResult < Struct.new(
      :transit_gateway_multicast_domains,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeTransitGatewayPeeringAttachmentsRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_attachment_ids: ["TransitGatewayAttachmentId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_attachment_ids
    #   One or more IDs of the transit gateway peering attachments.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters. The possible values are:
    #
    #   * `transit-gateway-attachment-id` - The ID of the transit gateway
    #     attachment.
    #
    #   * `local-owner-id` - The ID of your AWS account.
    #
    #   * `remote-owner-id` - The ID of the AWS account in the remote Region
    #     that owns the transit gateway.
    #
    #   * `state` - The state of the peering attachment. Valid values are
    #     `available` \| `deleted` \| `deleting` \| `failed` \| `failing` \|
    #     `initiatingRequest` \| `modifying` \| `pendingAcceptance` \|
    #     `pending` \| `rollingBack` \| `rejected` \| `rejecting`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources that have a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `transit-gateway-id` - The ID of the transit gateway.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayPeeringAttachmentsRequest AWS API Documentation
    #
    class DescribeTransitGatewayPeeringAttachmentsRequest < Struct.new(
      :transit_gateway_attachment_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_peering_attachments
    #   The transit gateway peering attachments.
    #   @return [Array<Types::TransitGatewayPeeringAttachment>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayPeeringAttachmentsResult AWS API Documentation
    #
    class DescribeTransitGatewayPeeringAttachmentsResult < Struct.new(
      :transit_gateway_peering_attachments,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeTransitGatewayRouteTablesRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_route_table_ids: ["TransitGatewayRouteTableId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_route_table_ids
    #   The IDs of the transit gateway route tables.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters. The possible values are:
    #
    #   * `default-association-route-table` - Indicates whether this is the
    #     default association route table for the transit gateway (`true` \|
    #     `false`).
    #
    #   * `default-propagation-route-table` - Indicates whether this is the
    #     default propagation route table for the transit gateway (`true` \|
    #     `false`).
    #
    #   * `state` - The state of the route table (`available` \| `deleting`
    #     \| `deleted` \| `pending`).
    #
    #   * `transit-gateway-id` - The ID of the transit gateway.
    #
    #   * `transit-gateway-route-table-id` - The ID of the transit gateway
    #     route table.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayRouteTablesRequest AWS API Documentation
    #
    class DescribeTransitGatewayRouteTablesRequest < Struct.new(
      :transit_gateway_route_table_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_route_tables
    #   Information about the transit gateway route tables.
    #   @return [Array<Types::TransitGatewayRouteTable>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayRouteTablesResult AWS API Documentation
    #
    class DescribeTransitGatewayRouteTablesResult < Struct.new(
      :transit_gateway_route_tables,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeTransitGatewayVpcAttachmentsRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_attachment_ids: ["TransitGatewayAttachmentId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_attachment_ids
    #   The IDs of the attachments.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters. The possible values are:
    #
    #   * `state` - The state of the attachment. Valid values are
    #     `available` \| `deleted` \| `deleting` \| `failed` \| `failing` \|
    #     `initiatingRequest` \| `modifying` \| `pendingAcceptance` \|
    #     `pending` \| `rollingBack` \| `rejected` \| `rejecting`.
    #
    #   * `transit-gateway-attachment-id` - The ID of the attachment.
    #
    #   * `transit-gateway-id` - The ID of the transit gateway.
    #
    #   * `vpc-id` - The ID of the VPC.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayVpcAttachmentsRequest AWS API Documentation
    #
    class DescribeTransitGatewayVpcAttachmentsRequest < Struct.new(
      :transit_gateway_attachment_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateway_vpc_attachments
    #   Information about the VPC attachments.
    #   @return [Array<Types::TransitGatewayVpcAttachment>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayVpcAttachmentsResult AWS API Documentation
    #
    class DescribeTransitGatewayVpcAttachmentsResult < Struct.new(
      :transit_gateway_vpc_attachments,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeTransitGatewaysRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_ids: ["TransitGatewayId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_ids
    #   The IDs of the transit gateways.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters. The possible values are:
    #
    #   * `options.propagation-default-route-table-id` - The ID of the
    #     default propagation route table.
    #
    #   * `options.amazon-side-asn` - The private ASN for the Amazon side of
    #     a BGP session.
    #
    #   * `options.association-default-route-table-id` - The ID of the
    #     default association route table.
    #
    #   * `options.auto-accept-shared-attachments` - Indicates whether there
    #     is automatic acceptance of attachment requests (`enable` \|
    #     `disable`).
    #
    #   * `options.default-route-table-association` - Indicates whether
    #     resource attachments are automatically associated with the default
    #     association route table (`enable` \| `disable`).
    #
    #   * `options.default-route-table-propagation` - Indicates whether
    #     resource attachments automatically propagate routes to the default
    #     propagation route table (`enable` \| `disable`).
    #
    #   * `options.dns-support` - Indicates whether DNS support is enabled
    #     (`enable` \| `disable`).
    #
    #   * `options.vpn-ecmp-support` - Indicates whether Equal Cost
    #     Multipath Protocol support is enabled (`enable` \| `disable`).
    #
    #   * `owner-id` - The ID of the AWS account that owns the transit
    #     gateway.
    #
    #   * `state` - The state of the transit gateway (`available` \|
    #     `deleted` \| `deleting` \| `modifying` \| `pending`).
    #
    #   * `transit-gateway-id` - The ID of the transit gateway.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewaysRequest AWS API Documentation
    #
    class DescribeTransitGatewaysRequest < Struct.new(
      :transit_gateway_ids,
      :filters,
      :max_results,
      :next_token,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] transit_gateways
    #   Information about the transit gateways.
    #   @return [Array<Types::TransitGateway>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewaysResult AWS API Documentation
    #
    class DescribeTransitGatewaysResult < Struct.new(
      :transit_gateways,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeVolumeAttributeRequest
    #   data as a hash:
    #
    #       {
    #         attribute: "autoEnableIO", # required, accepts autoEnableIO, productCodes
    #         volume_id: "VolumeId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] attribute
    #   The attribute of the volume. This parameter is required.
    #   @return [String]
    #
    # @!attribute [rw] volume_id
    #   The ID of the volume.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumeAttributeRequest AWS API Documentation
    #
    class DescribeVolumeAttributeRequest < Struct.new(
      :attribute,
      :volume_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] auto_enable_io
    #   The state of `autoEnableIO` attribute.
    #   @return [Types::AttributeBooleanValue]
    #
    # @!attribute [rw] product_codes
    #   A list of product codes.
    #   @return [Array<Types::ProductCode>]
    #
    # @!attribute [rw] volume_id
    #   The ID of the volume.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumeAttributeResult AWS API Documentation
    #
    class DescribeVolumeAttributeResult < Struct.new(
      :auto_enable_io,
      :product_codes,
      :volume_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeVolumeStatusRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #         volume_ids: ["VolumeId"],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `action.code` - The action code for the event (for example,
    #     `enable-volume-io`).
    #
    #   * `action.description` - A description of the action.
    #
    #   * `action.event-id` - The event ID associated with the action.
    #
    #   * `availability-zone` - The Availability Zone of the instance.
    #
    #   * `event.description` - A description of the event.
    #
    #   * `event.event-id` - The event ID.
    #
    #   * `event.event-type` - The event type (for `io-enabled`\: `passed`
    #     \| `failed`; for `io-performance`\: `io-performance:degraded` \|
    #     `io-performance:severely-degraded` \| `io-performance:stalled`).
    #
    #   * `event.not-after` - The latest end time for the event.
    #
    #   * `event.not-before` - The earliest start time for the event.
    #
    #   * `volume-status.details-name` - The cause for
    #     `volume-status.status` (`io-enabled` \| `io-performance`).
    #
    #   * `volume-status.details-status` - The status of
    #     `volume-status.details-name` (for `io-enabled`\: `passed` \|
    #     `failed`; for `io-performance`\: `normal` \| `degraded` \|
    #     `severely-degraded` \| `stalled`).
    #
    #   * `volume-status.status` - The status of the volume (`ok` \|
    #     `impaired` \| `warning` \| `insufficient-data`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of volume results returned by
    #   `DescribeVolumeStatus` in paginated output. When this parameter is
    #   used, the request only returns `MaxResults` results in a single page
    #   along with a `NextToken` response element. The remaining results of
    #   the initial request can be seen by sending another request with the
    #   returned `NextToken` value. This value can be between 5 and 1,000;
    #   if `MaxResults` is given a value larger than 1,000, only 1,000
    #   results are returned. If this parameter is not used, then
    #   `DescribeVolumeStatus` returns all results. You cannot specify this
    #   parameter and the volume IDs parameter in the same request.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The `NextToken` value to include in a future `DescribeVolumeStatus`
    #   request. When the results of the request exceed `MaxResults`, this
    #   value can be used to retrieve the next page of results. This value
    #   is `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] volume_ids
    #   The IDs of the volumes.
    #
    #   Default: Describes all your volumes.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumeStatusRequest AWS API Documentation
    #
    class DescribeVolumeStatusRequest < Struct.new(
      :filters,
      :max_results,
      :next_token,
      :volume_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] volume_statuses
    #   Information about the status of the volumes.
    #   @return [Array<Types::VolumeStatusItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumeStatusResult AWS API Documentation
    #
    class DescribeVolumeStatusResult < Struct.new(
      :next_token,
      :volume_statuses)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeVolumesModificationsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         volume_ids: ["VolumeId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         next_token: "String",
    #         max_results: 1,
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] volume_ids
    #   The IDs of the volumes.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `modification-state` - The current modification state (modifying
    #     \| optimizing \| completed \| failed).
    #
    #   * `original-iops` - The original IOPS rate of the volume.
    #
    #   * `original-size` - The original size of the volume, in GiB.
    #
    #   * `original-volume-type` - The original volume type of the volume
    #     (standard \| io1 \| io2 \| gp2 \| sc1 \| st1).
    #
    #   * `originalMultiAttachEnabled` - Indicates whether Multi-Attach
    #     support was enabled (true \| false).
    #
    #   * `start-time` - The modification start time.
    #
    #   * `target-iops` - The target IOPS rate of the volume.
    #
    #   * `target-size` - The target size of the volume, in GiB.
    #
    #   * `target-volume-type` - The target volume type of the volume
    #     (standard \| io1 \| io2 \| gp2 \| sc1 \| st1).
    #
    #   * `targetMultiAttachEnabled` - Indicates whether Multi-Attach
    #     support is to be enabled (true \| false).
    #
    #   * `volume-id` - The ID of the volume.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] next_token
    #   The `nextToken` value returned by a previous paginated request.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results (up to a limit of 500) to be returned
    #   in a paginated request.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumesModificationsRequest AWS API Documentation
    #
    class DescribeVolumesModificationsRequest < Struct.new(
      :dry_run,
      :volume_ids,
      :filters,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] volumes_modifications
    #   Information about the volume modifications.
    #   @return [Array<Types::VolumeModification>]
    #
    # @!attribute [rw] next_token
    #   Token for pagination, null if there are no more results
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumesModificationsResult AWS API Documentation
    #
    class DescribeVolumesModificationsResult < Struct.new(
      :volumes_modifications,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeVolumesRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         volume_ids: ["VolumeId"],
    #         dry_run: false,
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] filters
    #   The filters.
    #
    #   * `attachment.attach-time` - The time stamp when the attachment
    #     initiated.
    #
    #   * `attachment.delete-on-termination` - Whether the volume is deleted
    #     on instance termination.
    #
    #   * `attachment.device` - The device name specified in the block
    #     device mapping (for example, `/dev/sda1`).
    #
    #   * `attachment.instance-id` - The ID of the instance the volume is
    #     attached to.
    #
    #   * `attachment.status` - The attachment state (`attaching` \|
    #     `attached` \| `detaching`).
    #
    #   * `availability-zone` - The Availability Zone in which the volume
    #     was created.
    #
    #   * `create-time` - The time stamp when the volume was created.
    #
    #   * `encrypted` - Indicates whether the volume is encrypted (`true` \|
    #     `false`)
    #
    #   * `multi-attach-enabled` - Indicates whether the volume is enabled
    #     for Multi-Attach (`true` \| `false`)
    #
    #   * `fast-restored` - Indicates whether the volume was created from a
    #     snapshot that is enabled for fast snapshot restore (`true` \|
    #     `false`).
    #
    #   * `size` - The size of the volume, in GiB.
    #
    #   * `snapshot-id` - The snapshot from which the volume was created.
    #
    #   * `status` - The state of the volume (`creating` \| `available` \|
    #     `in-use` \| `deleting` \| `deleted` \| `error`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `volume-id` - The volume ID.
    #
    #   * `volume-type` - The Amazon EBS volume type (`gp2` \| `gp3` \|
    #     `io1` \| `io2` \| `st1` \| `sc1`\| `standard`)
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] volume_ids
    #   The volume IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] max_results
    #   The maximum number of volume results returned by `DescribeVolumes`
    #   in paginated output. When this parameter is used, `DescribeVolumes`
    #   only returns `MaxResults` results in a single page along with a
    #   `NextToken` response element. The remaining results of the initial
    #   request can be seen by sending another `DescribeVolumes` request
    #   with the returned `NextToken` value. This value can be between 5 and
    #   500; if `MaxResults` is given a value larger than 500, only 500
    #   results are returned. If this parameter is not used, then
    #   `DescribeVolumes` returns all results. You cannot specify this
    #   parameter and the volume IDs parameter in the same request.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The `NextToken` value returned from a previous paginated
    #   `DescribeVolumes` request where `MaxResults` was used and the
    #   results exceeded the value of that parameter. Pagination continues
    #   from the end of the previous results that returned the `NextToken`
    #   value. This value is `null` when there are no more results to
    #   return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumesRequest AWS API Documentation
    #
    class DescribeVolumesRequest < Struct.new(
      :filters,
      :volume_ids,
      :dry_run,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] volumes
    #   Information about the volumes.
    #   @return [Array<Types::Volume>]
    #
    # @!attribute [rw] next_token
    #   The `NextToken` value to include in a future `DescribeVolumes`
    #   request. When the results of a `DescribeVolumes` request exceed
    #   `MaxResults`, this value can be used to retrieve the next page of
    #   results. This value is `null` when there are no more results to
    #   return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVolumesResult AWS API Documentation
    #
    class DescribeVolumesResult < Struct.new(
      :volumes,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeVpcAttributeRequest
    #   data as a hash:
    #
    #       {
    #         attribute: "enableDnsSupport", # required, accepts enableDnsSupport, enableDnsHostnames
    #         vpc_id: "VpcId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] attribute
    #   The VPC attribute.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcAttributeRequest AWS API Documentation
    #
    class DescribeVpcAttributeRequest < Struct.new(
      :attribute,
      :vpc_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] enable_dns_hostnames
    #   Indicates whether the instances launched in the VPC get DNS
    #   hostnames. If this attribute is `true`, instances in the VPC get DNS
    #   hostnames; otherwise, they do not.
    #   @return [Types::AttributeBooleanValue]
    #
    # @!attribute [rw] enable_dns_support
    #   Indicates whether DNS resolution is enabled for the VPC. If this
    #   attribute is `true`, the Amazon DNS server resolves DNS hostnames
    #   for your instances to their corresponding IP addresses; otherwise,
    #   it does not.
    #   @return [Types::AttributeBooleanValue]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcAttributeResult AWS API Documentation
    #
    class DescribeVpcAttributeResult < Struct.new(
      :vpc_id,
      :enable_dns_hostnames,
      :enable_dns_support)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeVpcClassicLinkDnsSupportRequest
    #   data as a hash:
    #
    #       {
    #         max_results: 1,
    #         next_token: "DescribeVpcClassicLinkDnsSupportNextToken",
    #         vpc_ids: ["VpcId"],
    #       }
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] vpc_ids
    #   One or more VPC IDs.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLinkDnsSupportRequest AWS API Documentation
    #
    class DescribeVpcClassicLinkDnsSupportRequest < Struct.new(
      :max_results,
      :next_token,
      :vpc_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @!attribute [rw] vpcs
    #   Information about the ClassicLink DNS support status of the VPCs.
    #   @return [Array<Types::ClassicLinkDnsSupport>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLinkDnsSupportResult AWS API Documentation
    #
    class DescribeVpcClassicLinkDnsSupportResult < Struct.new(
      :next_token,
      :vpcs)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeVpcClassicLinkRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         dry_run: false,
    #         vpc_ids: ["VpcId"],
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `is-classic-link-enabled` - Whether the VPC is enabled for
    #     ClassicLink (`true` \| `false`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_ids
    #   One or more VPCs for which you want to describe the ClassicLink
    #   status.
    #   @return [Array<String>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLinkRequest AWS API Documentation
    #
    class DescribeVpcClassicLinkRequest < Struct.new(
      :filters,
      :dry_run,
      :vpc_ids)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpcs
    #   The ClassicLink status of one or more VPCs.
    #   @return [Array<Types::VpcClassicLink>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcClassicLinkResult AWS API Documentation
    #
    class DescribeVpcClassicLinkResult < Struct.new(
      :vpcs)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeVpcEndpointConnectionNotificationsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         connection_notification_id: "ConnectionNotificationId",
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] connection_notification_id
    #   The ID of the notification.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `connection-notification-arn` - The ARN of the SNS topic for the
    #     notification.
    #
    #   * `connection-notification-id` - The ID of the notification.
    #
    #   * `connection-notification-state` - The state of the notification
    #     (`Enabled` \| `Disabled`).
    #
    #   * `connection-notification-type` - The type of notification
    #     (`Topic`).
    #
    #   * `service-id` - The ID of the endpoint service.
    #
    #   * `vpc-endpoint-id` - The ID of the VPC endpoint.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return in a single call. To
    #   retrieve the remaining results, make another request with the
    #   returned `NextToken` value.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to request the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointConnectionNotificationsRequest AWS API Documentation
    #
    class DescribeVpcEndpointConnectionNotificationsRequest < Struct.new(
      :dry_run,
      :connection_notification_id,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] connection_notification_set
    #   One or more notifications.
    #   @return [Array<Types::ConnectionNotification>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointConnectionNotificationsResult AWS API Documentation
    #
    class DescribeVpcEndpointConnectionNotificationsResult < Struct.new(
      :connection_notification_set,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeVpcEndpointConnectionsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `service-id` - The ID of the service.
    #
    #   * `vpc-endpoint-owner` - The AWS account number of the owner of the
    #     endpoint.
    #
    #   * `vpc-endpoint-state` - The state of the endpoint
    #     (`pendingAcceptance` \| `pending` \| `available` \| `deleting` \|
    #     `deleted` \| `rejected` \| `failed`).
    #
    #   * `vpc-endpoint-id` - The ID of the endpoint.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results of the initial request can be seen by
    #   sending another request with the returned `NextToken` value. This
    #   value can be between 5 and 1,000; if `MaxResults` is given a value
    #   larger than 1,000, only 1,000 results are returned.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointConnectionsRequest AWS API Documentation
    #
    class DescribeVpcEndpointConnectionsRequest < Struct.new(
      :dry_run,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc_endpoint_connections
    #   Information about one or more VPC endpoint connections.
    #   @return [Array<Types::VpcEndpointConnection>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointConnectionsResult AWS API Documentation
    #
    class DescribeVpcEndpointConnectionsResult < Struct.new(
      :vpc_endpoint_connections,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeVpcEndpointServiceConfigurationsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         service_ids: ["VpcEndpointServiceId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] service_ids
    #   The IDs of one or more services.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `service-name` - The name of the service.
    #
    #   * `service-id` - The ID of the service.
    #
    #   * `service-state` - The state of the service (`Pending` \|
    #     `Available` \| `Deleting` \| `Deleted` \| `Failed`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results of the initial request can be seen by
    #   sending another request with the returned `NextToken` value. This
    #   value can be between 5 and 1,000; if `MaxResults` is given a value
    #   larger than 1,000, only 1,000 results are returned.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServiceConfigurationsRequest AWS API Documentation
    #
    class DescribeVpcEndpointServiceConfigurationsRequest < Struct.new(
      :dry_run,
      :service_ids,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] service_configurations
    #   Information about one or more services.
    #   @return [Array<Types::ServiceConfiguration>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServiceConfigurationsResult AWS API Documentation
    #
    class DescribeVpcEndpointServiceConfigurationsResult < Struct.new(
      :service_configurations,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeVpcEndpointServicePermissionsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         service_id: "VpcEndpointServiceId", # required
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] service_id
    #   The ID of the service.
    #   @return [String]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `principal` - The ARN of the principal.
    #
    #   * `principal-type` - The principal type (`All` \| `Service` \|
    #     `OrganizationUnit` \| `Account` \| `User` \| `Role`).
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return for the request in a single
    #   page. The remaining results of the initial request can be seen by
    #   sending another request with the returned `NextToken` value. This
    #   value can be between 5 and 1,000; if `MaxResults` is given a value
    #   larger than 1,000, only 1,000 results are returned.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token to retrieve the next page of results.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServicePermissionsRequest AWS API Documentation
    #
    class DescribeVpcEndpointServicePermissionsRequest < Struct.new(
      :dry_run,
      :service_id,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] allowed_principals
    #   Information about one or more allowed principals.
    #   @return [Array<Types::AllowedPrincipal>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServicePermissionsResult AWS API Documentation
    #
    class DescribeVpcEndpointServicePermissionsResult < Struct.new(
      :allowed_principals,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeVpcEndpointServices.
    #
    # @note When making an API call, you may pass DescribeVpcEndpointServicesRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         service_names: ["String"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] service_names
    #   One or more service names.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `service-name` - The name of the service.
    #
    #   * `service-type` - The type of service (`Interface` \| `Gateway`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. The request
    #   returns a token that you can specify in a subsequent call to get the
    #   next set of results.
    #
    #   Constraint: If the value is greater than 1,000, we return only 1,000
    #   items.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next set of items to return. (You received this
    #   token from a prior call.)
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServicesRequest AWS API Documentation
    #
    class DescribeVpcEndpointServicesRequest < Struct.new(
      :dry_run,
      :service_names,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeVpcEndpointServices.
    #
    # @!attribute [rw] service_names
    #   A list of supported services.
    #   @return [Array<String>]
    #
    # @!attribute [rw] service_details
    #   Information about the service.
    #   @return [Array<Types::ServiceDetail>]
    #
    # @!attribute [rw] next_token
    #   The token to use when requesting the next set of items. If there are
    #   no additional items to return, the string is empty.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServicesResult AWS API Documentation
    #
    class DescribeVpcEndpointServicesResult < Struct.new(
      :service_names,
      :service_details,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeVpcEndpoints.
    #
    # @note When making an API call, you may pass DescribeVpcEndpointsRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         vpc_endpoint_ids: ["VpcEndpointId"],
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         max_results: 1,
    #         next_token: "String",
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_endpoint_ids
    #   One or more endpoint IDs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `service-name` - The name of the service.
    #
    #   * `vpc-id` - The ID of the VPC in which the endpoint resides.
    #
    #   * `vpc-endpoint-id` - The ID of the endpoint.
    #
    #   * `vpc-endpoint-state` - The state of the endpoint
    #     (`pendingAcceptance` \| `pending` \| `available` \| `deleting` \|
    #     `deleted` \| `rejected` \| `failed`).
    #
    #   * `vpc-endpoint-type` - The type of VPC endpoint (`Interface` \|
    #     `Gateway` \| `GatewayLoadBalancer`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] max_results
    #   The maximum number of items to return for this request. The request
    #   returns a token that you can specify in a subsequent call to get the
    #   next set of results.
    #
    #   Constraint: If the value is greater than 1,000, we return only 1,000
    #   items.
    #   @return [Integer]
    #
    # @!attribute [rw] next_token
    #   The token for the next set of items to return. (You received this
    #   token from a prior call.)
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointsRequest AWS API Documentation
    #
    class DescribeVpcEndpointsRequest < Struct.new(
      :dry_run,
      :vpc_endpoint_ids,
      :filters,
      :max_results,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeVpcEndpoints.
    #
    # @!attribute [rw] vpc_endpoints
    #   Information about the endpoints.
    #   @return [Array<Types::VpcEndpoint>]
    #
    # @!attribute [rw] next_token
    #   The token to use when requesting the next set of items. If there are
    #   no additional items to return, the string is empty.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointsResult AWS API Documentation
    #
    class DescribeVpcEndpointsResult < Struct.new(
      :vpc_endpoints,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeVpcPeeringConnectionsRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         dry_run: false,
    #         vpc_peering_connection_ids: ["VpcPeeringConnectionId"],
    #         next_token: "String",
    #         max_results: 1,
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `accepter-vpc-info.cidr-block` - The IPv4 CIDR block of the
    #     accepter VPC.
    #
    #   * `accepter-vpc-info.owner-id` - The AWS account ID of the owner of
    #     the accepter VPC.
    #
    #   * `accepter-vpc-info.vpc-id` - The ID of the accepter VPC.
    #
    #   * `expiration-time` - The expiration date and time for the VPC
    #     peering connection.
    #
    #   * `requester-vpc-info.cidr-block` - The IPv4 CIDR block of the
    #     requester's VPC.
    #
    #   * `requester-vpc-info.owner-id` - The AWS account ID of the owner of
    #     the requester VPC.
    #
    #   * `requester-vpc-info.vpc-id` - The ID of the requester VPC.
    #
    #   * `status-code` - The status of the VPC peering connection
    #     (`pending-acceptance` \| `failed` \| `expired` \| `provisioning`
    #     \| `active` \| `deleting` \| `deleted` \| `rejected`).
    #
    #   * `status-message` - A message that provides more information about
    #     the status of the VPC peering connection, if applicable.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-peering-connection-id` - The ID of the VPC peering
    #     connection.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_peering_connection_ids
    #   One or more VPC peering connection IDs.
    #
    #   Default: Describes all your VPC peering connections.
    #   @return [Array<String>]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcPeeringConnectionsRequest AWS API Documentation
    #
    class DescribeVpcPeeringConnectionsRequest < Struct.new(
      :filters,
      :dry_run,
      :vpc_peering_connection_ids,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpc_peering_connections
    #   Information about the VPC peering connections.
    #   @return [Array<Types::VpcPeeringConnection>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcPeeringConnectionsResult AWS API Documentation
    #
    class DescribeVpcPeeringConnectionsResult < Struct.new(
      :vpc_peering_connections,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DescribeVpcsRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         vpc_ids: ["VpcId"],
    #         dry_run: false,
    #         next_token: "String",
    #         max_results: 1,
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `cidr` - The primary IPv4 CIDR block of the VPC. The CIDR block
    #     you specify must exactly match the VPC's CIDR block for
    #     information to be returned for the VPC. Must contain the slash
    #     followed by one or two digits (for example, `/28`).
    #
    #   * `cidr-block-association.cidr-block` - An IPv4 CIDR block
    #     associated with the VPC.
    #
    #   * `cidr-block-association.association-id` - The association ID for
    #     an IPv4 CIDR block associated with the VPC.
    #
    #   * `cidr-block-association.state` - The state of an IPv4 CIDR block
    #     associated with the VPC.
    #
    #   * `dhcp-options-id` - The ID of a set of DHCP options.
    #
    #   * `ipv6-cidr-block-association.ipv6-cidr-block` - An IPv6 CIDR block
    #     associated with the VPC.
    #
    #   * `ipv6-cidr-block-association.ipv6-pool` - The ID of the IPv6
    #     address pool from which the IPv6 CIDR block is allocated.
    #
    #   * `ipv6-cidr-block-association.association-id` - The association ID
    #     for an IPv6 CIDR block associated with the VPC.
    #
    #   * `ipv6-cidr-block-association.state` - The state of an IPv6 CIDR
    #     block associated with the VPC.
    #
    #   * `isDefault` - Indicates whether the VPC is the default VPC.
    #
    #   * `owner-id` - The ID of the AWS account that owns the VPC.
    #
    #   * `state` - The state of the VPC (`pending` \| `available`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `vpc-id` - The ID of the VPC.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] vpc_ids
    #   One or more VPC IDs.
    #
    #   Default: Describes all your VPCs.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] next_token
    #   The token for the next page of results.
    #   @return [String]
    #
    # @!attribute [rw] max_results
    #   The maximum number of results to return with a single call. To
    #   retrieve the remaining results, make another call with the returned
    #   `nextToken` value.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcsRequest AWS API Documentation
    #
    class DescribeVpcsRequest < Struct.new(
      :filters,
      :vpc_ids,
      :dry_run,
      :next_token,
      :max_results)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] vpcs
    #   Information about one or more VPCs.
    #   @return [Array<Types::Vpc>]
    #
    # @!attribute [rw] next_token
    #   The token to use to retrieve the next page of results. This value is
    #   `null` when there are no more results to return.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcsResult AWS API Documentation
    #
    class DescribeVpcsResult < Struct.new(
      :vpcs,
      :next_token)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeVpnConnections.
    #
    # @note When making an API call, you may pass DescribeVpnConnectionsRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         vpn_connection_ids: ["VpnConnectionId"],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `customer-gateway-configuration` - The configuration information
    #     for the customer gateway.
    #
    #   * `customer-gateway-id` - The ID of a customer gateway associated
    #     with the VPN connection.
    #
    #   * `state` - The state of the VPN connection (`pending` \|
    #     `available` \| `deleting` \| `deleted`).
    #
    #   * `option.static-routes-only` - Indicates whether the connection has
    #     static routes only. Used for devices that do not support Border
    #     Gateway Protocol (BGP).
    #
    #   * `route.destination-cidr-block` - The destination CIDR block. This
    #     corresponds to the subnet used in a customer data center.
    #
    #   * `bgp-asn` - The BGP Autonomous System Number (ASN) associated with
    #     a BGP device.
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `type` - The type of VPN connection. Currently the only supported
    #     type is `ipsec.1`.
    #
    #   * `vpn-connection-id` - The ID of the VPN connection.
    #
    #   * `vpn-gateway-id` - The ID of a virtual private gateway associated
    #     with the VPN connection.
    #
    #   * `transit-gateway-id` - The ID of a transit gateway associated with
    #     the VPN connection.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] vpn_connection_ids
    #   One or more VPN connection IDs.
    #
    #   Default: Describes your VPN connections.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpnConnectionsRequest AWS API Documentation
    #
    class DescribeVpnConnectionsRequest < Struct.new(
      :filters,
      :vpn_connection_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeVpnConnections.
    #
    # @!attribute [rw] vpn_connections
    #   Information about one or more VPN connections.
    #   @return [Array<Types::VpnConnection>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpnConnectionsResult AWS API Documentation
    #
    class DescribeVpnConnectionsResult < Struct.new(
      :vpn_connections)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DescribeVpnGateways.
    #
    # @note When making an API call, you may pass DescribeVpnGatewaysRequest
    #   data as a hash:
    #
    #       {
    #         filters: [
    #           {
    #             name: "String",
    #             values: ["String"],
    #           },
    #         ],
    #         vpn_gateway_ids: ["VpnGatewayId"],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] filters
    #   One or more filters.
    #
    #   * `amazon-side-asn` - The Autonomous System Number (ASN) for the
    #     Amazon side of the gateway.
    #
    #   * `attachment.state` - The current state of the attachment between
    #     the gateway and the VPC (`attaching` \| `attached` \| `detaching`
    #     \| `detached`).
    #
    #   * `attachment.vpc-id` - The ID of an attached VPC.
    #
    #   * `availability-zone` - The Availability Zone for the virtual
    #     private gateway (if applicable).
    #
    #   * `state` - The state of the virtual private gateway (`pending` \|
    #     `available` \| `deleting` \| `deleted`).
    #
    #   * `tag`\:&lt;key&gt; - The key/value combination of a tag assigned
    #     to the resource. Use the tag key in the filter name and the tag
    #     value as the filter value. For example, to find all resources that
    #     have a tag with the key `Owner` and the value `TeamA`, specify
    #     `tag:Owner` for the filter name and `TeamA` for the filter value.
    #
    #   * `tag-key` - The key of a tag assigned to the resource. Use this
    #     filter to find all resources assigned a tag with a specific key,
    #     regardless of the tag value.
    #
    #   * `type` - The type of virtual private gateway. Currently the only
    #     supported type is `ipsec.1`.
    #
    #   * `vpn-gateway-id` - The ID of the virtual private gateway.
    #   @return [Array<Types::Filter>]
    #
    # @!attribute [rw] vpn_gateway_ids
    #   One or more virtual private gateway IDs.
    #
    #   Default: Describes all your virtual private gateways.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpnGatewaysRequest AWS API Documentation
    #
    class DescribeVpnGatewaysRequest < Struct.new(
      :filters,
      :vpn_gateway_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the output of DescribeVpnGateways.
    #
    # @!attribute [rw] vpn_gateways
    #   Information about one or more virtual private gateways.
    #   @return [Array<Types::VpnGateway>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpnGatewaysResult AWS API Documentation
    #
    class DescribeVpnGatewaysResult < Struct.new(
      :vpn_gateways)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DetachClassicLinkVpcRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         instance_id: "InstanceId", # required
    #         vpc_id: "VpcId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance to unlink from the VPC.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC to which the instance is linked.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachClassicLinkVpcRequest AWS API Documentation
    #
    class DetachClassicLinkVpcRequest < Struct.new(
      :dry_run,
      :instance_id,
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachClassicLinkVpcResult AWS API Documentation
    #
    class DetachClassicLinkVpcResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DetachInternetGatewayRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         internet_gateway_id: "InternetGatewayId", # required
    #         vpc_id: "VpcId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] internet_gateway_id
    #   The ID of the internet gateway.
    #   @return [String]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachInternetGatewayRequest AWS API Documentation
    #
    class DetachInternetGatewayRequest < Struct.new(
      :dry_run,
      :internet_gateway_id,
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DetachNetworkInterface.
    #
    # @note When making an API call, you may pass DetachNetworkInterfaceRequest
    #   data as a hash:
    #
    #       {
    #         attachment_id: "NetworkInterfaceAttachmentId", # required
    #         dry_run: false,
    #         force: false,
    #       }
    #
    # @!attribute [rw] attachment_id
    #   The ID of the attachment.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] force
    #   Specifies whether to force a detachment.
    #
    #   <note markdown="1"> * Use the `Force` parameter only as a last resort to detach a
    #     network interface from a failed instance.
    #
    #   * If you use the `Force` parameter to detach a network interface,
    #     you might not be able to attach a different network interface to
    #     the same index on the instance without first stopping and starting
    #     the instance.
    #
    #   * If you force the detachment of a network interface, the [instance
    #     metadata][1] might not get updated. This means that the attributes
    #     associated with the detached network interface might still be
    #     visible. The instance metadata will get updated when you stop and
    #     start the instance.
    #
    #    </note>
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachNetworkInterfaceRequest AWS API Documentation
    #
    class DetachNetworkInterfaceRequest < Struct.new(
      :attachment_id,
      :dry_run,
      :force)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DetachVolumeRequest
    #   data as a hash:
    #
    #       {
    #         device: "String",
    #         force: false,
    #         instance_id: "InstanceId",
    #         volume_id: "VolumeId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] device
    #   The device name.
    #   @return [String]
    #
    # @!attribute [rw] force
    #   Forces detachment if the previous detachment attempt did not occur
    #   cleanly (for example, logging into an instance, unmounting the
    #   volume, and detaching normally). This option can lead to data loss
    #   or a corrupted file system. Use this option only as a last resort to
    #   detach a volume from a failed instance. The instance won't have an
    #   opportunity to flush file system caches or file system metadata. If
    #   you use this option, you must perform file system check and repair
    #   procedures.
    #   @return [Boolean]
    #
    # @!attribute [rw] instance_id
    #   The ID of the instance. If you are detaching a Multi-Attach enabled
    #   volume, you must specify an instance ID.
    #   @return [String]
    #
    # @!attribute [rw] volume_id
    #   The ID of the volume.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachVolumeRequest AWS API Documentation
    #
    class DetachVolumeRequest < Struct.new(
      :device,
      :force,
      :instance_id,
      :volume_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DetachVpnGateway.
    #
    # @note When making an API call, you may pass DetachVpnGatewayRequest
    #   data as a hash:
    #
    #       {
    #         vpc_id: "VpcId", # required
    #         vpn_gateway_id: "VpnGatewayId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @!attribute [rw] vpn_gateway_id
    #   The ID of the virtual private gateway.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DetachVpnGatewayRequest AWS API Documentation
    #
    class DetachVpnGatewayRequest < Struct.new(
      :vpc_id,
      :vpn_gateway_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a DHCP configuration option.
    #
    # @!attribute [rw] key
    #   The name of a DHCP option.
    #   @return [String]
    #
    # @!attribute [rw] values
    #   One or more values for the DHCP option.
    #   @return [Array<Types::AttributeValue>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DhcpConfiguration AWS API Documentation
    #
    class DhcpConfiguration < Struct.new(
      :key,
      :values)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a set of DHCP options.
    #
    # @!attribute [rw] dhcp_configurations
    #   One or more DHCP options in the set.
    #   @return [Array<Types::DhcpConfiguration>]
    #
    # @!attribute [rw] dhcp_options_id
    #   The ID of the set of DHCP options.
    #   @return [String]
    #
    # @!attribute [rw] owner_id
    #   The ID of the AWS account that owns the DHCP options set.
    #   @return [String]
    #
    # @!attribute [rw] tags
    #   Any tags assigned to the DHCP options set.
    #   @return [Array<Types::Tag>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DhcpOptions AWS API Documentation
    #
    class DhcpOptions < Struct.new(
      :dhcp_configurations,
      :dhcp_options_id,
      :owner_id,
      :tags)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an Active Directory.
    #
    # @!attribute [rw] directory_id
    #   The ID of the Active Directory used for authentication.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DirectoryServiceAuthentication AWS API Documentation
    #
    class DirectoryServiceAuthentication < Struct.new(
      :directory_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the Active Directory to be used for client authentication.
    #
    # @note When making an API call, you may pass DirectoryServiceAuthenticationRequest
    #   data as a hash:
    #
    #       {
    #         directory_id: "String",
    #       }
    #
    # @!attribute [rw] directory_id
    #   The ID of the Active Directory to be used for authentication.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DirectoryServiceAuthenticationRequest AWS API Documentation
    #
    class DirectoryServiceAuthenticationRequest < Struct.new(
      :directory_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DisableEbsEncryptionByDefaultRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableEbsEncryptionByDefaultRequest AWS API Documentation
    #
    class DisableEbsEncryptionByDefaultRequest < Struct.new(
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ebs_encryption_by_default
    #   The updated status of encryption by default.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableEbsEncryptionByDefaultResult AWS API Documentation
    #
    class DisableEbsEncryptionByDefaultResult < Struct.new(
      :ebs_encryption_by_default)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains information about the errors that occurred when disabling
    # fast snapshot restores.
    #
    # @!attribute [rw] snapshot_id
    #   The ID of the snapshot.
    #   @return [String]
    #
    # @!attribute [rw] fast_snapshot_restore_state_errors
    #   The errors.
    #   @return [Array<Types::DisableFastSnapshotRestoreStateErrorItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableFastSnapshotRestoreErrorItem AWS API Documentation
    #
    class DisableFastSnapshotRestoreErrorItem < Struct.new(
      :snapshot_id,
      :fast_snapshot_restore_state_errors)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes an error that occurred when disabling fast snapshot
    # restores.
    #
    # @!attribute [rw] code
    #   The error code.
    #   @return [String]
    #
    # @!attribute [rw] message
    #   The error message.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableFastSnapshotRestoreStateError AWS API Documentation
    #
    class DisableFastSnapshotRestoreStateError < Struct.new(
      :code,
      :message)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains information about an error that occurred when disabling fast
    # snapshot restores.
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone.
    #   @return [String]
    #
    # @!attribute [rw] error
    #   The error.
    #   @return [Types::DisableFastSnapshotRestoreStateError]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableFastSnapshotRestoreStateErrorItem AWS API Documentation
    #
    class DisableFastSnapshotRestoreStateErrorItem < Struct.new(
      :availability_zone,
      :error)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes fast snapshot restores that were successfully disabled.
    #
    # @!attribute [rw] snapshot_id
    #   The ID of the snapshot.
    #   @return [String]
    #
    # @!attribute [rw] availability_zone
    #   The Availability Zone.
    #   @return [String]
    #
    # @!attribute [rw] state
    #   The state of fast snapshot restores for the snapshot.
    #   @return [String]
    #
    # @!attribute [rw] state_transition_reason
    #   The reason for the state transition. The possible values are as
    #   follows:
    #
    #   * `Client.UserInitiated` - The state successfully transitioned to
    #     `enabling` or `disabling`.
    #
    #   * `Client.UserInitiated - Lifecycle state transition` - The state
    #     successfully transitioned to `optimizing`, `enabled`, or
    #     `disabled`.
    #   @return [String]
    #
    # @!attribute [rw] owner_id
    #   The ID of the AWS account that enabled fast snapshot restores on the
    #   snapshot.
    #   @return [String]
    #
    # @!attribute [rw] owner_alias
    #   The AWS owner alias that enabled fast snapshot restores on the
    #   snapshot. This is intended for future use.
    #   @return [String]
    #
    # @!attribute [rw] enabling_time
    #   The time at which fast snapshot restores entered the `enabling`
    #   state.
    #   @return [Time]
    #
    # @!attribute [rw] optimizing_time
    #   The time at which fast snapshot restores entered the `optimizing`
    #   state.
    #   @return [Time]
    #
    # @!attribute [rw] enabled_time
    #   The time at which fast snapshot restores entered the `enabled`
    #   state.
    #   @return [Time]
    #
    # @!attribute [rw] disabling_time
    #   The time at which fast snapshot restores entered the `disabling`
    #   state.
    #   @return [Time]
    #
    # @!attribute [rw] disabled_time
    #   The time at which fast snapshot restores entered the `disabled`
    #   state.
    #   @return [Time]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableFastSnapshotRestoreSuccessItem AWS API Documentation
    #
    class DisableFastSnapshotRestoreSuccessItem < Struct.new(
      :snapshot_id,
      :availability_zone,
      :state,
      :state_transition_reason,
      :owner_id,
      :owner_alias,
      :enabling_time,
      :optimizing_time,
      :enabled_time,
      :disabling_time,
      :disabled_time)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DisableFastSnapshotRestoresRequest
    #   data as a hash:
    #
    #       {
    #         availability_zones: ["String"], # required
    #         source_snapshot_ids: ["SnapshotId"], # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] availability_zones
    #   One or more Availability Zones. For example, `us-east-2a`.
    #   @return [Array<String>]
    #
    # @!attribute [rw] source_snapshot_ids
    #   The IDs of one or more snapshots. For example,
    #   `snap-1234567890abcdef0`.
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableFastSnapshotRestoresRequest AWS API Documentation
    #
    class DisableFastSnapshotRestoresRequest < Struct.new(
      :availability_zones,
      :source_snapshot_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] successful
    #   Information about the snapshots for which fast snapshot restores
    #   were successfully disabled.
    #   @return [Array<Types::DisableFastSnapshotRestoreSuccessItem>]
    #
    # @!attribute [rw] unsuccessful
    #   Information about the snapshots for which fast snapshot restores
    #   could not be disabled.
    #   @return [Array<Types::DisableFastSnapshotRestoreErrorItem>]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableFastSnapshotRestoresResult AWS API Documentation
    #
    class DisableFastSnapshotRestoresResult < Struct.new(
      :successful,
      :unsuccessful)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DisableTransitGatewayRouteTablePropagationRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_route_table_id: "TransitGatewayRouteTableId", # required
    #         transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_route_table_id
    #   The ID of the propagation route table.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the attachment.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableTransitGatewayRouteTablePropagationRequest AWS API Documentation
    #
    class DisableTransitGatewayRouteTablePropagationRequest < Struct.new(
      :transit_gateway_route_table_id,
      :transit_gateway_attachment_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] propagation
    #   Information about route propagation.
    #   @return [Types::TransitGatewayPropagation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableTransitGatewayRouteTablePropagationResult AWS API Documentation
    #
    class DisableTransitGatewayRouteTablePropagationResult < Struct.new(
      :propagation)
      SENSITIVE = []
      include Aws::Structure
    end

    # Contains the parameters for DisableVgwRoutePropagation.
    #
    # @note When making an API call, you may pass DisableVgwRoutePropagationRequest
    #   data as a hash:
    #
    #       {
    #         gateway_id: "VpnGatewayId", # required
    #         route_table_id: "RouteTableId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] gateway_id
    #   The ID of the virtual private gateway.
    #   @return [String]
    #
    # @!attribute [rw] route_table_id
    #   The ID of the route table.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVgwRoutePropagationRequest AWS API Documentation
    #
    class DisableVgwRoutePropagationRequest < Struct.new(
      :gateway_id,
      :route_table_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DisableVpcClassicLinkDnsSupportRequest
    #   data as a hash:
    #
    #       {
    #         vpc_id: "VpcId",
    #       }
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVpcClassicLinkDnsSupportRequest AWS API Documentation
    #
    class DisableVpcClassicLinkDnsSupportRequest < Struct.new(
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVpcClassicLinkDnsSupportResult AWS API Documentation
    #
    class DisableVpcClassicLinkDnsSupportResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DisableVpcClassicLinkRequest
    #   data as a hash:
    #
    #       {
    #         dry_run: false,
    #         vpc_id: "VpcId", # required
    #       }
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVpcClassicLinkRequest AWS API Documentation
    #
    class DisableVpcClassicLinkRequest < Struct.new(
      :dry_run,
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableVpcClassicLinkResult AWS API Documentation
    #
    class DisableVpcClassicLinkResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DisassociateAddressRequest
    #   data as a hash:
    #
    #       {
    #         association_id: "ElasticIpAssociationId",
    #         public_ip: "String",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] association_id
    #   \[EC2-VPC\] The association ID. Required for EC2-VPC.
    #   @return [String]
    #
    # @!attribute [rw] public_ip
    #   \[EC2-Classic\] The Elastic IP address. Required for EC2-Classic.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateAddressRequest AWS API Documentation
    #
    class DisassociateAddressRequest < Struct.new(
      :association_id,
      :public_ip,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DisassociateClientVpnTargetNetworkRequest
    #   data as a hash:
    #
    #       {
    #         client_vpn_endpoint_id: "ClientVpnEndpointId", # required
    #         association_id: "ClientVpnAssociationId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] client_vpn_endpoint_id
    #   The ID of the Client VPN endpoint from which to disassociate the
    #   target network.
    #   @return [String]
    #
    # @!attribute [rw] association_id
    #   The ID of the target network association.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateClientVpnTargetNetworkRequest AWS API Documentation
    #
    class DisassociateClientVpnTargetNetworkRequest < Struct.new(
      :client_vpn_endpoint_id,
      :association_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] association_id
    #   The ID of the target network association.
    #   @return [String]
    #
    # @!attribute [rw] status
    #   The current state of the target network association.
    #   @return [Types::AssociationStatus]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateClientVpnTargetNetworkResult AWS API Documentation
    #
    class DisassociateClientVpnTargetNetworkResult < Struct.new(
      :association_id,
      :status)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DisassociateEnclaveCertificateIamRoleRequest
    #   data as a hash:
    #
    #       {
    #         certificate_arn: "ResourceArn",
    #         role_arn: "ResourceArn",
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] certificate_arn
    #   The ARN of the ACM certificate from which to disassociate the IAM
    #   role.
    #   @return [String]
    #
    # @!attribute [rw] role_arn
    #   The ARN of the IAM role to disassociate.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateEnclaveCertificateIamRoleRequest AWS API Documentation
    #
    class DisassociateEnclaveCertificateIamRoleRequest < Struct.new(
      :certificate_arn,
      :role_arn,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] return
    #   Returns `true` if the request succeeds; otherwise, it returns an
    #   error.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateEnclaveCertificateIamRoleResult AWS API Documentation
    #
    class DisassociateEnclaveCertificateIamRoleResult < Struct.new(
      :return)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DisassociateIamInstanceProfileRequest
    #   data as a hash:
    #
    #       {
    #         association_id: "IamInstanceProfileAssociationId", # required
    #       }
    #
    # @!attribute [rw] association_id
    #   The ID of the IAM instance profile association.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateIamInstanceProfileRequest AWS API Documentation
    #
    class DisassociateIamInstanceProfileRequest < Struct.new(
      :association_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] iam_instance_profile_association
    #   Information about the IAM instance profile association.
    #   @return [Types::IamInstanceProfileAssociation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateIamInstanceProfileResult AWS API Documentation
    #
    class DisassociateIamInstanceProfileResult < Struct.new(
      :iam_instance_profile_association)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DisassociateRouteTableRequest
    #   data as a hash:
    #
    #       {
    #         association_id: "RouteTableAssociationId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] association_id
    #   The association ID representing the current association between the
    #   route table and subnet or gateway.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateRouteTableRequest AWS API Documentation
    #
    class DisassociateRouteTableRequest < Struct.new(
      :association_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DisassociateSubnetCidrBlockRequest
    #   data as a hash:
    #
    #       {
    #         association_id: "SubnetCidrAssociationId", # required
    #       }
    #
    # @!attribute [rw] association_id
    #   The association ID for the CIDR block.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateSubnetCidrBlockRequest AWS API Documentation
    #
    class DisassociateSubnetCidrBlockRequest < Struct.new(
      :association_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipv_6_cidr_block_association
    #   Information about the IPv6 CIDR block association.
    #   @return [Types::SubnetIpv6CidrBlockAssociation]
    #
    # @!attribute [rw] subnet_id
    #   The ID of the subnet.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateSubnetCidrBlockResult AWS API Documentation
    #
    class DisassociateSubnetCidrBlockResult < Struct.new(
      :ipv_6_cidr_block_association,
      :subnet_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DisassociateTransitGatewayMulticastDomainRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_multicast_domain_id: "TransitGatewayMulticastDomainId",
    #         transit_gateway_attachment_id: "TransitGatewayAttachmentId",
    #         subnet_ids: ["SubnetId"],
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_multicast_domain_id
    #   The ID of the transit gateway multicast domain.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the attachment.
    #   @return [String]
    #
    # @!attribute [rw] subnet_ids
    #   The IDs of the subnets;
    #   @return [Array<String>]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateTransitGatewayMulticastDomainRequest AWS API Documentation
    #
    class DisassociateTransitGatewayMulticastDomainRequest < Struct.new(
      :transit_gateway_multicast_domain_id,
      :transit_gateway_attachment_id,
      :subnet_ids,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] associations
    #   Information about the association.
    #   @return [Types::TransitGatewayMulticastDomainAssociations]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateTransitGatewayMulticastDomainResult AWS API Documentation
    #
    class DisassociateTransitGatewayMulticastDomainResult < Struct.new(
      :associations)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DisassociateTransitGatewayRouteTableRequest
    #   data as a hash:
    #
    #       {
    #         transit_gateway_route_table_id: "TransitGatewayRouteTableId", # required
    #         transit_gateway_attachment_id: "TransitGatewayAttachmentId", # required
    #         dry_run: false,
    #       }
    #
    # @!attribute [rw] transit_gateway_route_table_id
    #   The ID of the transit gateway route table.
    #   @return [String]
    #
    # @!attribute [rw] transit_gateway_attachment_id
    #   The ID of the attachment.
    #   @return [String]
    #
    # @!attribute [rw] dry_run
    #   Checks whether you have the required permissions for the action,
    #   without actually making the request, and provides an error response.
    #   If you have the required permissions, the error response is
    #   `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
    #   @return [Boolean]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateTransitGatewayRouteTableRequest AWS API Documentation
    #
    class DisassociateTransitGatewayRouteTableRequest < Struct.new(
      :transit_gateway_route_table_id,
      :transit_gateway_attachment_id,
      :dry_run)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] association
    #   Information about the association.
    #   @return [Types::TransitGatewayAssociation]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateTransitGatewayRouteTableResult AWS API Documentation
    #
    class DisassociateTransitGatewayRouteTableResult < Struct.new(
      :association)
      SENSITIVE = []
      include Aws::Structure
    end

    # @note When making an API call, you may pass DisassociateVpcCidrBlockRequest
    #   data as a hash:
    #
    #       {
    #         association_id: "VpcCidrAssociationId", # required
    #       }
    #
    # @!attribute [rw] association_id
    #   The association ID for the CIDR block.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateVpcCidrBlockRequest AWS API Documentation
    #
    class DisassociateVpcCidrBlockRequest < Struct.new(
      :association_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # @!attribute [rw] ipv_6_cidr_block_association
    #   Information about the IPv6 CIDR block association.
    #   @return [Types::VpcIpv6CidrBlockAssociation]
    #
    # @!attribute [rw] cidr_block_association
    #   Information about the IPv4 CIDR block association.
    #   @return [Types::VpcCidrBlockAssociation]
    #
    # @!attribute [rw] vpc_id
    #   The ID of the VPC.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisassociateVpcCidrBlockResult AWS API Documentation
    #
    class DisassociateVpcCidrBlockResult < Struct.new(
      :ipv_6_cidr_block_association,
      :cidr_block_association,
      :vpc_id)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a disk image.
    #
    # @note When making an API call, you may pass DiskImage
    #   data as a hash:
    #
    #       {
    #         description: "String",
    #         image: {
    #           bytes: 1, # required
    #           format: "VMDK", # required, accepts VMDK, RAW, VHD
    #           import_manifest_url: "String", # required
    #         },
    #         volume: {
    #           size: 1, # required
    #         },
    #       }
    #
    # @!attribute [rw] description
    #   A description of the disk image.
    #   @return [String]
    #
    # @!attribute [rw] image
    #   Information about the disk image.
    #   @return [Types::DiskImageDetail]
    #
    # @!attribute [rw] volume
    #   Information about the volume.
    #   @return [Types::VolumeDetail]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DiskImage AWS API Documentation
    #
    class DiskImage < Struct.new(
      :description,
      :image,
      :volume)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a disk image.
    #
    # @!attribute [rw] checksum
    #   The checksum computed for the disk image.
    #   @return [String]
    #
    # @!attribute [rw] format
    #   The disk image format.
    #   @return [String]
    #
    # @!attribute [rw] import_manifest_url
    #   A presigned URL for the import manifest stored in Amazon S3. For
    #   information about creating a presigned URL for an Amazon S3 object,
    #   read the "Query String Request Authentication Alternative" section
    #   of the [Authenticating REST Requests][1] topic in the *Amazon Simple
    #   Storage Service Developer Guide*.
    #
    #   For information about the import manifest referenced by this API
    #   action, see [VM Import Manifest][2].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html
    #   [2]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html
    #   @return [String]
    #
    # @!attribute [rw] size
    #   The size of the disk image, in GiB.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DiskImageDescription AWS API Documentation
    #
    class DiskImageDescription < Struct.new(
      :checksum,
      :format,
      :import_manifest_url,
      :size)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a disk image.
    #
    # @note When making an API call, you may pass DiskImageDetail
    #   data as a hash:
    #
    #       {
    #         bytes: 1, # required
    #         format: "VMDK", # required, accepts VMDK, RAW, VHD
    #         import_manifest_url: "String", # required
    #       }
    #
    # @!attribute [rw] bytes
    #   The size of the disk image, in GiB.
    #   @return [Integer]
    #
    # @!attribute [rw] format
    #   The disk image format.
    #   @return [String]
    #
    # @!attribute [rw] import_manifest_url
    #   A presigned URL for the import manifest stored in Amazon S3 and
    #   presented here as an Amazon S3 presigned URL. For information about
    #   creating a presigned URL for an Amazon S3 object, read the "Query
    #   String Request Authentication Alternative" section of the
    #   [Authenticating REST Requests][1] topic in the *Amazon Simple
    #   Storage Service Developer Guide*.
    #
    #   For information about the import manifest referenced by this API
    #   action, see [VM Import Manifest][2].
    #
    #
    #
    #   [1]: https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html
    #   [2]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DiskImageDetail AWS API Documentation
    #
    class DiskImageDetail < Struct.new(
      :bytes,
      :format,
      :import_manifest_url)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a disk image volume.
    #
    # @!attribute [rw] id
    #   The volume identifier.
    #   @return [String]
    #
    # @!attribute [rw] size
    #   The size of the volume, in GiB.
    #   @return [Integer]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DiskImageVolumeDescription AWS API Documentation
    #
    class DiskImageVolumeDescription < Struct.new(
      :id,
      :size)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes the disk.
    #
    # @!attribute [rw] size_in_gb
    #   The size of the disk in GB.
    #   @return [Integer]
    #
    # @!attribute [rw] count
    #   The number of disks with this configuration.
    #   @return [Integer]
    #
    # @!attribute [rw] type
    #   The type of disk.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DiskInfo AWS API Documentation
    #
    class DiskInfo < Struct.new(
      :size_in_gb,
      :count,
      :type)
      SENSITIVE = []
      include Aws::Structure
    end

    # Describes a DNS entry.
    #
    # @!attribute [rw] dns_name
    #   The DNS name.
    #   @return [String]
    #
    # @!attribute [rw] hosted_zone_id
    #   The ID of the private hosted zone.
    #   @return [String]
    #
    # @see http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DnsEntry AWS API Documentation
    #
    class DnsEntry < Struct.new(
      :dns_name,
      :hosted_zone_i