# -*- coding: binary -*-


module Msf

###
#
# This mixin provides a generic interface for running a TCP server of some
# sort that is designed to exploit clients.  Exploits that include this mixin
# automatically take a passive stance.
#
###
module Exploit::Remote::TcpServer
  include Exploit::Remote::SocketServer

  def initialize(info = {})
    super

    register_options(
      [
        OptBool.new('SSL',        [ false, 'Negotiate SSL for incoming connections', false]),
        # SSLVersion is currently unsupported for TCP servers (only supported by clients at the moment)
        OptPath.new('SSLCert',    [ false, 'Path to a custom SSL certificate (default is randomly generated)'])
      ], Msf::Exploit::Remote::TcpServer
    )

    register_advanced_options(
      [
        OptString.new('ListenerComm', [ false, 'The specific communication channel to use for this service']),
        OptBool.new('SSLCompression', [ false, 'Enable SSL/TLS-level compression', false ]),
        OptString.new('SSLCipher',    [ false, 'String for SSL cipher spec - "DHE-RSA-AES256-SHA" or "ADH"'])
      ], Msf::Exploit::Remote::TcpServer)

    register_evasion_options(
      [
        OptInt.new('TCP::max_send_size', [false, 'Maximum tcp segment size.  (0 = disable)', 0]),
        OptInt.new('TCP::send_delay', [false, 'Delays inserted before every send.  (0 = disable)', 0])
      ], Msf::Exploit::Remote::Tcp
    )
  end

  # Called when a client connects.
  #
  def on_client_connect(client)
  end

  #
  # Called when a client has disconnected.
  #
  def on_client_close(client)
  end

  #
  # Starts the service.
  #
  def start_service(*args)
    begin

      comm = _determine_server_comm

      self.service = Rex::Socket::TcpServer.create(
        'LocalHost' => srvhost,
        'LocalPort' => srvport,
        'SSL'       => ssl,
        'SSLCert'   => ssl_cert,
        'SSLCipher'   => ssl_cipher,
        'SSLCompression' => ssl_compression,
        'Comm'      => comm,
        'Context'   =>
          {
            'Msf'        => framework,
            'MsfExploit' => self,
          })

      self.service.on_client_connect_proc = Proc.new { |client|
        on_client_connect(client)
      }
      self.service.on_client_data_proc = Proc.new { |client|
        on_client_data(client)
      }
      self.service.on_client_close_proc = Proc.new { |client|
        on_client_close(client)
      }

      # Start the listening service
      self.service.start

    rescue ::Errno::EACCES => e
      if (srvport.to_i < 1024)
        print_line(" ")
        print_error("Could not start the TCP server: #{e}.")
        print_error(
          "This module is configured to use a privileged TCP port (#{srvport}). " +
          "On Unix systems, only the root user account is allowed to bind to privileged ports." +
          "Please run the framework as root to use this module."
        )
        print_error(
          "On Microsoft Windows systems, this error is returned when a process attempts to "+
          "listen on a host/port combination that is already in use. For example, Windows XP "+
          "will return this error if a process attempts to bind() over the system SMB/NetBIOS services."
        )
        print_line(" ")
      end
      raise e
    end

    via = via_string_for_ip(srvhost, comm)
    hoststr = Rex::Socket.is_ipv6?(srvhost) ? "[#{srvhost}]" : srvhost
    print_status("Started service listener on #{hoststr}:#{srvport} #{via}")
  end

  #
  # Returns the SSL option
  #
  def ssl
    datastore['SSL']
  end

  #
  # Returns the SSLCert option
  #
  def ssl_cert
    datastore['SSLCert']
  end

  #
  # Returns the SSLCipher option
  #
  def ssl_cipher
    datastore['SSLCipher']
  end

  # @return [Bool] enable SSL/TLS-level compression
  def ssl_compression
    datastore['SSLCompression']
  end

end

end

