import ast
import re
from typing import Any, Callable, Dict, Generator, List, Optional, Tuple, Union

class LeoGlobals:
    def adjustTripleString(self, s: str) -> str: ...
    def callerName(self, n: int) -> str: ...
    def callers(self, n: int=4) -> str: ...
    def es_exception(self, full: bool=True) -> Tuple[str, int]: ...
    def getLastTracebackFileAndLineNumber(self) -> Tuple[str, int]: ...
    def objToString(self, obj: Any, tag: str=None) -> str: ...
    def pdb(self) -> None: ...
    def plural(self, obj: Any) -> str: ...
    def printObj(self, obj: Any, tag: str=None) -> None: ...
    def splitLines(self, s: str) -> List[str]: ...
    def toEncodedString(self, s: Any, encoding: str='utf-8') -> bytes: ...
    def toUnicode(self, s: Union[bytes, str], encoding: str='utf-8') -> str: ...
    def trace(self, *args: Optional[Any]) -> None: ...
    def truncate(self, s: str, n: int) -> str: ...
    
# Top-level functions...

def fstringify_command(files: List[str]) -> None: ...
def fstringify_diff_command(files: List[str]) -> None: ...
def orange_command(files: List[str]) -> None: ...
def orange_diff_command(files: List[str]) -> None: ...
def main() -> None: ...
def regularize_nls(s: str) -> str: ...
def get_encoding_directive(bb: bytes) -> str: ...
def read_file(filename: str, encoding: str='utf-8') -> Optional[str]: ...
def read_file_with_encoding(filename: str) -> Tuple[str, str]: ...
def strip_BOM(bb: bytes) -> Tuple[Optional[str], bytes]: ...
def write_file(filename: str, s: str, encoding: str='utf-8') -> None: ...
def find_anchor_token(node: ast.AST, global_token_list: List["Token"]) -> Optional["Token"]: ...
    # def anchor_token(node: ast.AST) -> Optional["Token"]: ...
def find_paren_token(i: int, global_token_list: List["Token"]) -> Optional[int]: ...
def get_node_token_list(node: ast.AST, global_tokens_list: List["Token"]) -> List["Token"]: ...
def is_significant(kind: str, value: str) -> bool: ...
def is_significant_token(token: "Token") -> bool: ...
def match_parens(filename: str, i: int, j: int, tokens: List["Token"]) -> int: ...
def tokens_for_node(filename: str, node: ast.AST, global_token_list: List["Token"]) -> List["Token"]: ...
def tokens_to_string(tokens: List["Token"]) -> str: ...
def compare_asts(ast1: ast.AST, ast2: ast.AST) -> bool: ...
def _compare_asts(node1: ast.AST, node2: ast.AST) -> None: ...
def _compare_nodes(node1: Any, node2: Any) -> None: ...
def compare_lists(list1: List[str], list2: List[str]) -> Optional[int]: ...
def expected_got(expected: str, got: str) -> str: ...
def get_time() -> float: ...
def obj_id(obj: Any) -> str: ...
def op_name(node: ast.AST) -> str: ...
def make_tokens(contents: str) -> List["Token"]: ...
    # def check(contents: str, tokens: List["Token"]) -> bool: ...
def parse_ast(s: str) -> Optional[ast.AST]: ...
    # def oops(message: str) -> None: ...
def dump_ast(ast: ast.AST, tag: str='dump_ast') -> None: ...
def dump_contents(contents: str, tag: str='Contents') -> None: ...
def dump_lines(tokens: List["Token"], tag: str='Token lines') -> None: ...
def dump_results(tokens: List["Token"], tag: str='Results') -> None: ...
def dump_tokens(tokens: List["Token"], tag: str='Tokens') -> None: ...
def dump_tree(tokens: List["Token"], tree: ast.AST, tag: str='Tree') -> None: ...
def show_diffs(s1: str, s2: str, filename: str='') -> None: ...
def find_statement_node(node: ast.AST) -> Optional[ast.AST]: ...
def is_ancestor(node: ast.AST, token: "Token") -> bool: ...
def is_long_statement(node: ast.AST) -> bool: ...
def is_statement_node(node: ast.AST) -> bool: ...
def nearest_common_ancestor(node1: ast.AST, node2: ast.AST) -> Optional[ast.AST]: ...
    # def parents(node: ast.AST) -> List[ast.AST]: ...
def add_token_to_token_list(token: "Token", node: ast.AST) -> None: ...
def replace_node(new_node: ast.AST, old_node: ast.AST) -> None: ...
def replace_token(token: "Token", kind: str, value: str) -> None: ...

class AssignLinksError(Exception): ...

class AstNotEqual(Exception): ...

class FailFast(Exception): ...

class TokenOrderGenerator:
    def balance_tokens(self, tokens: List["Token"]) -> int: ...
    def create_links(self, tokens: List["Token"], tree: ast.AST, file_name: str='') -> Generator[Any, None, None]: ...
    def init_from_file(self, filename: str) -> Tuple[Any, Any, Any, Any]: ...
    def init_from_string(self, contents: str, filename: str) -> Tuple[Any, Any]: ...
    def begin_visitor(self, node: ast.AST) -> None: ...
    def end_visitor(self, node: ast.AST) -> None: ...
    def find_next_significant_token(self) -> Optional["Token"]: ...
    def gen(self, z: Any) -> Generator[Any, None, None]: ...
    def gen_name(self, val: str) -> Generator[Any, None, None]: ...
    def gen_op(self, val: str) -> Generator[Any, None, None]: ...
    def gen_token(self, kind: str, val: str) -> Generator[Any, None, None]: ...
    def sync_token(self, kind: str, val: str) -> None: ...
    def set_links(self, node: ast.AST, token: "Token") -> None: ...
    def sync_name(self, val: str) -> None: ...
    def sync_op(self, val: str) -> None: ...
    def visitor(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_keyword(self, node: ast.AST) -> None: ...
    def do_arg(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_arguments(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_AsyncFunctionDef(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_ClassDef(self, node: ast.AST, print_body: bool=True) -> Generator[ast.AST, None, None]: ...
    def do_FunctionDef(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Interactive(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Lambda(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Module(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Expr(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Expression(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_GeneratorExp(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_NamedExpr(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Attribute(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Bytes(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_comprehension(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Constant(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Dict(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_DictComp(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Ellipsis(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_ExtSlice(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Index(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_FormattedValue(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_JoinedStr(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_List(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_ListComp(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Name(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_NameConstant(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Num(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Set(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_SetComp(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Slice(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Str(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def get_concatenated_string_tokens(self) -> List["Token"]: ...
    def do_Subscript(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Tuple(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_BinOp(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_BoolOp(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Compare(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_UnaryOp(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_IfExp(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Starred(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_AnnAssign(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Assert(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Assign(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_AsyncFor(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_AsyncWith(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_AugAssign(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Await(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Break(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Call(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def arg_helper(self, node: Any) -> Generator[ast.AST, None, None]: ...
    def handle_call_arguments(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
        # def get_pos(obj: Any) -> Tuple[int, int, Any]: ...
        # def sort_key(aTuple: Tuple[int, int, Any]) -> int: ...
    def do_Continue(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Delete(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_ExceptHandler(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_For(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Global(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_If(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Import(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_ImportFrom(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Nonlocal(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Pass(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Raise(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Return(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Try(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_While(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_With(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_Yield(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    def do_YieldFrom(self, node: ast.AST) -> Generator[ast.AST, None, None]: ...
    

class TokenOrderTraverser:
    def traverse(self, tree: ast.AST) -> int: ...
        # def has_next(i: int, node: ast.AST, stack: List[int]) -> bool: ...
    def visit(self, node: ast.AST) -> None: ...


class Orange:
    def __init__(self, settings: Dict[Any, Any]=None) -> None: ...
    def push_state(self, kind: str, value: Any=None) -> None: ...
    def oops(self) -> None: ...
    def beautify(self,
        contents: str,
        filename: str,
        tokens: List["Token"],
        tree: ast.AST,
        max_join_line_length: Optional[int]=None,
        max_split_line_length: Optional[int]=None,
    ) -> str: ...
    def beautify_file(self, filename: str) -> bool: ...
    def beautify_file_diff(self, filename: str) -> bool: ...
    def do_comment(self) -> None: ...
    def do_encoding(self) -> None: ...
    def do_endmarker(self) -> None: ...
    def do_dedent(self) -> None: ...
    def do_indent(self) -> None: ...
    def handle_dedent_after_class_or_def(self, kind: str) -> None: ...
    def do_name(self) -> None: ...
    def do_newline(self) -> None: ...
    def do_nl(self) -> None: ...
    def do_number(self) -> None: ...
    def do_op(self) -> None: ...
    def do_string(self) -> None: ...
    def do_verbatim(self) -> None: ...
    def do_ws(self) -> None: ...
    def add_line_end(self) -> "Token": ...
    def add_token(self, kind: str, value: Any) -> "Token": ...
    def blank(self) -> None: ...
    def blank_lines(self, n: int) -> None: ...
    def clean(self, kind: str) -> None: ...
    def clean_blank_lines(self) -> bool: ...
    def colon(self, val: str) -> None: ...
        # def is_expr(node: ast.AST) -> bool: ...
    def line_end(self) -> None: ...
    def line_indent(self) -> None: ...
    def lt(self, val: str) -> None: ...
    def rt(self, val: str) -> None: ...
    def possible_unary_op(self, s: str) -> None: ...
    def unary_op(self, s: str) -> None: ...
    def star_op(self) -> None: ...
    def star_star_op(self) -> None: ...
    def word(self, s: str) -> None: ...
    def word_op(self, s: str) -> None: ...
    def split_line(self, node: ast.AST, token: "Token") -> bool: ...
    def append_tail(self, prefix: List["Token"], tail: List["Token"]) -> None: ...
    def find_prev_line(self) -> List["Token"]: ...
    def find_line_prefix(self, token_list: List["Token"]) -> List["Token"]: ...
    def join_lines(self, node: ast.AST, token: "Token") -> None: ...

class OrangeSettings: ...

class ParseState:
    def __init__(self, kind: str, value: Any) -> None: ...
    def __repr__(self) -> str: ...

class AstDumper:
    def dump_tree(self, tokens: List["Token"], tree: ast.AST) -> str: ...
    def dump_tree_and_links_helper(self, node: ast.AST, level: int, result: List[str]) -> None: ...
    def compute_node_string(self, node: ast.AST, level: int) -> str: ...
    def show_fields(self, class_name: str, node: ast.AST, truncate_n: int) -> str: ...
    def show_line_range(self, node: ast.AST) -> str: ...
    def show_tokens(self, node: ast.AST, n: int, m: int, show_cruft: bool=False) -> str: ...
    def show_header(self) -> str: ...
    def dump_ast(self, node: ast.AST, level: int=0) -> str: ...
    def get_fields(self, node: ast.AST) -> Generator[Any, None, None]: ...

def atok_name(token: "Token") -> str: ...
def atok_value(token: "Token") -> str: ...
def dump_token(token: "Token") -> str: ...
def postvisit(node: ast.AST, par_value: Any, value: Any) -> Any: ...
def previsit(node: ast.AST, par_value: Any) -> Tuple[Any, Any]: ...

class Fstringify(TokenOrderTraverser):
    def fstringify(self,
        contents: str,
        filename: str,
        tokens: List["Token"],
        tree: ast.AST,
    ) -> str: ...
    def fstringify_file(self, filename: str) -> bool: ...
    def fstringify_file_diff(self, filename: str) -> bool: ...
    def fstringify_file_silent(self, filename: str) -> bool: ...
    def make_fstring(self, node: ast.AST) -> None: ...
    def clean_ws(self, s: str) -> str: ...
    def compute_result(self, lt_s: str, tokens: List["Token"]) -> str: ...
    def check_back_slashes(self, lt_s: str, tokens: List["Token"]) -> bool: ...
    def change_quotes(self, lt_s: str, aList: List[Any]) -> bool: ...
    def munge_spec(self, spec: str) -> Tuple[str, str]: ...
    def scan_format_string(self, s: str) -> List[re.Match]: ...
    def scan_rhs(self, node: ast.AST) -> List[List["Token"]]: ...
    def substitute_values(self, lt_s: str, specs: list[re.Match], values: List[List["Token"]]) -> List["Token"]: ...
    def message(self, message: str) -> None: ...
    def replace(self, node: ast.AST, s: str, values: List[Any]) -> None: ...
    def visit(self, node: ast.AST) -> None: ...

class ReassignTokens(TokenOrderTraverser):
    def reassign(self, filename: str, tokens: List["Token"], tree: ast.AST) -> None: ...
    def visit(self, node: ast.AST) -> None: ...

class Token:
    def __init__(self, kind: str, value: str) -> None: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...
    def to_string(self) -> str: ...
    def brief_dump(self) -> str: ...
    def dump(self) -> str: ...
    def dump_header(self) -> None: ...
    def error_dump(self) -> str: ...
    def show_val(self, truncate_n: int) -> Union[str, int]: ...

class Tokenizer:
    def add_token(self, kind: str, five_tuple: Any, line: str, s_row: int, value: str) -> None: ...
    def check_results(self, contents: str) -> None: ...
    def create_input_tokens(self, contents: str, tokens: Any) -> List["Token"]: ...
    def do_token(self, contents: str, five_tuple: Any) -> None: ...
