/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.util;

import java.nio.charset.StandardCharsets;
import org.mozilla.universalchardet.UniversalDetector;

public class UiStringUtil {
    private UiStringUtil() {
    }

    public static String detectUtf8Html(String text) {
        return UiStringUtil.detectUtf8Html(text, false);
    }

    public static String detectUtf8HtmlNoWrap(String text) {
        return UiStringUtil.detectUtf8Html(text, true);
    }

    public static String detectUtf8Html(String text, boolean nowrap) {
        if (text == null) {
            return "";
        }
        UniversalDetector detector = new UniversalDetector(null);
        detector.handleData(text.getBytes(StandardCharsets.UTF_8), 0, text.length() - 1);
        detector.dataEnd();
        String encoding = detector.getDetectedCharset();
        String result = text;
        if (encoding != null) {
            result = String.format("<html><span style=\"font-family:'%s';%s\">%s</span></html>", "Monospace", nowrap ? "white-space:nowrap;" : "", text);
        }
        return result;
    }
}

