/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.text;

import com.jsql.util.LogLevel;
import com.jsql.view.swing.popupmenu.JPopupMenuText;
import com.jsql.view.swing.text.DecoratorJComponent;
import com.jsql.view.swing.text.JPopupComponent;
import com.jsql.view.swing.text.action.SilentDeleteTextAction;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JPopupTextComponent<T extends JTextComponent>
extends JPopupComponent<T>
implements DecoratorJComponent<T> {
    private static final Logger LOGGER = LogManager.getRootLogger();

    public JPopupTextComponent(T proxy) {
        super(proxy);
        ((JTextComponent)this.getProxy()).setComponentPopupMenu(new JPopupMenuText((JTextComponent)this.getProxy()));
        ((JTextComponent)this.getProxy()).setDragEnabled(true);
        UndoManager undoRedoManager = new UndoManager();
        Document doc = ((JTextComponent)this.getProxy()).getDocument();
        doc.addUndoableEditListener(undoableEditEvent -> undoRedoManager.addEdit(undoableEditEvent.getEdit()));
        this.initializeUndo(undoRedoManager);
        this.initializeRedo(undoRedoManager);
        this.makeDeleteSilent();
    }

    private void initializeUndo(final UndoManager undo) {
        String undoIdentifier = "Undo";
        ((JTextComponent)this.getProxy()).getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canUndo()) {
                        undo.undo();
                    }
                }
                catch (ArrayIndexOutOfBoundsException | CannotUndoException e) {
                    LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
                }
            }
        });
        ((JTextComponent)this.getProxy()).getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
    }

    private void initializeRedo(final UndoManager undo) {
        String redoIdentifier = "Redo";
        ((JTextComponent)this.getProxy()).getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canRedo()) {
                        undo.redo();
                    }
                }
                catch (CannotRedoException e) {
                    LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
                }
            }
        });
        ((JTextComponent)this.getProxy()).getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    private void makeDeleteSilent() {
        ActionMap actionMap = ((JTextComponent)this.getProxy()).getActionMap();
        String key = "delete-previous";
        actionMap.put(key, new SilentDeleteTextAction(key, actionMap.get(key)));
        key = "delete-next";
        actionMap.put(key, new SilentDeleteTextAction(key, actionMap.get(key)));
    }
}

