/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tab;

import com.jsql.util.LogLevel;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JTabbedPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TabbedPaneMouseWheelListener
implements MouseWheelListener {
    private static final Logger LOGGER = LogManager.getRootLogger();

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        JTabbedPane tabPane = (JTabbedPane)event.getSource();
        int dir = -event.getWheelRotation();
        int selIndex = tabPane.getSelectedIndex();
        int maxIndex = tabPane.getTabCount() - 1;
        selIndex = selIndex == 0 && dir < 0 || selIndex == maxIndex && dir > 0 ? maxIndex - selIndex : (selIndex += dir);
        if (0 <= selIndex && selIndex < tabPane.getTabCount()) {
            try {
                tabPane.setSelectedIndex(selIndex);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            }
        }
    }
}

