/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.sql.lexer;

import com.jsql.view.swing.util.UiUtil;
import java.awt.Color;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class TokenStyles {
    private static HashMap<String, SimpleAttributeSet> styles = new HashMap();

    private TokenStyles() {
    }

    private static void addStyle(String name, Color bg, Color fg, boolean bold, boolean italic) {
        SimpleAttributeSet style = new SimpleAttributeSet();
        StyleConstants.setFontFamily(style, UiUtil.FONT_MONO_NON_ASIAN.getFontName());
        StyleConstants.setFontSize(style, UiUtil.FONT_MONO_NON_ASIAN.getSize());
        StyleConstants.setBackground(style, bg);
        StyleConstants.setForeground(style, fg);
        StyleConstants.setBold(style, bold);
        StyleConstants.setItalic(style, italic);
        styles.put(name, style);
    }

    public static AttributeSet getStyle(String styleName) {
        return styles.get(styleName);
    }

    static {
        Color maroon = new Color(11546720);
        Color darkBlue = new Color(128);
        Color darkGreen = Color.GREEN.darker();
        Color darkPurple = new Color(10494192).darker();
        TokenStyles.addStyle("body", Color.WHITE, Color.BLACK, false, false);
        TokenStyles.addStyle("tag", Color.WHITE, Color.BLUE, true, false);
        TokenStyles.addStyle("endtag", Color.WHITE, Color.BLUE, false, false);
        TokenStyles.addStyle("reference", Color.WHITE, Color.BLACK, false, false);
        TokenStyles.addStyle("name", Color.WHITE, maroon, true, false);
        TokenStyles.addStyle("value", Color.WHITE, maroon, false, true);
        TokenStyles.addStyle("text", Color.WHITE, Color.BLACK, true, false);
        TokenStyles.addStyle("reservedWord", Color.WHITE, Color.BLUE, false, false);
        TokenStyles.addStyle("identifier", Color.WHITE, Color.BLACK, false, false);
        TokenStyles.addStyle("literal", Color.WHITE, maroon, false, false);
        TokenStyles.addStyle("separator", Color.WHITE, darkBlue, false, false);
        TokenStyles.addStyle("operator", Color.WHITE, Color.BLACK, true, false);
        TokenStyles.addStyle("comment", Color.WHITE, darkGreen, false, false);
        TokenStyles.addStyle("preprocessor", Color.WHITE, darkPurple, false, false);
        TokenStyles.addStyle("whitespace", Color.WHITE, Color.BLACK, false, false);
        TokenStyles.addStyle("error", Color.WHITE, Color.RED, false, false);
        TokenStyles.addStyle("unknown", Color.WHITE, Color.ORANGE, false, false);
        TokenStyles.addStyle("grayedOut", Color.WHITE, Color.GRAY, false, false);
    }
}

