/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.sql.lexer;

import com.jsql.util.LogLevel;
import com.jsql.view.swing.sql.lexer.Colorer;
import com.jsql.view.swing.sql.lexer.DocumentReader;
import com.jsql.view.swing.sql.lexer.TokenStyles;
import com.jsql.view.swing.sql.lexer.syntax.JavaScriptLexer;
import com.jsql.view.swing.sql.lexer.syntax.Lexer;
import com.jsql.view.swing.sql.lexer.syntax.SQLLexer;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HighlightedDocument
extends DefaultStyledDocument {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public static final Object SQL_STYLE = SQLLexer.class;
    public static final Object JAVASCRIPT_STYLE = JavaScriptLexer.class;
    public static final Object GRAYED_OUT_STYLE = new Object();
    private transient DocumentReader documentReader;
    private transient AttributeSet globalStyle = null;
    private transient Lexer syntaxLexer;
    private transient Colorer colorer;
    private transient Object docLock = new Object();

    public HighlightedDocument(Object l) {
        this.colorer = new Colorer(this);
        this.colorer.start();
        this.documentReader = new DocumentReader(this);
        this.syntaxLexer = l == SQL_STYLE ? new SQLLexer(this.documentReader) : new JavaScriptLexer(this.documentReader);
    }

    public void colorAll() {
        this.color(0, this.getLength());
    }

    public void color(int position, int adjustment) {
        this.colorer.color(position, adjustment);
    }

    public void setGlobalStyle(AttributeSet value) {
        this.globalStyle = value;
        this.colorAll();
    }

    public void setHighlightStyle(Object valueSource) {
        Object value = valueSource;
        if (value == GRAYED_OUT_STYLE) {
            this.setGlobalStyle(TokenStyles.getStyle("grayedOut"));
            return;
        }
        if (!(value instanceof Class)) {
            value = SQL_STYLE;
        }
        Class source = (Class)value;
        Class[] parms = new Class[]{Reader.class};
        Object[] args = new Object[]{this.documentReader};
        try {
            Constructor cons = source.getConstructor(parms);
            this.syntaxLexer = (Lexer)cons.newInstance(args);
            this.globalStyle = null;
            this.colorAll();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        Object object = this.docLock;
        synchronized (object) {
            super.insertString(offs, str, a);
            this.color(offs, str.length());
            this.documentReader.update(offs, str.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(int offs, int len) throws BadLocationException {
        Object object = this.docLock;
        synchronized (object) {
            super.remove(offs, len);
            this.color(offs, -len);
            this.documentReader.update(offs, -len);
        }
    }

    DocumentReader getDocumentReader() {
        return this.documentReader;
    }

    Object getDocumentLock() {
        return this.docLock;
    }

    Lexer getSyntaxLexer() {
        return this.syntaxLexer;
    }

    AttributeSet getGlobalStyle() {
        return this.globalStyle;
    }

    public void stopColorer() {
        this.colorer.stopThread();
    }
}

