/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.sql;

import com.jsql.model.injection.vendor.model.Vendor;
import com.jsql.model.injection.vendor.model.yaml.Method;
import com.jsql.model.injection.vendor.model.yaml.ModelYaml;
import com.jsql.util.I18nUtil;
import com.jsql.view.swing.manager.util.ComboMenu;
import com.jsql.view.swing.scrollpane.LightScrollPane;
import com.jsql.view.swing.sql.lexer.HighlightedDocument;
import com.jsql.view.swing.sql.text.JTextPaneLexer;
import com.jsql.view.swing.sql.text.JTextPaneObjectMethod;
import com.jsql.view.swing.tab.TabHeader;
import com.jsql.view.swing.tab.TabbedPaneWheeled;
import com.jsql.view.swing.text.listener.DocumentListenerEditing;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.MenuSelectionManager;
import javax.swing.OverlayLayout;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicRadioButtonMenuItemUI;

public class SqlEngine
extends JPanel
implements TabHeader.Cleanable {
    private static ModelYaml modelYaml = MediatorHelper.model().getMediatorVendor().getVendor().instance().getModelYaml();
    private static JTabbedPane tabbedPaneError = new TabbedPaneWheeled(4, 1);
    private static transient Border borderRight = BorderFactory.createMatteBorder(0, 0, 0, 1, UiUtil.COLOR_COMPONENT_BORDER);
    private static final List<JTextPaneLexer> textPanesError = new ArrayList<JTextPaneLexer>();

    public SqlEngine() {
        SqlEngine.initializeTextComponents();
        Stream.of(TextareaWithColor.DATABASE_DEFAULT, TextareaWithColor.TABLE_DEFAULT, TextareaWithColor.COLUMN_DEFAULT, TextareaWithColor.QUERY_DEFAULT, TextareaWithColor.FIELD_DEFAULT, TextareaWithColor.CONCAT_DEFAULT, TextareaWithColor.INFO, TextareaWithColor.DATABASE_ZIP, TextareaWithColor.TABLE_ZIP, TextareaWithColor.COLUMN_ZIP, TextareaWithColor.QUERY_ZIP, TextareaWithColor.FIELD_ZIP, TextareaWithColor.CONCAT_ZIP, TextareaWithColor.DATABASE_DIOS, TextareaWithColor.TABLE_DIOS, TextareaWithColor.COLUMN_DIOS, TextareaWithColor.QUERY_DIOS, TextareaWithColor.FIELD_DIOS, TextareaWithColor.CONCAT_DIOS, TextareaWithColor.MODE_AND, TextareaWithColor.MODE_OR, TextareaWithColor.BLIND, TextareaWithColor.TIME, TextareaWithColor.BIT_TEST, TextareaWithColor.LENGTH_TEST).forEach(textPane -> textPane.getText().setBorder(borderRight));
        JPanel panelStructure = this.getPanelStructure();
        JPanel panelStrategy = this.getPanelStrategy();
        JPanel panelConfiguration = this.getPanelConfiguration();
        JPanel panelFingerprinting = this.getPanelFingerprinting();
        TabbedPaneWheeled tabsBottom = new TabbedPaneWheeled(3, 1);
        Stream.of(new AbstractMap.SimpleEntry<String, JPanel>("SQLENGINE_STRUCTURE", panelStructure), new AbstractMap.SimpleEntry<String, JPanel>("SQLENGINE_STRATEGY", panelStrategy), new AbstractMap.SimpleEntry<String, JPanel>("SQLENGINE_CONFIGURATION", panelConfiguration), new AbstractMap.SimpleEntry<String, JPanel>("SQLENGINE_FINGERPRINTING", panelFingerprinting)).forEach(entry -> {
            tabsBottom.addTab(I18nUtil.valueByKey((String)entry.getKey()), (Component)entry.getValue());
            JLabel label = new JLabel(I18nUtil.valueByKey((String)entry.getKey()));
            tabsBottom.setTabComponentAt(tabsBottom.indexOfTab(I18nUtil.valueByKey((String)entry.getKey())), label);
            I18nViewUtil.addComponentForKey((String)entry.getKey(), label);
        });
        this.setLayout(new OverlayLayout(this));
        JPanel panelCombo = SqlEngine.initializeMenuVendor();
        this.add(panelCombo);
        this.add(tabsBottom);
        tabsBottom.setAlignmentX(3.0f);
        tabsBottom.setAlignmentY(1.0f);
        MediatorHelper.menubar().switchLocale(I18nUtil.getLocaleDefault());
    }

    private JPanel getPanelStructure() {
        String keyDatabases = "SQLENGINE_DATABASES";
        String keyTables = "SQLENGINE_TABLES";
        String keyColumns = "SQLENGINE_COLUMNS";
        String keyRows = "SQLENGINE_ROWS";
        String keyField = "SQLENGINE_FIELD";
        String keyFieldSeparator = "SQLENGINE_FIELDS_SEPARATOR";
        TabbedPaneWheeled tabsStandard = new TabbedPaneWheeled(4, 1);
        TabbedPaneWheeled tabsSchema = new TabbedPaneWheeled(1, 1);
        Stream.of(new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_DATABASES", TextareaWithColor.DATABASE_DEFAULT.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_TABLES", TextareaWithColor.TABLE_DEFAULT.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_COLUMNS", TextareaWithColor.COLUMN_DEFAULT.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_ROWS", TextareaWithColor.QUERY_DEFAULT.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_FIELD", TextareaWithColor.FIELD_DEFAULT.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_FIELDS_SEPARATOR", TextareaWithColor.CONCAT_DEFAULT.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_METADATA", TextareaWithColor.INFO.getText())).forEach(entry -> {
            tabsSchema.addTab(I18nUtil.valueByKey((String)entry.getKey()), new LightScrollPane(1, 0, 1, 0, (JComponent)entry.getValue()));
            JLabel label = new JLabel(I18nUtil.valueByKey((String)entry.getKey()));
            tabsSchema.setTabComponentAt(tabsSchema.indexOfTab(I18nUtil.valueByKey((String)entry.getKey())), label);
            I18nViewUtil.addComponentForKey((String)entry.getKey(), label);
        });
        TabbedPaneWheeled tabsZip = new TabbedPaneWheeled(1, 1);
        Stream.of(new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_DATABASES", TextareaWithColor.DATABASE_ZIP.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_TABLES", TextareaWithColor.TABLE_ZIP.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_COLUMNS", TextareaWithColor.COLUMN_ZIP.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_ROWS", TextareaWithColor.QUERY_ZIP.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_FIELD", TextareaWithColor.FIELD_ZIP.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_FIELDS_SEPARATOR", TextareaWithColor.CONCAT_ZIP.getText())).forEach(entry -> {
            tabsZip.addTab(I18nUtil.valueByKey((String)entry.getKey()), new LightScrollPane(1, 0, 1, 0, (JComponent)entry.getValue()));
            JLabel label = new JLabel(I18nUtil.valueByKey((String)entry.getKey()));
            tabsZip.setTabComponentAt(tabsZip.indexOfTab(I18nUtil.valueByKey((String)entry.getKey())), label);
            I18nViewUtil.addComponentForKey((String)entry.getKey(), label);
        });
        TabbedPaneWheeled tabsDios = new TabbedPaneWheeled(1, 1);
        Stream.of(new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_DATABASES", TextareaWithColor.DATABASE_DIOS.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_TABLES", TextareaWithColor.TABLE_DIOS.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_COLUMNS", TextareaWithColor.COLUMN_DIOS.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_ROWS", TextareaWithColor.QUERY_DIOS.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_FIELD", TextareaWithColor.FIELD_DIOS.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("SQLENGINE_FIELDS_SEPARATOR", TextareaWithColor.CONCAT_DIOS.getText())).forEach(entry -> {
            tabsDios.addTab(I18nUtil.valueByKey((String)entry.getKey()), new LightScrollPane(1, 0, 1, 0, (JComponent)entry.getValue()));
            JLabel label = new JLabel(I18nUtil.valueByKey((String)entry.getKey()));
            tabsDios.setTabComponentAt(tabsDios.indexOfTab(I18nUtil.valueByKey((String)entry.getKey())), label);
            I18nViewUtil.addComponentForKey((String)entry.getKey(), label);
        });
        Stream.of(new AbstractMap.SimpleEntry<String, TabbedPaneWheeled>("SQLENGINE_STANDARD", tabsSchema), new AbstractMap.SimpleEntry<String, TabbedPaneWheeled>("SQLENGINE_ZIP", tabsZip), new AbstractMap.SimpleEntry<String, TabbedPaneWheeled>("SQLENGINE_DIOS", tabsDios)).forEach(entry -> {
            tabsStandard.addTab(I18nUtil.valueByKey((String)entry.getKey()), (Component)entry.getValue());
            JLabel label = new JLabel(I18nUtil.valueByKey((String)entry.getKey()));
            tabsStandard.setTabComponentAt(tabsStandard.indexOfTab(I18nUtil.valueByKey((String)entry.getKey())), label);
            I18nViewUtil.addComponentForKey((String)entry.getKey(), label);
        });
        JPanel panelStructure = new JPanel(new BorderLayout());
        panelStructure.add((Component)tabsStandard, "Center");
        panelStructure.setBorder(BorderFactory.createEmptyBorder());
        return panelStructure;
    }

    private JPanel getPanelStrategy() {
        TabbedPaneWheeled tabsStrategy = new TabbedPaneWheeled(1, 1);
        tabsStrategy.addTab(I18nUtil.valueByKey("SQLENGINE_NORMAL"), new LightScrollPane(1, 0, 1, 0, TextareaWithColor.INDICES.getText()));
        JPanel panelStrategy = new JPanel(new BorderLayout());
        panelStrategy.add((Component)tabsStrategy, "Center");
        panelStrategy.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UiUtil.COLOR_COMPONENT_BORDER));
        JPanel panelError = new JPanel(new BorderLayout());
        panelError.add((Component)tabbedPaneError, "Center");
        tabsStrategy.addTab(I18nUtil.valueByKey("SQLENGINE_ERROR"), panelError);
        TabbedPaneWheeled tabsBoolean = new TabbedPaneWheeled(4, 1);
        Stream.of(new AbstractMap.SimpleEntry<String, JTextPaneLexer>("AND mode", TextareaWithColor.MODE_AND.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("OR mode", TextareaWithColor.MODE_OR.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("Blind", TextareaWithColor.BLIND.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("Time", TextareaWithColor.TIME.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("Bit Test", TextareaWithColor.BIT_TEST.getText()), new AbstractMap.SimpleEntry<String, JTextPaneLexer>("Length Test", TextareaWithColor.LENGTH_TEST.getText())).forEach(entry -> tabsBoolean.addTab((String)entry.getKey(), new LightScrollPane(1, 0, 1, 0, (JComponent)entry.getValue())));
        JPanel panelBoolean = new JPanel(new BorderLayout());
        panelBoolean.add((Component)tabsBoolean, "Center");
        tabsStrategy.addTab(I18nUtil.valueByKey("SQLENGINE_BOOLEAN"), panelBoolean);
        Stream.of("SQLENGINE_NORMAL", "SQLENGINE_ERROR", "SQLENGINE_BOOLEAN").forEach(keyI18n -> {
            JLabel label = new JLabel(I18nUtil.valueByKey(keyI18n));
            tabsStrategy.setTabComponentAt(tabsStrategy.indexOfTab(I18nUtil.valueByKey(keyI18n)), label);
            I18nViewUtil.addComponentForKey(keyI18n, label);
        });
        return panelStrategy;
    }

    private JPanel getPanelConfiguration() {
        TabbedPaneWheeled tabsConfiguration = new TabbedPaneWheeled(1, 1);
        tabsConfiguration.addTab(I18nUtil.valueByKey("SQLENGINE_CHARACTERS_SLIDINGWINDOW"), new LightScrollPane(1, 0, 1, 0, TextareaWithColor.SLIDING_WINDOW.getText()));
        tabsConfiguration.addTab(I18nUtil.valueByKey("SQLENGINE_ROWS_SLIDINGWINDOW"), new LightScrollPane(1, 0, 1, 0, TextareaWithColor.LIMIT.getText()));
        tabsConfiguration.addTab("Limit start index", new LightScrollPane(1, 0, 1, 0, TextareaWithColor.LIMIT_BOUNDARY.getText()));
        tabsConfiguration.addTab(I18nUtil.valueByKey("SQLENGINE_CAPACITY"), new LightScrollPane(1, 0, 1, 0, TextareaWithColor.CAPACITY.getText()));
        tabsConfiguration.addTab(I18nUtil.valueByKey("SQLENGINE_CALIBRATOR"), new LightScrollPane(1, 0, 1, 0, TextareaWithColor.CALIBRATOR.getText()));
        tabsConfiguration.addTab(I18nUtil.valueByKey("SQLENGINE_TRAPCANCELLER"), new LightScrollPane(1, 0, 1, 0, TextareaWithColor.FAILSAFE.getText()));
        tabsConfiguration.addTab("End comment", new LightScrollPane(1, 0, 1, 0, TextareaWithColor.ENDING_COMMENT.getText()));
        Stream.of("SQLENGINE_CHARACTERS_SLIDINGWINDOW", "SQLENGINE_ROWS_SLIDINGWINDOW", "SQLENGINE_CAPACITY", "SQLENGINE_CALIBRATOR", "SQLENGINE_TRAPCANCELLER").forEach(keyI18n -> {
            JLabel label = new JLabel(I18nUtil.valueByKey(keyI18n));
            tabsConfiguration.setTabComponentAt(tabsConfiguration.indexOfTab(I18nUtil.valueByKey(keyI18n)), label);
            I18nViewUtil.addComponentForKey(keyI18n, label);
        });
        JPanel panelConfiguration = new JPanel(new BorderLayout());
        panelConfiguration.add((Component)tabsConfiguration, "Center");
        panelConfiguration.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UiUtil.COLOR_COMPONENT_BORDER));
        return panelConfiguration;
    }

    private JPanel getPanelFingerprinting() {
        TabbedPaneWheeled tabs = new TabbedPaneWheeled(1, 1);
        tabs.addTab(I18nUtil.valueByKey("SQLENGINE_ORDER_BY"), new LightScrollPane(1, 0, 1, 0, TextareaWithColor.ORDER_BY.getText()));
        tabs.addTab("Order by error", new LightScrollPane(1, 0, 1, 0, TextareaWithColor.ORDER_BY_ERROR_MESSAGE.getText()));
        tabs.addTab("String error", new LightScrollPane(1, 0, 1, 0, TextareaWithColor.INCORRECT_STRING_ERROR_MESSAGE.getText()));
        tabs.addTab("Truthy", new LightScrollPane(1, 0, 1, 0, TextareaWithColor.TRUTHY.getText()));
        tabs.addTab("Falsy", new LightScrollPane(1, 0, 1, 0, TextareaWithColor.FALSY.getText()));
        Stream.of("SQLENGINE_ORDER_BY").forEach(keyI18n -> {
            JLabel label = new JLabel(I18nUtil.valueByKey(keyI18n));
            tabs.setTabComponentAt(tabs.indexOfTab(I18nUtil.valueByKey(keyI18n)), label);
            I18nViewUtil.addComponentForKey(keyI18n, label);
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)tabs, "Center");
        panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UiUtil.COLOR_COMPONENT_BORDER));
        return panel;
    }

    private static JPanel initializeMenuVendor() {
        JPanel panelCombo = new JPanel();
        panelCombo.setLayout(new BorderLayout());
        panelCombo.setOpaque(false);
        panelCombo.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        panelCombo.setPreferredSize(new Dimension(Integer.MAX_VALUE, 25));
        panelCombo.setMaximumSize(new Dimension(Integer.MAX_VALUE, 25));
        JMenuBar menuBarVendor = new JMenuBar();
        menuBarVendor.setOpaque(false);
        menuBarVendor.setBorder(null);
        ComboMenu comboMenuVendor = new ComboMenu(MediatorHelper.model().getMediatorVendor().getVendor().toString());
        menuBarVendor.add(comboMenuVendor);
        ButtonGroup groupVendor = new ButtonGroup();
        LinkedList<Vendor> listVendors = new LinkedList<Vendor>(MediatorHelper.model().getMediatorVendor().getVendors());
        listVendors.removeIf(vendor -> vendor == MediatorHelper.model().getMediatorVendor().getAuto());
        for (Vendor vendor2 : listVendors) {
            JRadioButtonMenuItem itemRadioVendor = new JRadioButtonMenuItem(vendor2.toString(), vendor2 == MediatorHelper.model().getMediatorVendor().getVendor());
            itemRadioVendor.addActionListener(actionEvent -> {
                modelYaml = vendor2.instance().getModelYaml();
                SqlEngine.initializeTextComponents();
                comboMenuVendor.setText(vendor2.toString());
            });
            itemRadioVendor.setUI(new BasicRadioButtonMenuItemUI(){

                @Override
                protected void doClick(MenuSelectionManager msm) {
                    this.menuItem.doClick(0);
                }
            });
            comboMenuVendor.add(itemRadioVendor);
            groupVendor.add(itemRadioVendor);
        }
        panelCombo.add((Component)menuBarVendor, "After");
        panelCombo.setAlignmentX(4.0f);
        panelCombo.setAlignmentY(1.0f);
        return panelCombo;
    }

    private static void initializeTextComponents() {
        SqlEngine.getTextPanes().forEach(SqlEngine::resetLexer);
        SqlEngine.getTextPanes().forEach(JTextPaneObjectMethod::switchSetterToVendor);
        SqlEngine.getTextPanes().forEach(textPaneLexer -> textPaneLexer.setText(""));
        Stream.of(TextareaWithColor.values()).forEach(entry -> entry.getText().setText(entry.getText().getSupplierGetter().get().trim()));
        SqlEngine.populateTabError();
    }

    private static void populateTabError() {
        tabbedPaneError.removeAll();
        if (modelYaml.getStrategy().getError() == null) {
            return;
        }
        for (Method methodError : modelYaml.getStrategy().getError().getMethod()) {
            JPanel panelError = new JPanel(new BorderLayout());
            Method[] refMethodError = new Method[]{methodError};
            JTextPaneLexer textPaneError = new JTextPaneLexer(refMethodError[0]::setQuery, refMethodError[0]::getQuery);
            SqlEngine.resetLexer(textPaneError);
            textPaneError.switchSetterToVendor();
            textPaneError.setText(methodError.getQuery().trim());
            textPaneError.setBorder(borderRight);
            panelError.add((Component)new LightScrollPane(1, 0, 1, 0, textPaneError), "Center");
            JPanel panelLimit = new JPanel();
            panelLimit.setLayout(new BoxLayout(panelLimit, 2));
            panelLimit.add(new JLabel(" Overflow limit: "));
            panelLimit.add(new JTextField(Integer.toString(methodError.getCapacity())));
            panelError.add((Component)panelLimit, "South");
            tabbedPaneError.addTab(methodError.getName(), panelError);
            tabbedPaneError.setTitleAt(tabbedPaneError.getTabCount() - 1, String.format("<html><div style=\"text-align:left;width:100px;\">%s</div></html>", methodError.getName()));
            textPanesError.add(textPaneError);
        }
    }

    @Override
    public void clean() {
        SqlEngine.getTextPanes().forEach(UiUtil::stopDocumentColorer);
    }

    private static void resetLexer(final JTextPaneLexer textPane) {
        UiUtil.stopDocumentColorer(textPane);
        HighlightedDocument document = new HighlightedDocument(HighlightedDocument.SQL_STYLE);
        document.setHighlightStyle(HighlightedDocument.SQL_STYLE);
        textPane.setStyledDocument(document);
        document.addDocumentListener(new DocumentListenerEditing(){

            @Override
            public void process() {
                textPane.setAttribute();
            }
        });
    }

    private static List<JTextPaneLexer> getTextPanes() {
        return Stream.concat(textPanesError.stream(), Stream.of(TextareaWithColor.values()).map(TextareaWithColor::getText)).collect(Collectors.toList());
    }

    static enum TextareaWithColor {
        DATABASE_DEFAULT(new JTextPaneLexer(v -> modelYaml.getResource().getSchema().setDatabase((String)v), () -> modelYaml.getResource().getSchema().getDatabase())),
        TABLE_DEFAULT(new JTextPaneLexer(v -> modelYaml.getResource().getSchema().setTable((String)v), () -> modelYaml.getResource().getSchema().getTable())),
        COLUMN_DEFAULT(new JTextPaneLexer(v -> modelYaml.getResource().getSchema().setColumn((String)v), () -> modelYaml.getResource().getSchema().getColumn())),
        QUERY_DEFAULT(new JTextPaneLexer(v -> modelYaml.getResource().getSchema().getRow().setQuery((String)v), () -> modelYaml.getResource().getSchema().getRow().getQuery())),
        FIELD_DEFAULT(new JTextPaneLexer(v -> modelYaml.getResource().getSchema().getRow().getFields().setField((String)v), () -> modelYaml.getResource().getSchema().getRow().getFields().getField())),
        CONCAT_DEFAULT(new JTextPaneLexer(v -> modelYaml.getResource().getSchema().getRow().getFields().setConcat((String)v), () -> modelYaml.getResource().getSchema().getRow().getFields().getConcat())),
        DATABASE_ZIP(new JTextPaneLexer(v -> modelYaml.getResource().getZip().setDatabase((String)v), () -> modelYaml.getResource().getZip().getDatabase())),
        TABLE_ZIP(new JTextPaneLexer(v -> modelYaml.getResource().getZip().setTable((String)v), () -> modelYaml.getResource().getZip().getTable())),
        COLUMN_ZIP(new JTextPaneLexer(v -> modelYaml.getResource().getZip().setColumn((String)v), () -> modelYaml.getResource().getZip().getColumn())),
        QUERY_ZIP(new JTextPaneLexer(v -> modelYaml.getResource().getZip().getRow().setQuery((String)v), () -> modelYaml.getResource().getZip().getRow().getQuery())),
        FIELD_ZIP(new JTextPaneLexer(v -> modelYaml.getResource().getZip().getRow().getFields().setField((String)v), () -> modelYaml.getResource().getZip().getRow().getFields().getField())),
        CONCAT_ZIP(new JTextPaneLexer(v -> modelYaml.getResource().getZip().getRow().getFields().setConcat((String)v), () -> modelYaml.getResource().getZip().getRow().getFields().getConcat())),
        DATABASE_DIOS(new JTextPaneLexer(v -> modelYaml.getResource().getDios().setDatabase((String)v), () -> modelYaml.getResource().getDios().getDatabase())),
        TABLE_DIOS(new JTextPaneLexer(v -> modelYaml.getResource().getDios().setTable((String)v), () -> modelYaml.getResource().getDios().getTable())),
        COLUMN_DIOS(new JTextPaneLexer(v -> modelYaml.getResource().getDios().setColumn((String)v), () -> modelYaml.getResource().getDios().getColumn())),
        QUERY_DIOS(new JTextPaneLexer(v -> modelYaml.getResource().getDios().getRow().setQuery((String)v), () -> modelYaml.getResource().getDios().getRow().getQuery())),
        FIELD_DIOS(new JTextPaneLexer(v -> modelYaml.getResource().getDios().getRow().getFields().setField((String)v), () -> modelYaml.getResource().getDios().getRow().getFields().getField())),
        CONCAT_DIOS(new JTextPaneLexer(v -> modelYaml.getResource().getDios().getRow().getFields().setConcat((String)v), () -> modelYaml.getResource().getDios().getRow().getFields().getConcat())),
        INFO(new JTextPaneLexer(v -> modelYaml.getResource().setInfo((String)v), () -> modelYaml.getResource().getInfo())),
        TRUTHY(new JTextPaneLexer(v -> modelYaml.getStrategy().getBoolean().getTest().setTruthy((String)v), () -> modelYaml.getStrategy().getBoolean().getTest().getTruthyAsString())),
        FALSY(new JTextPaneLexer(v -> modelYaml.getStrategy().getBoolean().getTest().setFalsy((String)v), () -> modelYaml.getStrategy().getBoolean().getTest().getFalsyAsString())),
        SLIDING_WINDOW(new JTextPaneLexer(v -> modelYaml.getStrategy().getConfiguration().setSlidingWindow((String)v), () -> modelYaml.getStrategy().getConfiguration().getSlidingWindow())),
        LIMIT(new JTextPaneLexer(v -> modelYaml.getStrategy().getConfiguration().setLimit((String)v), () -> modelYaml.getStrategy().getConfiguration().getLimit())),
        FAILSAFE(new JTextPaneLexer(v -> modelYaml.getStrategy().getConfiguration().setFailsafe((String)v), () -> modelYaml.getStrategy().getConfiguration().getFailsafe())),
        CALIBRATOR(new JTextPaneLexer(v -> modelYaml.getStrategy().getConfiguration().setCalibrator((String)v), () -> modelYaml.getStrategy().getConfiguration().getCalibrator())),
        ENDING_COMMENT(new JTextPaneLexer(v -> modelYaml.getStrategy().getConfiguration().setEndingComment((String)v), () -> modelYaml.getStrategy().getConfiguration().getEndingComment())),
        LIMIT_BOUNDARY(new JTextPaneLexer(v -> modelYaml.getStrategy().getConfiguration().setLimitBoundary((String)v), () -> modelYaml.getStrategy().getConfiguration().getLimitBoundary())),
        ORDER_BY_ERROR_MESSAGE(new JTextPaneLexer(v -> modelYaml.getStrategy().getConfiguration().getFingerprint().setOrderByErrorMessage((String)v), () -> modelYaml.getStrategy().getConfiguration().getFingerprint().getOrderByErrorMessage())),
        INCORRECT_STRING_ERROR_MESSAGE(new JTextPaneLexer(v -> modelYaml.getStrategy().getConfiguration().getFingerprint().setErrorMessageAsString((String)v), () -> modelYaml.getStrategy().getConfiguration().getFingerprint().getErrorMessageAsString())),
        INDICES(new JTextPaneLexer(v -> modelYaml.getStrategy().getNormal().setIndices((String)v), () -> modelYaml.getStrategy().getNormal().getIndices())),
        CAPACITY(new JTextPaneLexer(v -> modelYaml.getStrategy().getNormal().setCapacity((String)v), () -> modelYaml.getStrategy().getNormal().getCapacity())),
        ORDER_BY(new JTextPaneLexer(v -> modelYaml.getStrategy().getNormal().setOrderBy((String)v), () -> modelYaml.getStrategy().getNormal().getOrderBy())),
        MODE_AND(new JTextPaneLexer(v -> modelYaml.getStrategy().getBoolean().setModeAnd((String)v), () -> modelYaml.getStrategy().getBoolean().getModeAnd())),
        MODE_OR(new JTextPaneLexer(v -> modelYaml.getStrategy().getBoolean().setModeOr((String)v), () -> modelYaml.getStrategy().getBoolean().getModeOr())),
        BLIND(new JTextPaneLexer(v -> modelYaml.getStrategy().getBoolean().setBlind((String)v), () -> modelYaml.getStrategy().getBoolean().getBlind())),
        TIME(new JTextPaneLexer(v -> modelYaml.getStrategy().getBoolean().setTime((String)v), () -> modelYaml.getStrategy().getBoolean().getTime())),
        BIT_TEST(new JTextPaneLexer(v -> modelYaml.getStrategy().getBoolean().getTest().setBit((String)v), () -> modelYaml.getStrategy().getBoolean().getTest().getBit())),
        LENGTH_TEST(new JTextPaneLexer(v -> modelYaml.getStrategy().getBoolean().getTest().setLength((String)v), () -> modelYaml.getStrategy().getBoolean().getTest().getLength()));

        JTextPaneLexer text;

        public JTextPaneLexer getText() {
            return this.text;
        }

        private TextareaWithColor(JTextPaneLexer text) {
            this.text = text;
        }
    }
}

