/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.shell;

import com.jsql.util.LogLevel;
import com.jsql.view.swing.shell.BlockCaret;
import com.jsql.view.swing.shell.EmptyFocus;
import com.jsql.view.swing.shell.KeyAdapterTerminal;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractShell
extends JTextPane {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private boolean[] isEdited = new boolean[]{false};
    private String host;
    protected String[] loginPassword = null;
    private UUID uuidShell;
    private String urlShell;
    private transient StyledDocument styledDocument = this.getStyledDocument();
    private transient Style style = this.addStyle("Necrophagist's next album is 2014.", null);
    private String prompt = "";
    private String labelShell;

    protected AbstractShell(UUID uuidShell, String urlShell, String labelShell) throws MalformedURLException {
        this.uuidShell = uuidShell;
        this.urlShell = urlShell;
        this.labelShell = labelShell;
        URL url = new URL(urlShell);
        this.host = url.getHost();
        this.setFont(new Font("Ubuntu Mono", 0, ((Font)UIManager.get("TextPane.font")).getSize()));
        this.setCaret(new BlockCaret());
        this.setBackground(Color.BLACK);
        this.setForeground(Color.LIGHT_GRAY);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        this.displayPrompt(true);
        this.setCursor(null);
        this.setTransferHandler(null);
        this.setHighlighter(null);
        this.addMouseListener(new EmptyFocus(this));
        this.addKeyListener(new KeyAdapterTerminal(this));
    }

    public abstract void action(String var1, UUID var2, String var3, String ... var4);

    public void reset() {
        this.isEdited[0] = false;
        this.setEditable(true);
        this.displayPrompt(false);
        this.setCaretPosition(this.getDocument().getLength());
        this.setCursor(null);
    }

    public void append(String string) {
        try {
            Document doc = this.getDocument();
            doc.insertString(doc.getLength(), string, null);
        }
        catch (BadLocationException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    public void displayPrompt(boolean isAddingPrompt) {
        StyleConstants.setUnderline(this.style, true);
        this.appendPrompt("jsql", Color.LIGHT_GRAY, isAddingPrompt);
        StyleConstants.setUnderline(this.style, false);
        this.appendPrompt(" " + this.labelShell, Color.LIGHT_GRAY, isAddingPrompt);
        this.appendPrompt("[", new Color(50, 191, 50), isAddingPrompt);
        this.appendPrompt(this.host, new Color(191, 191, 25), isAddingPrompt);
        this.appendPrompt("]", new Color(50, 191, 50), isAddingPrompt);
        this.appendPrompt(" >", new Color(191, 100, 100), isAddingPrompt);
        this.appendPrompt(" ", Color.LIGHT_GRAY, isAddingPrompt);
    }

    private void appendPrompt(String string, Color color, boolean isAddingPrompt) {
        try {
            StyleConstants.setForeground(this.style, color);
            this.styledDocument.insertString(this.styledDocument.getLength(), string, this.style);
            if (isAddingPrompt) {
                this.prompt = this.prompt + string;
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getUI().getPreferredSize((JComponent)this).width <= this.getParent().getSize().width;
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
    }

    public int getLineOfOffset(int offset) throws BadLocationException {
        String errorMsg = "Can't translate offset to line";
        Document doc = this.getDocument();
        if (offset < 0) {
            throw new BadLocationException(errorMsg, -1);
        }
        if (offset > doc.getLength()) {
            throw new BadLocationException(errorMsg, doc.getLength() + 1);
        }
        Element map = doc.getDefaultRootElement();
        return map.getElementIndex(offset);
    }

    public int getLineStartOffset(int line) throws BadLocationException {
        Element map = this.getDocument().getDefaultRootElement();
        if (line < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (line >= map.getElementCount()) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element lineElem = map.getElement(line);
        return lineElem.getStartOffset();
    }

    public boolean[] getIsEdited() {
        return this.isEdited;
    }

    public UUID getUuidShell() {
        return this.uuidShell;
    }

    public String getUrlShell() {
        return this.urlShell;
    }

    public String getPrompt() {
        return this.prompt;
    }
}

