/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.shadow;

import com.jsql.util.LogLevel;
import com.jsql.view.swing.shadow.ShadowPopupBorder;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ShadowPopup
extends Popup {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final int MAX_CACHE_SIZE = 5;
    private static List<ShadowPopup> cache;
    private static final Border SHADOW_BORDER;
    private static final int SHADOW_SIZE = 5;
    private boolean canSnapshot = true;
    private Component owner;
    private Component contents;
    private int x;
    private int y;
    private Popup popup;
    private Border oldBorder;
    private boolean oldOpaque;
    private Container heavyWeightContainer;
    private static final Point POINT;
    private static final Rectangle RECT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Popup getInstance(Component owner, Component contents, int x, int y, Popup delegate) {
        Class<ShadowPopup> clazz = ShadowPopup.class;
        synchronized (ShadowPopup.class) {
            if (cache == null) {
                cache = new ArrayList<ShadowPopup>(5);
            }
            ShadowPopup result = !cache.isEmpty() ? cache.remove(0) : new ShadowPopup();
            // ** MonitorExit[var6_5] (shouldn't be in output)
            result.reset(owner, contents, x, y, delegate);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recycle(ShadowPopup popup) {
        Class<ShadowPopup> clazz = ShadowPopup.class;
        synchronized (ShadowPopup.class) {
            if (cache.size() < 5) {
                cache.add(popup);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean canSnapshot() {
        return this.canSnapshot;
    }

    @Override
    public void hide() {
        if (this.contents == null) {
            return;
        }
        JComponent parent = (JComponent)this.contents.getParent();
        this.popup.hide();
        if (parent != null && parent.getBorder() == SHADOW_BORDER) {
            parent.setBorder(this.oldBorder);
            parent.setOpaque(this.oldOpaque);
            this.oldBorder = null;
            if (this.heavyWeightContainer != null) {
                parent.putClientProperty("jgoodies.hShadowBg", null);
                parent.putClientProperty("jgoodies.vShadowBg", null);
                this.heavyWeightContainer = null;
            }
        }
        this.owner = null;
        this.contents = null;
        this.popup = null;
        ShadowPopup.recycle(this);
    }

    @Override
    public void show() {
        if (this.heavyWeightContainer != null) {
            this.snapshot();
        }
        this.popup.show();
    }

    private void reset(Component owner, Component contents, int x, int y, Popup popup) {
        this.owner = owner;
        this.contents = contents;
        this.popup = popup;
        this.x = x;
        this.y = y;
        Dimension contentsPrefSize = new Dimension();
        try {
            contentsPrefSize = contents.getPreferredSize();
        }
        catch (NullPointerException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
        if (contentsPrefSize.width <= 0 || contentsPrefSize.height <= 0) {
            return;
        }
        for (Container p = contents.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof JWindow) && !(p instanceof Panel)) continue;
            p.setBackground(contents.getBackground());
            this.heavyWeightContainer = p;
            break;
        }
        JComponent parent = (JComponent)contents.getParent();
        this.oldOpaque = parent.isOpaque();
        this.oldBorder = parent.getBorder();
        parent.setOpaque(false);
        parent.setBorder(SHADOW_BORDER);
        if (this.heavyWeightContainer != null) {
            this.heavyWeightContainer.setSize(this.heavyWeightContainer.getPreferredSize());
        } else {
            parent.setSize(parent.getPreferredSize());
        }
    }

    private void snapshot() {
        try {
            Dimension size = this.heavyWeightContainer.getPreferredSize();
            int width = size.width;
            int height = size.height;
            if (width <= 0 || height <= 5) {
                return;
            }
            Robot robot = new Robot();
            RECT.setBounds(this.x, this.y + height - 5, width, 5);
            BufferedImage hShadowBg = robot.createScreenCapture(RECT);
            RECT.setBounds(this.x + width - 5, this.y, 5, height - 5);
            BufferedImage vShadowBg = robot.createScreenCapture(RECT);
            JComponent parent = (JComponent)this.contents.getParent();
            parent.putClientProperty("jgoodies.hShadowBg", hShadowBg);
            parent.putClientProperty("jgoodies.vShadowBg", vShadowBg);
            Container layeredPane = this.getLayeredPane();
            if (layeredPane == null) {
                return;
            }
            int layeredPaneWidth = layeredPane.getWidth();
            int layeredPaneHeight = layeredPane.getHeight();
            ShadowPopup.POINT.x = this.x;
            ShadowPopup.POINT.y = this.y;
            SwingUtilities.convertPointFromScreen(POINT, layeredPane);
            this.paintHorizontalSnapshot(width, height, hShadowBg, layeredPane, layeredPaneWidth, layeredPaneHeight);
            this.paintVerticalSnapshot(width, height, vShadowBg, layeredPane, layeredPaneWidth, layeredPaneHeight);
        }
        catch (AWTException | IllegalArgumentException | SecurityException e) {
            this.canSnapshot = false;
            LOGGER.log(LogLevel.IGNORE, e);
        }
    }

    private void paintVerticalSnapshot(int width, int height, BufferedImage vShadowBg, Container layeredPane, int layeredPaneWidth, int layeredPaneHeight) {
        ShadowPopup.RECT.x = ShadowPopup.POINT.x + width - 5;
        ShadowPopup.RECT.y = ShadowPopup.POINT.y;
        ShadowPopup.RECT.width = 5;
        ShadowPopup.RECT.height = height - 5;
        this.extracted(vShadowBg, layeredPane, layeredPaneWidth, layeredPaneHeight);
    }

    private void paintHorizontalSnapshot(int width, int height, BufferedImage hShadowBg, Container layeredPane, int layeredPaneWidth, int layeredPaneHeight) {
        ShadowPopup.RECT.x = ShadowPopup.POINT.x;
        ShadowPopup.RECT.y = ShadowPopup.POINT.y + height - 5;
        ShadowPopup.RECT.width = width;
        ShadowPopup.RECT.height = 5;
        this.extracted(hShadowBg, layeredPane, layeredPaneWidth, layeredPaneHeight);
    }

    private void extracted(BufferedImage shadowBg, Container layeredPane, int layeredPaneWidth, int layeredPaneHeight) {
        if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > layeredPaneWidth) {
            ShadowPopup.RECT.width = layeredPaneWidth - ShadowPopup.RECT.x;
        }
        if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > layeredPaneHeight) {
            ShadowPopup.RECT.height = layeredPaneHeight - ShadowPopup.RECT.y;
        }
        if (!RECT.isEmpty()) {
            Graphics2D g = shadowBg.createGraphics();
            ((Graphics)g).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
            g.setClip(RECT);
            if (layeredPane instanceof JComponent) {
                JComponent c = (JComponent)layeredPane;
                boolean doubleBuffered = c.isDoubleBuffered();
                c.setDoubleBuffered(false);
                ShadowPopup.paintAll(c, g);
                c.setDoubleBuffered(doubleBuffered);
            } else {
                layeredPane.paintAll(g);
            }
            g.dispose();
        }
    }

    private static void paintAll(JComponent c, Graphics g) {
        try {
            c.paintAll(g);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e.getMessage(), (Throwable)e);
        }
    }

    private Container getLayeredPane() {
        Container parent = null;
        if (this.owner != null) {
            parent = this.owner instanceof Container ? (Container)this.owner : this.owner.getParent();
        }
        for (Container p = parent; p != null; p = p.getParent()) {
            if (p instanceof JRootPane) {
                if (p.getParent() instanceof JInternalFrame) continue;
                parent = ((JRootPane)p).getLayeredPane();
                continue;
            }
            if (!(p instanceof Window)) continue;
            if (parent != null) break;
            parent = p;
            break;
        }
        return parent;
    }

    static {
        SHADOW_BORDER = ShadowPopupBorder.getInstance();
        POINT = new Point();
        RECT = new Rectangle();
    }
}

