/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager;

import com.jsql.model.exception.JSqlException;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevel;
import com.jsql.view.swing.list.DnDList;
import com.jsql.view.swing.list.ItemList;
import com.jsql.view.swing.manager.AbstractManagerList;
import com.jsql.view.swing.manager.util.JButtonStateful;
import com.jsql.view.swing.scrollpane.LightScrollPane;
import com.jsql.view.swing.text.JPopupTextField;
import com.jsql.view.swing.ui.FlatButtonMouseAdapter;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManagerUpload
extends AbstractManagerList {
    private static final Logger LOGGER = LogManager.getRootLogger();

    public ManagerUpload() {
        this.setLayout(new BorderLayout());
        this.defaultText = "UPLOAD_RUN_BUTTON_LABEL";
        ArrayList<ItemList> pathsList = new ArrayList<ItemList>();
        try (InputStream inputStream = UiUtil.class.getClassLoader().getResourceAsStream("swing/list/payload.txt");
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                pathsList.add(new ItemList(line));
            }
        }
        catch (IOException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
        this.listPaths = new DnDList(pathsList);
        this.getListPaths().setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        this.add((Component)new LightScrollPane(0, 0, 0, 0, this.getListPaths()), "Center");
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 1));
        JTextField shellURL = (JTextField)new JPopupTextField(I18nUtil.valueByKey("UPLOAD_URL_LABEL")).getProxy();
        String urlTooltip = I18nUtil.valueByKey("UPLOAD_URL_TOOLTIP");
        shellURL.setToolTipText(urlTooltip);
        shellURL.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, UiUtil.COLOR_COMPONENT_BORDER), BorderFactory.createMatteBorder(1, 1, 0, 1, UiUtil.COLOR_DEFAULT_BACKGROUND)), UiUtil.BORDER_BLU));
        JPanel lastLine = new JPanel();
        lastLine.setLayout(new BoxLayout(lastLine, 0));
        lastLine.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, UiUtil.COLOR_COMPONENT_BORDER), BorderFactory.createEmptyBorder(1, 0, 1, 1)));
        this.initializeRunButton(shellURL);
        this.privilege = new JLabel(I18nUtil.valueByKey("PRIVILEGE_LABEL"), UiUtil.ICON_SQUARE_GREY, 2);
        I18nViewUtil.addComponentForKey("PRIVILEGE_LABEL", this.privilege);
        this.privilege.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, UiUtil.COLOR_DEFAULT_BACKGROUND));
        this.privilege.setToolTipText(I18nUtil.valueByKey("PRIVILEGE_TOOLTIP"));
        this.loader.setVisible(false);
        lastLine.add(this.privilege);
        lastLine.add(Box.createHorizontalGlue());
        lastLine.add(this.run);
        southPanel.add(shellURL);
        southPanel.add(lastLine);
        this.add((Component)southPanel, "South");
    }

    private void initializeRunButton(JTextField shellURL) {
        this.run = new JButtonStateful(this.defaultText);
        I18nViewUtil.addComponentForKey(this.defaultText, this.run);
        this.run.setToolTipText(I18nUtil.valueByKey("UPLOAD_RUN_BUTTON_TOOLTIP"));
        this.run.setEnabled(false);
        this.run.setContentAreaFilled(false);
        this.run.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.run.setBackground(new Color(200, 221, 242));
        this.run.addMouseListener(new FlatButtonMouseAdapter(this.run));
        this.run.addActionListener(actionEvent -> this.initializeRunAction(shellURL));
    }

    private void initializeRunAction(JTextField shellURL) {
        if (this.getListPaths().getSelectedValuesList().isEmpty()) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, "Select directory(ies) to upload a file into");
            return;
        }
        JFileChooser filechooser = new JFileChooser(MediatorHelper.model().getMediatorUtils().getPreferencesUtil().getPathFile());
        filechooser.setDialogTitle(I18nUtil.valueByKey("UPLOAD_DIALOG_TEXT"));
        try {
            int returnVal = filechooser.showOpenDialog(MediatorHelper.frame());
            if (returnVal != 0) {
                return;
            }
            this.uploadFiles(shellURL, filechooser);
        }
        catch (ClassCastException | NullPointerException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    private void uploadFiles(JTextField shellURL, JFileChooser filechooser) {
        for (Object path : this.getListPaths().getSelectedValuesList()) {
            new Thread(() -> {
                File file = filechooser.getSelectedFile();
                try {
                    this.loader.setVisible(true);
                    MediatorHelper.model().getResourceAccess().uploadFile(path.toString(), shellURL.getText(), file);
                }
                catch (JSqlException e) {
                    LOGGER.log(LogLevel.CONSOLE_ERROR, String.format("Payload creation error: %s", e.getMessage()));
                }
                catch (IOException e) {
                    LOGGER.log(LogLevel.CONSOLE_ERROR, String.format("Posting file failed: %s", e.getMessage()), (Throwable)e);
                }
                catch (InterruptedException e) {
                    LOGGER.log(LogLevel.CONSOLE_ERROR, String.format("Posting file failed: %s", e.getMessage()), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }, "ThreadUpload").start();
        }
    }
}

