/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager;

import com.jsql.model.accessible.CallableFile;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.suspendable.callable.ThreadFactoryCallable;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevel;
import com.jsql.view.swing.list.ItemList;
import com.jsql.view.swing.manager.AbstractManagerList;
import com.jsql.view.swing.manager.util.JButtonStateful;
import com.jsql.view.swing.manager.util.StateButton;
import com.jsql.view.swing.ui.FlatButtonMouseAdapter;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManagerFile
extends AbstractManagerList {
    private static final Logger LOGGER = LogManager.getRootLogger();

    public ManagerFile() {
        super("swing/list/file.txt");
        this.initializeRunButton();
        this.privilege = new JLabel(I18nUtil.valueByKey("PRIVILEGE_LABEL"), UiUtil.ICON_SQUARE_GREY, 2);
        I18nViewUtil.addComponentForKey("PRIVILEGE_LABEL", this.privilege);
        this.privilege.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, UiUtil.COLOR_DEFAULT_BACKGROUND));
        this.privilege.setToolTipText(I18nUtil.valueByKey("PRIVILEGE_TOOLTIP"));
        this.loader.setVisible(false);
        this.lastLine.add(this.privilege);
        this.lastLine.add(Box.createHorizontalGlue());
        this.lastLine.add(this.loader);
        this.lastLine.add(Box.createRigidArea(new Dimension(5, 0)));
        this.lastLine.add(this.run);
        this.add((Component)this.lastLine, "South");
    }

    private void initializeRunButton() {
        this.defaultText = "FILE_RUN_BUTTON_LABEL";
        this.run = new JButtonStateful(this.defaultText);
        I18nViewUtil.addComponentForKey("FILE_RUN_BUTTON_LABEL", this.run);
        this.run.setToolTipText(I18nUtil.valueByKey("FILE_RUN_BUTTON_TOOLTIP"));
        this.run.setEnabled(false);
        this.run.setContentAreaFilled(false);
        this.run.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.run.setBackground(new Color(200, 221, 242));
        this.run.addMouseListener(new FlatButtonMouseAdapter(this.run));
        this.run.addActionListener(actionEvent -> {
            if (this.listFile.getSelectedValuesList().isEmpty()) {
                LOGGER.log(LogLevel.CONSOLE_ERROR, "Select at least one file to read in the list");
                return;
            }
            new Thread(() -> {
                if (this.run.getState() == StateButton.STARTABLE) {
                    this.run.setText(I18nViewUtil.valueByKey("FILE_RUN_BUTTON_STOP"));
                    this.run.setState(StateButton.STOPPABLE);
                    this.loader.setVisible(true);
                    MediatorHelper.managerWebshell().clearSelection();
                    MediatorHelper.managerSqlshell().clearSelection();
                    try {
                        this.readFile(this.listFile.getSelectedValuesList());
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        LOGGER.log(LogLevel.CONSOLE_ERROR, e, (Throwable)e);
                    }
                } else {
                    MediatorHelper.model().getResourceAccess().stopSearchingFile();
                    this.run.setEnabled(false);
                    this.run.setState(StateButton.STOPPING);
                }
            }, "ThreadReadFile").start();
        });
    }

    public void readFile(List<ItemList> pathsFiles) throws JSqlException, InterruptedException, ExecutionException {
        int tasksHandled;
        if (!MediatorHelper.model().getResourceAccess().isReadingAllowed()) {
            return;
        }
        int countFileFound = 0;
        ExecutorService taskExecutor = Executors.newFixedThreadPool(10, new ThreadFactoryCallable("CallableReadFile"));
        ExecutorCompletionService<CallableFile> taskCompletionService = new ExecutorCompletionService<CallableFile>(taskExecutor);
        for (ItemList pathFile : pathsFiles) {
            CallableFile callableFile = new CallableFile(pathFile.toString(), MediatorHelper.model());
            taskCompletionService.submit(callableFile);
            MediatorHelper.model().getResourceAccess().getCallablesReadFile().add(callableFile);
        }
        ArrayList<String> duplicate = new ArrayList<String>();
        int submittedTasks = pathsFiles.size();
        for (tasksHandled = 0; tasksHandled < submittedTasks && !MediatorHelper.model().getResourceAccess().isSearchFileStopped(); ++tasksHandled) {
            CallableFile currentCallable = (CallableFile)taskCompletionService.take().get();
            if (!StringUtils.isNotEmpty(currentCallable.getSourceFile())) continue;
            String name = currentCallable.getPathFile().substring(currentCallable.getPathFile().lastIndexOf(47) + 1, currentCallable.getPathFile().length());
            String content = currentCallable.getSourceFile();
            String path = currentCallable.getPathFile();
            Request request = new Request();
            request.setMessage(Interaction.CREATE_FILE_TAB);
            request.setParameters(name, content, path);
            MediatorHelper.model().sendToViews(request);
            if (!duplicate.contains(path.replace(name, ""))) {
                LOGGER.log(LogLevel.CONSOLE_INFORM, "Shell might be possible in folder {}", () -> path.replace(name, ""));
            }
            duplicate.add(path.replace(name, ""));
            ++countFileFound;
        }
        for (CallableFile callableReadFile : MediatorHelper.model().getResourceAccess().getCallablesReadFile()) {
            callableReadFile.getSuspendableReadFile().stop();
        }
        MediatorHelper.model().getResourceAccess().getCallablesReadFile().clear();
        taskExecutor.shutdown();
        taskExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        MediatorHelper.model().getResourceAccess().setSearchFileStopped(false);
        String result = String.format("Found %s file%s%s on %s files checked", countFileFound, countFileFound > 1 ? Character.valueOf('s') : "", tasksHandled != submittedTasks ? " of " + tasksHandled + " processed " : "", submittedTasks);
        if (countFileFound > 0) {
            LOGGER.log(LogLevel.CONSOLE_SUCCESS, result);
        } else {
            LOGGER.log(LogLevel.CONSOLE_ERROR, result);
        }
        Request request = new Request();
        request.setMessage(Interaction.END_FILE_SEARCH);
        MediatorHelper.model().sendToViews(request);
    }
}

