/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager;

import com.jsql.util.LogLevel;
import com.jsql.view.swing.list.DnDList;
import com.jsql.view.swing.list.ItemList;
import com.jsql.view.swing.manager.Manager;
import com.jsql.view.swing.manager.util.JButtonStateful;
import com.jsql.view.swing.manager.util.StateButton;
import com.jsql.view.swing.scrollpane.LightScrollPane;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractManagerList
extends JPanel
implements Manager {
    private static final Logger LOGGER = LogManager.getRootLogger();
    protected transient List<ItemList> itemsList = new ArrayList<ItemList>();
    protected DnDList listFile;
    protected JPanel lastLine = new JPanel();
    protected DnDList listPaths;
    protected JButtonStateful run;
    protected JLabel privilege;
    protected String defaultText;
    protected JLabel loader = new JLabel(UiUtil.ICON_LOADER_GIF);

    protected AbstractManagerList() {
    }

    protected AbstractManagerList(String nameFile) {
        this.setLayout(new BorderLayout());
        try (InputStream inputStream = UiUtil.class.getClassLoader().getResourceAsStream(nameFile);
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                this.itemsList.add(new ItemList(line));
            }
        }
        catch (IOException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
        this.listFile = new DnDList(this.itemsList);
        this.listFile.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        this.add((Component)new LightScrollPane(0, 0, 0, 0, this.listFile), "Center");
        this.lastLine.setOpaque(false);
        this.lastLine.setLayout(new BoxLayout(this.lastLine, 0));
        this.lastLine.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, UiUtil.COLOR_COMPONENT_BORDER), BorderFactory.createEmptyBorder(1, 0, 1, 1)));
    }

    public void addToList(String element) {
        boolean isFound = false;
        DefaultListModel listModel = (DefaultListModel)this.listPaths.getModel();
        for (int i = 0; i < listModel.size(); ++i) {
            if (!((ItemList)listModel.get(i)).toString().equals(element)) continue;
            isFound = true;
        }
        if (!isFound) {
            ItemList itemList = new ItemList(element);
            listModel.addElement(itemList);
        }
    }

    public void addTag(String url, String tag) {
        ListModel listModel = this.listPaths.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            if (!url.contains(((ItemList)listModel.getElementAt(i)).getOriginalString())) continue;
            ((ItemList)listModel.getElementAt(i)).setIsDatabaseConfirmed(true);
            ((ItemList)listModel.getElementAt(i)).setInternalString(((ItemList)listModel.getElementAt(i)).getInternalString() + " [" + tag + "]");
            ((DefaultListModel)listModel).setElementAt((ItemList)listModel.getElementAt(i), i);
        }
    }

    public void highlight(String url, String strategy) {
        String itemLabel = String.format(" [%s]", strategy);
        ListModel listModel = this.listPaths.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            if (!url.contains(((ItemList)listModel.getElementAt(i)).getOriginalString())) continue;
            ((ItemList)listModel.getElementAt(i)).setIsVulnerable(true);
            ((ItemList)listModel.getElementAt(i)).setInternalString(((ItemList)listModel.getElementAt(i)).getInternalString().replace(itemLabel, "") + itemLabel);
            ((DefaultListModel)listModel).setElementAt((ItemList)listModel.getElementAt(i), i);
        }
    }

    public void endProcess() {
        this.run.setText(I18nViewUtil.valueByKey(this.defaultText));
        this.setButtonEnable(true);
        this.loader.setVisible(false);
        this.run.setState(StateButton.STARTABLE);
    }

    public void clearSelection() {
        this.listPaths.clearSelection();
    }

    public void setButtonEnable(boolean isEnable) {
        this.run.setEnabled(isEnable);
    }

    public void changePrivilegeIcon(Icon icon) {
        this.privilege.setIcon(icon);
    }

    public DnDList getListPaths() {
        return this.listPaths;
    }
}

