/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.list;

import com.jsql.util.LogLevel;
import com.jsql.view.swing.list.AbstractListTransfertHandler;
import com.jsql.view.swing.list.BeanInjection;
import com.jsql.view.swing.list.DnDList;
import com.jsql.view.swing.list.ItemList;
import com.jsql.view.swing.list.ItemListScan;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.TransferHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ListTransfertHandlerScan
extends AbstractListTransfertHandler {
    private static final Logger LOGGER = LogManager.getRootLogger();

    @Override
    protected List<Integer> initializeStringPaste(String clipboardText, int selectedIndexFrom, DefaultListModel<ItemList> listModel) {
        int selectedIndexTo = selectedIndexFrom;
        ArrayList<Integer> selectedIndexes = new ArrayList<Integer>();
        for (ItemListScan itemListScan : ListTransfertHandlerScan.parse(clipboardText)) {
            selectedIndexes.add(selectedIndexTo);
            listModel.add(selectedIndexTo++, itemListScan);
        }
        return selectedIndexes;
    }

    @Override
    protected String initializeTransferable() {
        ArrayList<JSONObject> jsons = new ArrayList<JSONObject>();
        StringBuilder stringTransferable = new StringBuilder();
        try {
            for (ItemList itemPath : this.dragPaths) {
                ItemListScan itemScanPath = (ItemListScan)itemPath;
                jsons.add(new JSONObject(itemScanPath.getBeanInjectionToJSON()));
            }
            stringTransferable.append(new JSONArray(jsons).toString(4));
        }
        catch (JSONException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e.getMessage(), (Throwable)e);
        }
        return stringTransferable.toString();
    }

    @Override
    protected void parseStringDrop(TransferHandler.TransferSupport support, DnDList list, DefaultListModel<ItemList> listModel) {
        JList.DropLocation dropLocation = (JList.DropLocation)support.getDropLocation();
        int indexDropLocation = dropLocation.getIndex();
        ArrayList<Integer> listSelectedIndices = new ArrayList<Integer>();
        if (this.dragPaths != null && !this.dragPaths.isEmpty()) {
            for (Object itemPath : this.dragPaths) {
                if (!StringUtils.isNotEmpty(((ItemList)itemPath).toString())) continue;
                ItemListScan itemDrag = (ItemListScan)itemPath;
                ItemListScan itemDrop = new ItemListScan(itemDrag.getBeanInjection());
                listSelectedIndices.add(indexDropLocation);
                listModel.add(indexDropLocation++, itemDrop);
            }
        } else {
            try {
                String importString = (String)support.getTransferable().getTransferData(DataFlavor.stringFlavor);
                for (ItemListScan itemListScan : ListTransfertHandlerScan.parse(importString)) {
                    listSelectedIndices.add(indexDropLocation);
                    listModel.add(indexDropLocation++, itemListScan);
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            }
        }
        int[] selectedIndices = new int[listSelectedIndices.size()];
        int i = 0;
        for (Integer integer : listSelectedIndices) {
            selectedIndices[i] = integer;
            ++i;
        }
        list.setSelectedIndices(selectedIndices);
    }

    public static List<ItemListScan> parse(String clipboardText) {
        ArrayList<ItemListScan> itemsParsed = new ArrayList<ItemListScan>();
        try {
            ListTransfertHandlerScan.parseJsonArray(clipboardText, itemsParsed);
        }
        catch (JSONException eJsonArray) {
            ListTransfertHandlerScan.parseJsonObject(clipboardText, itemsParsed);
        }
        return itemsParsed;
    }

    private static void parseJsonArray(String clipboardText, List<ItemListScan> itemsParsed) {
        JSONArray itemsJsonArray = new JSONArray(clipboardText);
        for (int i = 0; i < itemsJsonArray.length(); ++i) {
            JSONObject itemJsonObject = itemsJsonArray.getJSONObject(i);
            BeanInjection beanInjection = new BeanInjection(itemJsonObject.optString("url", ""), itemJsonObject.optString("request", ""), itemJsonObject.optString("header", ""), itemJsonObject.optString("method", ""), itemJsonObject.optString("vendor", ""), itemJsonObject.optString("requestType", ""));
            ItemListScan newItem = new ItemListScan(beanInjection);
            itemsParsed.add(newItem);
        }
    }

    private static void parseJsonObject(String clipboardText, List<ItemListScan> itemsParsed) {
        try {
            JSONObject itemsJsonObject = new JSONObject(clipboardText);
            BeanInjection beanInjection = new BeanInjection(itemsJsonObject.optString("url", ""), itemsJsonObject.optString("request", ""), itemsJsonObject.optString("header", ""), itemsJsonObject.optString("method", ""), itemsJsonObject.optString("vendor", ""), itemsJsonObject.optString("requestType", ""));
            ItemListScan newItem = new ItemListScan(beanInjection);
            itemsParsed.add(newItem);
        }
        catch (JSONException e) {
            for (String url : clipboardText.split("\\n")) {
                BeanInjection beanInjection = new BeanInjection(url);
                ItemListScan newItem = new ItemListScan(beanInjection);
                itemsParsed.add(newItem);
            }
        }
    }
}

