/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.list;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevel;
import com.jsql.view.swing.list.ItemList;
import com.jsql.view.swing.list.ListTransfertHandler;
import com.jsql.view.swing.list.MouseAdapterMenuAction;
import com.jsql.view.swing.list.RendererComplexCell;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DnDList
extends JList<ItemList> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    protected DefaultListModel<ItemList> listModel;
    private transient List<ItemList> defaultList;

    public DnDList(List<ItemList> newList) {
        this.defaultList = newList;
        this.listModel = new DefaultListModel();
        for (ItemList path : newList) {
            this.listModel.addElement(path);
        }
        this.setModel(this.listModel);
        RendererComplexCell renderer = new RendererComplexCell();
        this.setCellRenderer(renderer);
        this.initializeActionMap();
        this.initializeListener();
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT);
        this.setTransferHandler(new ListTransfertHandler());
    }

    private void initializeListener() {
        this.addMouseListener(new MouseAdapterMenuAction(this));
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                DnDList.this.repaint();
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                DnDList.this.repaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                if (arg0.getKeyCode() == 127) {
                    DnDList.this.removeSelectedItem();
                }
            }
        });
    }

    private void initializeActionMap() {
        ActionMap listActionMap = this.getActionMap();
        listActionMap.put(TransferHandler.getCutAction().getValue("Name"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DnDList.this.getSelectedValuesList().isEmpty()) {
                    return;
                }
                List selectedValues = DnDList.this.getSelectedValuesList();
                ArrayList<ItemList> siblings = new ArrayList<ItemList>();
                for (ItemList value : selectedValues) {
                    int valueIndex = DnDList.this.listModel.indexOf(value);
                    if (valueIndex < DnDList.this.listModel.size() - 1) {
                        siblings.add(DnDList.this.listModel.get(valueIndex + 1));
                        continue;
                    }
                    if (valueIndex <= 0) continue;
                    siblings.add(DnDList.this.listModel.get(valueIndex - 1));
                }
                TransferHandler.getCutAction().actionPerformed(e);
                for (ItemList sibling : siblings) {
                    DnDList.this.setSelectedValue(sibling, true);
                }
            }
        });
        listActionMap.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        listActionMap.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
    }

    public void removeSelectedItem() {
        if (this.getSelectedValuesList().isEmpty()) {
            return;
        }
        List selectedValues = this.getSelectedValuesList();
        for (ItemList itemSelected : selectedValues) {
            int indexOfItemSelected = this.listModel.indexOf(itemSelected);
            this.listModel.removeElement(itemSelected);
            if (indexOfItemSelected == this.listModel.getSize()) {
                this.setSelectedIndex(indexOfItemSelected - 1);
                continue;
            }
            this.setSelectedIndex(indexOfItemSelected);
        }
        try {
            Rectangle rectangle = this.getCellBounds(this.getMinSelectionIndex(), this.getMaxSelectionIndex());
            if (rectangle != null) {
                this.scrollRectToVisible(this.getCellBounds(this.getMinSelectionIndex(), this.getMaxSelectionIndex()));
            }
        }
        catch (NullPointerException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
    }

    public void dropPasteFile(List<File> filesToImport, int position) {
        if (filesToImport.isEmpty()) {
            return;
        }
        for (File fileToImport : filesToImport) {
            if (FilenameUtils.getExtension(fileToImport.getPath()).matches("txt|csv|ini")) continue;
            try {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), I18nUtil.valueByKey("LIST_IMPORT_ERROR_LABEL"), I18nUtil.valueByKey("LIST_IMPORT_ERROR_TITLE"), 0, UiUtil.ICON_ERROR);
            }
            catch (ClassCastException e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e.getMessage(), (Throwable)e);
            }
            return;
        }
        Object[] options = new String[]{I18nUtil.valueByKey("LIST_IMPORT_CONFIRM_REPLACE"), I18nUtil.valueByKey("LIST_IMPORT_CONFIRM_ADD"), I18nUtil.valueByKey("LIST_ADD_VALUE_CANCEL")};
        int answer = JOptionPane.showOptionDialog(this.getTopLevelAncestor(), I18nUtil.valueByKey("LIST_IMPORT_CONFIRM_LABEL"), I18nUtil.valueByKey("LIST_IMPORT_CONFIRM_TITLE"), 1, 3, null, options, options[2]);
        int startPosition = position;
        if (answer != 0 && answer != 1) {
            return;
        }
        if (answer == 0) {
            this.listModel.clear();
            startPosition = 0;
        }
        int startPositionFinal = startPosition;
        SwingUtilities.invokeLater(() -> this.addItems(filesToImport, startPositionFinal));
    }

    private void addItems(List<File> filesToImport, int startPosition) {
        int endPosition = startPosition;
        for (File file : filesToImport) {
            endPosition = this.initializeItems(endPosition, file);
        }
        if (!this.listModel.isEmpty()) {
            this.setSelectionInterval(startPosition, endPosition - 1);
        }
        try {
            this.scrollRectToVisible(this.getCellBounds(this.getMinSelectionIndex(), this.getMaxSelectionIndex()));
        }
        catch (NullPointerException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e.getMessage(), (Throwable)e);
        }
    }

    private int initializeItems(int startPosition, File file) {
        int endPosition = startPosition;
        try (FileReader fileReader = new FileReader(file);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (!StringUtils.isNotEmpty(line) || 0 > endPosition || endPosition > this.listModel.size()) continue;
                this.addItem(endPosition++, line);
            }
        }
        catch (IOException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e.getMessage(), (Throwable)e);
        }
        return endPosition;
    }

    public void restore() {
        this.listModel.clear();
        for (ItemList path : this.defaultList) {
            this.listModel.addElement(path);
        }
    }

    public void addItem(int endPosition, String line) {
        this.listModel.add(endPosition, new ItemList(line.replace("\\", "/")));
    }
}

