/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.interaction;

import com.jsql.model.bean.util.Header;
import com.jsql.model.bean.util.HttpHeader;
import com.jsql.util.LogLevel;
import com.jsql.view.interaction.InteractionCommand;
import com.jsql.view.swing.scrollpane.JScrollIndicator;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.DefaultTableModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageHeader
implements InteractionCommand {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String url;
    private String post;
    private Map<String, String> header;
    private Map<String, String> response;
    private String source;
    private String size;
    private String metadataProcess;
    private String metadataStrategy;

    public MessageHeader(Object[] interactionParams) {
        Map params = (Map)interactionParams[0];
        this.url = (String)params.get((Object)Header.URL);
        this.post = (String)params.get((Object)Header.POST);
        this.header = (Map)params.get((Object)Header.HEADER);
        this.response = (Map)params.get((Object)Header.RESPONSE);
        this.source = (String)params.get((Object)Header.SOURCE);
        this.size = (String)params.get((Object)Header.PAGE_SIZE);
        this.metadataProcess = (String)params.get((Object)Header.METADATA_PROCESS);
        this.metadataStrategy = (String)params.get((Object)Header.METADATA_STRATEGY);
    }

    @Override
    public void execute() {
        MediatorHelper.panelConsoles().getNetworkTable().addHeader(new HttpHeader(this.url, this.post, this.header, this.response, this.source));
        JViewport viewport = ((JScrollIndicator)MediatorHelper.panelConsoles().getNetworkSplitPane().getLeftComponent()).getScrollPane().getViewport();
        JTable table = (JTable)viewport.getView();
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        try {
            model.addRow(new Object[]{this.url, this.size, this.metadataStrategy, this.metadataProcess});
            Rectangle rect = table.getCellRect(table.getRowCount() - 1, 0, true);
            Point pt = viewport.getViewPosition();
            rect.translate(-pt.x, -pt.y);
            viewport.scrollRectToVisible(rect);
            MediatorHelper.tabConsoles().highlightTab("Network");
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
    }
}

