/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.dialog.translate;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public final class OrderedProperties {
    private Map<String, String> properties;
    private boolean suppressDate;

    public OrderedProperties() {
        this(new LinkedHashMap<String, String>(), false);
    }

    private OrderedProperties(Map<String, String> properties, boolean suppressDate) {
        this.properties = properties;
        this.suppressDate = suppressDate;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.properties.get(key);
        return value == null ? defaultValue : value;
    }

    public String setProperty(String key, String value) {
        return this.properties.put(key, value);
    }

    public String removeProperty(String key) {
        return this.properties.remove(key);
    }

    public boolean containsProperty(String key) {
        return this.properties.containsKey(key);
    }

    public int size() {
        return this.properties.size();
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Enumeration<String> propertyNames() {
        return new Vector<String>(this.properties.keySet()).elements();
    }

    public Set<String> stringPropertyNames() {
        return new LinkedHashSet<String>(this.properties.keySet());
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return new LinkedHashSet<Map.Entry<String, String>>(this.properties.entrySet());
    }

    public void load(InputStream stream) throws IOException {
        CustomProperties customProperties = new CustomProperties(this.properties);
        customProperties.load(stream);
    }

    public void load(Reader reader) throws IOException {
        CustomProperties customProperties = new CustomProperties(this.properties);
        customProperties.load(reader);
    }

    public void loadFromXML(InputStream stream) throws IOException {
        CustomProperties customProperties = new CustomProperties(this.properties);
        customProperties.loadFromXML(stream);
    }

    public void store(OutputStream stream, String comments) throws IOException {
        CustomProperties customProperties = new CustomProperties(this.properties);
        if (this.suppressDate) {
            customProperties.store(new DateSuppressingPropertiesBufferedWriter(new OutputStreamWriter(stream, StandardCharsets.ISO_8859_1)), comments);
        } else {
            customProperties.store(stream, comments);
        }
    }

    public void store(Writer writer, String comments) throws IOException {
        CustomProperties customProperties = new CustomProperties(this.properties);
        if (this.suppressDate) {
            customProperties.store(new DateSuppressingPropertiesBufferedWriter(writer), comments);
        } else {
            customProperties.store(writer, comments);
        }
    }

    public void storeToXML(OutputStream stream, String comment) throws IOException {
        CustomProperties customProperties = new CustomProperties(this.properties);
        customProperties.storeToXML(stream, comment);
    }

    public void storeToXML(OutputStream stream, String comment, String encoding) throws IOException {
        CustomProperties customProperties = new CustomProperties(this.properties);
        customProperties.storeToXML(stream, comment, encoding);
    }

    public void list(PrintStream stream) {
        CustomProperties customProperties = new CustomProperties(this.properties);
        customProperties.list(stream);
    }

    public void list(PrintWriter writer) {
        CustomProperties customProperties = new CustomProperties(this.properties);
        customProperties.list(writer);
    }

    public Properties toJdkProperties() {
        Properties jdkProperties = new Properties();
        for (Map.Entry<String, String> entry : this.entrySet()) {
            jdkProperties.put(entry.getKey(), entry.getValue());
        }
        return jdkProperties;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        OrderedProperties that = (OrderedProperties)other;
        return Arrays.equals(this.properties.entrySet().toArray(), that.properties.entrySet().toArray());
    }

    public int hashCode() {
        return Arrays.hashCode(this.properties.entrySet().toArray());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.properties = (Map)stream.readObject();
        this.suppressDate = stream.readBoolean();
    }

    public String toString() {
        return this.properties.toString();
    }

    public static OrderedProperties copyOf(OrderedProperties source) {
        OrderedPropertiesBuilder builder = new OrderedPropertiesBuilder();
        builder.withSuppressDateInComment(source.suppressDate);
        if (source.properties instanceof TreeMap) {
            builder.withOrdering(((TreeMap)source.properties).comparator());
        }
        OrderedProperties result = builder.build();
        for (Map.Entry<String, String> entry : source.entrySet()) {
            result.setProperty(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static final class DateSuppressingPropertiesBufferedWriter
    extends BufferedWriter {
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        private StringBuilder currentComment;
        private String previousComment;

        private DateSuppressingPropertiesBufferedWriter(Writer out) {
            super(out);
        }

        @Override
        public void write(String string) throws IOException {
            if (this.currentComment != null) {
                this.currentComment.append(string);
                if (string.endsWith(LINE_SEPARATOR)) {
                    if (this.previousComment != null) {
                        super.write(this.previousComment);
                    }
                    this.previousComment = this.currentComment.toString();
                    this.currentComment = null;
                }
            } else if (string.startsWith("#")) {
                this.currentComment = new StringBuilder(string);
            } else {
                super.write(string);
            }
        }
    }

    private static final class CustomProperties
    extends Properties {
        private final Map<String, String> targetProperties;

        private CustomProperties(Map<String, String> targetProperties) {
            this.targetProperties = targetProperties;
        }

        @Override
        public synchronized Object get(Object key) {
            return this.targetProperties.get(key);
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            return this.targetProperties.put((String)key, (String)value);
        }

        @Override
        public String getProperty(String key) {
            return this.targetProperties.get(key);
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return new Vector<String>(this.targetProperties.keySet()).elements();
        }

        @Override
        public Set<Object> keySet() {
            return new LinkedHashSet<Object>(this.targetProperties.keySet());
        }

        @Override
        public synchronized boolean equals(Object o) {
            return super.equals(o) && o instanceof OrderedProperties;
        }

        @Override
        public synchronized int hashCode() {
            return super.hashCode();
        }
    }

    public static final class OrderedPropertiesBuilder {
        private Comparator<? super String> comparator;
        private boolean suppressDate;

        public OrderedPropertiesBuilder withOrdering(Comparator<? super String> comparator) {
            this.comparator = comparator;
            return this;
        }

        public OrderedPropertiesBuilder withSuppressDateInComment(boolean suppressDate) {
            this.suppressDate = suppressDate;
            return this;
        }

        public OrderedProperties build() {
            TreeMap<String, String> properties = this.comparator != null ? new TreeMap(this.comparator) : new LinkedHashMap();
            return new OrderedProperties(properties, this.suppressDate);
        }
    }
}

