/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing;

import com.jsql.model.InjectionModel;
import com.jsql.util.I18nUtil;
import com.jsql.view.interaction.ObserverInteraction;
import com.jsql.view.swing.action.HotkeyUtil;
import com.jsql.view.swing.menubar.Menubar;
import com.jsql.view.swing.panel.PanelAddressBar;
import com.jsql.view.swing.panel.split.SplitHorizontalTopBottom;
import com.jsql.view.swing.shadow.ShadowPopupFactory;
import com.jsql.view.swing.shell.AbstractShell;
import com.jsql.view.swing.tab.TabManagers;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JFrameView
extends JFrame {
    private SplitHorizontalTopBottom splitHorizontalTopBottom;
    private Map<UUID, AbstractShell> mapShells = new HashMap<UUID, AbstractShell>();
    private transient ObserverInteraction observer = new ObserverInteraction("com.jsql.view.swing.interaction");

    public JFrameView() {
        super("jSQL Injection");
        MediatorHelper.register(this);
        UiUtil.prepareGUI();
        ShadowPopupFactory.install();
        this.initializePaneComponents();
        this.initializeWindow();
        this.initializeShortcuts();
    }

    private void initializeWindow() {
        this.setIconImages(UiUtil.getIcons());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent event) {
                super.windowOpened(event);
                Preferences preferences = Preferences.userRoot().node(InjectionModel.class.getName());
                double horizontalTopBottomSplitter = preferences.getDouble(SplitHorizontalTopBottom.getNameHSplitpane(), 0.75);
                if (!(0.0 <= horizontalTopBottomSplitter) || !(horizontalTopBottomSplitter <= 1.0)) {
                    horizontalTopBottomSplitter = 0.75;
                }
                JFrameView.this.splitHorizontalTopBottom.setDividerLocation(horizontalTopBottomSplitter);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                Preferences preferences = Preferences.userRoot().node(InjectionModel.class.getName());
                preferences.putInt(SplitHorizontalTopBottom.getNameVSplitpane(), JFrameView.this.splitHorizontalTopBottom.getSplitVerticalLeftRight().getDividerLocation());
                BigDecimal roundDecimal = BigDecimal.valueOf((double)JFrameView.this.splitHorizontalTopBottom.getDividerLocation() * 100.0 / (double)JFrameView.this.splitHorizontalTopBottom.getHeight() / 100.0);
                roundDecimal = roundDecimal.setScale(2, RoundingMode.HALF_UP);
                preferences.putDouble(SplitHorizontalTopBottom.getNameHSplitpane(), roundDecimal.doubleValue() - 0.01);
                preferences.putBoolean("binary_visible", false);
                preferences.putBoolean("chunk_visible", false);
                preferences.putBoolean("header_visible", false);
                preferences.putBoolean("java_visible", false);
                for (int i = 0; i < MediatorHelper.tabConsoles().getTabCount(); ++i) {
                    if ("CONSOLE_BINARY_LABEL".equals(MediatorHelper.tabConsoles().getTabComponentAt(i).getName())) {
                        preferences.putBoolean("binary_visible", true);
                        continue;
                    }
                    if ("CONSOLE_CHUNK_LABEL".equals(MediatorHelper.tabConsoles().getTabComponentAt(i).getName())) {
                        preferences.putBoolean("chunk_visible", true);
                        continue;
                    }
                    if ("CONSOLE_NETWORK_LABEL".equals(MediatorHelper.tabConsoles().getTabComponentAt(i).getName())) {
                        preferences.putBoolean("header_visible", true);
                        continue;
                    }
                    if (!"CONSOLE_JAVA_LABEL".equals(MediatorHelper.tabConsoles().getTabComponentAt(i).getName())) continue;
                    preferences.putBoolean("java_visible", true);
                }
            }
        });
        this.setSize(1024, 768);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
        MediatorHelper.panelAddressBar().getTextFieldAddress().requestFocusInWindow();
    }

    private void initializeShortcuts() {
        HotkeyUtil.addShortcut(this.getRootPane(), MediatorHelper.tabResults());
        HotkeyUtil.addTextFieldShortcutSelectAll();
    }

    private void initializePaneComponents() {
        Menubar menubar = new Menubar();
        this.setJMenuBar(menubar);
        MediatorHelper.register(menubar);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel mainPanel = new JPanel(new GridLayout(1, 0));
        this.splitHorizontalTopBottom = new SplitHorizontalTopBottom();
        mainPanel.add(this.splitHorizontalTopBottom);
        PanelAddressBar panelAddressBar = new PanelAddressBar();
        TabManagers tabManagers = new TabManagers();
        this.add(tabManagers);
        this.add(panelAddressBar);
        MediatorHelper.register(panelAddressBar);
        this.add(mainPanel);
        menubar.switchLocale(Locale.ENGLISH, I18nUtil.getLocaleDefault(), true);
    }

    public void resetInterface() {
        MediatorHelper.panelAddressBar().getAddressMenuBar().reset();
        MediatorHelper.treeDatabase().getTreeNodeModels().clear();
        this.mapShells.clear();
        MediatorHelper.panelConsoles().reset();
        MediatorHelper.treeDatabase().reset();
        for (int i = 0; i < MediatorHelper.tabConsoles().getTabCount(); ++i) {
            Component tabComponent = MediatorHelper.tabConsoles().getTabComponentAt(i);
            if (tabComponent == null) continue;
            tabComponent.setFont(tabComponent.getFont().deriveFont(0));
        }
        Stream.of(MediatorHelper.managerUpload(), MediatorHelper.managerFile(), MediatorHelper.managerWebshell(), MediatorHelper.managerSqlshell()).forEach(managerList -> {
            managerList.setButtonEnable(false);
            managerList.changePrivilegeIcon(UiUtil.ICON_SQUARE_GREY);
        });
    }

    public final Map<UUID, AbstractShell> getConsoles() {
        return this.mapShells;
    }

    public ObserverInteraction getObserver() {
        return this.observer;
    }

    public SplitHorizontalTopBottom getSplitHorizontalTopBottom() {
        return this.splitHorizontalTopBottom;
    }
}

