/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.injection.method.AbstractMethodInjection;
import com.jsql.util.LogLevel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParameterUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private List<AbstractMap.SimpleEntry<String, String>> listQueryString = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
    private List<AbstractMap.SimpleEntry<String, String>> listRequest = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
    private List<AbstractMap.SimpleEntry<String, String>> listHeader = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
    private String requestAsText = "";
    private InjectionModel injectionModel;

    public ParameterUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public void controlInput(String urlQuery, String dataRequest, String dataHeader, AbstractMethodInjection methodInjection, String typeRequest, boolean isScanning) {
        try {
            Object urlQueryFixed = urlQuery;
            if (!((String)urlQueryFixed).isEmpty() && !((String)urlQueryFixed).matches("(?i)^https?://.*")) {
                if (!((String)urlQueryFixed).matches("(?i)^\\w+://.*")) {
                    LOGGER.log(LogLevel.CONSOLE_INFORM, "Undefined URL protocol, forcing to [http://]");
                    urlQueryFixed = "http://" + (String)urlQueryFixed;
                } else {
                    throw new MalformedURLException("unknown URL protocol");
                }
            }
            this.initializeQueryString((String)urlQueryFixed);
            this.initializeRequest(dataRequest);
            this.initializeHeader(dataHeader);
            this.injectionModel.getMediatorUtils().getConnectionUtil().setMethodInjection(methodInjection);
            this.injectionModel.getMediatorUtils().getConnectionUtil().setTypeRequest(typeRequest);
            if (isScanning) {
                this.injectionModel.beginInjection();
            } else {
                new Thread(this.injectionModel::beginInjection, "ThreadBeginInjection").start();
            }
        }
        catch (MalformedURLException e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, "Incorrect Url: {}", (Object)e.getMessage());
            Request request = new Request();
            request.setMessage(Interaction.END_PREPARATION);
            this.injectionModel.sendToViews(request);
        }
    }

    public void checkParametersFormat() throws InjectionFailureException {
        this.checkOneOrLessStar();
        this.checkStarMatchMethod();
        this.checkMethodNotEmpty();
    }

    private void checkOneOrLessStar() throws InjectionFailureException {
        int nbStarInParameter = 0;
        if (this.getQueryStringFromEntries().contains("*")) {
            ++nbStarInParameter;
        }
        if (this.getRequestFromEntries().contains("*")) {
            ++nbStarInParameter;
        }
        if (this.getHeaderFromEntries().contains("*")) {
            ++nbStarInParameter;
        }
        if (nbStarInParameter >= 2) {
            throw new InjectionFailureException("Character insertion [*] must be used once in Query String, Request or Header parameters");
        }
    }

    public void checkStarMatchMethod() throws InjectionFailureException {
        AbstractMethodInjection methodInjection = this.injectionModel.getMediatorUtils().getConnectionUtil().getMethodInjection();
        boolean isCheckingAllParam = this.injectionModel.getMediatorUtils().getPreferencesUtil().isCheckingAllParam();
        if (this.getQueryStringFromEntries().contains("*") && methodInjection != this.injectionModel.getMediatorMethod().getQuery() && !isCheckingAllParam) {
            throw new InjectionFailureException("Select method GET to use character [*] or remove [*] from GET parameters");
        }
        if (this.getRequestFromEntries().contains("*") && methodInjection != this.injectionModel.getMediatorMethod().getRequest() && !isCheckingAllParam) {
            throw new InjectionFailureException("Select a Request method (like POST) to use [*], or remove [*] from Request parameters");
        }
        if (this.getHeaderFromEntries().contains("*") && methodInjection != this.injectionModel.getMediatorMethod().getHeader() && !isCheckingAllParam) {
            throw new InjectionFailureException("Select method Header to use character [*] or remove [*] from Header parameters");
        }
    }

    public void checkMethodNotEmpty() throws InjectionFailureException {
        AbstractMethodInjection methodInjection = this.injectionModel.getMediatorUtils().getConnectionUtil().getMethodInjection();
        boolean isCheckingAllParam = this.injectionModel.getMediatorUtils().getPreferencesUtil().isCheckingAllParam();
        if (methodInjection == this.injectionModel.getMediatorMethod().getQuery() && !isCheckingAllParam && this.getListQueryString().isEmpty() && !this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlBase().contains("*")) {
            throw new InjectionFailureException("No query string");
        }
        if (methodInjection == this.injectionModel.getMediatorMethod().getRequest() && this.getListRequest().isEmpty()) {
            throw new InjectionFailureException("Incorrect Request format");
        }
        if (methodInjection == this.injectionModel.getMediatorMethod().getHeader() && this.getListHeader().isEmpty()) {
            throw new InjectionFailureException("Incorrect Header format");
        }
    }

    public String initializeStar(AbstractMap.SimpleEntry<String, String> parameterToInject) {
        String characterInsertionByUser;
        if (parameterToInject == null) {
            characterInsertionByUser = "*";
        } else {
            characterInsertionByUser = parameterToInject.getValue();
            parameterToInject.setValue("*");
        }
        return characterInsertionByUser;
    }

    public void initializeQueryString(String urlQuery) throws MalformedURLException {
        URL url = new URL(urlQuery);
        if (StringUtils.isEmpty(urlQuery) || StringUtils.isEmpty(url.getHost())) {
            throw new MalformedURLException("empty URL");
        }
        this.injectionModel.getMediatorUtils().getConnectionUtil().setUrlByUser(urlQuery);
        this.injectionModel.getMediatorUtils().getConnectionUtil().setUrlBase(urlQuery);
        this.listQueryString.clear();
        Matcher regexQueryString = Pattern.compile("(.*\\?)(.*)").matcher(urlQuery);
        if (!regexQueryString.find()) {
            return;
        }
        this.injectionModel.getMediatorUtils().getConnectionUtil().setUrlBase(regexQueryString.group(1));
        if (StringUtils.isNotEmpty(url.getQuery())) {
            this.listQueryString = Pattern.compile("&").splitAsStream(regexQueryString.group(2)).map(s -> Arrays.copyOf(s.split("="), 2)).map(o -> new AbstractMap.SimpleEntry<String, String>(o[0], o[1] == null ? "" : o[1])).collect(Collectors.toList());
        }
    }

    public void initializeRequest(String request) {
        this.requestAsText = request;
        this.listRequest.clear();
        if (StringUtils.isNotEmpty(request)) {
            this.listRequest = Pattern.compile("&").splitAsStream(request).map(s -> Arrays.copyOf(s.split("="), 2)).map(o -> new AbstractMap.SimpleEntry<String, String>(o[0], o[1] == null ? "" : o[1])).collect(Collectors.toList());
        }
    }

    public void initializeHeader(String header) {
        this.listHeader.clear();
        if (StringUtils.isNotEmpty(header)) {
            this.listHeader = Pattern.compile("\\\\r\\\\n").splitAsStream(header).map(commaEntry -> Arrays.copyOf(commaEntry.split(":"), 2)).map(arrayEntry -> new AbstractMap.SimpleEntry<String, String>(arrayEntry[0], arrayEntry[1] == null ? "" : arrayEntry[1])).collect(Collectors.toList());
        }
    }

    public String getQueryStringFromEntries() {
        return this.listQueryString.stream().filter(Objects::nonNull).map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
    }

    public String getRequestFromEntries() {
        return this.listRequest.stream().filter(Objects::nonNull).map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
    }

    public String getHeaderFromEntries() {
        return this.listHeader.stream().filter(Objects::nonNull).map(entry -> String.format("%s:%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("\\r\\n"));
    }

    public boolean isRequestSoap() {
        return this.requestAsText.trim().matches("^(<soapenv:|<\\?xml).*");
    }

    public String getRawRequest() {
        return this.requestAsText;
    }

    public List<AbstractMap.SimpleEntry<String, String>> getListRequest() {
        return this.listRequest;
    }

    public void setListRequest(List<AbstractMap.SimpleEntry<String, String>> listRequest) {
        this.listRequest = listRequest;
    }

    public List<AbstractMap.SimpleEntry<String, String>> getListHeader() {
        return this.listHeader;
    }

    public void setListHeader(List<AbstractMap.SimpleEntry<String, String>> listHeader) {
        this.listHeader = listHeader;
    }

    public List<AbstractMap.SimpleEntry<String, String>> getListQueryString() {
        return this.listQueryString;
    }

    public void setListQueryString(List<AbstractMap.SimpleEntry<String, String>> listQueryString) {
        this.listQueryString = listQueryString;
    }
}

