/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.util.LogLevel;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class I18nUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final ResourceBundle LOCALE_ROOT = ResourceBundle.getBundle("i18n.jsql", Locale.ROOT);
    private static ResourceBundle localeDefault = ResourceBundle.getBundle("i18n.jsql", Locale.getDefault());

    private I18nUtil() {
    }

    public static String valueByKey(String key) {
        return (String)localeDefault.getObject(key);
    }

    public static void checkCurrentLanguage() {
        URL path = I18nUtil.class.getClassLoader().getResource("i18n/jsql_" + Locale.getDefault().getLanguage() + ".properties");
        if (!"en".equals(Locale.getDefault().getLanguage()) && path == null) {
            String languageHost = Locale.getDefault().getDisplayLanguage(Locale.ENGLISH);
            LOGGER.log(LogLevel.CONSOLE_SUCCESS, () -> String.join((CharSequence)"", "Please contribute and translate parts of jSQL Injection into ", languageHost, ": ", "click on the top right button and open menu [Community], choose [I help translate jSQL into > another language...] and ", "translate some text into ", languageHost, " then click on [Send]. Your translation will be integrated to the next release by the developer."));
        }
    }

    public static boolean isAsian(Locale newLocale) {
        return new Locale("zh").getLanguage().equals(newLocale.getLanguage()) || new Locale("ko").getLanguage().equals(newLocale.getLanguage()) || new Locale("ja").getLanguage().equals(newLocale.getLanguage());
    }

    public static void setLocaleDefault(ResourceBundle localeDefault) {
        I18nUtil.localeDefault = localeDefault;
    }

    public static Locale getLocaleDefault() {
        return localeDefault.getLocale();
    }

    public static ResourceBundle getLocaleRoot() {
        return LOCALE_ROOT;
    }
}

