/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.util.LogLevel;
import java.io.File;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.prefs.Preferences;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AuthenticationUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private boolean isAuthEnabled = false;
    private String usernameAuthentication;
    private String passwordAuthentication;
    private boolean isKerberos = false;
    private String pathKerberosLogin;
    private String pathKerberosKrb5;

    public boolean set(boolean isAuthentication, String usernameAuthentication, String passwordAuthentication, boolean isKerberos, String kerberosKrb5Conf, String kerberosLoginConf) {
        boolean isRestartRequired = this.initializeKerberos(isKerberos, kerberosKrb5Conf, kerberosLoginConf);
        this.initializeSimpleAuthorization(isAuthentication, usernameAuthentication, passwordAuthentication);
        this.setAuthentication();
        return isRestartRequired;
    }

    public void initializeSimpleAuthorization(boolean isAuthentication, String usernameAuthentication, String passwordAuthentication) {
        Preferences preferences = Preferences.userRoot().node(InjectionModel.class.getName());
        preferences.putBoolean("isDigestAuthentication", this.isAuthEnabled);
        preferences.put("usernameDigest", this.getUsernameAuthentication());
        preferences.put("passwordDigest", this.getPasswordAuthentication());
        this.isAuthEnabled = isAuthentication;
        this.usernameAuthentication = usernameAuthentication;
        this.passwordAuthentication = passwordAuthentication;
    }

    private boolean initializeKerberos(boolean isKerberos, String kerberosKrb5Conf, String kerberosLoginConf) {
        Preferences preferences = Preferences.userRoot().node(InjectionModel.class.getName());
        this.isKerberos = isKerberos;
        this.pathKerberosKrb5 = kerberosKrb5Conf;
        this.pathKerberosLogin = kerberosLoginConf;
        boolean isRestartRequired = this.isKerberos && !new File(this.pathKerberosKrb5).exists() && !kerberosKrb5Conf.equals(this.pathKerberosKrb5);
        preferences.putBoolean("enableKerberos", this.isKerberos);
        preferences.put("kerberosKrb5Conf", this.pathKerberosKrb5);
        preferences.put("kerberosLoginConf", this.pathKerberosLogin);
        if (this.isKerberos) {
            if (!new File(this.pathKerberosKrb5).exists()) {
                LOGGER.log(LogLevel.CONSOLE_ERROR, "Krb5 file not found: {}", (Object)this.pathKerberosKrb5);
            }
            if (!new File(this.pathKerberosLogin).exists()) {
                LOGGER.log(LogLevel.CONSOLE_ERROR, "Login file not found: {}", (Object)this.pathKerberosLogin);
            }
        }
        return isRestartRequired;
    }

    public void setKerberosCifs() {
        Preferences prefs = Preferences.userRoot().node(InjectionModel.class.getName());
        this.isAuthEnabled = prefs.getBoolean("isDigestAuthentication", false);
        this.usernameAuthentication = prefs.get("usernameDigest", "");
        this.passwordAuthentication = prefs.get("passwordDigest", "");
        this.isKerberos = prefs.getBoolean("enableKerberos", false);
        this.pathKerberosKrb5 = prefs.get("kerberosKrb5Conf", "");
        this.pathKerberosLogin = prefs.get("kerberosLoginConf", "");
        this.setAuthentication();
    }

    public void setAuthentication() {
        Authenticator.setDefault(null);
        if (this.isAuthEnabled) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(AuthenticationUtil.this.getUsernameAuthentication(), AuthenticationUtil.this.passwordAuthentication.toCharArray());
                }
            });
        } else {
            Authenticator.setDefault(null);
        }
        if (this.isKerberos) {
            System.setProperty("java.security.krb5.conf", this.pathKerberosKrb5);
            System.setProperty("java.security.auth.login.config", this.pathKerberosLogin);
            System.setProperty("spnego.krb5.conf", this.pathKerberosKrb5);
            System.setProperty("spnego.login.conf", this.pathKerberosLogin);
        } else {
            System.setProperty("java.security.krb5.conf", "");
            System.setProperty("java.security.auth.login.config", "");
            System.setProperty("spnego.krb5.conf", "");
            System.setProperty("spnego.login.conf", "");
        }
    }

    public String getUsernameDigest() {
        return this.getUsernameAuthentication();
    }

    public String getPasswordDigest() {
        return this.getPasswordAuthentication();
    }

    public boolean isAuthentEnabled() {
        return this.isAuthEnabled;
    }

    public String getPathKerberosLogin() {
        return this.pathKerberosLogin;
    }

    public String getPathKerberosKrb5() {
        return this.pathKerberosKrb5;
    }

    public boolean isKerberos() {
        return this.isKerberos;
    }

    public String getUsernameAuthentication() {
        return this.usernameAuthentication;
    }

    public String getPasswordAuthentication() {
        return this.passwordAuthentication;
    }

    public AuthenticationUtil withAuthentEnabled() {
        this.isAuthEnabled = true;
        return this;
    }

    public AuthenticationUtil withUsernameAuthentication(String usernameAuthentication) {
        this.usernameAuthentication = usernameAuthentication;
        return this;
    }

    public AuthenticationUtil withPasswordAuthentication(String passwordAuthentication) {
        this.passwordAuthentication = passwordAuthentication;
        return this;
    }
}

