/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBoolean;
import com.jsql.model.injection.strategy.blind.CallableTime;
import com.jsql.util.LogLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InjectionTime
extends AbstractInjectionBoolean<CallableTime> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private boolean isTimeInjectable = true;

    public InjectionTime(InjectionModel injectionModel, AbstractInjectionBoolean.BooleanMode booleanMode) {
        super(injectionModel, booleanMode);
        if (this.falseTest.isEmpty() || this.injectionModel.isStoppedByUser()) {
            return;
        }
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetTimeTagFalse");
        ArrayList<CallableTime> listCallableTagFalse = new ArrayList<CallableTime>();
        for (String urlTest : this.falseTest) {
            listCallableTagFalse.add(new CallableTime(urlTest, injectionModel, this, booleanMode, "time#false"));
        }
        try {
            List listTagFalse = taskExecutor.invokeAll(listCallableTagFalse);
            taskExecutor.shutdown();
            if (!taskExecutor.awaitTermination(15L, TimeUnit.SECONDS)) {
                taskExecutor.shutdownNow();
            }
            for (Future tagFalse : listTagFalse) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (!((CallableTime)tagFalse.get()).isTrue()) continue;
                this.isTimeInjectable = false;
                return;
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        this.initializeTrueMarks(booleanMode);
    }

    private void initializeTrueMarks(AbstractInjectionBoolean.BooleanMode booleanMode) {
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetTimeTagTrue");
        ArrayList<CallableTime> listCallableTagTrue = new ArrayList<CallableTime>();
        for (String urlTest : this.trueTest) {
            listCallableTagTrue.add(new CallableTime(urlTest, this.injectionModel, this, booleanMode, "time#true"));
        }
        try {
            List listTagTrue = taskExecutor.invokeAll(listCallableTagTrue);
            taskExecutor.shutdown();
            if (!taskExecutor.awaitTermination(15L, TimeUnit.SECONDS)) {
                taskExecutor.shutdownNow();
            }
            for (Future trueMark : listTagTrue) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                if (((CallableTime)trueMark.get()).isTrue()) continue;
                this.isTimeInjectable = false;
                return;
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public CallableTime getCallableSizeTest(String string, int indexCharacter) {
        return new CallableTime(string, indexCharacter, this.injectionModel, this, this.booleanMode, "time#size");
    }

    @Override
    public CallableTime getCallableBitTest(String string, int indexCharacter, int bit) {
        return new CallableTime(string, indexCharacter, bit, this.injectionModel, this, this.booleanMode, "time#bit");
    }

    @Override
    public boolean isInjectable() throws StoppedByUserSlidingException {
        if (this.injectionModel.isStoppedByUser()) {
            throw new StoppedByUserSlidingException();
        }
        CallableTime timeTest = new CallableTime(this.injectionModel.getMediatorVendor().getVendor().instance().sqlTestBooleanInitialization(), this.injectionModel, this, this.booleanMode, "time#confirm");
        try {
            timeTest.call();
        }
        catch (Exception e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
        return this.isTimeInjectable && timeTest.isTrue();
    }

    @Override
    public String getInfoMessage() {
        return "Time strategy: request is true if delay does not exceed 5 seconds.";
    }
}

