/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.pf4j.DefaultPluginDescriptor;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginException;
import org.pf4j.util.FileUtils;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestPluginDescriptorFinder
implements PluginDescriptorFinder {
    private static final Logger log = LoggerFactory.getLogger(ManifestPluginDescriptorFinder.class);

    @Override
    public boolean isApplicable(Path pluginPath) {
        return Files.exists(pluginPath, new LinkOption[0]) && (Files.isDirectory(pluginPath, new LinkOption[0]) || FileUtils.isJarFile(pluginPath));
    }

    @Override
    public PluginDescriptor find(Path pluginPath) throws PluginException {
        Manifest manifest = this.readManifest(pluginPath);
        return this.createPluginDescriptor(manifest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Manifest readManifest(Path pluginPath) throws PluginException {
        Path manifestPath;
        if (FileUtils.isJarFile(pluginPath)) {
            try (JarFile jar = new JarFile(pluginPath.toFile());){
                Manifest manifest2 = jar.getManifest();
                if (manifest2 != null) {
                    Manifest manifest = manifest2;
                    return manifest;
                }
            }
            catch (IOException e) {
                throw new PluginException(e);
            }
        }
        if ((manifestPath = this.getManifestPath(pluginPath)) == null) {
            throw new PluginException("Cannot find the manifest path");
        }
        log.debug("Lookup plugin descriptor in '{}'", (Object)manifestPath);
        if (Files.notExists(manifestPath, new LinkOption[0])) {
            throw new PluginException("Cannot find '{}' path", manifestPath);
        }
        try (InputStream input = Files.newInputStream(manifestPath, new OpenOption[0]);){
            Manifest manifest = new Manifest(input);
            return manifest;
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
    }

    protected Path getManifestPath(Path pluginPath) throws PluginException {
        if (Files.isDirectory(pluginPath, new LinkOption[0])) {
            return FileUtils.findFile(pluginPath, "MANIFEST.MF");
        }
        return null;
    }

    protected PluginDescriptor createPluginDescriptor(Manifest manifest) {
        String version;
        DefaultPluginDescriptor pluginDescriptor = this.createPluginDescriptorInstance();
        Attributes attributes = manifest.getMainAttributes();
        String id = attributes.getValue("Plugin-Id");
        pluginDescriptor.setPluginId(id);
        String description = attributes.getValue("Plugin-Description");
        if (StringUtils.isNullOrEmpty(description)) {
            pluginDescriptor.setPluginDescription("");
        } else {
            pluginDescriptor.setPluginDescription(description);
        }
        String clazz = attributes.getValue("Plugin-Class");
        if (StringUtils.isNotNullOrEmpty(clazz)) {
            pluginDescriptor.setPluginClass(clazz);
        }
        if (StringUtils.isNotNullOrEmpty(version = attributes.getValue("Plugin-Version"))) {
            pluginDescriptor.setPluginVersion(version);
        }
        String provider = attributes.getValue("Plugin-Provider");
        pluginDescriptor.setProvider(provider);
        String dependencies = attributes.getValue("Plugin-Dependencies");
        pluginDescriptor.setDependencies(dependencies);
        String requires = attributes.getValue("Plugin-Requires");
        if (StringUtils.isNotNullOrEmpty(requires)) {
            pluginDescriptor.setRequires(requires);
        }
        pluginDescriptor.setLicense(attributes.getValue("Plugin-License"));
        return pluginDescriptor;
    }

    protected DefaultPluginDescriptor createPluginDescriptorInstance() {
        return new DefaultPluginDescriptor();
    }
}

