/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.properties;

import ch.rakudave.jnetmap.controller.Controller;
import ch.rakudave.jnetmap.controller.command.Command;
import ch.rakudave.jnetmap.model.Connection;
import ch.rakudave.jnetmap.model.IF.NetworkIF;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.SwingHelper;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.components.EscapableDialog;
import ch.rakudave.jnetmap.view.components.TabPanel;
import ch.rakudave.jnetmap.view.jung.EdgeTransformers;
import ch.rakudave.jnetmap.view.preferences.PreferencePanel;
import ch.rakudave.jnetmap.view.properties.InterfaceProperties;
import edu.uci.ics.jung.graph.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ConnectionProperties
extends EscapableDialog {
    private Stroke stroke;

    public ConnectionProperties(Frame owner, final Connection c) {
        super((Window)owner, Lang.getNoHTML("connection.properties"));
        this.setLayout(new BorderLayout(5, 5));
        this.setPreferredSize(new Dimension(800, 460));
        this.setMinimumSize(new Dimension(800, 460));
        final Pair<Device> pair = Controller.getCurrentMap().getEndpoints(c);
        NetworkIF nif1 = pair.getFirst().getInterfaceFor(c);
        NetworkIF nif2 = pair.getSecond().getInterfaceFor(c);
        JPanel deviceNames = new JPanel(new GridLayout(1, 3));
        JLabel leftDevice = new JLabel(pair.getFirst().getName(), "Other".equals(pair.getFirst().getType()) ? Icons.fromBase64(pair.getFirst().getOtherID()) : Icons.getCisco(pair.getFirst().getType().toString().toLowerCase()), 0);
        leftDevice.setHorizontalTextPosition(0);
        leftDevice.setVerticalTextPosition(3);
        this.stroke = EdgeTransformers.strokeTransformer().transform(c);
        JPanel centerLine = new JPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                Graphics2D g2d = (Graphics2D)g;
                g2d.setStroke(ConnectionProperties.this.stroke);
                g2d.setPaint(c.getStatus().getColor());
                g2d.draw(new Line2D.Double(new Point(0, 32), new Point(super.getWidth(), 32)));
            }
        };
        JLabel rightDevice = new JLabel(pair.getSecond().getName(), "Other".equals(pair.getSecond().getType()) ? Icons.fromBase64(pair.getSecond().getOtherID()) : Icons.getCisco(pair.getSecond().getType().toString().toLowerCase()), 0);
        rightDevice.setHorizontalTextPosition(0);
        rightDevice.setVerticalTextPosition(3);
        deviceNames.add(leftDevice);
        deviceNames.add(centerLine);
        deviceNames.add(rightDevice);
        JPanel centerWrapper = new JPanel(new GridLayout(1, 3));
        PreferencePanel leftInterface = InterfaceProperties.getInnerPanel(owner, nif1, false);
        JPanel connectionPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        connectionPanel.setBorder(BorderFactory.createEmptyBorder(0, 50, 0, 50));
        final JComboBox<Connection.Type> connectionType = new JComboBox<Connection.Type>(Connection.Type.values());
        connectionType.setSelectedItem((Object)c.getType());
        final JTextField bandwidth = new JTextField(String.valueOf(c.getBandwidth()));
        ActionListener updateLine = e -> SwingUtilities.invokeLater(() -> {
            try {
                double aBandwidth = Double.valueOf(bandwidth.getText());
                this.stroke = EdgeTransformers.getStroke((Connection.Type)((Object)((Object)((Object)connectionType.getSelectedItem()))), aBandwidth);
                centerLine.repaint();
            }
            catch (NumberFormatException e1) {
                Logger.warn(bandwidth.getText() + " is not a number!", e1);
            }
        });
        final JTextField name = new JTextField(c.getName());
        connectionType.addActionListener(updateLine);
        bandwidth.addActionListener(updateLine);
        connectionPanel.add(new JLabel(Lang.get("connection.name") + ":"));
        connectionPanel.add(name);
        connectionPanel.add(new JLabel(Lang.get("connection.type") + ":"));
        connectionPanel.add(connectionType);
        connectionPanel.add(new JLabel(Lang.get("connection.bandwidth") + ":"));
        connectionPanel.add(bandwidth);
        connectionPanel.add(new JLabel(""));
        connectionPanel.add(new JLabel(""));
        connectionPanel.add(new JLabel(""));
        PreferencePanel rightInterface = InterfaceProperties.getInnerPanel(owner, nif2, false);
        centerWrapper.add(leftInterface);
        centerWrapper.add(connectionPanel);
        centerWrapper.add(rightInterface);
        JPanel bottomRow = new JPanel(new FlowLayout(4, 5, 5));
        ConnectionProperties _this = this;
        JButton cancel = new JButton(Lang.get("action.cancel"), Icons.get("cancel"));
        cancel.addActionListener(e -> _this.dispose());
        JButton ok = new JButton(Lang.get("action.ok"), Icons.get("ok"));
        ok.setPreferredSize(cancel.getPreferredSize());
        ok.addActionListener(e -> {
            leftInterface.save();
            rightInterface.save();
            Controller.getCurrentMap().getHistory().execute(new Command(){
                Connection.Type oldType;
                Connection.Type newType;
                double oldBandwidth;
                double newBandwidth;
                String oldName;
                String newName;
                {
                    this.oldType = c.getType();
                    this.newType = (Connection.Type)((Object)connectionType.getSelectedItem());
                    this.oldBandwidth = c.getBandwidth();
                    this.oldName = c.getName();
                    this.newName = name.getText();
                }

                @Override
                public Object undo() {
                    c.setType(this.oldType);
                    c.setBandwidth(this.oldBandwidth);
                    c.setName(this.oldName);
                    return null;
                }

                @Override
                public Object redo() {
                    try {
                        this.newBandwidth = Double.valueOf(bandwidth.getText());
                    }
                    catch (NumberFormatException e) {
                        Logger.warn(bandwidth.getText() + " is not a number!", e);
                    }
                    c.setType(this.newType);
                    c.setBandwidth(this.newBandwidth);
                    c.setName(this.newName);
                    return null;
                }

                @Override
                public String toString() {
                    return Lang.getNoHTML("command.update.connection") + ": " + ((Device)pair.getFirst()).getName() + " \u2194 " + ((Device)pair.getSecond()).getName();
                }
            });
            _this.dispose();
            if (TabPanel.getCurrentTab() != null) {
                TabPanel.getCurrentTab().repaint();
            }
        });
        bottomRow.add(cancel);
        bottomRow.add(ok);
        this.add((Component)deviceNames, "North");
        this.add((Component)centerWrapper, "Center");
        this.add((Component)bottomRow, "South");
        this.pack();
        SwingHelper.centerTo(owner, this);
        bandwidth.requestFocus();
        this.setVisible(true);
    }
}

