/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.jung;

import ch.rakudave.jnetmap.model.IF.NetworkIF;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.net.status.Status;
import ch.rakudave.jnetmap.util.Icons;
import edu.uci.ics.jung.visualization.FourPassImageShaper;
import edu.uci.ics.jung.visualization.decorators.EllipseVertexShapeTransformer;
import edu.uci.ics.jung.visualization.decorators.VertexIconShapeTransformer;
import edu.uci.ics.jung.visualization.picking.PickedState;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.collections15.Transformer;

public class VertexTransformers {
    public static Transformer<Device, Icon> iconTransformer(PickedState<Device> pi) {
        return d -> VertexTransformers.getIcon(d, pi.isPicked((Device)d) ? "_s" : "");
    }

    private static Icon getIcon(Device d, String flag) {
        String type = d.getType();
        if (type != null) {
            if (type.equals("Other")) {
                ImageIcon img = Icons.fromBase64(d.getOtherID());
                if (img != null) {
                    return img;
                }
            } else {
                return Icons.getCisco(type.toString().toLowerCase() + flag);
            }
        }
        return Icons.getCisco("workstation" + flag);
    }

    public static Transformer<Device, Shape> shapeTransformer() {
        return new DeviceVertexIconShapeTransformer<Device>(new EllipseVertexShapeTransformer());
    }

    public static Transformer<Device, String> tooltipTransformer() {
        return arg0 -> {
            List<NetworkIF> nifs = arg0.getInterfaces();
            if (nifs.isEmpty()) {
                return "---";
            }
            int i = 0;
            StringBuilder sb = new StringBuilder("<html>");
            for (NetworkIF nif : nifs) {
                sb.append(nif.getName());
                if (nif.getAddress() != null) {
                    sb.append(": ").append(nif.getAddress().getHostAddress());
                    if (Status.UP.equals((Object)nif.getStatus())) {
                        sb.append(" (").append(nif.getLatency()).append("ms)");
                    }
                }
                if (++i == nifs.size()) continue;
                sb.append("<br />");
            }
            return sb.append("</html>").toString();
        };
    }

    public static class DeviceVertexIconShapeTransformer<V>
    extends VertexIconShapeTransformer<V> {
        public DeviceVertexIconShapeTransformer(Transformer<V, Shape> delegate) {
            super(delegate);
        }

        @Override
        public Shape transform(V v) {
            Icon icon = VertexTransformers.getIcon((Device)v, "");
            if (icon != null && icon instanceof ImageIcon) {
                Image image = ((ImageIcon)icon).getImage();
                Shape shape = (Shape)this.shapeMap.get(image);
                if (shape == null && (shape = FourPassImageShaper.getShape(image, 32)).getBounds().getWidth() > 0.0 && shape.getBounds().getHeight() > 0.0) {
                    AffineTransform transform = AffineTransform.getTranslateInstance(-image.getWidth(null) / 2, -image.getHeight(null) / 2);
                    shape = transform.createTransformedShape(shape);
                    this.shapeMap.put(image, shape);
                }
                return shape;
            }
            return (Shape)this.delegate.transform(v);
        }
    }
}

